/*
 * Decompiled with CFR 0.152.
 */
package flashsystem;

import flashsystem.BytesUtil;
import flashsystem.HexDump;
import flashsystem.TaParseException;

public class TaEntry {
    String _partition = "";
    String _data = "";
    String _size = "";

    public void setPartition(int partition) {
        this._partition = HexDump.toHex(partition);
    }

    public void setPartition(String partition) {
        this._partition = partition;
    }

    public void addData(String data) {
        this._data = String.valueOf(this._data) + " " + data;
        this._data = this._data.trim();
    }

    public void setData(byte[] d) {
        this._data = "";
        int i = 0;
        while (i < d.length) {
            String dataS = HexDump.toHex(d[i]);
            this.addData(dataS.substring(dataS.length() - 2));
            ++i;
        }
    }

    public void addData(char[] data) {
        int i = 0;
        while (i < data.length) {
            String dataS = HexDump.toHex(data[i]);
            this.addData(dataS.substring(dataS.length() - 2));
            ++i;
        }
    }

    public String getPartition() {
        return this._partition;
    }

    public Byte[] getPartitionBytes() {
        return BytesUtil.getBytes(this._partition);
    }

    public void setSize(String size) {
        this._size = "0000" + size;
    }

    public void resize(int newsize) {
        block3: {
            int cursize;
            block2: {
                cursize = 0;
                cursize = this._data.length() == 2 ? 1 : this._data.split(" ").length;
                if (newsize <= cursize) break block2;
                int i = cursize;
                while (i < newsize) {
                    this.addData("FF");
                    ++i;
                }
                break block3;
            }
            if (newsize >= cursize) break block3;
            this._data = "";
            int i = 0;
            while (i < newsize) {
                this.addData("FF");
                ++i;
            }
        }
    }

    public String getComputedSize() {
        String lsize = "";
        lsize = this._data.length() == 2 ? HexDump.toHex(1) : HexDump.toHex(this._data.split(" ").length);
        lsize = "0000" + lsize.substring(lsize.length() - 4);
        return lsize;
    }

    public Byte[] getSizeBytes() {
        return BytesUtil.getBytes(this.getComputedSize());
    }

    public String getSize() {
        return this._size;
    }

    public String getData() {
        return this._data;
    }

    public String getDataString() {
        String[] result = this._data.split(" ");
        byte[] b2 = new byte[result.length];
        int i = 0;
        while (i < result.length) {
            b2[i] = BytesUtil.getBytes(result[i])[0];
            ++i;
        }
        return new String(b2);
    }

    public Byte[] getDataBytes() {
        String[] datas = this._data.split(" ");
        Byte[] data = new Byte[datas.length];
        int j = 0;
        while (j < datas.length) {
            data[j] = BytesUtil.getBytes(datas[j])[0];
            ++j;
        }
        return data;
    }

    public Byte[] getWordByte() {
        return BytesUtil.concatAll(this.getPartitionBytes(), new Byte[][]{this.getSizeBytes(), this.getDataBytes()});
    }

    public byte[] getWordbyte() {
        Byte[] b1 = this.getWordByte();
        byte[] b2 = new byte[b1.length];
        int i = 0;
        while (i < b1.length) {
            b2[i] = b1[i];
            ++i;
        }
        return b2;
    }

    public String toString() {
        return String.valueOf(this.getPartition()) + " " + this.getComputedSize().substring(4) + " " + this.getData();
    }

    public void close() throws TaParseException {
        if (Integer.parseInt(this.getComputedSize(), 16) != Integer.parseInt(this._size, 16)) {
            throw new TaParseException("TA entry (" + this.getPartition() + ")parsing error");
        }
    }
}

