/*
 * Decompiled with CFR 0.152.
 */
package flashsystem;

import flashsystem.BytesUtil;
import flashsystem.HexDump;
import org.system.OS;

public class SinHashBlock {
    long boffset;
    int blength;
    int hashsize;
    byte[] hash;
    int blockindex;
    int spare;

    public SinHashBlock(byte[] hashblock, int index) {
        this.spare = this.spare = 0;
        byte[] offset = new byte[4];
        byte[] length = new byte[4];
        System.arraycopy(hashblock, 0, offset, 0, 4);
        System.arraycopy(hashblock, 4, length, 0, 4);
        this.boffset = BytesUtil.getLong(offset);
        this.blength = BytesUtil.getInt(length);
        this.hashsize = hashblock[8];
        this.blockindex = index;
    }

    public void setSpare(int spare) {
        this.spare = spare;
    }

    public int getHashSize() {
        return this.hashsize;
    }

    public long getOffset() {
        return this.boffset + (long)(this.spare * this.blockindex);
    }

    public int getLength() {
        return this.blength;
    }

    public void setHash(byte[] array) {
        this.hash = array;
    }

    public byte[] getHash() {
        return this.hash;
    }

    public void validate(byte[] data) throws Exception {
        if (this.hash.length == 32) {
            if (!HexDump.toHex(this.hash).equals(OS.getSHA256(data))) {
                throw new Exception("Bad data");
            }
        } else if (this.hash.length == 20) {
            if (!HexDump.toHex(this.hash).equals(OS.getSHA1(data))) {
                throw new Exception("Bad data");
            }
        } else {
            throw new Exception("Cannot determine digest");
        }
    }

    public String toString() {
        return "Block " + this.blockindex + " ; Data size : " + this.getLength() + " ; Data hash size " + this.getHashSize() + " ; Dest offset : " + this.getOffset() + " ; Spare size : " + this.spare;
    }
}

