/*
 * Decompiled with CFR 0.152.
 */
package flashsystem;

import flashsystem.BytesUtil;
import flashsystem.SinHashBlock;
import flashsystem.SinPartInfo;
import java.util.Vector;
import org.logger.MyLogger;

public class SinFileHeader {
    private byte[] version = new byte[1];
    private byte[] nextHeader = new byte[1];
    private byte[] headersize = new byte[4];
    private byte[] partitionType = new byte[1];
    private byte[] sinreserved = new byte[4];
    private byte[] hashlistsize = new byte[4];
    private SinPartInfo partitioninfo = new SinPartInfo();
    private byte[] header;
    private Vector<SinHashBlock> blocks = new Vector();
    private int blocksize;
    private String unit = "";
    private long partitionsize;

    public SinFileHeader(byte[] header) {
        this.header = header;
        System.arraycopy(header, 0, this.version, 0, 1);
        System.arraycopy(header, 1, this.nextHeader, 0, 1);
        System.arraycopy(header, 2, this.headersize, 0, 4);
        this.partitionType[0] = header[6];
        System.arraycopy(header, 7, this.sinreserved, 0, 4);
        System.arraycopy(header, 11, this.hashlistsize, 0, 4);
        if (this.getHashListSize() > 0) {
            int hashoffset = 15;
            int read = 0;
            byte[] block = new byte[9];
            int index = 0;
            do {
                System.arraycopy(header, hashoffset, block, 0, block.length);
                read += block.length;
                SinHashBlock b2 = new SinHashBlock(block, index);
                byte[] hash = new byte[b2.getHashSize()];
                System.arraycopy(header, hashoffset += block.length, hash, 0, hash.length);
                hashoffset += hash.length;
                read += hash.length;
                b2.setHash(hash);
                this.blocks.add(b2);
                if (b2.getLength() <= 16) continue;
                ++index;
            } while (read < BytesUtil.getInt(this.hashlistsize));
        }
    }

    public int getPartitionInfoLength() {
        return this.blocks.get(0).getLength();
    }

    public boolean hasPartitionInfo() {
        return this.blocks.size() > 1;
    }

    public void setPartitionInfo(byte[] partinfo) {
        this.partitioninfo.setPartInfo(partinfo, this.getVersion());
    }

    public byte[] getPartitionInfo() {
        return this.partitioninfo.getPartInfo();
    }

    public void setBlockSize(int bksize) {
        this.blocksize = bksize;
        this.partitionsize = this.partitioninfo.getNbPartitionBlocks() * (long)this.blocksize;
        long gig = 0x40000000L;
        long meg = 0x100000L;
        this.unit = this.partitionsize / gig > 0L ? String.valueOf(this.unit) + Long.toString(this.partitionsize / gig) + "." + Long.toString(this.partitionsize % gig / meg) + "Gb" : String.valueOf(this.unit) + Long.toString(this.partitionsize / meg) + "." + Long.toString(this.partitionsize % meg / 1024L) + "Mb";
        MyLogger.getLogger().debug((Object)("Sin version " + this.getVersion() + " ; Partition block count : " + this.partitioninfo.getNbPartitionBlocks() + " ; Partition block size : " + this.blocksize + " ; Partition size : " + this.unit));
    }

    public long getOutfileLength() {
        return this.partitionsize;
    }

    public String getOutfileLengthString() {
        return this.unit;
    }

    public int getNbHashBlocks() {
        return this.blocks.size();
    }

    public int getVersion() {
        return BytesUtil.getInt(this.version);
    }

    public int getNextHeader() {
        return BytesUtil.getInt(this.nextHeader);
    }

    public byte getPartitionType() {
        return this.partitionType[0];
    }

    public byte[] getHeader() {
        return this.header;
    }

    public String getPartypeString() {
        if (this.partitionType[0] == 9) {
            return "Without spare";
        }
        if (this.partitionType[0] == 10) {
            return "With spare";
        }
        return "unknown";
    }

    public Vector<SinHashBlock> getHashBlocks() {
        return this.blocks;
    }

    public int getHashListSize() {
        return BytesUtil.getInt(this.hashlistsize);
    }

    public int getHeaderSize() {
        return BytesUtil.getInt(this.headersize);
    }
}

