/*
 * Decompiled with CFR 0.152.
 */
package flashsystem;

import flashsystem.BytesUtil;
import flashsystem.HexDump;
import flashsystem.SinFileHeader;
import flashsystem.SinHashBlock;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.util.Vector;
import org.logger.MyLogger;

public class SinFile {
    byte[] ident = new byte[16];
    static byte[] readarray64 = new byte[65536];
    static byte[] readarray4 = new byte[4096];
    File sinfile;
    byte[] yaffs2;
    String datatype;
    long nbchunks;
    long chunksize;
    SinFileHeader sinheader;

    public SinFileHeader getSinHeader() {
        return this.sinheader;
    }

    public SinFile(String file) throws FileNotFoundException, IOException {
        byte[] byArray = new byte[16];
        byArray[0] = 3;
        byArray[4] = 1;
        byArray[8] = -1;
        byArray[9] = -1;
        this.yaffs2 = byArray;
        this.datatype = null;
        this.nbchunks = 0L;
        this.chunksize = 0L;
        this.sinfile = new File(file);
        this.processHeader();
        this.datatype = this.getDatatype();
        if (this.sinheader.hasPartitionInfo()) {
            if (this.sinheader.getVersion() == 1) {
                int cursize = this.sinheader.getHashBlocks().get(1).getLength();
                this.sinheader.setBlockSize(cursize);
                if (this.sinheader.getPartitionType() == 10) {
                    int i = 0;
                    while (i < this.sinheader.getHashBlocks().size()) {
                        this.sinheader.getHashBlocks().get(i).setSpare(cursize % 131072);
                        ++i;
                    }
                }
            } else {
                this.sinheader.setBlockSize(512);
            }
        }
    }

    public String getLongFileName() {
        return this.sinfile.getAbsolutePath();
    }

    public String getShortFileName() {
        return this.sinfile.getName();
    }

    public String getHeaderFileName() {
        String path = this.sinfile.getAbsolutePath();
        return String.valueOf(path.substring(0, path.length() - 3)) + "header";
    }

    public byte[] getHeaderBytes() {
        return this.sinheader.getHeader();
    }

    public byte[] getChunckBytes(int chunkId) throws IOException {
        RandomAccessFile fin = new RandomAccessFile(this.sinfile, "r");
        long offset = (long)this.sinheader.getHeaderSize() + (long)chunkId * this.chunksize;
        fin.seek(offset);
        int readcount = 0;
        if ((long)readarray64.length == this.chunksize) {
            readcount = fin.read(readarray64);
            fin.close();
            return BytesUtil.getReply(readarray64, readcount);
        }
        readcount = fin.read(readarray4);
        fin.close();
        return BytesUtil.getReply(readarray4, readcount);
    }

    public void setChunkSize(long size) {
        long datasize = this.sinfile.length() - (long)this.sinheader.getHeaderSize();
        this.nbchunks = datasize / size;
        this.chunksize = size;
        if (datasize % size > 0L) {
            ++this.nbchunks;
        }
    }

    public long getChunkSize() {
        return this.chunksize;
    }

    public long getNbChunks() {
        return this.nbchunks;
    }

    public String getImageFileName() throws IOException {
        String path = this.sinfile.getAbsolutePath();
        return String.valueOf(path.substring(0, path.length() - 3)) + this.getDataType();
    }

    public String getPartInfoFileName() {
        String path = this.sinfile.getAbsolutePath();
        return String.valueOf(path.substring(0, path.length() - 3)) + "partinfo";
    }

    public void dumpHeader() throws IOException {
        MyLogger.getLogger().info((Object)("Extracting " + this.getShortFileName() + " header to " + this.getHeaderFileName()));
        FileOutputStream fout = new FileOutputStream(new File(this.getHeaderFileName()));
        fout.write(this.sinheader.getHeader());
        fout.flush();
        fout.close();
        MyLogger.getLogger().info((Object)"HEADER Extraction finished");
    }

    public void dumpImage() throws IOException {
        try {
            if (this.sinheader.hasPartitionInfo()) {
                FileOutputStream foutpart = new FileOutputStream(new File(this.getPartInfoFileName()));
                foutpart.write(this.sinheader.getPartitionInfo());
                foutpart.flush();
                foutpart.close();
            }
            byte[] empty = new byte[66560];
            int i = 0;
            while (i < empty.length) {
                empty[i] = -1;
                ++i;
            }
            File f = new File(this.getImageFileName());
            f.delete();
            RandomAccessFile fout = new RandomAccessFile(f, "rw");
            MyLogger.getLogger().info((Object)"Generating container file");
            MyLogger.getLogger().info((Object)("Output file size : " + this.sinheader.getOutfileLengthString()));
            long i2 = 0L;
            while (i2 < this.sinheader.getOutfileLength() / (long)empty.length) {
                fout.write(empty);
                ++i2;
            }
            i2 = 0L;
            while (i2 < this.sinheader.getOutfileLength() % (long)empty.length) {
                fout.write(255);
                ++i2;
            }
            MyLogger.getLogger().info((Object)"Finished Generating container file");
            RandomAccessFile findata = new RandomAccessFile(this.sinfile, "r");
            MyLogger.getLogger().info((Object)"Extracting data into container");
            findata.seek(this.sinheader.getHeaderSize());
            Vector<SinHashBlock> blocks = this.sinheader.getHashBlocks();
            int i3 = 0;
            while (i3 < blocks.size()) {
                SinHashBlock b2 = blocks.elementAt(i3);
                byte[] data = new byte[b2.getLength()];
                findata.read(data);
                b2.validate(data);
                fout.seek(blocks.size() == 1 ? 0L : b2.getOffset());
                fout.write(data);
                ++i3;
            }
            fout.close();
            findata.close();
            MyLogger.getLogger().info((Object)"Data Extraction finished");
        }
        catch (Exception e) {
            MyLogger.getLogger().error((Object)("Error while extracting data : " + e.getMessage()));
            e.printStackTrace();
        }
    }

    private void processHeader() throws IOException {
        byte[] headersize = new byte[4];
        RandomAccessFile fin = new RandomAccessFile(this.sinfile, "r");
        fin.seek(2L);
        int nbread = fin.read(headersize);
        if (nbread != headersize.length) {
            fin.close();
            throw new IOException("Error in processHeader");
        }
        byte[] header = new byte[BytesUtil.getInt(headersize)];
        fin.seek(0L);
        nbread = fin.read(header);
        this.sinheader = new SinFileHeader(header);
        if (this.sinheader.hasPartitionInfo()) {
            fin.seek(this.sinheader.getHeaderSize());
            byte[] part = new byte[this.sinheader.getPartitionInfoLength()];
            fin.read(part);
            this.sinheader.setPartitionInfo(part);
        }
        fin.close();
    }

    public byte[] getPartitionInfoBytes() throws IOException {
        return this.sinheader.getPartitionInfo();
    }

    public String getDatatype() throws IOException {
        int read;
        RandomAccessFile fin;
        block14: {
            String result;
            block13: {
                fin = new RandomAccessFile(this.sinfile, "r");
                fin.seek(this.sinheader.getHeaderSize() + this.sinheader.getPartitionInfo().length);
                read = fin.read(this.ident);
                if (read != this.ident.length) {
                    fin.close();
                    throw new IOException("Error in retrieving data type");
                }
                result = new String(this.ident);
                String yaffs = new String(this.yaffs2);
                if (!result.equals(yaffs)) break block13;
                fin.close();
                return "yaffs2";
            }
            if (!result.contains("ELF")) break block14;
            fin.close();
            return "elf";
        }
        try {
            boolean isnull = true;
            boolean count = false;
            int i = 0;
            while (i < this.ident.length) {
                if (this.ident[i] != 0) {
                    isnull = false;
                }
                ++i;
            }
            while (isnull) {
                read = fin.read(this.ident);
                if (read == -1) {
                    throw new Exception("End of file");
                }
                i = 0;
                while (i < read) {
                    if (this.ident[i] != 0) {
                        isnull = false;
                    }
                    ++i;
                }
            }
            fin.seek(fin.getFilePointer() - 16L + 56L);
            byte[] ident1 = new byte[2];
            read = fin.read(ident1);
            if (read == -1) {
                throw new Exception("End of file");
            }
            fin.close();
            if (HexDump.toHex(ident1).contains("53, EF")) {
                return "ext4";
            }
            return "unknown";
        }
        catch (Exception e) {
            fin.close();
            return "unknown";
        }
    }

    public String getDataType() throws IOException {
        return this.datatype;
    }

    public byte getSpareBytes() {
        return this.sinheader.getPartitionType();
    }
}

