/*
 * Decompiled with CFR 0.152.
 */
package flashsystem;

import flashsystem.BytesUtil;
import flashsystem.HexDump;
import flashsystem.X10FlashException;
import java.io.FileOutputStream;

public class S1Packet {
    byte[] cmd = new byte[4];
    byte[] flags = new byte[4];
    byte[] datalen = new byte[4];
    byte hdr;
    byte[] data;
    byte[] crc32 = new byte[4];
    int lastdatapos = 0;
    int lastcrcpos = 0;
    boolean finalized = false;

    public S1Packet(byte[] pdata) throws X10FlashException {
        try {
            if (pdata == null) {
                this.validate();
                return;
            }
            if (pdata.length == 0) {
                this.validate();
                return;
            }
            System.arraycopy(pdata, 0, this.cmd, 0, 4);
            System.arraycopy(pdata, 4, this.flags, 0, 4);
            System.arraycopy(pdata, 8, this.datalen, 0, 4);
            this.hdr = pdata[12];
            if (this.getDataLength() > 65553) {
                throw new X10FlashException("Incorect read packet. Bad Data length");
            }
            this.data = new byte[this.getDataLength()];
            int totransfer = pdata.length - 13;
            if (totransfer > this.getDataLength()) {
                totransfer = this.getDataLength();
            }
            this.lastdatapos = totransfer;
            System.arraycopy(pdata, 13, this.data, 0, totransfer);
            if (pdata.length > 13 + totransfer) {
                System.arraycopy(pdata, 13 + totransfer, this.crc32, 0, 4);
                this.finalized = true;
                if (BytesUtil.getLong(this.calculatedCRC32()) != BytesUtil.getLong(this.crc32)) {
                    throw new X10FlashException("S1 Data CRC32 Error");
                }
                if (this.calculateHeaderCkSum() != this.hdr) {
                    throw new X10FlashException("S1 Header checksum Error");
                }
            }
        }
        catch (Exception e) {
            throw new X10FlashException(e.getMessage());
        }
    }

    public void validate() throws X10FlashException {
        try {
            if (BytesUtil.getLong(this.calculatedCRC32()) != BytesUtil.getLong(this.crc32)) {
                throw new X10FlashException("S1 Data CRC32 Error");
            }
            if (this.calculateHeaderCkSum() != this.hdr) {
                throw new X10FlashException("S1 Header checksum Error");
            }
        }
        catch (Exception e) {
            throw new X10FlashException(e.getMessage());
        }
    }

    public byte[] getByteArray() {
        byte[] array = new byte[17 + this.data.length];
        System.arraycopy(this.cmd, 0, array, 0, 4);
        System.arraycopy(this.flags, 0, array, 4, 4);
        System.arraycopy(this.datalen, 0, array, 8, 4);
        array[12] = this.hdr;
        System.arraycopy(this.data, 0, array, 13, this.data.length);
        System.arraycopy(this.crc32, 0, array, array.length - 4, 4);
        return array;
    }

    public void release() {
        this.cmd = null;
        this.flags = null;
        this.datalen = null;
        this.data = null;
        this.crc32 = null;
    }

    public S1Packet(int pcommand, byte[] pdata, boolean ongoing) {
        this.cmd = BytesUtil.getBytesWord(pcommand, 4);
        this.setFlags(false, true, ongoing);
        this.data = pdata == null ? new byte[0] : pdata;
        this.datalen = BytesUtil.getBytesWord(this.data.length, 4);
        this.hdr = this.calculateHeaderCkSum();
        this.crc32 = this.calculatedCRC32();
    }

    public S1Packet(int pcommand, byte pdata, boolean ongoing) {
        this.cmd = BytesUtil.getBytesWord(pcommand, 4);
        this.setFlags(false, true, ongoing);
        this.data = new byte[]{pdata};
        this.datalen = BytesUtil.getBytesWord(this.data.length, 4);
        this.hdr = this.calculateHeaderCkSum();
        this.crc32 = this.calculatedCRC32();
    }

    public void setFlags(boolean flag1, boolean flag2, boolean ongoing) {
        this.flags = BytesUtil.getBytesWord(this.getFlag(flag1, flag2, ongoing), 4);
    }

    private int getFlag(boolean flag1, boolean flag2, boolean ongoing) {
        boolean flag = !flag1;
        byte byte0 = (byte)(flag2 ? 2 : 0);
        byte byte1 = (byte)(ongoing ? 4 : 0);
        return (byte)(flag ? 1 : 0) | byte0 | byte1;
    }

    public int getFlags() {
        return BytesUtil.getInt(this.flags);
    }

    public String getFlagsAsString() {
        String result = "";
        int flag1 = this.getFlags() & 1;
        int flag2 = this.getFlags() & 2;
        int flag3 = this.getFlags() & 4;
        result = flag1 == 0 ? "true" : "false";
        result = flag2 == 0 ? String.valueOf(result) + ",false" : String.valueOf(result) + ",true";
        result = flag3 == 0 ? String.valueOf(result) + ",false" : String.valueOf(result) + ",true";
        return result;
    }

    public int getCommand() {
        return BytesUtil.getInt(this.cmd);
    }

    public int getDataLength() {
        return BytesUtil.getInt(this.datalen);
    }

    public byte[] getDataArray() {
        return this.data;
    }

    public String getDataString() {
        return new String(this.data);
    }

    public void addData(byte[] datachunk) throws X10FlashException {
        if (this.lastdatapos < this.data.length) {
            int totransfer = this.data.length - this.lastdatapos;
            if (datachunk.length <= totransfer) {
                totransfer = datachunk.length;
            }
            System.arraycopy(datachunk, 0, this.data, this.lastdatapos, totransfer);
            this.lastdatapos += totransfer;
            if (datachunk.length > totransfer) {
                int lasttransfer = datachunk.length - totransfer;
                System.arraycopy(datachunk, totransfer, this.crc32, this.lastcrcpos, lasttransfer);
                this.lastcrcpos += lasttransfer;
                this.finalized = this.lastcrcpos == 4;
            }
        } else {
            int lasttransfer = 4 - this.lastcrcpos;
            if (datachunk.length < lasttransfer) {
                lasttransfer = datachunk.length;
            }
            System.arraycopy(datachunk, 0, this.crc32, this.lastcrcpos, lasttransfer);
            this.lastcrcpos += lasttransfer;
            boolean bl = this.finalized = this.lastcrcpos == 4;
        }
        if (this.finalized) {
            if (BytesUtil.getLong(this.calculatedCRC32()) != BytesUtil.getLong(this.crc32)) {
                throw new X10FlashException("S1 Data CRC32 Error");
            }
            if (this.calculateHeaderCkSum() != this.hdr) {
                throw new X10FlashException("S1 Header checksum Error");
            }
        }
    }

    public String toString() {
        if (this.data == null) {
            return "";
        }
        return "Data : \t" + new String(this.data) + "\n" + "CRC32 : \t" + HexDump.toHex(this.crc32);
    }

    public byte[] calculatedCRC32() {
        if (this.data == null) {
            return null;
        }
        return BytesUtil.getCRC32(this.data);
    }

    public boolean hasMoreToRead() {
        return !this.finalized;
    }

    public byte calculateHeaderCkSum() {
        byte[] header = new byte[12];
        System.arraycopy(this.cmd, 0, header, 0, 4);
        System.arraycopy(this.flags, 0, header, 4, 4);
        System.arraycopy(this.datalen, 0, header, 8, 4);
        byte result = this.calcSum(header);
        header = null;
        return result;
    }

    private byte calcSum(byte[] paramArray) {
        byte byte0 = 0;
        if (paramArray.length < 12) {
            return 0;
        }
        int i = 0;
        while (i < 12) {
            byte0 = (byte)(byte0 ^ paramArray[i]);
            ++i;
        }
        byte0 = (byte)(byte0 + 7);
        return byte0;
    }

    public void saveDataAs(String file) {
        try {
            FileOutputStream fos = new FileOutputStream(file);
            fos.write(this.data);
            fos.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

