/*
 * Decompiled with CFR 0.152.
 */
package flashsystem;

import flashsystem.Bundle;
import flashsystem.X10flash;
import gui.About;
import gui.FlasherGUI;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.lang.reflect.Constructor;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.Properties;
import org.adb.AdbUtility;
import org.logger.MyLogger;
import org.plugins.PluginInterface;
import org.system.AdbPhoneThread;
import org.system.ClassPath;
import org.system.DeviceChangedListener;
import org.system.DeviceEntry;
import org.system.DeviceProperties;
import org.system.Devices;
import org.system.GlobalConfig;
import org.system.OS;
import org.system.Shell;
import org.system.StatusEvent;
import org.system.StatusListener;

public class FlasherConsole {
    private static AdbPhoneThread phoneWatchdog;
    private static String fsep;
    private static Properties plugins;

    static {
        fsep = OS.getFileSeparator();
        plugins = new Properties();
    }

    public static void init(boolean withadb) {
        MyLogger.disableTextArea();
        MyLogger.setLevel("info");
        MyLogger.getLogger().info((Object)("Flashtool " + About.getVersion()));
        FlasherGUI.guimode = false;
        if (withadb) {
            StatusListener phoneStatus = new StatusListener(){

                @Override
                public void statusChanged(StatusEvent e) {
                    if (!e.isDriverOk()) {
                        MyLogger.getLogger().error((Object)"Drivers need to be installed for connected device.");
                        MyLogger.getLogger().error((Object)"You can find them in the drivers folder of Flashtool.");
                    } else {
                        if (e.getNew().equals("adb")) {
                            MyLogger.getLogger().info((Object)"Device connected with USB debugging on");
                            MyLogger.getLogger().debug((Object)"Device connected, continuing with identification");
                            FlasherConsole.doIdent();
                        }
                        if (e.getNew().equals("none")) {
                            MyLogger.getLogger().info((Object)"Device disconnected");
                        }
                        if (e.getNew().equals("flash")) {
                            MyLogger.getLogger().info((Object)"Device connected in flash mode");
                        }
                        if (e.getNew().equals("fastboot")) {
                            MyLogger.getLogger().info((Object)"Device connected in fastboot mode");
                        }
                        if (e.getNew().equals("normal")) {
                            MyLogger.getLogger().info((Object)"Device connected with USB debugging off");
                            MyLogger.getLogger().info((Object)"For 2011 devices line, be sure you are not in MTP mode");
                        }
                    }
                }
            };
            phoneWatchdog = new AdbPhoneThread();
            phoneWatchdog.start();
            phoneWatchdog.addStatusListener(phoneStatus);
        } else {
            DeviceChangedListener.start();
        }
    }

    public static void exit() {
        DeviceChangedListener.stop();
        if (phoneWatchdog != null) {
            phoneWatchdog.done();
            try {
                phoneWatchdog.join();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        MyLogger.writeFile();
        System.exit(0);
    }

    public static void doRoot() {
        Devices.waitForReboot(false);
        if (Devices.getCurrent().getVersion().contains("2.3")) {
            if (!Devices.getCurrent().hasRoot()) {
                FlasherConsole.doRootzergRush();
            } else {
                MyLogger.getLogger().error((Object)"Your device is already rooted");
            }
        } else if (!Devices.getCurrent().hasRoot()) {
            FlasherConsole.doRootpsneuter();
        } else {
            MyLogger.getLogger().error((Object)"Your device is already rooted");
        }
        FlasherConsole.exit();
    }

    public static void doRootzergRush() {
        try {
            AdbUtility.push(Devices.getCurrent().getBusybox(false), String.valueOf(GlobalConfig.getProperty("deviceworkdir")) + "/busybox");
            Shell shell = new Shell("busyhelper");
            shell.run(true);
            AdbUtility.push(new File("." + fsep + "custom" + fsep + "root" + fsep + "zergrush.tar.uue").getAbsolutePath(), GlobalConfig.getProperty("deviceworkdir"));
            shell = new Shell("rootit");
            MyLogger.getLogger().info((Object)"Running part1 of Root Exploit, please wait");
            shell.run(true);
            Devices.waitForReboot(true);
            MyLogger.getLogger().info((Object)"Running part2 of Root Exploit");
            shell = new Shell("rootit2");
            shell.run(false);
            MyLogger.getLogger().info((Object)"Finished!.");
            MyLogger.getLogger().info((Object)"Root should be available after reboot!");
        }
        catch (Exception e) {
            MyLogger.getLogger().error((Object)e.getMessage());
        }
    }

    public static void doRootpsneuter() {
        try {
            AdbUtility.push(Devices.getCurrent().getBusybox(false), String.valueOf(GlobalConfig.getProperty("deviceworkdir")) + "/busybox");
            Shell shell = new Shell("busyhelper");
            shell.run(true);
            AdbUtility.push("." + fsep + "custom" + fsep + "root" + fsep + "psneuter.tar.uue", GlobalConfig.getProperty("deviceworkdir"));
            shell = new Shell("rootit");
            MyLogger.getLogger().info((Object)"Running part1 of Root Exploit, please wait");
            shell.run(false);
            Devices.waitForReboot(true);
            MyLogger.getLogger().info((Object)"Running part2 of Root Exploit");
            shell = new Shell("rootit2");
            shell.run(false);
            MyLogger.getLogger().info((Object)"Finished!.");
            MyLogger.getLogger().info((Object)"Root should be available after reboot!");
        }
        catch (Exception e) {
            MyLogger.getLogger().error((Object)e.getMessage());
        }
    }

    public static void doBLUnlock() {
        try {
            Devices.waitForReboot(false);
            PluginInterface po = (PluginInterface)plugins.get("Bootloader Unlock");
            po.run();
        }
        catch (Exception e) {
            MyLogger.getLogger().error((Object)"The BootLoader Unlock plugin is not loaded");
        }
    }

    public static void doGetIMEI() throws Exception {
        X10flash f = null;
        try {
            Bundle b = new Bundle();
            b.setSimulate(false);
            f = new X10flash(b);
            MyLogger.getLogger().info((Object)"Please connect your phone in flash mode");
            while (!f.deviceFound()) {
            }
            f.openDevice(false);
            MyLogger.getLogger().info((Object)("IMEI : " + f.getPhoneProperty("IMEI")));
            f.closeDevice();
            FlasherConsole.exit();
        }
        catch (Exception e) {
            if (f != null) {
                f.closeDevice();
            }
            throw e;
        }
    }

    public static void doFlash(String file, boolean wipedata, boolean wipecache, boolean excludebb, boolean excludekrnl, boolean excludesys) throws Exception {
        X10flash f = null;
        try {
            File bf = new File(file);
            if (!bf.exists()) {
                MyLogger.getLogger().error((Object)("File " + bf.getAbsolutePath() + " does not exist"));
                FlasherConsole.exit();
            }
            MyLogger.getLogger().info((Object)("Choosed " + bf.getAbsolutePath()));
            Bundle b = new Bundle(bf.getAbsolutePath(), 1);
            b.setSimulate(false);
            b.getMeta().setCategEnabled("DATA", wipedata);
            b.getMeta().setCategEnabled("CACHE", wipecache);
            b.getMeta().setCategEnabled("BASEBAND", excludebb);
            b.getMeta().setCategEnabled("SYSTEM", excludesys);
            b.getMeta().setCategEnabled("KERNEL", excludekrnl);
            MyLogger.getLogger().info((Object)"Preparing files for flashing");
            b.open();
            f = new X10flash(b);
            MyLogger.getLogger().info((Object)"Please connect your phone in flash mode");
            while (!f.deviceFound()) {
            }
            f.openDevice(false);
            f.flashDevice();
            b.close();
            FlasherConsole.exit();
        }
        catch (Exception e) {
            if (f != null) {
                f.closeDevice();
            }
            throw e;
        }
    }

    public static void doIdent() {
        Enumeration<Object> e = Devices.listDevices(true);
        if (!e.hasMoreElements()) {
            MyLogger.getLogger().error((Object)"No device is registered in Flashtool.");
            MyLogger.getLogger().error((Object)"You can only flash devices.");
            return;
        }
        boolean found = false;
        Properties founditems = new Properties();
        founditems.clear();
        Properties buildprop = new Properties();
        buildprop.clear();
        while (e.hasMoreElements()) {
            DeviceEntry current = Devices.getDevice((String)e.nextElement());
            String prop = current.getBuildProp();
            if (!buildprop.containsKey(prop)) {
                String readprop = DeviceProperties.getProperty(prop);
                buildprop.setProperty(prop, readprop);
            }
            Iterator<String> i = current.getRecognitionList().iterator();
            String localdev = buildprop.getProperty(prop);
            while (i.hasNext()) {
                String pattern = i.next().toUpperCase();
                if (!localdev.toUpperCase().contains(pattern)) continue;
                founditems.put(current.getId(), current.getName());
            }
        }
        if (founditems.size() == 1) {
            found = true;
            Devices.setCurrent((String)founditems.keys().nextElement());
            if (!Devices.isWaitingForReboot()) {
                MyLogger.getLogger().info((Object)("Connected device : " + Devices.getCurrent().getId()));
            }
        } else {
            MyLogger.getLogger().error((Object)"Cannot identify your device.");
            MyLogger.getLogger().error((Object)"You can only flash devices.");
        }
        if (found) {
            if (!Devices.isWaitingForReboot()) {
                MyLogger.getLogger().info((Object)("Installed version of busybox : " + Devices.getCurrent().getInstalledBusyboxVersion(false)));
                MyLogger.getLogger().info((Object)("Android version : " + Devices.getCurrent().getVersion() + " / kernel version : " + Devices.getCurrent().getKernelVersion()));
            }
            if (Devices.getCurrent().isRecovery()) {
                MyLogger.getLogger().info((Object)"Phone in recovery mode");
                if (!Devices.isWaitingForReboot()) {
                    MyLogger.getLogger().info((Object)"Root Access Allowed");
                }
            } else {
                boolean hasRoot;
                boolean hasSU = Devices.getCurrent().hasSU();
                if (hasSU && (hasRoot = Devices.getCurrent().hasRoot()) && !Devices.isWaitingForReboot()) {
                    MyLogger.getLogger().info((Object)"Root Access Allowed");
                }
            }
            plugins.clear();
            FlasherConsole.addDevicesPlugins();
            FlasherConsole.addGenericPlugins();
            MyLogger.getLogger().debug((Object)"Stop waiting for device");
            if (Devices.isWaitingForReboot()) {
                Devices.stopWaitForReboot();
            }
            MyLogger.getLogger().debug((Object)"End of identification");
        }
    }

    public static void addDevicesPlugins() {
        try {
            File dir = new File(String.valueOf(Devices.getCurrent().getDeviceDir()) + fsep + "features");
            File[] chld = dir.listFiles();
            MyLogger.getLogger().debug((Object)("Found " + chld.length + " device plugins to add"));
            int i = 0;
            while (i < chld.length) {
                if (chld[i].isDirectory()) {
                    try {
                        Properties p = new Properties();
                        p.load(new FileInputStream(new File(String.valueOf(chld[i].getAbsolutePath()) + fsep + "feature.properties")));
                        MyLogger.getLogger().debug((Object)("Registering " + p.getProperty("classname")));
                        ClassPath.addFile(String.valueOf(chld[i].getAbsolutePath()) + fsep + p.getProperty("plugin"));
                        FlasherConsole.registerPlugin("device", p.getProperty("classname"), chld[i].getAbsolutePath());
                    }
                    catch (IOException iOException) {
                        // empty catch block
                    }
                }
                ++i;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static void addGenericPlugins() {
        try {
            File dir = new File(String.valueOf(OS.getWorkDir()) + fsep + "custom" + fsep + "features");
            File[] chld = dir.listFiles();
            MyLogger.getLogger().debug((Object)("Found " + chld.length + " generic plugins to add"));
            int i = 0;
            while (i < chld.length) {
                if (chld[i].isDirectory()) {
                    try {
                        Properties p = new Properties();
                        p.load(new FileInputStream(new File(String.valueOf(chld[i].getAbsolutePath()) + fsep + "feature.properties")));
                        ClassPath.addFile(String.valueOf(chld[i].getAbsolutePath()) + fsep + p.getProperty("plugin"));
                        FlasherConsole.registerPlugin("generic", p.getProperty("classname"), chld[i].getAbsolutePath());
                    }
                    catch (IOException iOException) {
                        // empty catch block
                    }
                }
                ++i;
            }
        }
        catch (Exception e) {
            MyLogger.getLogger().debug((Object)e.getMessage());
        }
    }

    public static void registerPlugin(String type, String classname, String workdir) {
        try {
            Class<?> pluginClass = Class.forName(classname);
            Constructor<?> constr = pluginClass.getConstructor(new Class[0]);
            PluginInterface pluginObject = (PluginInterface)constr.newInstance(new Object[0]);
            pluginObject.setWorkdir(workdir);
            boolean aenabled = false;
            String aversion = Devices.getCurrent().getVersion();
            Enumeration<String> e1 = pluginObject.getCompatibleAndroidVersions();
            while (e1.hasMoreElements()) {
                String pversion = e1.nextElement();
                if (!aversion.startsWith(pversion) && !pversion.equals("any")) continue;
                aenabled = true;
            }
            boolean kenabled = false;
            String kversion = Devices.getCurrent().getKernelVersion();
            Enumeration<String> e2 = pluginObject.getCompatibleKernelVersions();
            while (e2.hasMoreElements()) {
                String pversion = e2.nextElement();
                if (!kversion.equals(pversion) && !pversion.equals("any")) continue;
                kenabled = true;
            }
            boolean denabled = false;
            if (type.equals("generic")) {
                String currdevid = Devices.getCurrent().getId();
                Enumeration<String> e3 = pluginObject.getCompatibleDevices();
                while (e3.hasMoreElements()) {
                    String pversion = e3.nextElement();
                    if (!currdevid.equals(pversion) && !pversion.equals("any")) continue;
                    denabled = true;
                }
            } else {
                denabled = true;
            }
            boolean hasroot = false;
            if (pluginObject.isRootNeeded()) {
                hasroot = Devices.getCurrent().hasRoot();
            }
            if (type.equals("device") && aenabled && kenabled && denabled && hasroot) {
                plugins.put(pluginObject.getName(), pluginObject);
            } else if (aenabled && kenabled && denabled && hasroot) {
                plugins.put(pluginObject.getName(), pluginObject);
            }
            Enumeration<Object> e = plugins.keys();
            while (e.hasMoreElements()) {
                String string = (String)e.nextElement();
            }
        }
        catch (Exception e) {
            MyLogger.getLogger().error((Object)e.getMessage());
        }
    }
}

