/*
 * Decompiled with CFR 0.152.
 */
package flashsystem;

import flashsystem.HexDump;
import flashsystem.S1Packet;
import flashsystem.X10FlashException;
import flashsystem.io.USBFlash;
import java.io.IOException;
import java.util.Arrays;
import org.logger.MyLogger;

public class Command {
    private boolean _simulate;
    public static final byte[] TA_EDREAM_FLASH_STARTUP_SHUTDOWN_RESULT_ONGOING;
    public static final byte[] TA_FLASH_STARTUP_SHUTDOWN_RESULT_FINISHED;
    public static final byte[] TA_EDREAM_FLASH_STARTUP_SHUTDOWN_RESULT_FINISHED;
    static final int CMD01 = 1;
    static final int CMD04 = 4;
    static final int CMD05 = 5;
    static final int CMD06 = 6;
    static final int CMD07 = 7;
    static final int CMD09 = 9;
    static final int CMD10 = 10;
    static final int CMD12 = 12;
    static final int CMD13 = 13;
    static final byte[] VALNULL;
    static final byte[] VAL1;
    static final byte[] VAL2;

    static {
        byte[] byArray = new byte[9];
        byArray[2] = 39;
        byArray[3] = 116;
        byArray[7] = 1;
        byArray[8] = 1;
        TA_EDREAM_FLASH_STARTUP_SHUTDOWN_RESULT_ONGOING = byArray;
        byte[] byArray2 = new byte[9];
        byArray2[2] = 8;
        byArray2[3] = -77;
        byArray2[7] = 1;
        byArray2[8] = -86;
        TA_FLASH_STARTUP_SHUTDOWN_RESULT_FINISHED = byArray2;
        byte[] byArray3 = new byte[9];
        byArray3[2] = 39;
        byArray3[3] = 116;
        byArray3[7] = 1;
        TA_EDREAM_FLASH_STARTUP_SHUTDOWN_RESULT_FINISHED = byArray3;
        VALNULL = new byte[0];
        VAL1 = new byte[]{1};
        VAL2 = new byte[]{2};
    }

    public Command(boolean simulate) {
        this._simulate = simulate;
    }

    public String getLastReplyString() {
        try {
            return new String(USBFlash.getLastReply());
        }
        catch (Exception e) {
            return "";
        }
    }

    public String getLastReplyHex() {
        try {
            return HexDump.toHex(USBFlash.getLastReply());
        }
        catch (Exception e) {
            return "";
        }
    }

    public short getLastReplyLength() {
        try {
            return (short)USBFlash.getLastReply().length;
        }
        catch (Exception e) {
            return 0;
        }
    }

    private void writeCommand(int command, byte[] data, boolean ongoing) throws X10FlashException, IOException {
        if (!this._simulate) {
            S1Packet p = new S1Packet(command, data, ongoing);
            try {
                USBFlash.writeS1(p);
                p.release();
            }
            catch (X10FlashException xe) {
                p.release();
                throw new X10FlashException(xe.getMessage());
            }
            catch (IOException ioe) {
                p.release();
                throw new IOException(ioe.getMessage());
            }
        }
    }

    public void send(int cmd, byte[] data, boolean ongoing) throws X10FlashException, IOException {
        int maxdatalen = 65519;
        int totallen = data.length;
        int nbwrite = totallen / maxdatalen;
        int remain = totallen % maxdatalen;
        int i = 0;
        while (i < nbwrite) {
            int begin = i * maxdatalen;
            int end = (i + 1) * maxdatalen;
            this.writeCommand(cmd, Arrays.copyOfRange(data, begin, end), true);
            MyLogger.getLogger().debug((Object)("Reply      : " + this.getLastReplyString()));
            MyLogger.getLogger().debug((Object)("Reply(Hex) : " + this.getLastReplyHex()));
            if (USBFlash.getLastFlags() == 0) {
                this.writeCommand(7, VALNULL, false);
                throw new X10FlashException(this.getLastReplyString());
            }
            ++i;
        }
        if (remain > 0 || data.length == 0) {
            int begin = totallen - remain;
            int end = totallen;
            this.writeCommand(cmd, Arrays.copyOfRange(data, begin, end), ongoing);
            MyLogger.getLogger().debug((Object)("Reply      : " + this.getLastReplyString()));
            MyLogger.getLogger().debug((Object)("Reply(Hex) : " + this.getLastReplyHex()));
            if (USBFlash.getLastFlags() == 0) {
                this.writeCommand(7, VALNULL, false);
                throw new X10FlashException(this.getLastReplyString());
            }
        }
    }
}

