/*
 * Decompiled with CFR 0.152.
 */
package flashsystem;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.math.BigInteger;
import java.util.Arrays;

public class BytesUtil {
    private static long[] pivot = new long[256];
    static final String HEXES = "0123456789ABCDEF";

    static {
        int i = 0;
        while (i < 256) {
            long l1 = i;
            int j = 0;
            while (j < 8) {
                l1 = l1 % 2L == 0L ? l1 >> 1 & 0xFFFFFFFFL : (l1 >> 1 ^ 0xEDB88320L) & 0xFFFFFFFFL;
                BytesUtil.pivot[i] = l1;
                ++j;
            }
            ++i;
        }
    }

    public static byte[] getBytesWord(int paramInt1, int paramInt2) {
        int i = paramInt2;
        if (paramInt2 < 1 || paramInt2 > 4) {
            i = 4;
        }
        byte[] arrayOfByte = new byte[i];
        int j = 0;
        int k = i - 1;
        do {
            arrayOfByte[k] = (byte)(paramInt1 >> j & 0xFF);
            j += 8;
        } while (--k >= 0);
        return arrayOfByte;
    }

    public static byte[] getBytesWord(long paramLong, int paramInt) {
        int i = paramInt;
        if (paramInt < 1 || paramInt > 8) {
            i = 8;
        }
        byte[] arrayOfByte1 = new byte[]{(byte)(paramLong >>> 56), (byte)(paramLong >>> 48), (byte)(paramLong >>> 40), (byte)(paramLong >>> 32), (byte)(paramLong >>> 24), (byte)(paramLong >>> 16), (byte)(paramLong >>> 8), (byte)(paramLong >>> 0)};
        byte[] localObject = new byte[i];
        int j = 8 - i;
        int k = 0;
        do {
            localObject[k] = arrayOfByte1[j];
            ++j;
        } while (++k < i);
        return localObject;
    }

    public static byte[] bytesconcat(byte[] paramArrayOfByte1, byte[] paramArrayOfByte2) {
        byte[] arrayOfByte = null;
        if (paramArrayOfByte1 == null && paramArrayOfByte2 != null) {
            arrayOfByte = new byte[paramArrayOfByte2.length];
            System.arraycopy(paramArrayOfByte2, 0, arrayOfByte, 0, paramArrayOfByte2.length);
        } else if (paramArrayOfByte1 != null && paramArrayOfByte2 == null) {
            arrayOfByte = new byte[paramArrayOfByte1.length];
            System.arraycopy(paramArrayOfByte1, 0, arrayOfByte, 0, paramArrayOfByte1.length);
        } else if (paramArrayOfByte1 != null && paramArrayOfByte2 != null) {
            arrayOfByte = new byte[paramArrayOfByte1.length + paramArrayOfByte2.length];
            System.arraycopy(paramArrayOfByte1, 0, arrayOfByte, 0, paramArrayOfByte1.length);
            System.arraycopy(paramArrayOfByte2, 0, arrayOfByte, paramArrayOfByte1.length, paramArrayOfByte2.length);
        }
        return arrayOfByte;
    }

    public static int getInt(byte[] paramArrayOfByte) {
        if (paramArrayOfByte == null) {
            return 0;
        }
        byte[] arrayOfByte = paramArrayOfByte;
        int i = arrayOfByte.length;
        if (i < 4) {
            arrayOfByte = BytesUtil.bytesconcat(new byte[4 - i], arrayOfByte);
        }
        return new BigInteger(arrayOfByte).intValue();
    }

    public static long getLong(byte[] paramArrayOfByte) {
        if (paramArrayOfByte == null) {
            return 0L;
        }
        byte[] arrayOfByte = paramArrayOfByte;
        int i = arrayOfByte.length;
        if (i < 4) {
            arrayOfByte = BytesUtil.bytesconcat(new byte[4 - i], arrayOfByte);
        }
        return new BigInteger(arrayOfByte).longValue();
    }

    public static byte[] getCRC32(byte[] paramArrayOfByte) {
        long result = 0L;
        int i = 0;
        while (i < paramArrayOfByte.length) {
            long l = 0xFFL & (long)paramArrayOfByte[i] & 0xFFFFFFFFL;
            long l1 = (result ^ l) & 0xFFFFFFFFL;
            result = (result >> 8 & 0xFFFFFFFFL ^ pivot[(int)(l1 & 0xFFL)]) & 0xFFFFFFFFL;
            ++i;
        }
        return BytesUtil.getBytesWord(result & 0xFFFFFFFFL, 4);
    }

    public static String getHex(byte[] raw) {
        if (raw == null) {
            return null;
        }
        StringBuilder hex = new StringBuilder(2 * raw.length);
        byte[] byArray = raw;
        int n = raw.length;
        int n2 = 0;
        while (n2 < n) {
            byte b = byArray[n2];
            hex.append(HEXES.charAt((b & 0xF0) >> 4)).append(HEXES.charAt(b & 0xF));
            ++n2;
        }
        return hex.toString();
    }

    public static Byte[] getBytes(String hexString) {
        int len = hexString.length();
        Byte[] data = new Byte[len / 2];
        int i = 0;
        while (i < len) {
            data[i / 2] = (byte)((Character.digit(hexString.charAt(i), 16) << 4) + Character.digit(hexString.charAt(i + 1), 16));
            i += 2;
        }
        return data;
    }

    public static byte[] concatAll(byte[] first, byte[] ... rest) {
        int totalLength = first.length;
        byte[][] byArray = rest;
        int n = rest.length;
        int n2 = 0;
        while (n2 < n) {
            byte[] array = byArray[n2];
            totalLength += array.length;
            ++n2;
        }
        byte[] result = Arrays.copyOf(first, totalLength);
        int offset = first.length;
        byte[][] byArray2 = rest;
        int n3 = rest.length;
        int n4 = 0;
        while (n4 < n3) {
            byte[] array = byArray2[n4];
            System.arraycopy(array, 0, result, offset, array.length);
            offset += array.length;
            ++n4;
        }
        return result;
    }

    public static <T> T[] concatAll(T[] first, T[] ... rest) {
        int totalLength = first.length;
        T[][] TArray = rest;
        int n = rest.length;
        int n2 = 0;
        while (n2 < n) {
            T[] array = TArray[n2];
            totalLength += array.length;
            ++n2;
        }
        T[] result = Arrays.copyOf(first, totalLength);
        int offset = first.length;
        T[][] TArray2 = rest;
        int n3 = rest.length;
        int n4 = 0;
        while (n4 < n3) {
            T[] array = TArray2[n4];
            System.arraycopy(array, 0, result, offset, array.length);
            offset += array.length;
            ++n4;
        }
        return result;
    }

    public static byte[] getReply(byte[] reply, int nbread) {
        if (reply.length == nbread) {
            return reply;
        }
        byte[] newreply = null;
        if (nbread > 0) {
            newreply = new byte[nbread];
            System.arraycopy(reply, 0, newreply, 0, nbread);
        }
        return newreply;
    }

    public static byte[] getBytesFromFile(File file) throws IOException {
        FileInputStream is = new FileInputStream(file);
        long length = file.length();
        if (length > Integer.MAX_VALUE) {
            throw new IOException("File too large for this operation");
        }
        byte[] bytes = new byte[(int)length];
        int offset = 0;
        int numRead = 0;
        while (offset < bytes.length && (numRead = ((InputStream)is).read(bytes, offset, bytes.length - offset)) >= 0) {
            offset += numRead;
        }
        if (offset < bytes.length) {
            throw new IOException("Could not completely read file " + file.getName());
        }
        ((InputStream)is).close();
        return bytes;
    }

    public static byte[] revert(byte[] array) {
        int i = 0;
        int j = array.length - 1;
        while (i < j) {
            byte b = array[i];
            array[i] = array[j];
            array[j] = b;
            ++i;
            --j;
        }
        return array;
    }
}

