/*
 * Decompiled with CFR 0.152.
 */
package flashsystem;

import java.io.IOException;
import java.io.OutputStream;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Properties;
import java.util.Vector;
import org.jdom.Document;
import org.jdom.Element;
import org.jdom.output.XMLOutputter;

public class BundleMetaData {
    Hashtable<String, Vector<String>> _categ = new Hashtable();
    Properties _ftoint = new Properties();
    Properties _inttof = new Properties();
    Properties _pathtof = new Properties();
    Properties _categex = new Properties();
    Properties _categwipe = new Properties();
    Properties _enabled = new Properties();
    Properties _catorders = new Properties();

    public BundleMetaData() {
        this._categex.setProperty("SYSTEM", "Exclude system");
        this._categex.setProperty("BASEBAND", "Exclude baseband");
        this._categex.setProperty("KERNEL", "Exclude kernel");
        this._categex.setProperty("PARTITION", "Exclude partition");
        this._categex.setProperty("NONE", "Exclude uncategorized");
        this._categex.setProperty("FOTA", "Exclude Fota");
        this._categex.setProperty("TA", "Exclude TA");
        this._categwipe.setProperty("DATA", "Wipe data");
        this._categwipe.setProperty("CACHE", "Wipe cache");
        this._categwipe.setProperty("LOG", "Wipe apps log");
        this._catorders.setProperty("1", "KERNEL");
        this._catorders.setProperty("2", "FOTA");
        this._catorders.setProperty("3", "BASEBAND");
        this._catorders.setProperty("4", "NONE");
        this._catorders.setProperty("5", "LOG");
        this._catorders.setProperty("6", "SYSTEM");
        this._catorders.setProperty("7", "DATA");
        this._catorders.setProperty("8", "CACHE");
    }

    public int getNbCategs() {
        return this._catorders.size();
    }

    public String getCagorie(int order) {
        return this._catorders.getProperty(Integer.toString(order));
    }

    public Enumeration<String> getCategories() {
        return this._categ.keys();
    }

    public Enumeration<String> getWipe() {
        Vector<String> list = new Vector<String>();
        Enumeration<String> categlist = this._categ.keys();
        while (categlist.hasMoreElements()) {
            String key = categlist.nextElement();
            if (!this._categwipe.containsKey(key)) continue;
            list.add(key);
        }
        return list.elements();
    }

    public String getWipeLabel(String categ) {
        return this._categwipe.getProperty(categ);
    }

    public String getExcludeLabel(String categ) {
        return this._categex.getProperty(categ);
    }

    public Enumeration<String> getExclude() {
        Vector<String> list = new Vector<String>();
        Enumeration<String> categlist = this._categ.keys();
        while (categlist.hasMoreElements()) {
            String key = categlist.nextElement();
            if (!this._categex.containsKey(key)) continue;
            list.add(key);
        }
        return list.elements();
    }

    public void process(String fname, String path) throws Exception {
        String intname = fname;
        int S1pos = intname.toUpperCase().indexOf("_S1");
        if (S1pos > 0) {
            intname = String.valueOf(intname.substring(0, S1pos)) + ".sin";
        }
        this._ftoint.setProperty(fname, intname);
        this._inttof.setProperty(intname, fname);
        this._pathtof.setProperty(intname, path);
        if (intname.toUpperCase().contains("SYSTEM")) {
            this.add(intname, "system".toUpperCase());
        } else if (intname.toUpperCase().contains("USERDATA")) {
            this.add(intname, "data".toUpperCase());
        } else if (intname.toUpperCase().contains("AMSS")) {
            this.add(intname, "baseband".toUpperCase());
        } else if (intname.toUpperCase().contains("ADSP") || intname.toUpperCase().startsWith("DSP")) {
            this.add(intname, "baseband".toUpperCase());
        } else if (intname.toUpperCase().contains("MODEM") || intname.toUpperCase().contains("PRCMU")) {
            this.add(intname, "baseband".toUpperCase());
        } else if (intname.toUpperCase().contains("FOTA")) {
            this.add(intname, "fota".toUpperCase());
        } else if (intname.toUpperCase().contains("APPS_LOG")) {
            this.add(intname, "log".toUpperCase());
        } else if (intname.toUpperCase().contains("CACHE")) {
            this.add(intname, "cache".toUpperCase());
        } else if (intname.toUpperCase().contains("KERNEL")) {
            this.add(intname, "kernel".toUpperCase());
        } else if (intname.toUpperCase().startsWith("PARTITION")) {
            this.add(intname, "partition".toUpperCase());
        } else if (intname.toUpperCase().startsWith("LOADER")) {
            this.add(intname, "loader".toUpperCase());
        } else if (intname.toUpperCase().endsWith(".TA")) {
            this.add(intname, "ta".toUpperCase());
        } else {
            this.add(intname, "none".toUpperCase());
        }
    }

    public void add(String intname, String categorie) throws Exception {
        Enumeration<String> elem = this._categ.keys();
        while (elem.hasMoreElements()) {
            String lcateg = elem.nextElement();
            if (!this._categ.get(lcateg).contains(intname) || lcateg.equals(categorie)) continue;
            throw new Exception("A file cannot be affected to more  than one category");
        }
        Vector<String> list = this._categ.containsKey(categorie) ? this._categ.get(categorie) : new Vector<String>();
        list.add(intname);
        this._categ.put(categorie, list);
        this._enabled.put(categorie, "true");
    }

    public void setCategEnabled(String categ, boolean enabled) {
        if (enabled) {
            this._enabled.setProperty(categ, "true");
        } else {
            this._enabled.setProperty(categ, "false");
        }
    }

    public void remove(String name) {
        String categ = this.getCategorie(name);
        if (categ.length() > 0) {
            Vector<String> list = this._categ.get(categ);
            list.remove(name);
            if (list.size() == 0) {
                this._categ.remove(categ);
            }
        }
    }

    public String toString() {
        String result = "";
        Enumeration<String> elem = this._categ.keys();
        while (elem.hasMoreElements()) {
            String categ = elem.nextElement();
            result = String.valueOf(result) + categ + "\n";
            Vector<String> list = this._categ.get(categ);
            Enumeration<String> listelem = list.elements();
            while (listelem.hasMoreElements()) {
                result = String.valueOf(result) + "   " + listelem.nextElement() + "\n";
            }
        }
        return result;
    }

    public String getInternal(String external) {
        return this._ftoint.getProperty(external);
    }

    public String getExternal(String internal) {
        return this._inttof.getProperty(internal);
    }

    public boolean hasCategorie(String categ, boolean checkSelected) {
        if (this._categ.containsKey(categ.toUpperCase())) {
            if (checkSelected) {
                return this._enabled.getProperty(categ.toUpperCase()).equals("true");
            }
            return true;
        }
        return false;
    }

    public String getCategorie(String name) {
        Enumeration<String> elems = this._categ.keys();
        while (elems.hasMoreElements()) {
            String categ = elems.nextElement();
            Vector<String> list = this._categ.get(categ);
            if (!list.contains(name)) continue;
            return categ;
        }
        return "";
    }

    public Enumeration<String> getAllEntries(boolean checkSelected) {
        Vector<String> result = new Vector<String>();
        Enumeration<String> elem = this._categ.keys();
        while (elem.hasMoreElements()) {
            String categ = elem.nextElement();
            boolean toAdd = true;
            if (checkSelected) {
                toAdd = this._enabled.getProperty(categ).equals("true");
            }
            if (!toAdd) continue;
            Vector<String> list = this._categ.get(categ);
            Enumeration<String> listelem = list.elements();
            while (listelem.hasMoreElements()) {
                result.add(listelem.nextElement());
            }
        }
        return result.elements();
    }

    public Enumeration<String> getEntriesOf(String pcateg, boolean checkSelected) {
        Vector<String> result = new Vector<String>();
        Enumeration<String> elem = this._categ.keys();
        while (elem.hasMoreElements()) {
            String categ = elem.nextElement();
            if (!categ.toUpperCase().equals(pcateg.toUpperCase())) continue;
            boolean toAdd = true;
            if (checkSelected) {
                toAdd = this._enabled.getProperty(categ).equals("true");
            }
            if (!toAdd) continue;
            Vector<String> list = this._categ.get(categ);
            Enumeration<String> listelem = list.elements();
            while (listelem.hasMoreElements()) {
                result.add(listelem.nextElement());
            }
        }
        return result.elements();
    }

    public Enumeration<String> getEntries() {
        Vector<String> result = new Vector<String>();
        Enumeration<String> elem = this._categ.keys();
        while (elem.hasMoreElements()) {
            String categ = elem.nextElement();
            Vector<String> list = this._categ.get(categ);
            Enumeration<String> listelem = list.elements();
            while (listelem.hasMoreElements()) {
                result.add(listelem.nextElement());
            }
        }
        return result.elements();
    }

    public String getPath(String name) {
        return this._pathtof.getProperty(name);
    }

    public void createXML() {
        Element root = new Element("BundleMetaData");
        Document doc = new Document(root);
        XMLOutputter outputter = new XMLOutputter();
        try {
            outputter.output(doc, (OutputStream)System.out);
        }
        catch (IOException e) {
            System.err.println(e);
        }
    }

    public boolean isCategEnabled(String categ) {
        if (this._enabled.getProperty(categ) == null) {
            return false;
        }
        return this._enabled.getProperty(categ).equals("true");
    }

    public void clear() {
        this._categ.clear();
        this._ftoint.clear();
        this._inttof.clear();
        this._pathtof.clear();
        this._enabled.clear();
    }
}

