/*
 * Decompiled with CFR 0.152.
 */
package flashsystem;

import flashsystem.Bundle;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.util.jar.JarEntry;
import org.logger.MyLogger;
import org.system.OS;

public class BundleEntry {
    private File fileentry = null;
    private JarEntry jarentry = null;
    private Bundle _bundle;
    private String _name;
    private String _categorie;

    public BundleEntry(File f, String name) {
        this.fileentry = f;
        this._name = name;
    }

    public BundleEntry(Bundle b, JarEntry j) {
        this.jarentry = j;
        this._bundle = b;
        this._name = j.getName();
    }

    public InputStream getInputStream() throws FileNotFoundException, IOException {
        if (this.fileentry != null) {
            MyLogger.getLogger().debug((Object)("Streaming from file : " + this.fileentry.getPath()));
            return new FileInputStream(this.fileentry);
        }
        MyLogger.getLogger().debug((Object)("Streaming from jar entry : " + this.jarentry.getName()));
        return this._bundle.getImageStream(this.jarentry);
    }

    public String getName() {
        return this._name;
    }

    public String getAbsolutePath() {
        return this.fileentry.getAbsolutePath();
    }

    public boolean isJarEntry() {
        return this.jarentry != null;
    }

    public String getMD5() {
        if (this.fileentry != null) {
            return OS.getMD5(this.fileentry);
        }
        return "";
    }

    public long getSize() {
        if (this.fileentry != null) {
            return this.fileentry.length();
        }
        return this.jarentry.getSize();
    }

    public void setCategorie(String categorie) {
        this._categorie = categorie;
    }

    public String getCategorie() {
        return this._categorie;
    }
}

