/*
 * Decompiled with CFR 0.152.
 */
package flashsystem;

import flashsystem.BundleEntry;
import flashsystem.BundleException;
import flashsystem.BundleMetaData;
import gui.FirmwareFileFilter;
import java.io.BufferedOutputStream;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Enumeration;
import java.util.Properties;
import java.util.Vector;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.jar.JarOutputStream;
import java.util.jar.Manifest;
import org.logger.MyLogger;
import org.system.OS;

public final class Bundle {
    private JarFile _firmware;
    private boolean _simulate = false;
    private Properties bundleList = new Properties();
    private String _version;
    private String _branding;
    private String _device;
    private String _cmd25;
    public static final int JARTYPE = 1;
    public static final int FOLDERTYPE = 2;
    private BundleMetaData _meta;

    public Bundle() {
        this._meta = new BundleMetaData();
    }

    public Bundle(String path, int type) {
        this.feed(path, type);
    }

    public void setMeta(BundleMetaData meta) {
        this._meta = meta;
        this.feedFromMeta();
    }

    public Bundle(String path, int type, BundleMetaData meta) {
        this._meta = meta;
        this.feed(path, type);
    }

    private void feed(String path, int type) {
        if (type == 1) {
            this.feedFromJar(path);
        }
        if (type == 2) {
            this.feedFromFolder(path);
        }
    }

    private void feedFromJar(String path) {
        try {
            this._firmware = new JarFile(path);
            this._meta = new BundleMetaData();
            MyLogger.getLogger().debug((Object)("Creating bundle from ftf file : " + this._firmware.getName()));
            Enumeration<JarEntry> e = this._firmware.entries();
            while (e.hasMoreElements()) {
                BundleEntry entry = new BundleEntry(this, e.nextElement());
                if (!entry.getName().toUpperCase().endsWith("SIN") && !entry.getName().toUpperCase().endsWith("TA")) continue;
                try {
                    this._meta.process(entry.getName(), "");
                }
                catch (Exception exception) {
                    // empty catch block
                }
                this.bundleList.put(entry.getName(), entry);
                MyLogger.getLogger().debug((Object)("Added this entry to the bundle list : " + entry.getName()));
            }
        }
        catch (IOException ioe) {
            MyLogger.getLogger().error((Object)("Cannot open the file " + path));
        }
    }

    private void feedFromFolder(String path) {
        File[] list = new File(path).listFiles(new FirmwareFileFilter());
        int i = 0;
        while (i < list.length) {
            BundleEntry entry = new BundleEntry(list[i], list[i].getName());
            this.bundleList.put(entry.getName(), entry);
            MyLogger.getLogger().debug((Object)("Added this entry to the bundle list : " + entry.getName()));
            ++i;
        }
    }

    private void feedFromMeta() {
        this.bundleList.clear();
        Enumeration<String> all = this._meta.getAllEntries(true);
        while (all.hasMoreElements()) {
            String name = all.nextElement();
            BundleEntry entry = new BundleEntry(new File(this._meta.getPath(name)), name);
            this.bundleList.put(entry.getName(), entry);
            MyLogger.getLogger().debug((Object)("Added this entry to the bundle list : " + entry.getName()));
        }
    }

    public void setLoader(File loader) {
        try {
            if (this._meta != null) {
                this._meta.process("loader.sin", loader.getAbsolutePath());
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        BundleEntry entry = new BundleEntry(loader, "loader.sin");
        this.bundleList.put("loader.sin", entry);
    }

    public void setSimulate(boolean simulate) {
        this._simulate = simulate;
    }

    public BundleEntry getEntry(String name) {
        return (BundleEntry)this.bundleList.get(name);
    }

    public Enumeration<BundleEntry> allEntries() {
        Vector<BundleEntry> v = new Vector<BundleEntry>();
        Enumeration<Object> e = this.bundleList.keys();
        while (e.hasMoreElements()) {
            String key = (String)e.nextElement();
            BundleEntry entry = (BundleEntry)this.bundleList.get(key);
            v.add(entry);
        }
        return v.elements();
    }

    public InputStream getImageStream(JarEntry j) throws IOException {
        return this._firmware.getInputStream(j);
    }

    public boolean hasTA() {
        return this._meta.hasCategorie("TA", true);
    }

    public BundleEntry getLoader() throws IOException, FileNotFoundException {
        return (BundleEntry)this.bundleList.get("loader.sin");
    }

    public boolean hasLoader() {
        return this._meta.hasCategorie("LOADER", false);
    }

    public BundleEntry getPartition() throws IOException, FileNotFoundException {
        return (BundleEntry)this.bundleList.get(this._meta.getEntriesOf("PARTITION", true).nextElement());
    }

    public boolean hasPartition() {
        return this._meta.hasCategorie("PARTITION", true);
    }

    public boolean simulate() {
        return this._simulate;
    }

    public void setVersion(String version) {
        this._version = version;
    }

    public void setBranding(String branding) {
        this._branding = branding;
    }

    public void setDevice(String device) {
        this._device = device;
    }

    public void setCmd25(String value) {
        this._cmd25 = value;
        if (this._cmd25 == null) {
            this._cmd25 = "false";
        }
    }

    public boolean hasCmd25() {
        try {
            return this._cmd25.equals("true");
        }
        catch (Exception e) {
            return false;
        }
    }

    public void createFTF() throws Exception {
        File ftf = new File("./firmwares/" + this._device + "_" + this._version + "_" + this._branding + ".ftf");
        byte[] buffer = new byte[10240];
        StringBuffer sbuf = new StringBuffer();
        sbuf.append("Manifest-Version: 1.0\n");
        sbuf.append("Created-By: FlashTool\n");
        sbuf.append("version: " + this._version + "\n");
        sbuf.append("branding: " + this._branding + "\n");
        sbuf.append("device: " + this._device + "\n");
        sbuf.append("cmd25: " + this._cmd25 + "\n");
        Manifest manifest = new Manifest(new ByteArrayInputStream(sbuf.toString().getBytes("UTF-8")));
        FileOutputStream stream = new FileOutputStream(ftf);
        JarOutputStream out = new JarOutputStream((OutputStream)stream, manifest);
        out.setLevel(1);
        Enumeration<BundleEntry> e = this.allEntries();
        while (e.hasMoreElements()) {
            int nRead;
            BundleEntry entry = e.nextElement();
            String name = entry.getName();
            int S1pos = name.toUpperCase().indexOf("_S1");
            if (S1pos > 0) {
                name = String.valueOf(name.substring(0, S1pos)) + ".sin";
            }
            MyLogger.getLogger().info((Object)("Adding " + entry.getName() + " to the bundle"));
            JarEntry jarAdd = new JarEntry(name);
            out.putNextEntry(jarAdd);
            InputStream in = entry.getInputStream();
            while ((nRead = in.read(buffer, 0, buffer.length)) > 0) {
                out.write(buffer, 0, nRead);
            }
            in.close();
        }
        out.close();
        stream.close();
    }

    private void saveEntry(BundleEntry entry) throws IOException {
        if (entry.isJarEntry()) {
            int len;
            MyLogger.getLogger().debug((Object)("Saving entry " + entry.getName() + " to disk"));
            InputStream in = entry.getInputStream();
            String outname = "." + OS.getFileSeparator() + "firmwares" + OS.getFileSeparator() + "prepared" + OS.getFileSeparator() + entry.getName();
            MyLogger.getLogger().debug((Object)("Writing Entry to " + outname));
            BufferedOutputStream out = new BufferedOutputStream(new FileOutputStream(outname));
            byte[] buffer = new byte[1024];
            while ((len = in.read(buffer)) >= 0) {
                ((OutputStream)out).write(buffer, 0, len);
            }
            in.close();
            ((OutputStream)out).close();
            this.bundleList.put(entry.getName(), new BundleEntry(new File(outname), entry.getName()));
        }
    }

    public long getMaxProgress() {
        Enumeration<String> e = this.getMeta().getAllEntries(true);
        long totalsize = 0L;
        while (e.hasMoreElements()) {
            BundleEntry entry = this.getEntry(e.nextElement());
            if (entry.getName().contains("loader")) {
                totalsize += entry.getSize() / 4096L;
                if (entry.getSize() % 4096L > 0L) {
                    ++totalsize;
                }
                ++totalsize;
            } else if (entry.getName().toUpperCase().endsWith("SIN")) {
                totalsize += entry.getSize() / 65536L * 2L;
            }
            if (entry.getSize() % 65536L > 0L) {
                ++totalsize;
            }
            ++totalsize;
        }
        if (this.hasCmd25()) {
            ++totalsize;
        }
        if (this.hasPartition()) {
            totalsize += 2L;
        }
        return totalsize + 8L;
    }

    public void open() throws BundleException {
        try {
            File f = new File("." + OS.getFileSeparator() + "firmwares" + OS.getFileSeparator() + "prepared");
            if (f.exists()) {
                File[] f1 = f.listFiles();
                int i = 0;
                while (i < f1.length) {
                    if (!f1[i].delete()) {
                        throw new Exception("Cannot delete " + f1[i].getAbsolutePath());
                    }
                    ++i;
                }
                if (!f.delete()) {
                    throw new Exception("Cannot delete " + f.getAbsolutePath());
                }
            }
            f.mkdir();
            MyLogger.getLogger().debug((Object)("Created the " + f.getName() + " folder"));
            Enumeration<String> entries = this._meta.getAllEntries(true);
            while (entries.hasMoreElements()) {
                this.saveEntry(this.getEntry(entries.nextElement()));
            }
            if (this.hasLoader()) {
                this.saveEntry(this.getLoader());
            }
        }
        catch (Exception e) {
            throw new BundleException(e.getMessage());
        }
    }

    public void close() {
        if (this._firmware != null) {
            Enumeration<JarEntry> e = this._firmware.entries();
            while (e.hasMoreElements()) {
                JarEntry entry = e.nextElement();
                if (!entry.getName().toUpperCase().endsWith("SIN") && !entry.getName().toUpperCase().endsWith("TA")) continue;
                String outname = "." + OS.getFileSeparator() + "firmwares" + OS.getFileSeparator() + "prepared" + OS.getFileSeparator() + entry.getName();
                File f = new File(outname);
                f.delete();
            }
            File f = new File("." + OS.getFileSeparator() + "firmwares" + OS.getFileSeparator() + "prepared");
            f.delete();
            try {
                this._firmware.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    public void removeEntry(String name) {
        this.bundleList.remove(name);
    }

    public BundleMetaData getMeta() {
        return this._meta;
    }
}

