/*
 * Decompiled with CFR 0.152.
 */
package sun.org.mozilla.javascript.internal;

import java.io.Serializable;
import sun.org.mozilla.javascript.internal.Interpreter;
import sun.org.mozilla.javascript.internal.ScriptRuntime;
import sun.org.mozilla.javascript.internal.UintMap;
import sun.org.mozilla.javascript.internal.debug.DebuggableScript;

final class InterpreterData
implements Serializable,
DebuggableScript {
    static final long serialVersionUID = 5067677351589230234L;
    static final int INITIAL_MAX_ICODE_LENGTH = 1024;
    static final int INITIAL_STRINGTABLE_SIZE = 64;
    static final int INITIAL_NUMBERTABLE_SIZE = 64;
    String itsName;
    String itsSourceFile;
    boolean itsNeedsActivation;
    int itsFunctionType;
    String[] itsStringTable;
    double[] itsDoubleTable;
    InterpreterData[] itsNestedFunctions;
    Object[] itsRegExpLiterals;
    byte[] itsICode;
    int[] itsExceptionTable;
    int itsMaxVars;
    int itsMaxLocals;
    int itsMaxStack;
    int itsMaxFrameArray;
    String[] argNames;
    boolean[] argIsConst;
    int argCount;
    int itsMaxCalleeArgs;
    String encodedSource;
    int encodedSourceStart;
    int encodedSourceEnd;
    int languageVersion;
    boolean useDynamicScope;
    boolean isStrict;
    boolean topLevel;
    Object[] literalIds;
    UintMap longJumps;
    int firstLinePC = -1;
    InterpreterData parentData;
    boolean evalScriptFlag;

    InterpreterData(int n, String string, String string2, boolean bl) {
        this.languageVersion = n;
        this.itsSourceFile = string;
        this.encodedSource = string2;
        this.isStrict = bl;
        this.init();
    }

    InterpreterData(InterpreterData interpreterData) {
        this.parentData = interpreterData;
        this.languageVersion = interpreterData.languageVersion;
        this.itsSourceFile = interpreterData.itsSourceFile;
        this.encodedSource = interpreterData.encodedSource;
        this.init();
    }

    private void init() {
        this.itsICode = new byte[1024];
        this.itsStringTable = new String[64];
    }

    @Override
    public boolean isTopLevel() {
        return this.topLevel;
    }

    @Override
    public boolean isFunction() {
        return this.itsFunctionType != 0;
    }

    @Override
    public String getFunctionName() {
        return this.itsName;
    }

    @Override
    public int getParamCount() {
        return this.argCount;
    }

    @Override
    public int getParamAndVarCount() {
        return this.argNames.length;
    }

    @Override
    public String getParamOrVarName(int n) {
        return this.argNames[n];
    }

    public boolean getParamOrVarConst(int n) {
        return this.argIsConst[n];
    }

    @Override
    public String getSourceName() {
        return this.itsSourceFile;
    }

    @Override
    public boolean isGeneratedScript() {
        return ScriptRuntime.isGeneratedScript(this.itsSourceFile);
    }

    @Override
    public int[] getLineNumbers() {
        return Interpreter.getLineNumbers(this);
    }

    @Override
    public int getFunctionCount() {
        return this.itsNestedFunctions == null ? 0 : this.itsNestedFunctions.length;
    }

    @Override
    public DebuggableScript getFunction(int n) {
        return this.itsNestedFunctions[n];
    }

    @Override
    public DebuggableScript getParent() {
        return this.parentData;
    }
}

