/*
 * Decompiled with CFR 0.152.
 */
package sun.org.mozilla.classfile.internal;

import sun.org.mozilla.classfile.internal.ClassFileWriter;
import sun.org.mozilla.classfile.internal.FieldOrMethodRef;
import sun.org.mozilla.javascript.internal.ObjToIntMap;
import sun.org.mozilla.javascript.internal.UintMap;

final class ConstantPool {
    private static final int ConstantPoolSize = 256;
    static final byte CONSTANT_Class = 7;
    static final byte CONSTANT_Fieldref = 9;
    static final byte CONSTANT_Methodref = 10;
    static final byte CONSTANT_InterfaceMethodref = 11;
    static final byte CONSTANT_String = 8;
    static final byte CONSTANT_Integer = 3;
    static final byte CONSTANT_Float = 4;
    static final byte CONSTANT_Long = 5;
    static final byte CONSTANT_Double = 6;
    static final byte CONSTANT_NameAndType = 12;
    static final byte CONSTANT_Utf8 = 1;
    private ClassFileWriter cfw;
    private static final int MAX_UTF_ENCODING_SIZE = 65535;
    private UintMap itsStringConstHash = new UintMap();
    private ObjToIntMap itsUtf8Hash = new ObjToIntMap();
    private ObjToIntMap itsFieldRefHash = new ObjToIntMap();
    private ObjToIntMap itsMethodRefHash = new ObjToIntMap();
    private ObjToIntMap itsClassHash = new ObjToIntMap();
    private int itsTop;
    private int itsTopIndex;
    private UintMap itsConstantData = new UintMap();
    private UintMap itsPoolTypes = new UintMap();
    private byte[] itsPool;

    ConstantPool(ClassFileWriter classFileWriter) {
        this.cfw = classFileWriter;
        this.itsTopIndex = 1;
        this.itsPool = new byte[256];
        this.itsTop = 0;
    }

    int write(byte[] byArray, int n) {
        n = ClassFileWriter.putInt16((short)this.itsTopIndex, byArray, n);
        System.arraycopy(this.itsPool, 0, byArray, n, this.itsTop);
        return n += this.itsTop;
    }

    int getWriteSize() {
        return 2 + this.itsTop;
    }

    int addConstant(int n) {
        this.ensure(5);
        this.itsPool[this.itsTop++] = 3;
        this.itsTop = ClassFileWriter.putInt32(n, this.itsPool, this.itsTop);
        this.itsPoolTypes.put(this.itsTopIndex, 3);
        return (short)this.itsTopIndex++;
    }

    int addConstant(long l) {
        this.ensure(9);
        this.itsPool[this.itsTop++] = 5;
        this.itsTop = ClassFileWriter.putInt64(l, this.itsPool, this.itsTop);
        int n = this.itsTopIndex;
        this.itsTopIndex += 2;
        this.itsPoolTypes.put(n, 5);
        return n;
    }

    int addConstant(float f) {
        this.ensure(5);
        this.itsPool[this.itsTop++] = 4;
        int n = Float.floatToIntBits(f);
        this.itsTop = ClassFileWriter.putInt32(n, this.itsPool, this.itsTop);
        this.itsPoolTypes.put(this.itsTopIndex, 4);
        return this.itsTopIndex++;
    }

    int addConstant(double d) {
        this.ensure(9);
        this.itsPool[this.itsTop++] = 6;
        long l = Double.doubleToLongBits(d);
        this.itsTop = ClassFileWriter.putInt64(l, this.itsPool, this.itsTop);
        int n = this.itsTopIndex;
        this.itsTopIndex += 2;
        this.itsPoolTypes.put(n, 6);
        return n;
    }

    int addConstant(String string) {
        int n = 0xFFFF & this.addUtf8(string);
        int n2 = this.itsStringConstHash.getInt(n, -1);
        if (n2 == -1) {
            n2 = this.itsTopIndex++;
            this.ensure(3);
            this.itsPool[this.itsTop++] = 8;
            this.itsTop = ClassFileWriter.putInt16(n, this.itsPool, this.itsTop);
            this.itsStringConstHash.put(n, n2);
        }
        this.itsPoolTypes.put(n2, 8);
        return n2;
    }

    boolean isUnderUtfEncodingLimit(String string) {
        int n = string.length();
        if (n * 3 <= 65535) {
            return true;
        }
        if (n > 65535) {
            return false;
        }
        return n == this.getUtfEncodingLimit(string, 0, n);
    }

    int getUtfEncodingLimit(String string, int n, int n2) {
        if ((n2 - n) * 3 <= 65535) {
            return n2;
        }
        int n3 = 65535;
        for (int i = n; i != n2; ++i) {
            char c = string.charAt(i);
            n3 = '\u0000' != c && c <= '\u007f' ? --n3 : (c < '\u07ff' ? (n3 -= 2) : (n3 -= 3));
            if (n3 >= 0) continue;
            return i;
        }
        return n2;
    }

    short addUtf8(String string) {
        int n = this.itsUtf8Hash.get(string, -1);
        if (n == -1) {
            boolean bl;
            int n2 = string.length();
            if (n2 > 65535) {
                bl = true;
            } else {
                int n3;
                bl = false;
                this.ensure(3 + n2 * 3);
                int n4 = this.itsTop;
                this.itsPool[n4++] = 1;
                n4 += 2;
                char[] cArray = this.cfw.getCharBuffer(n2);
                string.getChars(0, n2, cArray, 0);
                for (n3 = 0; n3 != n2; ++n3) {
                    char c = cArray[n3];
                    if (c != '\u0000' && c <= '\u007f') {
                        this.itsPool[n4++] = (byte)c;
                        continue;
                    }
                    if (c > '\u07ff') {
                        this.itsPool[n4++] = (byte)(0xE0 | c >> 12);
                        this.itsPool[n4++] = (byte)(0x80 | c >> 6 & 0x3F);
                        this.itsPool[n4++] = (byte)(0x80 | c & 0x3F);
                        continue;
                    }
                    this.itsPool[n4++] = (byte)(0xC0 | c >> 6);
                    this.itsPool[n4++] = (byte)(0x80 | c & 0x3F);
                }
                n3 = n4 - (this.itsTop + 1 + 2);
                if (n3 > 65535) {
                    bl = true;
                } else {
                    this.itsPool[this.itsTop + 1] = (byte)(n3 >>> 8);
                    this.itsPool[this.itsTop + 2] = (byte)n3;
                    this.itsTop = n4;
                    n = this.itsTopIndex++;
                    this.itsUtf8Hash.put(string, n);
                }
            }
            if (bl) {
                throw new IllegalArgumentException("Too big string");
            }
        }
        this.setConstantData(n, string);
        this.itsPoolTypes.put(n, 1);
        return (short)n;
    }

    private short addNameAndType(String string, String string2) {
        short s = this.addUtf8(string);
        short s2 = this.addUtf8(string2);
        this.ensure(5);
        this.itsPool[this.itsTop++] = 12;
        this.itsTop = ClassFileWriter.putInt16(s, this.itsPool, this.itsTop);
        this.itsTop = ClassFileWriter.putInt16(s2, this.itsPool, this.itsTop);
        this.itsPoolTypes.put(this.itsTopIndex, 12);
        return (short)this.itsTopIndex++;
    }

    short addClass(String string) {
        int n = this.itsClassHash.get(string, -1);
        if (n == -1) {
            String string2 = string;
            if (string.indexOf(46) > 0 && (n = this.itsClassHash.get(string2 = ClassFileWriter.getSlashedForm(string), -1)) != -1) {
                this.itsClassHash.put(string, n);
            }
            if (n == -1) {
                short s = this.addUtf8(string2);
                this.ensure(3);
                this.itsPool[this.itsTop++] = 7;
                this.itsTop = ClassFileWriter.putInt16(s, this.itsPool, this.itsTop);
                n = this.itsTopIndex++;
                this.itsClassHash.put(string2, n);
                if (string != string2) {
                    this.itsClassHash.put(string, n);
                }
            }
        }
        this.setConstantData(n, string);
        this.itsPoolTypes.put(n, 7);
        return (short)n;
    }

    short addFieldRef(String string, String string2, String string3) {
        FieldOrMethodRef fieldOrMethodRef = new FieldOrMethodRef(string, string2, string3);
        int n = this.itsFieldRefHash.get(fieldOrMethodRef, -1);
        if (n == -1) {
            short s = this.addNameAndType(string2, string3);
            short s2 = this.addClass(string);
            this.ensure(5);
            this.itsPool[this.itsTop++] = 9;
            this.itsTop = ClassFileWriter.putInt16(s2, this.itsPool, this.itsTop);
            this.itsTop = ClassFileWriter.putInt16(s, this.itsPool, this.itsTop);
            n = this.itsTopIndex++;
            this.itsFieldRefHash.put(fieldOrMethodRef, n);
        }
        this.setConstantData(n, fieldOrMethodRef);
        this.itsPoolTypes.put(n, 9);
        return (short)n;
    }

    short addMethodRef(String string, String string2, String string3) {
        FieldOrMethodRef fieldOrMethodRef = new FieldOrMethodRef(string, string2, string3);
        int n = this.itsMethodRefHash.get(fieldOrMethodRef, -1);
        if (n == -1) {
            short s = this.addNameAndType(string2, string3);
            short s2 = this.addClass(string);
            this.ensure(5);
            this.itsPool[this.itsTop++] = 10;
            this.itsTop = ClassFileWriter.putInt16(s2, this.itsPool, this.itsTop);
            this.itsTop = ClassFileWriter.putInt16(s, this.itsPool, this.itsTop);
            n = this.itsTopIndex++;
            this.itsMethodRefHash.put(fieldOrMethodRef, n);
        }
        this.setConstantData(n, fieldOrMethodRef);
        this.itsPoolTypes.put(n, 10);
        return (short)n;
    }

    short addInterfaceMethodRef(String string, String string2, String string3) {
        short s = this.addNameAndType(string2, string3);
        short s2 = this.addClass(string);
        this.ensure(5);
        this.itsPool[this.itsTop++] = 11;
        this.itsTop = ClassFileWriter.putInt16(s2, this.itsPool, this.itsTop);
        this.itsTop = ClassFileWriter.putInt16(s, this.itsPool, this.itsTop);
        FieldOrMethodRef fieldOrMethodRef = new FieldOrMethodRef(string, string2, string3);
        this.setConstantData(this.itsTopIndex, fieldOrMethodRef);
        this.itsPoolTypes.put(this.itsTopIndex, 11);
        return (short)this.itsTopIndex++;
    }

    Object getConstantData(int n) {
        return this.itsConstantData.getObject(n);
    }

    void setConstantData(int n, Object object) {
        this.itsConstantData.put(n, object);
    }

    byte getConstantType(int n) {
        return (byte)this.itsPoolTypes.getInt(n, 0);
    }

    void ensure(int n) {
        if (this.itsTop + n > this.itsPool.length) {
            int n2 = this.itsPool.length * 2;
            if (this.itsTop + n > n2) {
                n2 = this.itsTop + n;
            }
            byte[] byArray = new byte[n2];
            System.arraycopy(this.itsPool, 0, byArray, 0, this.itsTop);
            this.itsPool = byArray;
        }
    }
}

