/*
 * Decompiled with CFR 0.152.
 */
package sun.java2d.cmm.lcms;

import java.awt.image.BufferedImage;
import sun.awt.image.ByteComponentRaster;
import sun.awt.image.IntegerComponentRaster;
import sun.awt.image.ShortComponentRaster;

class LCMSImageLayout {
    public static final int SWAPFIRST = 16384;
    public static final int DOSWAP = 1024;
    public static final int PT_RGB_8 = LCMSImageLayout.CHANNELS_SH(3) | LCMSImageLayout.BYTES_SH(1);
    public static final int PT_GRAY_8 = LCMSImageLayout.CHANNELS_SH(1) | LCMSImageLayout.BYTES_SH(1);
    public static final int PT_GRAY_16 = LCMSImageLayout.CHANNELS_SH(1) | LCMSImageLayout.BYTES_SH(2);
    public static final int PT_RGBA_8 = LCMSImageLayout.EXTRA_SH(1) | LCMSImageLayout.CHANNELS_SH(3) | LCMSImageLayout.BYTES_SH(1);
    public static final int PT_ARGB_8 = LCMSImageLayout.EXTRA_SH(1) | LCMSImageLayout.CHANNELS_SH(3) | LCMSImageLayout.BYTES_SH(1) | 0x4000;
    public static final int PT_BGR_8 = 0x400 | LCMSImageLayout.CHANNELS_SH(3) | LCMSImageLayout.BYTES_SH(1);
    public static final int PT_ABGR_8 = 0x400 | LCMSImageLayout.EXTRA_SH(1) | LCMSImageLayout.CHANNELS_SH(3) | LCMSImageLayout.BYTES_SH(1);
    public static final int PT_BGRA_8 = LCMSImageLayout.EXTRA_SH(1) | LCMSImageLayout.CHANNELS_SH(3) | LCMSImageLayout.BYTES_SH(1) | 0x400 | 0x4000;
    public static final int DT_BYTE = 0;
    public static final int DT_SHORT = 1;
    public static final int DT_INT = 2;
    public static final int DT_DOUBLE = 3;
    boolean isIntPacked = false;
    int pixelType;
    int dataType;
    int width;
    int height;
    int nextRowOffset;
    int offset;
    Object dataArray;

    public static int BYTES_SH(int n) {
        return n;
    }

    public static int EXTRA_SH(int n) {
        return n << 7;
    }

    public static int CHANNELS_SH(int n) {
        return n << 3;
    }

    private LCMSImageLayout(int n, int n2, int n3) {
        this.pixelType = n2;
        this.width = n;
        this.height = 1;
        this.nextRowOffset = n * n3;
        this.offset = 0;
    }

    private LCMSImageLayout(int n, int n2, int n3, int n4) {
        this.pixelType = n3;
        this.width = n;
        this.height = n2;
        this.nextRowOffset = n * n4;
        this.offset = 0;
    }

    public LCMSImageLayout(byte[] byArray, int n, int n2, int n3) {
        this(n, n2, n3);
        this.dataType = 0;
        this.dataArray = byArray;
    }

    public LCMSImageLayout(short[] sArray, int n, int n2, int n3) {
        this(n, n2, n3);
        this.dataType = 1;
        this.dataArray = sArray;
    }

    public LCMSImageLayout(int[] nArray, int n, int n2, int n3) {
        this(n, n2, n3);
        this.dataType = 2;
        this.dataArray = nArray;
    }

    public LCMSImageLayout(double[] dArray, int n, int n2, int n3) {
        this(n, n2, n3);
        this.dataType = 3;
        this.dataArray = dArray;
    }

    public LCMSImageLayout(BufferedImage bufferedImage) {
        switch (bufferedImage.getType()) {
            case 1: {
                this.pixelType = PT_ARGB_8;
                this.isIntPacked = true;
                break;
            }
            case 2: {
                this.pixelType = PT_ARGB_8;
                this.isIntPacked = true;
                break;
            }
            case 4: {
                this.pixelType = PT_ABGR_8;
                this.isIntPacked = true;
                break;
            }
            case 5: {
                this.pixelType = PT_BGR_8;
                break;
            }
            case 6: {
                this.pixelType = PT_ABGR_8;
                break;
            }
            case 10: {
                this.pixelType = PT_GRAY_8;
                break;
            }
            case 11: {
                this.pixelType = PT_GRAY_16;
                break;
            }
            default: {
                throw new IllegalArgumentException("CMMImageLayout - bad image type passed to constructor");
            }
        }
        this.width = bufferedImage.getWidth();
        this.height = bufferedImage.getHeight();
        switch (bufferedImage.getType()) {
            case 1: 
            case 2: 
            case 4: {
                IntegerComponentRaster integerComponentRaster = (IntegerComponentRaster)bufferedImage.getRaster();
                this.nextRowOffset = integerComponentRaster.getScanlineStride() * 4;
                this.offset = integerComponentRaster.getDataOffset(0) * 4;
                this.dataArray = integerComponentRaster.getDataStorage();
                this.dataType = 2;
                break;
            }
            case 5: 
            case 6: {
                ByteComponentRaster byteComponentRaster = (ByteComponentRaster)bufferedImage.getRaster();
                this.nextRowOffset = byteComponentRaster.getScanlineStride();
                this.offset = byteComponentRaster.getDataOffset(0);
                this.dataArray = byteComponentRaster.getDataStorage();
                this.dataType = 0;
                break;
            }
            case 10: {
                ByteComponentRaster byteComponentRaster = (ByteComponentRaster)bufferedImage.getRaster();
                this.nextRowOffset = byteComponentRaster.getScanlineStride();
                this.offset = byteComponentRaster.getDataOffset(0);
                this.dataArray = byteComponentRaster.getDataStorage();
                this.dataType = 0;
                break;
            }
            case 11: {
                ShortComponentRaster shortComponentRaster = (ShortComponentRaster)bufferedImage.getRaster();
                this.nextRowOffset = shortComponentRaster.getScanlineStride() * 2;
                this.offset = shortComponentRaster.getDataOffset(0) * 2;
                this.dataArray = shortComponentRaster.getDataStorage();
                this.dataType = 1;
            }
        }
    }

    public static boolean isSupported(BufferedImage bufferedImage) {
        switch (bufferedImage.getType()) {
            case 1: 
            case 2: 
            case 4: 
            case 5: 
            case 6: 
            case 10: 
            case 11: {
                return true;
            }
        }
        return false;
    }
}

