/*
 * Decompiled with CFR 0.152.
 */
package javax.swing.plaf.synth;

import java.awt.Dimension;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.Rectangle;
import java.beans.PropertyChangeEvent;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.basic.BasicHTML;
import javax.swing.plaf.basic.BasicLabelUI;
import javax.swing.plaf.synth.ColorType;
import javax.swing.plaf.synth.SynthContext;
import javax.swing.plaf.synth.SynthLookAndFeel;
import javax.swing.plaf.synth.SynthStyle;
import javax.swing.plaf.synth.SynthUI;
import javax.swing.text.View;

public class SynthLabelUI
extends BasicLabelUI
implements SynthUI {
    private SynthStyle style;

    public static ComponentUI createUI(JComponent jComponent) {
        return new SynthLabelUI();
    }

    @Override
    protected void installDefaults(JLabel jLabel) {
        this.updateStyle(jLabel);
    }

    void updateStyle(JLabel jLabel) {
        SynthContext synthContext = this.getContext(jLabel, 1);
        this.style = SynthLookAndFeel.updateStyle(synthContext, this);
        synthContext.dispose();
    }

    @Override
    protected void uninstallDefaults(JLabel jLabel) {
        SynthContext synthContext = this.getContext(jLabel, 1);
        this.style.uninstallDefaults(synthContext);
        synthContext.dispose();
        this.style = null;
    }

    @Override
    public SynthContext getContext(JComponent jComponent) {
        return this.getContext(jComponent, this.getComponentState(jComponent));
    }

    private SynthContext getContext(JComponent jComponent, int n) {
        return SynthContext.getContext(SynthContext.class, jComponent, SynthLookAndFeel.getRegion(jComponent), this.style, n);
    }

    private int getComponentState(JComponent jComponent) {
        int n = SynthLookAndFeel.getComponentState(jComponent);
        if (SynthLookAndFeel.getSelectedUI() == this && n == 1) {
            n = SynthLookAndFeel.getSelectedUIState() | 1;
        }
        return n;
    }

    @Override
    public int getBaseline(JComponent jComponent, int n, int n2) {
        int n3;
        if (jComponent == null) {
            throw new NullPointerException("Component must be non-null");
        }
        if (n < 0 || n2 < 0) {
            throw new IllegalArgumentException("Width and height must be >= 0");
        }
        JLabel jLabel = (JLabel)jComponent;
        String string = jLabel.getText();
        if (string == null || "".equals(string)) {
            return -1;
        }
        Insets insets = jLabel.getInsets();
        Rectangle rectangle = new Rectangle();
        Rectangle rectangle2 = new Rectangle();
        Rectangle rectangle3 = new Rectangle();
        rectangle.x = insets.left;
        rectangle.y = insets.top;
        rectangle.width = n - (insets.right + rectangle.x);
        rectangle.height = n2 - (insets.bottom + rectangle.y);
        SynthContext synthContext = this.getContext(jLabel);
        FontMetrics fontMetrics = synthContext.getComponent().getFontMetrics(synthContext.getStyle().getFont(synthContext));
        synthContext.getStyle().getGraphicsUtils(synthContext).layoutText(synthContext, fontMetrics, jLabel.getText(), jLabel.getIcon(), jLabel.getHorizontalAlignment(), jLabel.getVerticalAlignment(), jLabel.getHorizontalTextPosition(), jLabel.getVerticalTextPosition(), rectangle, rectangle3, rectangle2, jLabel.getIconTextGap());
        View view = (View)jLabel.getClientProperty("html");
        if (view != null) {
            n3 = BasicHTML.getHTMLBaseline(view, rectangle2.width, rectangle2.height);
            if (n3 >= 0) {
                n3 += rectangle2.y;
            }
        } else {
            n3 = rectangle2.y + fontMetrics.getAscent();
        }
        synthContext.dispose();
        return n3;
    }

    @Override
    public void update(Graphics graphics, JComponent jComponent) {
        SynthContext synthContext = this.getContext(jComponent);
        SynthLookAndFeel.update(synthContext, graphics);
        synthContext.getPainter().paintLabelBackground(synthContext, graphics, 0, 0, jComponent.getWidth(), jComponent.getHeight());
        this.paint(synthContext, graphics);
        synthContext.dispose();
    }

    @Override
    public void paint(Graphics graphics, JComponent jComponent) {
        SynthContext synthContext = this.getContext(jComponent);
        this.paint(synthContext, graphics);
        synthContext.dispose();
    }

    protected void paint(SynthContext synthContext, Graphics graphics) {
        JLabel jLabel = (JLabel)synthContext.getComponent();
        Icon icon = jLabel.isEnabled() ? jLabel.getIcon() : jLabel.getDisabledIcon();
        graphics.setColor(synthContext.getStyle().getColor(synthContext, ColorType.TEXT_FOREGROUND));
        graphics.setFont(this.style.getFont(synthContext));
        synthContext.getStyle().getGraphicsUtils(synthContext).paintText(synthContext, graphics, jLabel.getText(), icon, jLabel.getHorizontalAlignment(), jLabel.getVerticalAlignment(), jLabel.getHorizontalTextPosition(), jLabel.getVerticalTextPosition(), jLabel.getIconTextGap(), jLabel.getDisplayedMnemonicIndex(), 0);
    }

    @Override
    public void paintBorder(SynthContext synthContext, Graphics graphics, int n, int n2, int n3, int n4) {
        synthContext.getPainter().paintLabelBorder(synthContext, graphics, n, n2, n3, n4);
    }

    @Override
    public Dimension getPreferredSize(JComponent jComponent) {
        JLabel jLabel = (JLabel)jComponent;
        Icon icon = jLabel.isEnabled() ? jLabel.getIcon() : jLabel.getDisabledIcon();
        SynthContext synthContext = this.getContext(jComponent);
        Dimension dimension = synthContext.getStyle().getGraphicsUtils(synthContext).getPreferredSize(synthContext, synthContext.getStyle().getFont(synthContext), jLabel.getText(), icon, jLabel.getHorizontalAlignment(), jLabel.getVerticalAlignment(), jLabel.getHorizontalTextPosition(), jLabel.getVerticalTextPosition(), jLabel.getIconTextGap(), jLabel.getDisplayedMnemonicIndex());
        synthContext.dispose();
        return dimension;
    }

    @Override
    public Dimension getMinimumSize(JComponent jComponent) {
        JLabel jLabel = (JLabel)jComponent;
        Icon icon = jLabel.isEnabled() ? jLabel.getIcon() : jLabel.getDisabledIcon();
        SynthContext synthContext = this.getContext(jComponent);
        Dimension dimension = synthContext.getStyle().getGraphicsUtils(synthContext).getMinimumSize(synthContext, synthContext.getStyle().getFont(synthContext), jLabel.getText(), icon, jLabel.getHorizontalAlignment(), jLabel.getVerticalAlignment(), jLabel.getHorizontalTextPosition(), jLabel.getVerticalTextPosition(), jLabel.getIconTextGap(), jLabel.getDisplayedMnemonicIndex());
        synthContext.dispose();
        return dimension;
    }

    @Override
    public Dimension getMaximumSize(JComponent jComponent) {
        JLabel jLabel = (JLabel)jComponent;
        Icon icon = jLabel.isEnabled() ? jLabel.getIcon() : jLabel.getDisabledIcon();
        SynthContext synthContext = this.getContext(jComponent);
        Dimension dimension = synthContext.getStyle().getGraphicsUtils(synthContext).getMaximumSize(synthContext, synthContext.getStyle().getFont(synthContext), jLabel.getText(), icon, jLabel.getHorizontalAlignment(), jLabel.getVerticalAlignment(), jLabel.getHorizontalTextPosition(), jLabel.getVerticalTextPosition(), jLabel.getIconTextGap(), jLabel.getDisplayedMnemonicIndex());
        synthContext.dispose();
        return dimension;
    }

    @Override
    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        super.propertyChange(propertyChangeEvent);
        if (SynthLookAndFeel.shouldUpdateStyle(propertyChangeEvent)) {
            this.updateStyle((JLabel)propertyChangeEvent.getSource());
        }
    }
}

