/*
 * Decompiled with CFR 0.152.
 */
package javax.swing.colorchooser;

import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JFormattedTextField;
import javax.swing.JLabel;
import javax.swing.colorchooser.AbstractColorChooserPanel;
import javax.swing.colorchooser.ColorModel;
import javax.swing.colorchooser.ColorPanel;
import javax.swing.colorchooser.ColorSelectionModel;
import javax.swing.colorchooser.DiagramComponent;
import javax.swing.colorchooser.ValueFormatter;

final class ColorChooserPanel
extends AbstractColorChooserPanel
implements PropertyChangeListener {
    private static final int MASK = -16777216;
    private final ColorModel model;
    private final ColorPanel panel;
    private final DiagramComponent slider;
    private final DiagramComponent diagram;
    private final JFormattedTextField text;
    private final JLabel label;

    ColorChooserPanel(ColorModel colorModel) {
        this.model = colorModel;
        this.panel = new ColorPanel(this.model);
        this.slider = new DiagramComponent(this.panel, false);
        this.diagram = new DiagramComponent(this.panel, true);
        this.text = new JFormattedTextField();
        this.label = new JLabel(null, null, 4);
        ValueFormatter.init(6, true, this.text);
    }

    @Override
    public void setEnabled(boolean bl) {
        super.setEnabled(bl);
        ColorChooserPanel.setEnabled(this, bl);
    }

    private static void setEnabled(Container container, boolean bl) {
        for (Component component : container.getComponents()) {
            component.setEnabled(bl);
            if (!(component instanceof Container)) continue;
            ColorChooserPanel.setEnabled((Container)component, bl);
        }
    }

    @Override
    public void updateChooser() {
        Color color = this.getColorFromModel();
        if (color != null) {
            this.panel.setColor(color);
            this.text.setValue(color.getRGB());
            this.slider.repaint();
            this.diagram.repaint();
        }
    }

    @Override
    protected void buildChooser() {
        Object object;
        if (0 == this.getComponentCount()) {
            this.setLayout(new GridBagLayout());
            object = new GridBagConstraints();
            ((GridBagConstraints)object).gridx = 3;
            ((GridBagConstraints)object).gridwidth = 2;
            ((GridBagConstraints)object).weighty = 1.0;
            ((GridBagConstraints)object).anchor = 11;
            ((GridBagConstraints)object).fill = 2;
            ((GridBagConstraints)object).insets.top = 10;
            ((GridBagConstraints)object).insets.right = 10;
            this.add((Component)this.panel, object);
            ((GridBagConstraints)object).gridwidth = 1;
            ((GridBagConstraints)object).weightx = 1.0;
            ((GridBagConstraints)object).weighty = 0.0;
            ((GridBagConstraints)object).anchor = 10;
            ((GridBagConstraints)object).insets.right = 5;
            ((GridBagConstraints)object).insets.bottom = 10;
            this.add((Component)this.label, object);
            ((GridBagConstraints)object).gridx = 4;
            ((GridBagConstraints)object).weightx = 0.0;
            ((GridBagConstraints)object).insets.right = 10;
            this.add((Component)this.text, object);
            ((GridBagConstraints)object).gridx = 2;
            ((GridBagConstraints)object).gridheight = 2;
            ((GridBagConstraints)object).anchor = 11;
            ((GridBagConstraints)object).ipadx = this.text.getPreferredSize().height;
            ((GridBagConstraints)object).ipady = this.getPreferredSize().height;
            this.add((Component)this.slider, object);
            ((GridBagConstraints)object).gridx = 1;
            ((GridBagConstraints)object).insets.left = 10;
            ((GridBagConstraints)object).ipadx = ((GridBagConstraints)object).ipady;
            this.add((Component)this.diagram, object);
            this.label.setLabelFor(this.text);
            this.text.addPropertyChangeListener("value", this);
            this.slider.setBorder(this.text.getBorder());
            this.diagram.setBorder(this.text.getBorder());
            ColorChooserPanel.setInheritsPopupMenu(this, true);
        }
        boolean bl = (object = this.model.getText(this, "HexCode")) != null;
        this.text.setVisible(bl);
        this.label.setVisible(bl);
        if (bl) {
            this.label.setText((String)object);
            int n = this.model.getInteger(this, "HexCodeMnemonic");
            if (n > 0) {
                this.label.setDisplayedMnemonic(n);
                n = this.model.getInteger(this, "HexCodeMnemonicIndex");
                if (n >= 0) {
                    this.label.setDisplayedMnemonicIndex(n);
                }
            }
        }
        this.panel.buildPanel();
    }

    @Override
    public String getDisplayName() {
        return this.model.getText(this, "Name");
    }

    @Override
    public int getMnemonic() {
        return this.model.getInteger(this, "Mnemonic");
    }

    @Override
    public int getDisplayedMnemonicIndex() {
        return this.model.getInteger(this, "DisplayedMnemonicIndex");
    }

    @Override
    public Icon getSmallDisplayIcon() {
        return null;
    }

    @Override
    public Icon getLargeDisplayIcon() {
        return null;
    }

    @Override
    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        Object object;
        ColorSelectionModel colorSelectionModel = this.getColorSelectionModel();
        if (colorSelectionModel != null && (object = propertyChangeEvent.getNewValue()) instanceof Integer) {
            int n = 0xFF000000 & colorSelectionModel.getSelectedColor().getRGB() | (Integer)object;
            colorSelectionModel.setSelectedColor(new Color(n, true));
        }
        this.text.selectAll();
    }

    private static void setInheritsPopupMenu(JComponent jComponent, boolean bl) {
        jComponent.setInheritsPopupMenu(bl);
        for (Component component : jComponent.getComponents()) {
            if (!(component instanceof JComponent)) continue;
            ColorChooserPanel.setInheritsPopupMenu((JComponent)component, bl);
        }
    }
}

