/*
 * Decompiled with CFR 0.152.
 */
package java.util.concurrent;

import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;
import java.util.concurrent.locks.LockSupport;

public class Exchanger<V> {
    private static final int NCPU = Runtime.getRuntime().availableProcessors();
    private static final int CAPACITY = 32;
    private static final int FULL = Math.max(0, Math.min(32, NCPU / 2) - 1);
    private static final int SPINS = NCPU == 1 ? 0 : 2000;
    private static final int TIMED_SPINS = SPINS / 20;
    private static final Object CANCEL = new Object();
    private static final Object NULL_ITEM = new Object();
    private volatile Slot[] arena = new Slot[32];
    private final AtomicInteger max = new AtomicInteger();

    private Object doExchange(Object object, boolean bl, long l) {
        Node node = new Node(object);
        int n = this.hashIndex();
        int n2 = 0;
        while (true) {
            Slot slot;
            if ((slot = this.arena[n]) == null) {
                this.createSlot(n);
                continue;
            }
            Object v = slot.get();
            if (v != null && slot.compareAndSet(v, null)) {
                Node node2 = (Node)v;
                if (!node2.compareAndSet(null, object)) continue;
                LockSupport.unpark(node2.waiter);
                return node2.item;
            }
            if (v == null && slot.compareAndSet(null, node)) {
                if (n == 0) {
                    return bl ? this.awaitNanos(node, slot, l) : Exchanger.await(node, slot);
                }
                Object object2 = Exchanger.spinWait(node, slot);
                if (object2 != CANCEL) {
                    return object2;
                }
                node = new Node(object);
                int n3 = this.max.get();
                if (n3 <= (n >>>= 1)) continue;
                this.max.compareAndSet(n3, n3 - 1);
                continue;
            }
            if (++n2 <= 1) continue;
            int n4 = this.max.get();
            if (n2 > 3 && n4 < FULL && this.max.compareAndSet(n4, n4 + 1)) {
                n = n4 + 1;
                continue;
            }
            if (--n >= 0) continue;
            n = n4;
        }
    }

    private final int hashIndex() {
        int n;
        long l = Thread.currentThread().getId();
        int n2 = ((int)(l ^ l >>> 32) ^ 0x811C9DC5) * 16777619;
        int n3 = this.max.get();
        int n4 = -1024 >> n3 & 4 | 504 >>> n3 & 2 | -65294 >>> n3 & 1;
        while ((n = n2 & (1 << n4) - 1) > n3) {
            n2 = n2 >>> n4 | n2 << 33 - n4;
        }
        return n;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void createSlot(int n) {
        Slot[] slotArray;
        Slot slot = new Slot();
        Slot[] slotArray2 = slotArray = this.arena;
        synchronized (slotArray) {
            if (slotArray[n] == null) {
                slotArray[n] = slot;
            }
            // ** MonitorExit[var4_4] (shouldn't be in output)
            return;
        }
    }

    private static boolean tryCancel(Node node, Slot slot) {
        if (!node.compareAndSet(null, CANCEL)) {
            return false;
        }
        if (slot.get() == node) {
            slot.compareAndSet(node, null);
        }
        return true;
    }

    private static Object spinWait(Node node, Slot slot) {
        int n = SPINS;
        Object v;
        while ((v = node.get()) == null) {
            if (n > 0) {
                --n;
                continue;
            }
            Exchanger.tryCancel(node, slot);
        }
        return v;
    }

    private static Object await(Node node, Slot slot) {
        Thread thread = Thread.currentThread();
        int n = SPINS;
        Object v;
        while ((v = node.get()) == null) {
            if (n > 0) {
                --n;
                continue;
            }
            if (node.waiter == null) {
                node.waiter = thread;
                continue;
            }
            if (thread.isInterrupted()) {
                Exchanger.tryCancel(node, slot);
                continue;
            }
            LockSupport.park(node);
        }
        return v;
    }

    private Object awaitNanos(Node node, Slot slot, long l) {
        int n = TIMED_SPINS;
        long l2 = 0L;
        Thread thread = null;
        while (true) {
            Object v;
            if ((v = node.get()) != null) {
                return v;
            }
            long l3 = System.nanoTime();
            if (thread == null) {
                thread = Thread.currentThread();
            } else {
                l -= l3 - l2;
            }
            l2 = l3;
            if (l > 0L) {
                if (n > 0) {
                    --n;
                    continue;
                }
                if (node.waiter == null) {
                    node.waiter = thread;
                    continue;
                }
                if (thread.isInterrupted()) {
                    Exchanger.tryCancel(node, slot);
                    continue;
                }
                LockSupport.parkNanos(node, l);
                continue;
            }
            if (Exchanger.tryCancel(node, slot) && !thread.isInterrupted()) break;
        }
        return this.scanOnTimeout(node);
    }

    private Object scanOnTimeout(Node node) {
        for (int i = this.arena.length - 1; i >= 0; --i) {
            Object v;
            Slot slot = this.arena[i];
            if (slot == null) continue;
            while ((v = slot.get()) != null) {
                Node node2;
                if (!slot.compareAndSet(v, null) || !(node2 = (Node)v).compareAndSet(null, node.item)) continue;
                LockSupport.unpark(node2.waiter);
                return node2.item;
            }
        }
        return CANCEL;
    }

    public V exchange(V v) throws InterruptedException {
        if (!Thread.interrupted()) {
            Object object = this.doExchange(v == null ? NULL_ITEM : v, false, 0L);
            if (object == NULL_ITEM) {
                return null;
            }
            if (object != CANCEL) {
                return (V)object;
            }
            Thread.interrupted();
        }
        throw new InterruptedException();
    }

    public V exchange(V v, long l, TimeUnit timeUnit) throws InterruptedException, TimeoutException {
        if (!Thread.interrupted()) {
            Object object = this.doExchange(v == null ? NULL_ITEM : v, true, timeUnit.toNanos(l));
            if (object == NULL_ITEM) {
                return null;
            }
            if (object != CANCEL) {
                return (V)object;
            }
            if (!Thread.interrupted()) {
                throw new TimeoutException();
            }
        }
        throw new InterruptedException();
    }

    private static final class Node
    extends AtomicReference<Object> {
        public final Object item;
        public volatile Thread waiter;

        public Node(Object object) {
            this.item = object;
        }
    }

    private static final class Slot
    extends AtomicReference<Object> {
        long q0;
        long q1;
        long q2;
        long q3;
        long q4;
        long q5;
        long q6;
        long q7;
        long q8;
        long q9;
        long qa;
        long qb;
        long qc;
        long qd;
        long qe;

        private Slot() {
        }
    }
}

