/*
 * Decompiled with CFR 0.152.
 */
package com.sun.org.apache.xerces.internal.impl;

import javax.xml.namespace.NamespaceContext;
import javax.xml.namespace.QName;
import javax.xml.stream.Location;
import javax.xml.stream.StreamFilter;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;

public class XMLStreamFilterImpl
implements XMLStreamReader {
    private StreamFilter fStreamFilter = null;
    private XMLStreamReader fStreamReader = null;
    private int fCurrentEvent;
    private boolean fEventAccepted = false;
    private boolean fStreamAdvancedByHasNext = false;

    public XMLStreamFilterImpl(XMLStreamReader xMLStreamReader, StreamFilter streamFilter) {
        this.fStreamReader = xMLStreamReader;
        this.fStreamFilter = streamFilter;
        try {
            if (this.fStreamFilter.accept(this.fStreamReader)) {
                this.fEventAccepted = true;
            } else {
                this.findNextEvent();
            }
        }
        catch (XMLStreamException xMLStreamException) {
            System.err.println("Error while creating a stream Filter" + xMLStreamException);
        }
    }

    protected void setStreamFilter(StreamFilter streamFilter) {
        this.fStreamFilter = streamFilter;
    }

    @Override
    public int next() throws XMLStreamException {
        if (this.fStreamAdvancedByHasNext && this.fEventAccepted) {
            this.fStreamAdvancedByHasNext = false;
            return this.fCurrentEvent;
        }
        int n = this.findNextEvent();
        if (n != -1) {
            return n;
        }
        throw new IllegalStateException("The stream reader has reached the end of the document, or there are no more  items to return");
    }

    @Override
    public int nextTag() throws XMLStreamException {
        if (this.fStreamAdvancedByHasNext && this.fEventAccepted && (this.fCurrentEvent == 1 || this.fCurrentEvent == 1)) {
            this.fStreamAdvancedByHasNext = false;
            return this.fCurrentEvent;
        }
        int n = this.findNextTag();
        if (n != -1) {
            return n;
        }
        throw new IllegalStateException("The stream reader has reached the end of the document, or there are no more  items to return");
    }

    @Override
    public boolean hasNext() throws XMLStreamException {
        if (this.fStreamReader.hasNext()) {
            if (!this.fEventAccepted) {
                this.fCurrentEvent = this.findNextEvent();
                if (this.fCurrentEvent == -1) {
                    return false;
                }
                this.fStreamAdvancedByHasNext = true;
            }
            return true;
        }
        return false;
    }

    private int findNextEvent() throws XMLStreamException {
        this.fStreamAdvancedByHasNext = false;
        while (this.fStreamReader.hasNext()) {
            this.fCurrentEvent = this.fStreamReader.next();
            if (!this.fStreamFilter.accept(this.fStreamReader)) continue;
            this.fEventAccepted = true;
            return this.fCurrentEvent;
        }
        if (this.fCurrentEvent == 8) {
            return this.fCurrentEvent;
        }
        return -1;
    }

    private int findNextTag() throws XMLStreamException {
        this.fStreamAdvancedByHasNext = false;
        while (this.fStreamReader.hasNext()) {
            this.fCurrentEvent = this.fStreamReader.nextTag();
            if (!this.fStreamFilter.accept(this.fStreamReader)) continue;
            this.fEventAccepted = true;
            return this.fCurrentEvent;
        }
        if (this.fCurrentEvent == 8) {
            return this.fCurrentEvent;
        }
        return -1;
    }

    @Override
    public void close() throws XMLStreamException {
        this.fStreamReader.close();
    }

    @Override
    public int getAttributeCount() {
        return this.fStreamReader.getAttributeCount();
    }

    @Override
    public QName getAttributeName(int n) {
        return this.fStreamReader.getAttributeName(n);
    }

    @Override
    public String getAttributeNamespace(int n) {
        return this.fStreamReader.getAttributeNamespace(n);
    }

    @Override
    public String getAttributePrefix(int n) {
        return this.fStreamReader.getAttributePrefix(n);
    }

    @Override
    public String getAttributeType(int n) {
        return this.fStreamReader.getAttributeType(n);
    }

    @Override
    public String getAttributeValue(int n) {
        return this.fStreamReader.getAttributeValue(n);
    }

    @Override
    public String getAttributeValue(String string, String string2) {
        return this.fStreamReader.getAttributeValue(string, string2);
    }

    @Override
    public String getCharacterEncodingScheme() {
        return this.fStreamReader.getCharacterEncodingScheme();
    }

    @Override
    public String getElementText() throws XMLStreamException {
        return this.fStreamReader.getElementText();
    }

    @Override
    public String getEncoding() {
        return this.fStreamReader.getEncoding();
    }

    @Override
    public int getEventType() {
        return this.fStreamReader.getEventType();
    }

    @Override
    public String getLocalName() {
        return this.fStreamReader.getLocalName();
    }

    @Override
    public Location getLocation() {
        return this.fStreamReader.getLocation();
    }

    @Override
    public QName getName() {
        return this.fStreamReader.getName();
    }

    @Override
    public NamespaceContext getNamespaceContext() {
        return this.fStreamReader.getNamespaceContext();
    }

    @Override
    public int getNamespaceCount() {
        return this.fStreamReader.getNamespaceCount();
    }

    @Override
    public String getNamespacePrefix(int n) {
        return this.fStreamReader.getNamespacePrefix(n);
    }

    @Override
    public String getNamespaceURI() {
        return this.fStreamReader.getNamespaceURI();
    }

    @Override
    public String getNamespaceURI(int n) {
        return this.fStreamReader.getNamespaceURI(n);
    }

    @Override
    public String getNamespaceURI(String string) {
        return this.fStreamReader.getNamespaceURI(string);
    }

    @Override
    public String getPIData() {
        return this.fStreamReader.getPIData();
    }

    @Override
    public String getPITarget() {
        return this.fStreamReader.getPITarget();
    }

    @Override
    public String getPrefix() {
        return this.fStreamReader.getPrefix();
    }

    @Override
    public Object getProperty(String string) throws IllegalArgumentException {
        return this.fStreamReader.getProperty(string);
    }

    @Override
    public String getText() {
        return this.fStreamReader.getText();
    }

    @Override
    public char[] getTextCharacters() {
        return this.fStreamReader.getTextCharacters();
    }

    @Override
    public int getTextCharacters(int n, char[] cArray, int n2, int n3) throws XMLStreamException {
        return this.fStreamReader.getTextCharacters(n, cArray, n2, n3);
    }

    @Override
    public int getTextLength() {
        return this.fStreamReader.getTextLength();
    }

    @Override
    public int getTextStart() {
        return this.fStreamReader.getTextStart();
    }

    @Override
    public String getVersion() {
        return this.fStreamReader.getVersion();
    }

    @Override
    public boolean hasName() {
        return this.fStreamReader.hasName();
    }

    @Override
    public boolean hasText() {
        return this.fStreamReader.hasText();
    }

    @Override
    public boolean isAttributeSpecified(int n) {
        return this.fStreamReader.isAttributeSpecified(n);
    }

    @Override
    public boolean isCharacters() {
        return this.fStreamReader.isCharacters();
    }

    @Override
    public boolean isEndElement() {
        return this.fStreamReader.isEndElement();
    }

    @Override
    public boolean isStandalone() {
        return this.fStreamReader.isStandalone();
    }

    @Override
    public boolean isStartElement() {
        return this.fStreamReader.isStartElement();
    }

    @Override
    public boolean isWhiteSpace() {
        return this.fStreamReader.isWhiteSpace();
    }

    @Override
    public void require(int n, String string, String string2) throws XMLStreamException {
        this.fStreamReader.require(n, string, string2);
    }

    @Override
    public boolean standaloneSet() {
        return this.fStreamReader.standaloneSet();
    }

    @Override
    public String getAttributeLocalName(int n) {
        return this.fStreamReader.getAttributeLocalName(n);
    }
}

