/*
 * Decompiled with CFR 0.152.
 */
package com.sun.media.sound;

import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import javax.sound.sampled.AudioFormat;
import javax.sound.sampled.AudioInputStream;

public class SoftJitterCorrector
extends AudioInputStream {
    public SoftJitterCorrector(AudioInputStream audioInputStream, int n, int n2) {
        super(new JitterStream(audioInputStream, n, n2), audioInputStream.getFormat(), audioInputStream.getFrameLength());
    }

    private static class JitterStream
    extends InputStream {
        static int MAX_BUFFER_SIZE = 0x100000;
        boolean active = true;
        Thread thread;
        AudioInputStream stream;
        int writepos = 0;
        int readpos = 0;
        byte[][] buffers;
        Object buffers_mutex = new Object();
        int w_count = 1000;
        int w_min_tol = 2;
        int w_max_tol = 10;
        int w = 0;
        int w_min = -1;
        int bbuffer_pos = 0;
        int bbuffer_max = 0;
        byte[] bbuffer = null;

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public byte[] nextReadBuffer() {
            Object object = this.buffers_mutex;
            synchronized (object) {
                if (this.writepos > this.readpos) {
                    int n = this.writepos - this.readpos;
                    if (n < this.w_min) {
                        this.w_min = n;
                    }
                    int n2 = this.readpos++;
                    return this.buffers[n2 % this.buffers.length];
                }
                this.w_min = -1;
                this.w = this.w_count - 1;
            }
            while (true) {
                try {
                    Thread.sleep(1L);
                }
                catch (InterruptedException interruptedException) {
                    return null;
                }
                object = this.buffers_mutex;
                synchronized (object) {
                    if (this.writepos > this.readpos) {
                        this.w = 0;
                        this.w_min = -1;
                        this.w = this.w_count - 1;
                        int n = this.readpos++;
                        return this.buffers[n % this.buffers.length];
                    }
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public byte[] nextWriteBuffer() {
            Object object = this.buffers_mutex;
            synchronized (object) {
                return this.buffers[this.writepos % this.buffers.length];
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void commit() {
            Object object = this.buffers_mutex;
            synchronized (object) {
                ++this.writepos;
                if (this.writepos - this.readpos > this.buffers.length) {
                    int n = this.writepos - this.readpos + 10;
                    n = Math.max(this.buffers.length * 2, n);
                    this.buffers = new byte[n][this.buffers[0].length];
                }
            }
        }

        public JitterStream(AudioInputStream audioInputStream, int n, int n2) {
            this.w_count = 10 * (n / n2);
            if (this.w_count < 100) {
                this.w_count = 100;
            }
            this.buffers = new byte[n / n2 + 10][n2];
            this.bbuffer_max = MAX_BUFFER_SIZE / n2;
            this.stream = audioInputStream;
            Runnable runnable = new Runnable(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 * Enabled aggressive block sorting
                 * Enabled unnecessary exception pruning
                 * Enabled aggressive exception aggregation
                 * Converted monitor instructions to comments
                 * Lifted jumps to return sites
                 */
                @Override
                public void run() {
                    AudioFormat audioFormat = JitterStream.this.stream.getFormat();
                    int n = JitterStream.this.buffers[0].length;
                    int n2 = n / audioFormat.getFrameSize();
                    long l = (long)((double)n2 * 1.0E9 / (double)audioFormat.getSampleRate());
                    long l2 = System.nanoTime();
                    long l3 = l2 + l;
                    int n3 = 0;
                    while (true) {
                        JitterStream jitterStream = JitterStream.this;
                        // MONITORENTER : jitterStream
                        if (!JitterStream.this.active) {
                            // MONITOREXIT : jitterStream
                            return;
                        }
                        // MONITOREXIT : jitterStream
                        Object object = JitterStream.this.buffers;
                        // MONITORENTER : JitterStream.this.buffers
                        int n4 = JitterStream.this.writepos - JitterStream.this.readpos;
                        if (n3 == 0) {
                            ++JitterStream.this.w;
                            if (JitterStream.this.w_min != Integer.MAX_VALUE && JitterStream.this.w == JitterStream.this.w_count) {
                                n3 = 0;
                                if (JitterStream.this.w_min < JitterStream.this.w_min_tol) {
                                    n3 = (JitterStream.this.w_min_tol + JitterStream.this.w_max_tol) / 2 - JitterStream.this.w_min;
                                }
                                if (JitterStream.this.w_min > JitterStream.this.w_max_tol) {
                                    n3 = (JitterStream.this.w_min_tol + JitterStream.this.w_max_tol) / 2 - JitterStream.this.w_min;
                                }
                                JitterStream.this.w = 0;
                                JitterStream.this.w_min = Integer.MAX_VALUE;
                            }
                        }
                        // MONITOREXIT : object
                        while (n4 > JitterStream.this.bbuffer_max) {
                            object = JitterStream.this.buffers;
                            // MONITORENTER : JitterStream.this.buffers
                            n4 = JitterStream.this.writepos - JitterStream.this.readpos;
                            // MONITOREXIT : object
                            JitterStream jitterStream2 = JitterStream.this;
                            object = jitterStream2;
                            // MONITORENTER : jitterStream2
                            if (!JitterStream.this.active) {
                                // MONITOREXIT : object
                                break;
                            }
                            // MONITOREXIT : object
                            try {
                                Thread.sleep(1L);
                            }
                            catch (InterruptedException interruptedException) {}
                        }
                        if (n3 < 0) {
                            ++n3;
                        } else {
                            object = JitterStream.this.nextWriteBuffer();
                            try {
                                int n5;
                                for (int i = 0; i != ((byte[][])object).length; i += n5) {
                                    n5 = JitterStream.this.stream.read((byte[])object, i, ((byte[][])object).length - i);
                                    if (n5 < 0) {
                                        throw new EOFException();
                                    }
                                    if (n5 != 0) continue;
                                    Thread.yield();
                                }
                            }
                            catch (IOException iOException) {
                                // empty catch block
                            }
                            JitterStream.this.commit();
                        }
                        if (n3 > 0) {
                            --n3;
                            l3 = System.nanoTime() + l;
                            continue;
                        }
                        long l4 = l3 - System.nanoTime();
                        if (l4 > 0L) {
                            try {
                                Thread.sleep(l4 / 1000000L);
                            }
                            catch (InterruptedException interruptedException) {
                                // empty catch block
                            }
                        }
                        l3 += l;
                    }
                }
            };
            this.thread = new Thread(runnable);
            this.thread.setDaemon(true);
            this.thread.setPriority(10);
            this.thread.start();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void close() throws IOException {
            JitterStream jitterStream = this;
            synchronized (jitterStream) {
                this.active = false;
            }
            try {
                this.thread.join();
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            this.stream.close();
        }

        @Override
        public int read() throws IOException {
            byte[] byArray = new byte[1];
            if (this.read(byArray) == -1) {
                return -1;
            }
            return byArray[0] & 0xFF;
        }

        public void fillBuffer() {
            this.bbuffer = this.nextReadBuffer();
            this.bbuffer_pos = 0;
        }

        @Override
        public int read(byte[] byArray, int n, int n2) {
            if (this.bbuffer == null) {
                this.fillBuffer();
            }
            int n3 = this.bbuffer.length;
            int n4 = n + n2;
            while (n < n4) {
                if (this.available() == 0) {
                    this.fillBuffer();
                    continue;
                }
                byte[] byArray2 = this.bbuffer;
                int n5 = this.bbuffer_pos;
                while (n < n4 && n5 < n3) {
                    byArray[n++] = byArray2[n5++];
                }
                this.bbuffer_pos = n5;
            }
            return n2;
        }

        @Override
        public int available() {
            return this.bbuffer.length - this.bbuffer_pos;
        }
    }
}

