/*
 * Decompiled with CFR 0.152.
 */
package com.sun.corba.se.impl.encoding;

import com.sun.corba.se.impl.corba.CORBAObjectImpl;
import com.sun.corba.se.impl.corba.PrincipalImpl;
import com.sun.corba.se.impl.corba.TypeCodeImpl;
import com.sun.corba.se.impl.encoding.BufferManagerRead;
import com.sun.corba.se.impl.encoding.ByteBufferWithInfo;
import com.sun.corba.se.impl.encoding.CDRInputStreamBase;
import com.sun.corba.se.impl.encoding.CDROutputObject;
import com.sun.corba.se.impl.encoding.CDROutputStream;
import com.sun.corba.se.impl.encoding.CodeSetConversion;
import com.sun.corba.se.impl.encoding.MarkAndResetHandler;
import com.sun.corba.se.impl.encoding.RestorableInputStream;
import com.sun.corba.se.impl.logging.OMGSystemException;
import com.sun.corba.se.impl.logging.ORBUtilSystemException;
import com.sun.corba.se.impl.orbutil.CacheTable;
import com.sun.corba.se.impl.orbutil.ORBUtility;
import com.sun.corba.se.impl.orbutil.RepositoryIdFactory;
import com.sun.corba.se.impl.orbutil.RepositoryIdInterface;
import com.sun.corba.se.impl.orbutil.RepositoryIdStrings;
import com.sun.corba.se.impl.orbutil.RepositoryIdUtility;
import com.sun.corba.se.impl.util.RepositoryId;
import com.sun.corba.se.impl.util.Utility;
import com.sun.corba.se.pept.protocol.MessageMediator;
import com.sun.corba.se.spi.ior.IOR;
import com.sun.corba.se.spi.ior.IORFactories;
import com.sun.corba.se.spi.ior.iiop.GIOPVersion;
import com.sun.corba.se.spi.orb.ORB;
import com.sun.corba.se.spi.orb.ORBVersionFactory;
import com.sun.corba.se.spi.presentation.rmi.PresentationDefaults;
import com.sun.corba.se.spi.presentation.rmi.PresentationManager;
import com.sun.corba.se.spi.presentation.rmi.StubAdapter;
import com.sun.corba.se.spi.protocol.CorbaClientDelegate;
import com.sun.org.omg.CORBA.portable.ValueHelper;
import com.sun.org.omg.SendingContext.CodeBase;
import java.io.IOException;
import java.io.Serializable;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.math.BigDecimal;
import java.net.MalformedURLException;
import java.nio.ByteBuffer;
import java.security.AccessController;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import javax.rmi.CORBA.Tie;
import javax.rmi.CORBA.ValueHandler;
import org.omg.CORBA.Any;
import org.omg.CORBA.AnySeqHolder;
import org.omg.CORBA.BooleanSeqHolder;
import org.omg.CORBA.CharSeqHolder;
import org.omg.CORBA.CompletionStatus;
import org.omg.CORBA.CustomMarshal;
import org.omg.CORBA.DoubleSeqHolder;
import org.omg.CORBA.FloatSeqHolder;
import org.omg.CORBA.LongLongSeqHolder;
import org.omg.CORBA.LongSeqHolder;
import org.omg.CORBA.MARSHAL;
import org.omg.CORBA.Object;
import org.omg.CORBA.OctetSeqHolder;
import org.omg.CORBA.Principal;
import org.omg.CORBA.ShortSeqHolder;
import org.omg.CORBA.SystemException;
import org.omg.CORBA.TypeCode;
import org.omg.CORBA.TypeCodePackage.BadKind;
import org.omg.CORBA.ULongLongSeqHolder;
import org.omg.CORBA.ULongSeqHolder;
import org.omg.CORBA.UShortSeqHolder;
import org.omg.CORBA.WCharSeqHolder;
import org.omg.CORBA.portable.BoxedValueHelper;
import org.omg.CORBA.portable.CustomValue;
import org.omg.CORBA.portable.IDLEntity;
import org.omg.CORBA.portable.IndirectionException;
import org.omg.CORBA.portable.InputStream;
import org.omg.CORBA.portable.InvokeHandler;
import org.omg.CORBA.portable.StreamableValue;
import org.omg.CORBA.portable.ValueBase;
import org.omg.CORBA.portable.ValueFactory;

public class CDRInputStream_1_0
extends CDRInputStreamBase
implements RestorableInputStream {
    private static final String kReadMethod = "read";
    private static final int maxBlockLength = 0x7FFFFF00;
    protected BufferManagerRead bufferManagerRead;
    protected ByteBufferWithInfo bbwi;
    private boolean debug = false;
    protected boolean littleEndian;
    protected ORB orb;
    protected ORBUtilSystemException wrapper;
    protected OMGSystemException omgWrapper;
    protected ValueHandler valueHandler = null;
    private CacheTable valueCache = null;
    private CacheTable repositoryIdCache = null;
    private CacheTable codebaseCache = null;
    protected int blockLength = 0x7FFFFF00;
    protected int end_flag = 0;
    private int chunkedValueNestingLevel = 0;
    protected int valueIndirection = 0;
    protected int stringIndirection = 0;
    protected boolean isChunked = false;
    private RepositoryIdUtility repIdUtil;
    private RepositoryIdStrings repIdStrs;
    private CodeSetConversion.BTCConverter charConverter;
    private CodeSetConversion.BTCConverter wcharConverter;
    private boolean specialNoOptionalDataState = false;
    private static final String _id = "IDL:omg.org/CORBA/DataInputStream:1.0";
    private static final String[] _ids = new String[]{"IDL:omg.org/CORBA/DataInputStream:1.0"};
    protected MarkAndResetHandler markAndResetHandler = null;

    @Override
    public CDRInputStreamBase dup() {
        CDRInputStreamBase cDRInputStreamBase = null;
        try {
            cDRInputStreamBase = (CDRInputStreamBase)this.getClass().newInstance();
        }
        catch (Exception exception) {
            throw this.wrapper.couldNotDuplicateCdrInputStream(exception);
        }
        cDRInputStreamBase.init(this.orb, this.bbwi.byteBuffer, this.bbwi.buflen, this.littleEndian, this.bufferManagerRead);
        ((CDRInputStream_1_0)cDRInputStreamBase).bbwi.position(this.bbwi.position());
        ((CDRInputStream_1_0)cDRInputStreamBase).bbwi.byteBuffer.limit(this.bbwi.buflen);
        return cDRInputStreamBase;
    }

    @Override
    public void init(org.omg.CORBA.ORB oRB, ByteBuffer byteBuffer, int n, boolean bl, BufferManagerRead bufferManagerRead) {
        this.orb = (ORB)oRB;
        this.wrapper = ORBUtilSystemException.get((ORB)oRB, "rpc.encoding");
        this.omgWrapper = OMGSystemException.get((ORB)oRB, "rpc.encoding");
        this.littleEndian = bl;
        this.bufferManagerRead = bufferManagerRead;
        this.bbwi = new ByteBufferWithInfo(oRB, byteBuffer, 0);
        this.bbwi.buflen = n;
        this.bbwi.byteBuffer.limit(this.bbwi.buflen);
        this.markAndResetHandler = this.bufferManagerRead.getMarkAndResetHandler();
        this.debug = ((ORB)oRB).transportDebugFlag;
    }

    @Override
    void performORBVersionSpecificInit() {
        this.createRepositoryIdHandlers();
    }

    private final void createRepositoryIdHandlers() {
        this.repIdUtil = RepositoryIdFactory.getRepIdUtility(this.orb);
        this.repIdStrs = RepositoryIdFactory.getRepIdStringsFactory(this.orb);
    }

    @Override
    public GIOPVersion getGIOPVersion() {
        return GIOPVersion.V1_0;
    }

    @Override
    void setHeaderPadding(boolean bl) {
        throw this.wrapper.giopVersionError();
    }

    protected final int computeAlignment(int n, int n2) {
        int n3;
        if (n2 > 1 && (n3 = n & n2 - 1) != 0) {
            return n2 - n3;
        }
        return 0;
    }

    public int getSize() {
        return this.bbwi.position();
    }

    protected void checkBlockLength(int n, int n2) {
        if (!this.isChunked) {
            return;
        }
        if (this.specialNoOptionalDataState) {
            throw this.omgWrapper.rmiiiopOptionalDataIncompatible1();
        }
        boolean bl = false;
        if (this.blockLength == this.get_offset()) {
            this.blockLength = 0x7FFFFF00;
            this.start_block();
            if (this.blockLength == 0x7FFFFF00) {
                bl = true;
            }
        } else if (this.blockLength < this.get_offset()) {
            throw this.wrapper.chunkOverflow();
        }
        int n3 = this.computeAlignment(this.bbwi.position(), n) + n2;
        if (this.blockLength != 0x7FFFFF00 && this.blockLength < this.get_offset() + n3) {
            throw this.omgWrapper.rmiiiopOptionalDataIncompatible2();
        }
        if (bl) {
            int n4 = this.read_long();
            this.bbwi.position(this.bbwi.position() - 4);
            if (n4 < 0) {
                throw this.omgWrapper.rmiiiopOptionalDataIncompatible3();
            }
        }
    }

    protected void alignAndCheck(int n, int n2) {
        this.checkBlockLength(n, n2);
        int n3 = this.computeAlignment(this.bbwi.position(), n);
        this.bbwi.position(this.bbwi.position() + n3);
        if (this.bbwi.position() + n2 > this.bbwi.buflen) {
            this.grow(n, n2);
        }
    }

    protected void grow(int n, int n2) {
        this.bbwi.needed = n2;
        this.bbwi = this.bufferManagerRead.underflow(this.bbwi);
    }

    @Override
    public final void consumeEndian() {
        this.littleEndian = this.read_boolean();
    }

    public final double read_longdouble() {
        throw this.wrapper.longDoubleNotImplemented(CompletionStatus.COMPLETED_MAYBE);
    }

    @Override
    public final boolean read_boolean() {
        return this.read_octet() != 0;
    }

    @Override
    public final char read_char() {
        this.alignAndCheck(1, 1);
        return this.getConvertedChars(1, this.getCharConverter())[0];
    }

    @Override
    public char read_wchar() {
        int n;
        int n2;
        if (ORBUtility.isForeignORB(this.orb)) {
            throw this.wrapper.wcharDataInGiop10(CompletionStatus.COMPLETED_MAYBE);
        }
        this.alignAndCheck(2, 2);
        if (this.littleEndian) {
            n2 = this.bbwi.byteBuffer.get(this.bbwi.position()) & 0xFF;
            this.bbwi.position(this.bbwi.position() + 1);
            n = this.bbwi.byteBuffer.get(this.bbwi.position()) & 0xFF;
            this.bbwi.position(this.bbwi.position() + 1);
        } else {
            n = this.bbwi.byteBuffer.get(this.bbwi.position()) & 0xFF;
            this.bbwi.position(this.bbwi.position() + 1);
            n2 = this.bbwi.byteBuffer.get(this.bbwi.position()) & 0xFF;
            this.bbwi.position(this.bbwi.position() + 1);
        }
        return (char)((n << 8) + (n2 << 0));
    }

    @Override
    public final byte read_octet() {
        this.alignAndCheck(1, 1);
        byte by = this.bbwi.byteBuffer.get(this.bbwi.position());
        this.bbwi.position(this.bbwi.position() + 1);
        return by;
    }

    @Override
    public final short read_short() {
        int n;
        int n2;
        this.alignAndCheck(2, 2);
        if (this.littleEndian) {
            n2 = this.bbwi.byteBuffer.get(this.bbwi.position()) << 0 & 0xFF;
            this.bbwi.position(this.bbwi.position() + 1);
            n = this.bbwi.byteBuffer.get(this.bbwi.position()) << 8 & 0xFF00;
            this.bbwi.position(this.bbwi.position() + 1);
        } else {
            n = this.bbwi.byteBuffer.get(this.bbwi.position()) << 8 & 0xFF00;
            this.bbwi.position(this.bbwi.position() + 1);
            n2 = this.bbwi.byteBuffer.get(this.bbwi.position()) << 0 & 0xFF;
            this.bbwi.position(this.bbwi.position() + 1);
        }
        return (short)(n | n2);
    }

    @Override
    public final short read_ushort() {
        return this.read_short();
    }

    @Override
    public final int read_long() {
        int n;
        int n2;
        int n3;
        int n4;
        this.alignAndCheck(4, 4);
        int n5 = this.bbwi.position();
        if (this.littleEndian) {
            n4 = this.bbwi.byteBuffer.get(n5++) & 0xFF;
            n3 = this.bbwi.byteBuffer.get(n5++) & 0xFF;
            n2 = this.bbwi.byteBuffer.get(n5++) & 0xFF;
            n = this.bbwi.byteBuffer.get(n5++) & 0xFF;
        } else {
            n = this.bbwi.byteBuffer.get(n5++) & 0xFF;
            n2 = this.bbwi.byteBuffer.get(n5++) & 0xFF;
            n3 = this.bbwi.byteBuffer.get(n5++) & 0xFF;
            n4 = this.bbwi.byteBuffer.get(n5++) & 0xFF;
        }
        this.bbwi.position(n5);
        return n << 24 | n2 << 16 | n3 << 8 | n4;
    }

    @Override
    public final int read_ulong() {
        return this.read_long();
    }

    @Override
    public final long read_longlong() {
        long l;
        long l2;
        this.alignAndCheck(8, 8);
        if (this.littleEndian) {
            l2 = (long)this.read_long() & 0xFFFFFFFFL;
            l = (long)this.read_long() << 32;
        } else {
            l = (long)this.read_long() << 32;
            l2 = (long)this.read_long() & 0xFFFFFFFFL;
        }
        return l | l2;
    }

    @Override
    public final long read_ulonglong() {
        return this.read_longlong();
    }

    @Override
    public final float read_float() {
        return Float.intBitsToFloat(this.read_long());
    }

    @Override
    public final double read_double() {
        return Double.longBitsToDouble(this.read_longlong());
    }

    protected final void checkForNegativeLength(int n) {
        if (n < 0) {
            throw this.wrapper.negativeStringLength(CompletionStatus.COMPLETED_MAYBE, (java.lang.Object)new Integer(n));
        }
    }

    protected final String readStringOrIndirection(boolean bl) {
        int n = this.read_long();
        if (bl) {
            if (n == -1) {
                return null;
            }
            this.stringIndirection = this.get_offset() - 4;
        }
        this.checkForNegativeLength(n);
        if (this.orb != null && ORBUtility.isLegacyORB(this.orb)) {
            return this.legacyReadString(n);
        }
        return this.internalReadString(n);
    }

    private final String internalReadString(int n) {
        if (n == 0) {
            return new String("");
        }
        char[] cArray = this.getConvertedChars(n - 1, this.getCharConverter());
        this.read_octet();
        return new String(cArray, 0, this.getCharConverter().getNumChars());
    }

    private final String legacyReadString(int n) {
        int n2;
        if (n == 0) {
            return new String("");
        }
        char[] cArray = new char[--n];
        for (int i = 0; i < n; i += n2) {
            int n3;
            int n4 = this.bbwi.buflen - this.bbwi.position();
            if (n4 <= 0) {
                this.grow(1, 1);
                n4 = this.bbwi.buflen - this.bbwi.position();
            }
            n2 = (n3 = n - i) < n4 ? n3 : n4;
            for (int j = 0; j < n2; ++j) {
                cArray[i + j] = (char)(this.bbwi.byteBuffer.get(this.bbwi.position() + j) & 0xFF);
            }
            this.bbwi.position(this.bbwi.position() + n2);
        }
        if (this.bbwi.position() + 1 > this.bbwi.buflen) {
            this.alignAndCheck(1, 1);
        }
        this.bbwi.position(this.bbwi.position() + 1);
        return new String(cArray);
    }

    @Override
    public final String read_string() {
        return this.readStringOrIndirection(false);
    }

    @Override
    public String read_wstring() {
        if (ORBUtility.isForeignORB(this.orb)) {
            throw this.wrapper.wcharDataInGiop10(CompletionStatus.COMPLETED_MAYBE);
        }
        int n = this.read_long();
        if (n == 0) {
            return new String("");
        }
        this.checkForNegativeLength(n);
        char[] cArray = new char[--n];
        for (int i = 0; i < n; ++i) {
            cArray[i] = this.read_wchar();
        }
        this.read_wchar();
        return new String(cArray);
    }

    @Override
    public final void read_octet_array(byte[] byArray, int n, int n2) {
        int n3;
        if (byArray == null) {
            throw this.wrapper.nullParam();
        }
        if (n2 == 0) {
            return;
        }
        this.alignAndCheck(1, 1);
        for (int i = n; i < n2 + n; i += n3) {
            int n4;
            int n5 = this.bbwi.buflen - this.bbwi.position();
            if (n5 <= 0) {
                this.grow(1, 1);
                n5 = this.bbwi.buflen - this.bbwi.position();
            }
            n3 = (n4 = n2 + n - i) < n5 ? n4 : n5;
            for (int j = 0; j < n3; ++j) {
                byArray[i + j] = this.bbwi.byteBuffer.get(this.bbwi.position() + j);
            }
            this.bbwi.position(this.bbwi.position() + n3);
        }
    }

    @Override
    public Principal read_Principal() {
        int n = this.read_long();
        byte[] byArray = new byte[n];
        this.read_octet_array(byArray, 0, n);
        PrincipalImpl principalImpl = new PrincipalImpl();
        ((Principal)principalImpl).name(byArray);
        return principalImpl;
    }

    @Override
    public TypeCode read_TypeCode() {
        TypeCodeImpl typeCodeImpl = new TypeCodeImpl(this.orb);
        typeCodeImpl.read_value(this.parent);
        return typeCodeImpl;
    }

    @Override
    public Any read_any() {
        Any any = this.orb.create_any();
        TypeCodeImpl typeCodeImpl = new TypeCodeImpl(this.orb);
        try {
            typeCodeImpl.read_value(this.parent);
        }
        catch (MARSHAL mARSHAL) {
            if (typeCodeImpl.kind().value() != 29) {
                throw mARSHAL;
            }
            this.dprintThrowable(mARSHAL);
        }
        any.read_value(this.parent, typeCodeImpl);
        return any;
    }

    @Override
    public Object read_Object() {
        return this.read_Object(null);
    }

    @Override
    public Object read_Object(Class clazz) {
        IOR iOR = IORFactories.makeIOR(this.parent);
        if (iOR.isNil()) {
            return null;
        }
        PresentationManager.StubFactoryFactory stubFactoryFactory = ORB.getStubFactoryFactory();
        String string = iOR.getProfile().getCodebase();
        PresentationManager.StubFactory stubFactory = null;
        if (clazz == null) {
            RepositoryId repositoryId = RepositoryId.cache.getId(iOR.getTypeId());
            String string2 = repositoryId.getClassName();
            boolean bl = repositoryId.isIDLType();
            if (string2 == null || string2.equals("")) {
                stubFactory = null;
            } else {
                try {
                    stubFactory = stubFactoryFactory.createStubFactory(string2, bl, string, null, null);
                }
                catch (Exception exception) {
                    stubFactory = null;
                }
            }
        } else if (StubAdapter.isStubClass(clazz)) {
            stubFactory = PresentationDefaults.makeStaticStubFactory(clazz);
        } else {
            boolean bl = IDLEntity.class.isAssignableFrom(clazz);
            stubFactory = stubFactoryFactory.createStubFactory(clazz.getName(), bl, string, clazz, clazz.getClassLoader());
        }
        return CDRInputStream_1_0.internalIORToObject(iOR, stubFactory, this.orb);
    }

    public static Object internalIORToObject(IOR iOR, PresentationManager.StubFactory stubFactory, ORB oRB) {
        ORBUtilSystemException oRBUtilSystemException = ORBUtilSystemException.get(oRB, "rpc.encoding");
        java.lang.Object object = iOR.getProfile().getServant();
        if (object != null) {
            if (object instanceof Tie) {
                String string = iOR.getProfile().getCodebase();
                Object object2 = (Object)((java.lang.Object)Utility.loadStub((Tie)object, stubFactory, string, false));
                if (object2 != null) {
                    return object2;
                }
                throw oRBUtilSystemException.readObjectException();
            }
            if (object instanceof Object) {
                if (!(object instanceof InvokeHandler)) {
                    return (Object)object;
                }
            } else {
                throw oRBUtilSystemException.badServantReadObject();
            }
        }
        CorbaClientDelegate corbaClientDelegate = ORBUtility.makeClientDelegate(iOR);
        Object object3 = null;
        try {
            object3 = stubFactory.makeStub();
        }
        catch (Throwable throwable) {
            oRBUtilSystemException.stubCreateError(throwable);
            if (throwable instanceof ThreadDeath) {
                throw (ThreadDeath)throwable;
            }
            object3 = new CORBAObjectImpl();
        }
        StubAdapter.setDelegate(object3, corbaClientDelegate);
        return object3;
    }

    @Override
    public java.lang.Object read_abstract_interface() {
        return this.read_abstract_interface(null);
    }

    @Override
    public java.lang.Object read_abstract_interface(Class clazz) {
        boolean bl = this.read_boolean();
        if (bl) {
            return this.read_Object(clazz);
        }
        return this.read_value();
    }

    @Override
    public Serializable read_value() {
        return this.read_value((Class)null);
    }

    private Serializable handleIndirection() {
        int n = this.read_long() + this.get_offset() - 4;
        if (this.valueCache != null && this.valueCache.containsVal(n)) {
            Serializable serializable = (Serializable)this.valueCache.getKey(n);
            return serializable;
        }
        throw new IndirectionException(n);
    }

    private String readRepositoryIds(int n, Class clazz, String string) {
        return this.readRepositoryIds(n, clazz, string, null);
    }

    private String readRepositoryIds(int n, Class clazz, String string, BoxedValueHelper boxedValueHelper) {
        switch (this.repIdUtil.getTypeInfo(n)) {
            case 0: {
                if (clazz == null) {
                    if (string != null) {
                        return string;
                    }
                    if (boxedValueHelper != null) {
                        return boxedValueHelper.get_id();
                    }
                    throw this.wrapper.expectedTypeNullAndNoRepId(CompletionStatus.COMPLETED_MAYBE);
                }
                return this.repIdStrs.createForAnyType(clazz);
            }
            case 2: {
                return this.read_repositoryId();
            }
            case 6: {
                return this.read_repositoryIds();
            }
        }
        throw this.wrapper.badValueTag(CompletionStatus.COMPLETED_MAYBE, (java.lang.Object)Integer.toHexString(n));
    }

    @Override
    public Serializable read_value(Class clazz) {
        int n = this.readValueTag();
        if (n == 0) {
            return null;
        }
        if (n == -1) {
            return this.handleIndirection();
        }
        int n2 = this.get_offset() - 4;
        boolean bl = this.isChunked;
        this.isChunked = this.repIdUtil.isChunkedEncoding(n);
        java.lang.Object object = null;
        String string = null;
        if (this.repIdUtil.isCodeBasePresent(n)) {
            string = this.read_codebase_URL();
        }
        String string2 = this.readRepositoryIds(n, clazz, null);
        this.start_block();
        --this.end_flag;
        if (this.isChunked) {
            --this.chunkedValueNestingLevel;
        }
        if (string2.equals(this.repIdStrs.getWStringValueRepId())) {
            object = this.read_wstring();
        } else if (string2.equals(this.repIdStrs.getClassDescValueRepId())) {
            object = this.readClass();
        } else {
            Class clazz2 = clazz;
            if (clazz == null || !string2.equals(this.repIdStrs.createForAnyType(clazz))) {
                clazz2 = this.getClassFromString(string2, string, clazz);
            }
            if (clazz2 == null) {
                throw this.wrapper.couldNotFindClass(CompletionStatus.COMPLETED_MAYBE, new ClassNotFoundException());
            }
            if (clazz2 != null && IDLEntity.class.isAssignableFrom(clazz2)) {
                object = this.readIDLValue(n2, string2, clazz2, string);
            } else {
                try {
                    if (this.valueHandler == null) {
                        this.valueHandler = ORBUtility.createValueHandler(this.orb);
                    }
                    object = this.valueHandler.readValue(this.parent, n2, clazz2, string2, this.getCodeBase());
                }
                catch (SystemException systemException) {
                    throw systemException;
                }
                catch (Exception exception) {
                    throw this.wrapper.valuehandlerReadException(CompletionStatus.COMPLETED_MAYBE, exception);
                }
                catch (Error error) {
                    throw this.wrapper.valuehandlerReadError(CompletionStatus.COMPLETED_MAYBE, error);
                }
            }
        }
        this.handleEndOfValue();
        this.readEndTag();
        if (this.valueCache == null) {
            this.valueCache = new CacheTable(this.orb, false);
        }
        this.valueCache.put(object, n2);
        this.isChunked = bl;
        this.start_block();
        return (Serializable)object;
    }

    @Override
    public Serializable read_value(BoxedValueHelper boxedValueHelper) {
        String string;
        int n = this.readValueTag();
        if (n == 0) {
            return null;
        }
        if (n == -1) {
            int n2 = this.read_long() + this.get_offset() - 4;
            if (this.valueCache != null && this.valueCache.containsVal(n2)) {
                Serializable serializable = (Serializable)this.valueCache.getKey(n2);
                return serializable;
            }
            throw new IndirectionException(n2);
        }
        int n3 = this.get_offset() - 4;
        boolean bl = this.isChunked;
        this.isChunked = this.repIdUtil.isChunkedEncoding(n);
        java.lang.Object object = null;
        String string2 = null;
        if (this.repIdUtil.isCodeBasePresent(n)) {
            string2 = this.read_codebase_URL();
        }
        if (!(string = this.readRepositoryIds(n, null, null, boxedValueHelper)).equals(boxedValueHelper.get_id())) {
            boxedValueHelper = Utility.getHelper(null, string2, string);
        }
        this.start_block();
        --this.end_flag;
        if (this.isChunked) {
            --this.chunkedValueNestingLevel;
        }
        if (boxedValueHelper instanceof ValueHelper) {
            object = this.readIDLValueWithHelper((ValueHelper)boxedValueHelper, n3);
        } else {
            this.valueIndirection = n3;
            object = boxedValueHelper.read_value(this.parent);
        }
        this.handleEndOfValue();
        this.readEndTag();
        if (this.valueCache == null) {
            this.valueCache = new CacheTable(this.orb, false);
        }
        this.valueCache.put(object, n3);
        this.isChunked = bl;
        this.start_block();
        return (Serializable)object;
    }

    private boolean isCustomType(ValueHelper valueHelper) {
        try {
            TypeCode typeCode = valueHelper.get_type();
            int n = typeCode.kind().value();
            if (n == 29) {
                return typeCode.type_modifier() == 1;
            }
        }
        catch (BadKind badKind) {
            throw this.wrapper.badKind(badKind);
        }
        return false;
    }

    @Override
    public Serializable read_value(Serializable serializable) {
        if (this.valueCache == null) {
            this.valueCache = new CacheTable(this.orb, false);
        }
        this.valueCache.put(serializable, this.valueIndirection);
        if (serializable instanceof StreamableValue) {
            ((StreamableValue)serializable)._read(this.parent);
        } else if (serializable instanceof CustomValue) {
            ((CustomValue)serializable).unmarshal(this.parent);
        }
        return serializable;
    }

    @Override
    public Serializable read_value(String string) {
        int n = this.readValueTag();
        if (n == 0) {
            return null;
        }
        if (n == -1) {
            int n2 = this.read_long() + this.get_offset() - 4;
            if (this.valueCache != null && this.valueCache.containsVal(n2)) {
                Serializable serializable = (Serializable)this.valueCache.getKey(n2);
                return serializable;
            }
            throw new IndirectionException(n2);
        }
        int n3 = this.get_offset() - 4;
        boolean bl = this.isChunked;
        this.isChunked = this.repIdUtil.isChunkedEncoding(n);
        Serializable serializable = null;
        String string2 = null;
        if (this.repIdUtil.isCodeBasePresent(n)) {
            string2 = this.read_codebase_URL();
        }
        String string3 = this.readRepositoryIds(n, null, string);
        ValueFactory valueFactory = Utility.getFactory(null, string2, this.orb, string3);
        this.start_block();
        --this.end_flag;
        if (this.isChunked) {
            --this.chunkedValueNestingLevel;
        }
        this.valueIndirection = n3;
        serializable = valueFactory.read_value(this.parent);
        this.handleEndOfValue();
        this.readEndTag();
        if (this.valueCache == null) {
            this.valueCache = new CacheTable(this.orb, false);
        }
        this.valueCache.put(serializable, n3);
        this.isChunked = bl;
        this.start_block();
        return serializable;
    }

    private Class readClass() {
        String string = null;
        String string2 = null;
        if (this.orb == null || ORBVersionFactory.getFOREIGN().equals(this.orb.getORBVersion()) || ORBVersionFactory.getNEWER().compareTo(this.orb.getORBVersion()) <= 0) {
            string = (String)((java.lang.Object)this.read_value(String.class));
            string2 = (String)((java.lang.Object)this.read_value(String.class));
        } else {
            string2 = (String)((java.lang.Object)this.read_value(String.class));
            string = (String)((java.lang.Object)this.read_value(String.class));
        }
        if (this.debug) {
            this.dprint("readClass codebases: " + string + " rep Id: " + string2);
        }
        Class clazz = null;
        RepositoryIdInterface repositoryIdInterface = this.repIdStrs.getFromString(string2);
        try {
            clazz = repositoryIdInterface.getClassFromType(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw this.wrapper.cnfeReadClass(CompletionStatus.COMPLETED_MAYBE, classNotFoundException, repositoryIdInterface.getClassName());
        }
        catch (MalformedURLException malformedURLException) {
            throw this.wrapper.malformedUrl(CompletionStatus.COMPLETED_MAYBE, malformedURLException, repositoryIdInterface.getClassName(), string);
        }
        return clazz;
    }

    private java.lang.Object readIDLValueWithHelper(ValueHelper valueHelper, int n) {
        Method method;
        java.lang.Object object;
        try {
            object = new Class[]{InputStream.class, valueHelper.get_class()};
            method = valueHelper.getClass().getDeclaredMethod(kReadMethod, (Class<?>)object);
        }
        catch (NoSuchMethodException noSuchMethodException) {
            Serializable serializable = valueHelper.read_value(this.parent);
            return serializable;
        }
        object = null;
        try {
            object = valueHelper.get_class().newInstance();
        }
        catch (InstantiationException instantiationException) {
            throw this.wrapper.couldNotInstantiateHelper(instantiationException, (java.lang.Object)valueHelper.get_class());
        }
        catch (IllegalAccessException illegalAccessException) {
            return valueHelper.read_value(this.parent);
        }
        if (this.valueCache == null) {
            this.valueCache = new CacheTable(this.orb, false);
        }
        this.valueCache.put(object, n);
        if (object instanceof CustomMarshal && this.isCustomType(valueHelper)) {
            ((CustomMarshal)object).unmarshal(this.parent);
            return object;
        }
        try {
            java.lang.Object[] objectArray = new java.lang.Object[]{this.parent, object};
            method.invoke(valueHelper, objectArray);
            return object;
        }
        catch (IllegalAccessException illegalAccessException) {
            throw this.wrapper.couldNotInvokeHelperReadMethod(illegalAccessException, (java.lang.Object)valueHelper.get_class());
        }
        catch (InvocationTargetException invocationTargetException) {
            throw this.wrapper.couldNotInvokeHelperReadMethod(invocationTargetException, (java.lang.Object)valueHelper.get_class());
        }
    }

    private java.lang.Object readBoxedIDLEntity(Class clazz, String string) {
        Class clazz2 = null;
        try {
            ClassLoader classLoader = clazz == null ? null : clazz.getClassLoader();
            final Class clazz3 = clazz2 = Utility.loadClassForClass(clazz.getName() + "Helper", string, classLoader, clazz, classLoader);
            final Class[] classArray = new Class[]{InputStream.class};
            Method method = null;
            try {
                method = (Method)AccessController.doPrivileged(new PrivilegedExceptionAction(){

                    public java.lang.Object run() throws NoSuchMethodException {
                        return clazz3.getDeclaredMethod(CDRInputStream_1_0.kReadMethod, classArray);
                    }
                });
            }
            catch (PrivilegedActionException privilegedActionException) {
                throw (NoSuchMethodException)privilegedActionException.getException();
            }
            java.lang.Object[] objectArray = new java.lang.Object[]{this.parent};
            return method.invoke(null, objectArray);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw this.wrapper.couldNotInvokeHelperReadMethod(classNotFoundException, clazz2);
        }
        catch (NoSuchMethodException noSuchMethodException) {
            throw this.wrapper.couldNotInvokeHelperReadMethod(noSuchMethodException, clazz2);
        }
        catch (IllegalAccessException illegalAccessException) {
            throw this.wrapper.couldNotInvokeHelperReadMethod(illegalAccessException, clazz2);
        }
        catch (InvocationTargetException invocationTargetException) {
            throw this.wrapper.couldNotInvokeHelperReadMethod(invocationTargetException, clazz2);
        }
    }

    private java.lang.Object readIDLValue(int n, String string, Class clazz, String string2) {
        ValueFactory valueFactory;
        try {
            valueFactory = Utility.getFactory(clazz, string2, this.orb, string);
        }
        catch (MARSHAL mARSHAL) {
            if (!StreamableValue.class.isAssignableFrom(clazz) && !CustomValue.class.isAssignableFrom(clazz) && ValueBase.class.isAssignableFrom(clazz)) {
                BoxedValueHelper boxedValueHelper = Utility.getHelper(clazz, string2, string);
                if (boxedValueHelper instanceof ValueHelper) {
                    return this.readIDLValueWithHelper((ValueHelper)boxedValueHelper, n);
                }
                return boxedValueHelper.read_value(this.parent);
            }
            return this.readBoxedIDLEntity(clazz, string2);
        }
        this.valueIndirection = n;
        return valueFactory.read_value(this.parent);
    }

    private void readEndTag() {
        if (this.isChunked) {
            int n = this.read_long();
            if (n >= 0) {
                throw this.wrapper.positiveEndTag(CompletionStatus.COMPLETED_MAYBE, (java.lang.Object)new Integer(n), (java.lang.Object)new Integer(this.get_offset() - 4));
            }
            if (this.orb == null || ORBVersionFactory.getFOREIGN().equals(this.orb.getORBVersion()) || ORBVersionFactory.getNEWER().compareTo(this.orb.getORBVersion()) <= 0) {
                if (n < this.chunkedValueNestingLevel) {
                    throw this.wrapper.unexpectedEnclosingValuetype(CompletionStatus.COMPLETED_MAYBE, (java.lang.Object)new Integer(n), (java.lang.Object)new Integer(this.chunkedValueNestingLevel));
                }
                if (n != this.chunkedValueNestingLevel) {
                    this.bbwi.position(this.bbwi.position() - 4);
                }
            } else if (n != this.end_flag) {
                this.bbwi.position(this.bbwi.position() - 4);
            }
            ++this.chunkedValueNestingLevel;
        }
        ++this.end_flag;
    }

    protected int get_offset() {
        return this.bbwi.position();
    }

    private void start_block() {
        if (!this.isChunked) {
            return;
        }
        this.blockLength = 0x7FFFFF00;
        this.blockLength = this.read_long();
        if (this.blockLength > 0 && this.blockLength < 0x7FFFFF00) {
            this.blockLength += this.get_offset();
        } else {
            this.blockLength = 0x7FFFFF00;
            this.bbwi.position(this.bbwi.position() - 4);
        }
    }

    private void handleEndOfValue() {
        if (!this.isChunked) {
            return;
        }
        while (this.blockLength != 0x7FFFFF00) {
            this.end_block();
            this.start_block();
        }
        int n = this.read_long();
        this.bbwi.position(this.bbwi.position() - 4);
        if (n < 0) {
            return;
        }
        if (n != 0 && n < 0x7FFFFF00) {
            throw this.wrapper.couldNotSkipBytes(CompletionStatus.COMPLETED_MAYBE, (java.lang.Object)new Integer(n), (java.lang.Object)new Integer(this.get_offset()));
        }
        this.read_value();
        this.handleEndOfValue();
    }

    private void end_block() {
        if (this.blockLength != 0x7FFFFF00) {
            if (this.blockLength == this.get_offset()) {
                this.blockLength = 0x7FFFFF00;
            } else if (this.blockLength > this.get_offset()) {
                this.skipToOffset(this.blockLength);
            } else {
                throw this.wrapper.badChunkLength(new Integer(this.blockLength), new Integer(this.get_offset()));
            }
        }
    }

    private int readValueTag() {
        return this.read_long();
    }

    @Override
    public org.omg.CORBA.ORB orb() {
        return this.orb;
    }

    @Override
    public final void read_boolean_array(boolean[] blArray, int n, int n2) {
        for (int i = 0; i < n2; ++i) {
            blArray[i + n] = this.read_boolean();
        }
    }

    @Override
    public final void read_char_array(char[] cArray, int n, int n2) {
        for (int i = 0; i < n2; ++i) {
            cArray[i + n] = this.read_char();
        }
    }

    @Override
    public final void read_wchar_array(char[] cArray, int n, int n2) {
        for (int i = 0; i < n2; ++i) {
            cArray[i + n] = this.read_wchar();
        }
    }

    @Override
    public final void read_short_array(short[] sArray, int n, int n2) {
        for (int i = 0; i < n2; ++i) {
            sArray[i + n] = this.read_short();
        }
    }

    @Override
    public final void read_ushort_array(short[] sArray, int n, int n2) {
        this.read_short_array(sArray, n, n2);
    }

    @Override
    public final void read_long_array(int[] nArray, int n, int n2) {
        for (int i = 0; i < n2; ++i) {
            nArray[i + n] = this.read_long();
        }
    }

    @Override
    public final void read_ulong_array(int[] nArray, int n, int n2) {
        this.read_long_array(nArray, n, n2);
    }

    @Override
    public final void read_longlong_array(long[] lArray, int n, int n2) {
        for (int i = 0; i < n2; ++i) {
            lArray[i + n] = this.read_longlong();
        }
    }

    @Override
    public final void read_ulonglong_array(long[] lArray, int n, int n2) {
        this.read_longlong_array(lArray, n, n2);
    }

    @Override
    public final void read_float_array(float[] fArray, int n, int n2) {
        for (int i = 0; i < n2; ++i) {
            fArray[i + n] = this.read_float();
        }
    }

    @Override
    public final void read_double_array(double[] dArray, int n, int n2) {
        for (int i = 0; i < n2; ++i) {
            dArray[i + n] = this.read_double();
        }
    }

    public final void read_any_array(Any[] anyArray, int n, int n2) {
        for (int i = 0; i < n2; ++i) {
            anyArray[i + n] = this.read_any();
        }
    }

    private String read_repositoryIds() {
        int n = this.read_long();
        if (n == -1) {
            int n2 = this.read_long() + this.get_offset() - 4;
            if (this.repositoryIdCache != null && this.repositoryIdCache.containsOrderedVal(n2)) {
                return (String)this.repositoryIdCache.getKey(n2);
            }
            throw this.wrapper.unableToLocateRepIdArray(new Integer(n2));
        }
        int n3 = this.get_offset();
        String string = this.read_repositoryId();
        if (this.repositoryIdCache == null) {
            this.repositoryIdCache = new CacheTable(this.orb, false);
        }
        this.repositoryIdCache.put(string, n3);
        for (int i = 1; i < n; ++i) {
            this.read_repositoryId();
        }
        return string;
    }

    private final String read_repositoryId() {
        String string = this.readStringOrIndirection(true);
        if (string == null) {
            int n = this.read_long() + this.get_offset() - 4;
            if (this.repositoryIdCache != null && this.repositoryIdCache.containsOrderedVal(n)) {
                return (String)this.repositoryIdCache.getKey(n);
            }
            throw this.wrapper.badRepIdIndirection(CompletionStatus.COMPLETED_MAYBE, (java.lang.Object)new Integer(this.bbwi.position()));
        }
        if (this.repositoryIdCache == null) {
            this.repositoryIdCache = new CacheTable(this.orb, false);
        }
        this.repositoryIdCache.put(string, this.stringIndirection);
        return string;
    }

    private final String read_codebase_URL() {
        String string = this.readStringOrIndirection(true);
        if (string == null) {
            int n = this.read_long() + this.get_offset() - 4;
            if (this.codebaseCache != null && this.codebaseCache.containsVal(n)) {
                return (String)this.codebaseCache.getKey(n);
            }
            throw this.wrapper.badCodebaseIndirection(CompletionStatus.COMPLETED_MAYBE, (java.lang.Object)new Integer(this.bbwi.position()));
        }
        if (this.codebaseCache == null) {
            this.codebaseCache = new CacheTable(this.orb, false);
        }
        this.codebaseCache.put(string, this.stringIndirection);
        return string;
    }

    @Override
    public java.lang.Object read_Abstract() {
        return this.read_abstract_interface();
    }

    @Override
    public Serializable read_Value() {
        return this.read_value();
    }

    @Override
    public void read_any_array(AnySeqHolder anySeqHolder, int n, int n2) {
        this.read_any_array(anySeqHolder.value, n, n2);
    }

    @Override
    public void read_boolean_array(BooleanSeqHolder booleanSeqHolder, int n, int n2) {
        this.read_boolean_array(booleanSeqHolder.value, n, n2);
    }

    @Override
    public void read_char_array(CharSeqHolder charSeqHolder, int n, int n2) {
        this.read_char_array(charSeqHolder.value, n, n2);
    }

    @Override
    public void read_wchar_array(WCharSeqHolder wCharSeqHolder, int n, int n2) {
        this.read_wchar_array(wCharSeqHolder.value, n, n2);
    }

    @Override
    public void read_octet_array(OctetSeqHolder octetSeqHolder, int n, int n2) {
        this.read_octet_array(octetSeqHolder.value, n, n2);
    }

    @Override
    public void read_short_array(ShortSeqHolder shortSeqHolder, int n, int n2) {
        this.read_short_array(shortSeqHolder.value, n, n2);
    }

    @Override
    public void read_ushort_array(UShortSeqHolder uShortSeqHolder, int n, int n2) {
        this.read_ushort_array(uShortSeqHolder.value, n, n2);
    }

    @Override
    public void read_long_array(LongSeqHolder longSeqHolder, int n, int n2) {
        this.read_long_array(longSeqHolder.value, n, n2);
    }

    @Override
    public void read_ulong_array(ULongSeqHolder uLongSeqHolder, int n, int n2) {
        this.read_ulong_array(uLongSeqHolder.value, n, n2);
    }

    @Override
    public void read_ulonglong_array(ULongLongSeqHolder uLongLongSeqHolder, int n, int n2) {
        this.read_ulonglong_array(uLongLongSeqHolder.value, n, n2);
    }

    @Override
    public void read_longlong_array(LongLongSeqHolder longLongSeqHolder, int n, int n2) {
        this.read_longlong_array(longLongSeqHolder.value, n, n2);
    }

    @Override
    public void read_float_array(FloatSeqHolder floatSeqHolder, int n, int n2) {
        this.read_float_array(floatSeqHolder.value, n, n2);
    }

    @Override
    public void read_double_array(DoubleSeqHolder doubleSeqHolder, int n, int n2) {
        this.read_double_array(doubleSeqHolder.value, n, n2);
    }

    @Override
    public BigDecimal read_fixed(short s, short s2) {
        StringBuffer stringBuffer = this.read_fixed_buffer();
        if (s != stringBuffer.length()) {
            throw this.wrapper.badFixed(new Integer(s), new Integer(stringBuffer.length()));
        }
        stringBuffer.insert(s - s2, '.');
        return new BigDecimal(stringBuffer.toString());
    }

    @Override
    public BigDecimal read_fixed() {
        return new BigDecimal(this.read_fixed_buffer().toString());
    }

    private StringBuffer read_fixed_buffer() {
        StringBuffer stringBuffer = new StringBuffer(64);
        boolean bl = false;
        boolean bl2 = true;
        while (bl2) {
            byte by = this.read_octet();
            int n = (by & 0xF0) >> 4;
            int n2 = by & 0xF;
            if (bl || n != 0) {
                stringBuffer.append(Character.forDigit(n, 10));
                bl = true;
            }
            if (n2 == 12) {
                if (!bl) {
                    return new StringBuffer("0.0");
                }
                bl2 = false;
                continue;
            }
            if (n2 == 13) {
                stringBuffer.insert(0, '-');
                bl2 = false;
                continue;
            }
            stringBuffer.append(Character.forDigit(n2, 10));
            bl = true;
        }
        return stringBuffer;
    }

    @Override
    public String[] _truncatable_ids() {
        if (_ids == null) {
            return null;
        }
        return (String[])_ids.clone();
    }

    @Override
    public void printBuffer() {
        CDRInputStream_1_0.printBuffer(this.bbwi);
    }

    public static void printBuffer(ByteBufferWithInfo byteBufferWithInfo) {
        System.out.println("----- Input Buffer -----");
        System.out.println();
        System.out.println("Current position: " + byteBufferWithInfo.position());
        System.out.println("Total length : " + byteBufferWithInfo.buflen);
        System.out.println();
        try {
            char[] cArray = new char[16];
            for (int i = 0; i < byteBufferWithInfo.buflen; i += 16) {
                int n;
                int n2;
                for (n2 = 0; n2 < 16 && n2 + i < byteBufferWithInfo.buflen; ++n2) {
                    String string;
                    n = byteBufferWithInfo.byteBuffer.get(i + n2);
                    if (n < 0) {
                        n = 256 + n;
                    }
                    if ((string = Integer.toHexString(n)).length() == 1) {
                        string = "0" + string;
                    }
                    System.out.print(string + " ");
                }
                while (n2 < 16) {
                    System.out.print("   ");
                    ++n2;
                }
                for (n = 0; n < 16 && n + i < byteBufferWithInfo.buflen; ++n) {
                    cArray[n] = ORBUtility.isPrintable((char)byteBufferWithInfo.byteBuffer.get(i + n)) ? (int)byteBufferWithInfo.byteBuffer.get(i + n) : 46;
                }
                System.out.println(new String(cArray, 0, n));
            }
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
        }
        System.out.println("------------------------");
    }

    @Override
    public ByteBuffer getByteBuffer() {
        ByteBuffer byteBuffer = null;
        if (this.bbwi != null) {
            byteBuffer = this.bbwi.byteBuffer;
        }
        return byteBuffer;
    }

    @Override
    public int getBufferLength() {
        return this.bbwi.buflen;
    }

    @Override
    public void setBufferLength(int n) {
        this.bbwi.buflen = n;
        this.bbwi.byteBuffer.limit(this.bbwi.buflen);
    }

    @Override
    public void setByteBufferWithInfo(ByteBufferWithInfo byteBufferWithInfo) {
        this.bbwi = byteBufferWithInfo;
    }

    @Override
    public void setByteBuffer(ByteBuffer byteBuffer) {
        this.bbwi.byteBuffer = byteBuffer;
    }

    @Override
    public int getIndex() {
        return this.bbwi.position();
    }

    @Override
    public void setIndex(int n) {
        this.bbwi.position(n);
    }

    @Override
    public boolean isLittleEndian() {
        return this.littleEndian;
    }

    @Override
    public void orb(org.omg.CORBA.ORB oRB) {
        this.orb = (ORB)oRB;
    }

    @Override
    public BufferManagerRead getBufferManager() {
        return this.bufferManagerRead;
    }

    private void skipToOffset(int n) {
        int n2;
        int n3 = n - this.get_offset();
        for (int i = 0; i < n3; i += n2) {
            int n4;
            int n5 = this.bbwi.buflen - this.bbwi.position();
            if (n5 <= 0) {
                this.grow(1, 1);
                n5 = this.bbwi.buflen - this.bbwi.position();
            }
            n2 = (n4 = n3 - i) < n5 ? n4 : n5;
            this.bbwi.position(this.bbwi.position() + n2);
        }
    }

    @Override
    public java.lang.Object createStreamMemento() {
        return new StreamMemento();
    }

    @Override
    public void restoreInternalState(java.lang.Object object) {
        StreamMemento streamMemento = (StreamMemento)object;
        this.blockLength = streamMemento.blockLength_;
        this.end_flag = streamMemento.end_flag_;
        this.chunkedValueNestingLevel = streamMemento.chunkedValueNestingLevel_;
        this.valueIndirection = streamMemento.valueIndirection_;
        this.stringIndirection = streamMemento.stringIndirection_;
        this.isChunked = streamMemento.isChunked_;
        this.valueHandler = streamMemento.valueHandler_;
        this.specialNoOptionalDataState = streamMemento.specialNoOptionalDataState_;
        this.bbwi = streamMemento.bbwi_;
    }

    @Override
    public int getPosition() {
        return this.get_offset();
    }

    @Override
    public void mark(int n) {
        this.markAndResetHandler.mark(this);
    }

    @Override
    public void reset() {
        this.markAndResetHandler.reset();
    }

    @Override
    CodeBase getCodeBase() {
        return this.parent.getCodeBase();
    }

    private Class getClassFromString(String string, String string2, Class clazz) {
        RepositoryIdInterface repositoryIdInterface = this.repIdStrs.getFromString(string);
        try {
            try {
                return repositoryIdInterface.getClassFromType(clazz, string2);
            }
            catch (ClassNotFoundException classNotFoundException) {
                try {
                    if (this.getCodeBase() == null) {
                        return null;
                    }
                    string2 = this.getCodeBase().implementation(string);
                    if (string2 == null) {
                        return null;
                    }
                    return repositoryIdInterface.getClassFromType(clazz, string2);
                }
                catch (ClassNotFoundException classNotFoundException2) {
                    this.dprintThrowable(classNotFoundException2);
                    return null;
                }
            }
        }
        catch (MalformedURLException malformedURLException) {
            throw this.wrapper.malformedUrl(CompletionStatus.COMPLETED_MAYBE, malformedURLException, string, string2);
        }
    }

    private Class getClassFromString(String string, String string2) {
        RepositoryIdInterface repositoryIdInterface = this.repIdStrs.getFromString(string);
        for (int i = 0; i < 3; ++i) {
            try {
                switch (i) {
                    case 0: {
                        return repositoryIdInterface.getClassFromType();
                    }
                    case 1: {
                        break;
                    }
                    case 2: {
                        string2 = this.getCodeBase().implementation(string);
                    }
                }
                if (string2 == null) continue;
                return repositoryIdInterface.getClassFromType(string2);
            }
            catch (ClassNotFoundException classNotFoundException) {
                continue;
            }
            catch (MalformedURLException malformedURLException) {
                throw this.wrapper.malformedUrl(CompletionStatus.COMPLETED_MAYBE, malformedURLException, string, string2);
            }
        }
        this.dprint("getClassFromString failed with rep id " + string + " and codebase " + string2);
        return null;
    }

    char[] getConvertedChars(int n, CodeSetConversion.BTCConverter bTCConverter) {
        if (this.bbwi.buflen - this.bbwi.position() >= n) {
            byte[] byArray;
            if (this.bbwi.byteBuffer.hasArray()) {
                byArray = this.bbwi.byteBuffer.array();
            } else {
                byArray = new byte[this.bbwi.buflen];
                for (int i = 0; i < this.bbwi.buflen; ++i) {
                    byArray[i] = this.bbwi.byteBuffer.get(i);
                }
            }
            char[] cArray = bTCConverter.getChars(byArray, this.bbwi.position(), n);
            this.bbwi.position(this.bbwi.position() + n);
            return cArray;
        }
        byte[] byArray = new byte[n];
        this.read_octet_array(byArray, 0, byArray.length);
        return bTCConverter.getChars(byArray, 0, n);
    }

    protected CodeSetConversion.BTCConverter getCharConverter() {
        if (this.charConverter == null) {
            this.charConverter = this.parent.createCharBTCConverter();
        }
        return this.charConverter;
    }

    protected CodeSetConversion.BTCConverter getWCharConverter() {
        if (this.wcharConverter == null) {
            this.wcharConverter = this.parent.createWCharBTCConverter();
        }
        return this.wcharConverter;
    }

    protected void dprintThrowable(Throwable throwable) {
        if (this.debug && throwable != null) {
            throwable.printStackTrace();
        }
    }

    protected void dprint(String string) {
        if (this.debug) {
            ORBUtility.dprint(this, string);
        }
    }

    @Override
    void alignOnBoundary(int n) {
        int n2 = this.computeAlignment(this.bbwi.position(), n);
        if (this.bbwi.position() + n2 <= this.bbwi.buflen) {
            this.bbwi.position(this.bbwi.position() + n2);
        }
    }

    @Override
    public void resetCodeSetConverters() {
        this.charConverter = null;
        this.wcharConverter = null;
    }

    @Override
    public void start_value() {
        int n = this.readValueTag();
        if (n == 0) {
            this.specialNoOptionalDataState = true;
            return;
        }
        if (n == -1) {
            throw this.wrapper.customWrapperIndirection(CompletionStatus.COMPLETED_MAYBE);
        }
        if (this.repIdUtil.isCodeBasePresent(n)) {
            throw this.wrapper.customWrapperWithCodebase(CompletionStatus.COMPLETED_MAYBE);
        }
        if (this.repIdUtil.getTypeInfo(n) != 2) {
            throw this.wrapper.customWrapperNotSingleRepid(CompletionStatus.COMPLETED_MAYBE);
        }
        this.read_repositoryId();
        this.start_block();
        --this.end_flag;
        --this.chunkedValueNestingLevel;
    }

    @Override
    public void end_value() {
        if (this.specialNoOptionalDataState) {
            this.specialNoOptionalDataState = false;
            return;
        }
        this.handleEndOfValue();
        this.readEndTag();
        this.start_block();
    }

    @Override
    public void close() throws IOException {
        this.getBufferManager().close(this.bbwi);
        if (this.bbwi != null && this.getByteBuffer() != null) {
            java.lang.Object object;
            MessageMediator messageMediator = this.parent.getMessageMediator();
            if (messageMediator != null && (object = (CDROutputObject)messageMediator.getOutputObject()) != null && ((CDROutputStream)object).isSharing(this.getByteBuffer())) {
                ((CDROutputStream)object).setByteBuffer(null);
                ((CDROutputObject)object).setByteBufferWithInfo(null);
            }
            object = this.orb.getByteBufferPool();
            if (this.debug) {
                int n = System.identityHashCode(this.bbwi.byteBuffer);
                StringBuffer stringBuffer = new StringBuffer(80);
                stringBuffer.append(".close - releasing ByteBuffer id (");
                stringBuffer.append(n).append(") to ByteBufferPool.");
                String string = stringBuffer.toString();
                this.dprint(string);
            }
            object.releaseByteBuffer(this.bbwi.byteBuffer);
            this.bbwi.byteBuffer = null;
            this.bbwi = null;
        }
    }

    protected class StreamMemento {
        private int blockLength_;
        private int end_flag_;
        private int chunkedValueNestingLevel_;
        private int valueIndirection_;
        private int stringIndirection_;
        private boolean isChunked_;
        private ValueHandler valueHandler_;
        private ByteBufferWithInfo bbwi_;
        private boolean specialNoOptionalDataState_;

        public StreamMemento() {
            this.blockLength_ = CDRInputStream_1_0.this.blockLength;
            this.end_flag_ = CDRInputStream_1_0.this.end_flag;
            this.chunkedValueNestingLevel_ = CDRInputStream_1_0.this.chunkedValueNestingLevel;
            this.valueIndirection_ = CDRInputStream_1_0.this.valueIndirection;
            this.stringIndirection_ = CDRInputStream_1_0.this.stringIndirection;
            this.isChunked_ = CDRInputStream_1_0.this.isChunked;
            this.valueHandler_ = CDRInputStream_1_0.this.valueHandler;
            this.specialNoOptionalDataState_ = CDRInputStream_1_0.this.specialNoOptionalDataState;
            this.bbwi_ = new ByteBufferWithInfo(CDRInputStream_1_0.this.bbwi);
        }
    }
}

