/*
 * Decompiled with CFR 0.152.
 */
package javafx.stage;

import com.sun.javafx.tk.FileChooserType;
import com.sun.javafx.tk.Toolkit;
import java.io.File;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.SimpleObjectProperty;
import javafx.beans.property.SimpleStringProperty;
import javafx.beans.property.StringProperty;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import javafx.stage.Window;

public final class FileChooser {
    private StringProperty title;
    private ObjectProperty<File> initialDirectory;
    private ObservableList<ExtensionFilter> extensionFilters = FXCollections.observableArrayList();

    public final void setTitle(String string) {
        this.titleProperty().set(string);
    }

    public final String getTitle() {
        return this.title != null ? (String)this.title.get() : null;
    }

    public final StringProperty titleProperty() {
        if (this.title == null) {
            this.title = new SimpleStringProperty(this, "title");
        }
        return this.title;
    }

    public final void setInitialDirectory(File file) {
        this.initialDirectoryProperty().set(file);
    }

    public final File getInitialDirectory() {
        return this.initialDirectory != null ? (File)this.initialDirectory.get() : null;
    }

    public final ObjectProperty<File> initialDirectoryProperty() {
        if (this.initialDirectory == null) {
            this.initialDirectory = new SimpleObjectProperty<File>(this, "initialDirectory");
        }
        return this.initialDirectory;
    }

    public ObservableList<ExtensionFilter> getExtensionFilters() {
        return this.extensionFilters;
    }

    public File showOpenDialog(Window window) {
        List<File> list = this.showDialog(window, FileChooserType.OPEN);
        return list != null && list.size() > 0 ? list.get(0) : null;
    }

    public List<File> showOpenMultipleDialog(Window window) {
        List<File> list = this.showDialog(window, FileChooserType.OPEN_MULTIPLE);
        return list != null && list.size() > 0 ? Collections.unmodifiableList(list) : null;
    }

    public File showSaveDialog(Window window) {
        List<File> list = this.showDialog(window, FileChooserType.SAVE);
        return list != null && list.size() > 0 ? list.get(0) : null;
    }

    private List<File> showDialog(Window window, FileChooserType fileChooserType) {
        return Toolkit.getToolkit().showFileChooser(window != null ? window.impl_getPeer() : null, this.getTitle(), this.getInitialDirectory(), fileChooserType, this.extensionFilters);
    }

    public static final class ExtensionFilter {
        private final String description;
        private final List<String> extensions;

        public ExtensionFilter(String string, String ... stringArray) {
            ExtensionFilter.validateArgs(string, stringArray);
            this.description = string;
            this.extensions = Collections.unmodifiableList(Arrays.asList((Object[])stringArray.clone()));
        }

        public ExtensionFilter(String string, List<String> list) {
            String[] stringArray = list != null ? list.toArray(new String[list.size()]) : null;
            ExtensionFilter.validateArgs(string, stringArray);
            this.description = string;
            this.extensions = Collections.unmodifiableList(Arrays.asList(stringArray));
        }

        public String getDescription() {
            return this.description;
        }

        public List<String> getExtensions() {
            return this.extensions;
        }

        private static void validateArgs(String string, String[] stringArray) {
            if (string == null) {
                throw new NullPointerException("Description must not be null");
            }
            if (string.isEmpty()) {
                throw new IllegalArgumentException("Description must not be empty");
            }
            if (stringArray == null) {
                throw new NullPointerException("Extensions must not be null");
            }
            if (stringArray.length == 0) {
                throw new IllegalArgumentException("At least one extension must be defined");
            }
            for (String string2 : stringArray) {
                if (string2 == null) {
                    throw new NullPointerException("Extension must not be null");
                }
                if (!string2.isEmpty()) continue;
                throw new IllegalArgumentException("Extension must not be empty");
            }
        }
    }
}

