/*
 * Decompiled with CFR 0.152.
 */
package javafx.embed.swt;

import com.sun.javafx.application.PlatformImpl;
import com.sun.javafx.cursor.CursorFrame;
import com.sun.javafx.cursor.CursorType;
import com.sun.javafx.embed.EmbeddedSceneDragSourceInterface;
import com.sun.javafx.embed.EmbeddedSceneDragStartListenerInterface;
import com.sun.javafx.embed.EmbeddedSceneDropTargetInterface;
import com.sun.javafx.embed.EmbeddedSceneInterface;
import com.sun.javafx.embed.EmbeddedStageInterface;
import com.sun.javafx.embed.HostInterface;
import com.sun.javafx.stage.EmbeddedWindow;
import java.nio.IntBuffer;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.HashSet;
import java.util.Set;
import javafx.application.Platform;
import javafx.embed.swt.CustomTransfer;
import javafx.embed.swt.SWTCursors;
import javafx.embed.swt.SWTEvents;
import javafx.scene.Scene;
import javafx.scene.input.TransferMode;
import org.eclipse.swt.SWT;
import org.eclipse.swt.dnd.DragSource;
import org.eclipse.swt.dnd.DragSourceEvent;
import org.eclipse.swt.dnd.DragSourceListener;
import org.eclipse.swt.dnd.DropTarget;
import org.eclipse.swt.dnd.DropTargetEvent;
import org.eclipse.swt.dnd.DropTargetListener;
import org.eclipse.swt.dnd.FileTransfer;
import org.eclipse.swt.dnd.HTMLTransfer;
import org.eclipse.swt.dnd.ImageTransfer;
import org.eclipse.swt.dnd.RTFTransfer;
import org.eclipse.swt.dnd.TextTransfer;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.dnd.TransferData;
import org.eclipse.swt.dnd.URLTransfer;
import org.eclipse.swt.events.ControlEvent;
import org.eclipse.swt.events.ControlListener;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.MenuDetectEvent;
import org.eclipse.swt.events.MenuDetectListener;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.MouseMoveListener;
import org.eclipse.swt.events.MouseTrackListener;
import org.eclipse.swt.events.MouseWheelListener;
import org.eclipse.swt.events.PaintEvent;
import org.eclipse.swt.events.PaintListener;
import org.eclipse.swt.graphics.Cursor;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.ImageData;
import org.eclipse.swt.graphics.PaletteData;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.widgets.Canvas;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;

public class FXCanvas
extends Canvas {
    private HostContainer hostContainer;
    private volatile EmbeddedWindow stage;
    private volatile Scene scene;
    private EmbeddedStageInterface stagePeer;
    private EmbeddedSceneInterface scenePeer;
    private int pWidth = 0;
    private int pHeight = 0;
    private volatile int pPreferredWidth = -1;
    private volatile int pPreferredHeight = -1;
    private IntBuffer pixelsBuf = null;
    static Transfer[] StandardTransfers = new Transfer[]{TextTransfer.getInstance(), RTFTransfer.getInstance(), HTMLTransfer.getInstance(), URLTransfer.getInstance(), ImageTransfer.getInstance(), FileTransfer.getInstance()};
    static Transfer[] CustomTransfers = new Transfer[0];
    int lastWidth;
    int lastHeight;
    IntBuffer lastPixelsBuf = null;

    static Transfer[] getAllTransfers() {
        Transfer[] transferArray = new Transfer[StandardTransfers.length + CustomTransfers.length];
        System.arraycopy(StandardTransfers, 0, transferArray, 0, StandardTransfers.length);
        System.arraycopy(CustomTransfers, 0, transferArray, StandardTransfers.length, CustomTransfers.length);
        return transferArray;
    }

    static Transfer getCustomTransfer(String string) {
        for (int i = 0; i < CustomTransfers.length; ++i) {
            if (!((CustomTransfer)CustomTransfers[i]).getMime().equals(string)) continue;
            return CustomTransfers[i];
        }
        CustomTransfer customTransfer = new CustomTransfer(string, string);
        Transfer[] transferArray = new Transfer[CustomTransfers.length + 1];
        System.arraycopy(CustomTransfers, 0, transferArray, 0, CustomTransfers.length);
        transferArray[FXCanvas.CustomTransfers.length] = customTransfer;
        CustomTransfers = transferArray;
        return customTransfer;
    }

    public FXCanvas(Composite composite, int n) {
        super(composite, n | 0x40000);
        FXCanvas.initFx();
        this.hostContainer = new HostContainer();
        this.registerEventListeners();
    }

    private static void initFx() {
        AccessController.doPrivileged(new PrivilegedAction<Void>(){

            @Override
            public Void run() {
                System.setProperty("javafx.macosx.embedded", "true");
                System.setProperty("javafx.embed.isEventThread", "true");
                return null;
            }
        });
        PlatformImpl.startup(new Runnable(){

            @Override
            public void run() {
            }
        });
    }

    public Point computeSize(int n, int n2, boolean bl) {
        this.checkWidget();
        if (n == -1 && n2 == -1 && this.pPreferredWidth != -1 && this.pPreferredHeight != -1) {
            return new Point(this.pPreferredWidth, this.pPreferredHeight);
        }
        return super.computeSize(n, n2, bl);
    }

    public Scene getScene() {
        this.checkWidget();
        return this.scene;
    }

    public void setScene(Scene scene) {
        this.checkWidget();
        if (this.stage == null && scene != null) {
            this.stage = new EmbeddedWindow(this.hostContainer);
            this.stage.show();
        }
        this.scene = scene;
        if (this.stage != null) {
            this.stage.setScene(scene);
        }
        if (this.stage != null && scene == null) {
            this.stage.hide();
            this.stage = null;
        }
    }

    private void registerEventListeners() {
        this.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent disposeEvent) {
                FXCanvas.this.widgetDisposed(disposeEvent);
            }
        });
        this.addPaintListener(new PaintListener(){

            public void paintControl(PaintEvent paintEvent) {
                FXCanvas.this.paintControl(paintEvent);
            }
        });
        this.addMouseListener(new MouseListener(){

            public void mouseDoubleClick(MouseEvent mouseEvent) {
            }

            public void mouseDown(MouseEvent mouseEvent) {
                FXCanvas.this.sendMouseEventToFX(mouseEvent, 0);
            }

            public void mouseUp(MouseEvent mouseEvent) {
                FXCanvas.this.sendMouseEventToFX(mouseEvent, 1);
            }
        });
        this.addMouseMoveListener(new MouseMoveListener(){

            public void mouseMove(MouseEvent mouseEvent) {
                if ((mouseEvent.stateMask & SWT.BUTTON_MASK) != 0) {
                    FXCanvas.this.sendMouseEventToFX(mouseEvent, 6);
                } else {
                    FXCanvas.this.sendMouseEventToFX(mouseEvent, 5);
                }
            }
        });
        this.addMouseWheelListener(new MouseWheelListener(){

            public void mouseScrolled(MouseEvent mouseEvent) {
                FXCanvas.this.sendMouseEventToFX(mouseEvent, 7);
            }
        });
        this.addMouseTrackListener(new MouseTrackListener(){

            public void mouseEnter(MouseEvent mouseEvent) {
                FXCanvas.this.sendMouseEventToFX(mouseEvent, 3);
            }

            public void mouseExit(MouseEvent mouseEvent) {
                FXCanvas.this.sendMouseEventToFX(mouseEvent, 4);
            }

            public void mouseHover(MouseEvent mouseEvent) {
            }
        });
        this.addControlListener(new ControlListener(){

            public void controlMoved(ControlEvent controlEvent) {
                FXCanvas.this.sendMoveEventToFX();
            }

            public void controlResized(ControlEvent controlEvent) {
                FXCanvas.this.sendResizeEventToFX();
            }
        });
        this.addFocusListener(new FocusListener(){

            public void focusGained(FocusEvent focusEvent) {
                FXCanvas.this.sendFocusEventToFX(focusEvent, true);
            }

            public void focusLost(FocusEvent focusEvent) {
                FXCanvas.this.sendFocusEventToFX(focusEvent, false);
            }
        });
        this.addKeyListener(new KeyListener(){

            public void keyPressed(KeyEvent keyEvent) {
                FXCanvas.this.sendKeyEventToFX(keyEvent, 1);
            }

            public void keyReleased(KeyEvent keyEvent) {
                FXCanvas.this.sendKeyEventToFX(keyEvent, 2);
            }
        });
        this.addMenuDetectListener(new MenuDetectListener(){

            public void menuDetected(MenuDetectEvent menuDetectEvent) {
                FXCanvas.this.sendMenuEventToFX(menuDetectEvent);
            }
        });
    }

    private void widgetDisposed(DisposeEvent disposeEvent) {
        if (this.stage != null) {
            this.stage.hide();
        }
    }

    private void paintControl(PaintEvent paintEvent) {
        PaletteData paletteData;
        if (this.scenePeer == null || this.pixelsBuf == null) {
            return;
        }
        IntBuffer intBuffer = this.pixelsBuf;
        int n = this.pWidth;
        int n2 = this.pHeight;
        if (this.scenePeer.getPixels(this.pixelsBuf, this.pWidth, this.pHeight)) {
            n = this.lastWidth = this.pWidth;
            n2 = this.lastHeight = this.pHeight;
            intBuffer = this.lastPixelsBuf = this.pixelsBuf;
        } else {
            if (this.lastPixelsBuf == null) {
                return;
            }
            n = this.lastWidth;
            n2 = this.lastHeight;
            intBuffer = this.lastPixelsBuf;
        }
        ImageData imageData = null;
        if ("win32".equals(SWT.getPlatform())) {
            paletteData = new PaletteData(65280, 0xFF0000, -16777216);
            int n3 = n * 4;
            byte[] byArray = new byte[n3 * n2];
            int[] nArray = intBuffer.array();
            int n4 = 0;
            int n5 = 0;
            for (int i = 0; i < n2; ++i) {
                for (int j = 0; j < n; ++j) {
                    int n6 = nArray[n5++];
                    byArray[n4++] = (byte)(n6 & 0xFF);
                    byArray[n4++] = (byte)(n6 >> 8 & 0xFF);
                    byArray[n4++] = (byte)(n6 >> 16 & 0xFF);
                    byArray[n4++] = 0;
                }
            }
            imageData = new ImageData(n, n2, 32, paletteData, 4, byArray);
        } else {
            paletteData = new PaletteData(0xFF0000, 65280, 255);
            imageData = new ImageData(n, n2, 32, paletteData);
            imageData.setPixels(0, 0, n * n2, intBuffer.array(), 0);
        }
        paletteData = new Image((Device)Display.getDefault(), imageData);
        paintEvent.gc.drawImage((Image)paletteData, 0, 0);
        paletteData.dispose();
    }

    private void sendMoveEventToFX() {
        if (this.stagePeer == null) {
            return;
        }
        Point point = this.toDisplay(this.getLocation());
        this.stagePeer.setLocation(point.x, point.y);
    }

    private void sendMouseEventToFX(MouseEvent mouseEvent, int n) {
        if (this.scenePeer == null) {
            return;
        }
        Point point = this.toDisplay(mouseEvent.x, mouseEvent.y);
        boolean bl = (mouseEvent.stateMask & 0x80000) != 0;
        boolean bl2 = (mouseEvent.stateMask & 0x100000) != 0;
        boolean bl3 = (mouseEvent.stateMask & 0x200000) != 0;
        boolean bl4 = (mouseEvent.stateMask & 0x20000) != 0;
        boolean bl5 = (mouseEvent.stateMask & 0x40000) != 0;
        boolean bl6 = (mouseEvent.stateMask & 0x10000) != 0;
        boolean bl7 = (mouseEvent.stateMask & 0x400000) != 0;
        switch (n) {
            case 0: {
                bl |= mouseEvent.button == 1;
                bl2 |= mouseEvent.button == 2;
                bl3 |= mouseEvent.button == 3;
                break;
            }
            case 1: {
                bl &= mouseEvent.button != 1;
                bl2 &= mouseEvent.button != 2;
                bl3 &= mouseEvent.button != 3;
            }
        }
        this.scenePeer.mouseEvent(n, SWTEvents.mouseButtonToEmbedMouseButton(mouseEvent.button, mouseEvent.stateMask), bl, bl2, bl3, mouseEvent.count, mouseEvent.x, mouseEvent.y, point.x, point.y, bl4, bl5, bl6, bl7, SWTEvents.getWheelRotation(mouseEvent, n), false);
    }

    private void sendKeyEventToFX(KeyEvent keyEvent, int n) {
        if (this.scenePeer == null) {
            return;
        }
        int n2 = keyEvent.stateMask;
        if (n == 1) {
            if (keyEvent.keyCode == 131072) {
                n2 |= 0x20000;
            }
            if (keyEvent.keyCode == 262144) {
                n2 |= 0x40000;
            }
            if (keyEvent.keyCode == 65536) {
                n2 |= 0x10000;
            }
            if (keyEvent.keyCode == 0x400000) {
                n2 |= 0x400000;
            }
        } else {
            if (keyEvent.keyCode == 131072) {
                n2 &= 0xFFFDFFFF;
            }
            if (keyEvent.keyCode == 262144) {
                n2 &= 0xFFFBFFFF;
            }
            if (keyEvent.keyCode == 65536) {
                n2 &= 0xFFFEFFFF;
            }
            if (keyEvent.keyCode == 0x400000) {
                n2 &= 0xFFBFFFFF;
            }
        }
        int n3 = SWTEvents.keyCodeToEmbedKeyCode(keyEvent.keyCode);
        this.scenePeer.keyEvent(SWTEvents.keyIDToEmbedKeyType(n), n3, new char[0], SWTEvents.keyModifiersToEmbedKeyModifiers(n2));
        if (keyEvent.character != '\u0000' && n == 1) {
            char[] cArray = new char[]{keyEvent.character};
            this.scenePeer.keyEvent(2, keyEvent.keyCode, cArray, SWTEvents.keyModifiersToEmbedKeyModifiers(n2));
        }
    }

    private void sendMenuEventToFX(MenuDetectEvent menuDetectEvent) {
        if (this.scenePeer == null) {
            return;
        }
        Point point = this.toControl(menuDetectEvent.x, menuDetectEvent.y);
        this.scenePeer.menuEvent(point.x, point.y, menuDetectEvent.x, menuDetectEvent.y, false);
    }

    private void sendResizeEventToFX() {
        this.redraw();
        this.update();
        this.pWidth = this.getClientArea().width;
        this.pHeight = this.getClientArea().height;
        if (this.pWidth <= 0 || this.pHeight <= 0) {
            this.lastPixelsBuf = null;
            this.pixelsBuf = null;
        } else {
            this.pixelsBuf = IntBuffer.allocate(this.pWidth * this.pHeight);
        }
        if (this.scenePeer == null) {
            return;
        }
        this.stagePeer.setSize(this.pWidth, this.pHeight);
        this.scenePeer.setSize(this.pWidth, this.pHeight);
    }

    private void sendFocusEventToFX(FocusEvent focusEvent, boolean bl) {
        if (this.stage == null || this.stagePeer == null) {
            return;
        }
        int n = bl ? 0 : 3;
        this.stagePeer.setFocused(bl, n);
    }

    private class HostContainer
    implements HostInterface {
        DropTarget dropTarget;
        Object lock = new Object();
        boolean queued = false;

        private HostContainer() {
        }

        @Override
        public void setEmbeddedStage(EmbeddedStageInterface embeddedStageInterface) {
            FXCanvas.this.stagePeer = embeddedStageInterface;
            if (FXCanvas.this.stagePeer == null) {
                return;
            }
            if (FXCanvas.this.pWidth > 0 && FXCanvas.this.pHeight > 0) {
                FXCanvas.this.stagePeer.setSize(FXCanvas.this.pWidth, FXCanvas.this.pHeight);
            }
            if (FXCanvas.this.isFocusControl()) {
                FXCanvas.this.stagePeer.setFocused(true, 0);
            }
            FXCanvas.this.sendMoveEventToFX();
            FXCanvas.this.sendResizeEventToFX();
        }

        TransferMode getTransferMode(int n) {
            switch (n) {
                case 1: {
                    return TransferMode.COPY;
                }
                case 2: 
                case 8: {
                    return TransferMode.MOVE;
                }
                case 4: {
                    return TransferMode.LINK;
                }
            }
            return null;
        }

        Set<TransferMode> getTransferModes(int n) {
            HashSet<TransferMode> hashSet = new HashSet<TransferMode>();
            if ((n & 1) != 0) {
                hashSet.add(TransferMode.COPY);
            }
            if ((n & 2) != 0) {
                hashSet.add(TransferMode.MOVE);
            }
            if ((n & 8) != 0) {
                hashSet.add(TransferMode.MOVE);
            }
            if ((n & 4) != 0) {
                hashSet.add(TransferMode.LINK);
            }
            return hashSet;
        }

        private DragSource createDragSource(final EmbeddedSceneDragSourceInterface embeddedSceneDragSourceInterface, TransferMode transferMode) {
            Transfer[] transferArray = this.getTransferTypes(embeddedSceneDragSourceInterface.getMimeTypes());
            if (transferArray.length == 0) {
                return null;
            }
            int n = this.getDragActions(embeddedSceneDragSourceInterface.getSupportedActions());
            final DragSource dragSource = new DragSource((Control)FXCanvas.this, n);
            dragSource.setTransfer(transferArray);
            dragSource.addDragListener(new DragSourceListener(){

                public void dragFinished(DragSourceEvent dragSourceEvent) {
                    dragSource.dispose();
                    embeddedSceneDragSourceInterface.dragDropEnd(HostContainer.this.getTransferMode(dragSourceEvent.detail));
                }

                public void dragSetData(DragSourceEvent dragSourceEvent) {
                    Transfer[] transferArray = dragSource.getTransfer();
                    for (int i = 0; i < transferArray.length; ++i) {
                        String string;
                        if (transferArray[i].isSupportedType(dragSourceEvent.dataType) && (string = HostContainer.this.getMime(transferArray[i])) != null) {
                            dragSourceEvent.doit = true;
                            dragSourceEvent.data = embeddedSceneDragSourceInterface.getData(string);
                            return;
                        }
                        dragSourceEvent.doit = false;
                    }
                }

                public void dragStart(DragSourceEvent dragSourceEvent) {
                }
            });
            return dragSource;
        }

        int getDragAction(TransferMode transferMode) {
            if (transferMode == null) {
                return 0;
            }
            switch (transferMode) {
                case COPY: {
                    return 1;
                }
                case MOVE: {
                    return 2;
                }
                case LINK: {
                    return 4;
                }
            }
            throw new IllegalArgumentException("Invalid transfer mode");
        }

        int getDragActions(Set<TransferMode> set) {
            int n = 0;
            for (TransferMode transferMode : set) {
                n |= this.getDragAction(transferMode);
            }
            return n;
        }

        Transfer getTransferType(String string) {
            if (string.equals("text/plain")) {
                return TextTransfer.getInstance();
            }
            if (string.equals("text/rtf")) {
                return RTFTransfer.getInstance();
            }
            if (string.equals("text/html")) {
                return HTMLTransfer.getInstance();
            }
            if (string.equals("text/uri-list")) {
                return URLTransfer.getInstance();
            }
            if (string.equals("application/x-java-rawimage")) {
                return ImageTransfer.getInstance();
            }
            if (string.equals("application/x-java-file-list") || string.equals("java.file-list")) {
                return FileTransfer.getInstance();
            }
            return FXCanvas.getCustomTransfer(string);
        }

        Transfer[] getTransferTypes(String[] stringArray) {
            int n = 0;
            Transfer[] transferArray = new Transfer[stringArray.length];
            for (int i = 0; i < stringArray.length; ++i) {
                Transfer transfer = this.getTransferType(stringArray[i]);
                if (transfer == null) continue;
                transferArray[n++] = transfer;
            }
            if (n != stringArray.length) {
                Transfer[] transferArray2 = new Transfer[n];
                System.arraycopy(transferArray, 0, transferArray2, 0, n);
                transferArray = transferArray2;
            }
            return transferArray;
        }

        String getMime(Transfer transfer) {
            if (transfer.equals(TextTransfer.getInstance())) {
                return "text/plain";
            }
            if (transfer.equals(RTFTransfer.getInstance())) {
                return "text/rtf";
            }
            if (transfer.equals(HTMLTransfer.getInstance())) {
                return "text/html";
            }
            if (transfer.equals(URLTransfer.getInstance())) {
                return "text/uri-list";
            }
            if (transfer.equals(ImageTransfer.getInstance())) {
                return "application/x-java-rawimage";
            }
            if (transfer.equals(FileTransfer.getInstance())) {
                return "application/x-java-file-list";
            }
            if (transfer instanceof CustomTransfer) {
                return ((CustomTransfer)transfer).getMime();
            }
            return null;
        }

        String[] getMimes(Transfer[] transferArray, TransferData transferData) {
            int n = 0;
            String[] stringArray = new String[transferArray.length];
            for (int i = 0; i < transferArray.length; ++i) {
                if (!transferArray[i].isSupportedType(transferData)) continue;
                stringArray[n++] = this.getMime(transferArray[i]);
            }
            if (n != stringArray.length) {
                String[] stringArray2 = new String[n];
                System.arraycopy(stringArray, 0, stringArray2, 0, n);
                stringArray = stringArray2;
            }
            return stringArray;
        }

        DropTarget createDropTarget(EmbeddedSceneInterface embeddedSceneInterface) {
            final DropTarget dropTarget = new DropTarget((Control)FXCanvas.this, 7);
            final EmbeddedSceneDropTargetInterface embeddedSceneDropTargetInterface = embeddedSceneInterface.createDropTarget();
            dropTarget.setTransfer(FXCanvas.getAllTransfers());
            dropTarget.addDropListener(new DropTargetListener(){
                Object data;
                TransferData[] transferData;
                TransferData currentTransferData;
                boolean ignoreLeave;
                int detail = 0;
                int operations = 0;
                EmbeddedSceneDragSourceInterface fxDragSource = new EmbeddedSceneDragSourceInterface(){

                    @Override
                    public Set<TransferMode> getSupportedActions() {
                        return HostContainer.this.getTransferModes(operations);
                    }

                    @Override
                    public Object getData(String string) {
                        return data;
                    }

                    @Override
                    public String[] getMimeTypes() {
                        if (currentTransferData == null) {
                            return new String[0];
                        }
                        return HostContainer.this.getMimes(FXCanvas.getAllTransfers(), currentTransferData);
                    }

                    @Override
                    public boolean isMimeTypeAvailable(String string) {
                        String[] stringArray = this.getMimeTypes();
                        for (int i = 0; i < stringArray.length; ++i) {
                            if (!stringArray[i].equals(string)) continue;
                            return true;
                        }
                        return false;
                    }

                    @Override
                    public void dragDropEnd(TransferMode transferMode) {
                        data = null;
                        transferData = null;
                        currentTransferData = null;
                    }
                };

                public void dragEnter(DropTargetEvent dropTargetEvent) {
                    dropTarget.setTransfer(FXCanvas.getAllTransfers());
                    this.detail = dropTargetEvent.detail;
                    this.operations = dropTargetEvent.operations;
                    this.dragOver(dropTargetEvent, true, this.detail);
                }

                public void dragLeave(DropTargetEvent dropTargetEvent) {
                    this.operations = 0;
                    this.detail = 0;
                    this.data = null;
                    this.transferData = null;
                    this.currentTransferData = null;
                    FXCanvas.this.getDisplay().asyncExec(new Runnable(){

                        @Override
                        public void run() {
                            if (ignoreLeave) {
                                return;
                            }
                            embeddedSceneDropTargetInterface.handleDragLeave();
                        }
                    });
                }

                public void dragOperationChanged(DropTargetEvent dropTargetEvent) {
                    this.detail = dropTargetEvent.detail;
                    this.operations = dropTargetEvent.operations;
                    this.dragOver(dropTargetEvent, false, this.detail);
                }

                public void dragOver(DropTargetEvent dropTargetEvent) {
                    this.operations = dropTargetEvent.operations;
                    this.dragOver(dropTargetEvent, false, this.detail);
                }

                public void dragOver(DropTargetEvent dropTargetEvent, boolean bl, int n) {
                    this.transferData = dropTargetEvent.dataTypes;
                    this.currentTransferData = dropTargetEvent.currentDataType;
                    Point point = FXCanvas.this.toControl(dropTargetEvent.x, dropTargetEvent.y);
                    if (n == 0) {
                        n = 1;
                    }
                    TransferMode transferMode = HostContainer.this.getTransferMode(n);
                    TransferMode transferMode2 = bl ? embeddedSceneDropTargetInterface.handleDragEnter(point.x, point.y, dropTargetEvent.x, dropTargetEvent.y, transferMode, this.fxDragSource) : embeddedSceneDropTargetInterface.handleDragOver(point.x, point.y, dropTargetEvent.x, dropTargetEvent.y, transferMode);
                    dropTargetEvent.detail = HostContainer.this.getDragAction(transferMode2);
                }

                public void drop(DropTargetEvent dropTargetEvent) {
                    this.detail = dropTargetEvent.detail;
                    this.operations = dropTargetEvent.operations;
                    this.data = dropTargetEvent.data;
                    this.transferData = dropTargetEvent.dataTypes;
                    this.currentTransferData = dropTargetEvent.currentDataType;
                    Point point = FXCanvas.this.toControl(dropTargetEvent.x, dropTargetEvent.y);
                    TransferMode transferMode = HostContainer.this.getTransferMode(dropTargetEvent.detail);
                    TransferMode transferMode2 = embeddedSceneDropTargetInterface.handleDragDrop(point.x, point.y, dropTargetEvent.x, dropTargetEvent.y, transferMode);
                    dropTargetEvent.detail = HostContainer.this.getDragAction(transferMode2);
                    this.data = null;
                    this.transferData = null;
                    this.currentTransferData = null;
                }

                public void dropAccept(DropTargetEvent dropTargetEvent) {
                    this.ignoreLeave = true;
                }
            });
            return dropTarget;
        }

        @Override
        public void setEmbeddedScene(EmbeddedSceneInterface embeddedSceneInterface) {
            FXCanvas.this.scenePeer = embeddedSceneInterface;
            if (FXCanvas.this.scenePeer == null) {
                return;
            }
            if (FXCanvas.this.pWidth > 0 && FXCanvas.this.pHeight > 0) {
                FXCanvas.this.scenePeer.setSize(FXCanvas.this.pWidth, FXCanvas.this.pHeight);
            }
            FXCanvas.this.scenePeer.setDragStartListener(new EmbeddedSceneDragStartListenerInterface(){

                @Override
                public void dragStarted(final EmbeddedSceneDragSourceInterface embeddedSceneDragSourceInterface, final TransferMode transferMode) {
                    Platform.runLater(new Runnable(){

                        @Override
                        public void run() {
                            DragSource dragSource = HostContainer.this.createDragSource(embeddedSceneDragSourceInterface, transferMode);
                            if (dragSource == null) {
                                embeddedSceneDragSourceInterface.dragDropEnd(null);
                            } else {
                                if (HostContainer.this.dropTarget != null) {
                                    HostContainer.this.dropTarget.setTransfer(FXCanvas.getAllTransfers());
                                }
                                FXCanvas.this.notifyListeners(29, null);
                            }
                        }
                    });
                }
            });
            if (this.dropTarget != null) {
                this.dropTarget.dispose();
            }
            this.dropTarget = this.createDropTarget(embeddedSceneInterface);
        }

        @Override
        public boolean requestFocus() {
            Display.getDefault().asyncExec(new Runnable(){

                @Override
                public void run() {
                    if (FXCanvas.this.isDisposed()) {
                        return;
                    }
                    FXCanvas.this.forceFocus();
                }
            });
            return true;
        }

        @Override
        public boolean traverseFocusOut(boolean bl) {
            return true;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void repaint() {
            Object object = this.lock;
            synchronized (object) {
                if (this.queued) {
                    return;
                }
                this.queued = true;
                Display.getDefault().asyncExec(new Runnable(){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    @Override
                    public void run() {
                        try {
                            if (FXCanvas.this.isDisposed()) {
                                return;
                            }
                            FXCanvas.this.redraw();
                            FXCanvas.this.sendMoveEventToFX();
                        }
                        finally {
                            Object object = HostContainer.this.lock;
                            synchronized (object) {
                                HostContainer.this.queued = false;
                            }
                        }
                    }
                });
            }
        }

        @Override
        public void setPreferredSize(int n, int n2) {
            FXCanvas.this.pPreferredWidth = n;
            FXCanvas.this.pPreferredHeight = n2;
        }

        @Override
        public void setEnabled(boolean bl) {
            FXCanvas.this.setEnabled(bl);
        }

        @Override
        public void setCursor(CursorFrame cursorFrame) {
            FXCanvas.this.setCursor(this.getPlatformCursor(cursorFrame));
        }

        private Cursor getPlatformCursor(CursorFrame cursorFrame) {
            if (cursorFrame.getCursorType() == CursorType.DEFAULT) {
                return null;
            }
            Cursor cursor = cursorFrame.getPlatformCursor(Cursor.class);
            if (cursor != null) {
                return cursor;
            }
            Cursor cursor2 = SWTCursors.embedCursorToCursor(cursorFrame);
            cursorFrame.setPlatforCursor(Cursor.class, cursor2);
            return cursor2;
        }
    }
}

