/*
 * Decompiled with CFR 0.152.
 */
package com.sun.webpane.platform;

import com.sun.webpane.platform.SharedBufferManager;
import java.io.IOException;
import java.io.InputStream;
import java.util.logging.Level;
import java.util.logging.Logger;

public class SharedBufferInputStream
extends InputStream {
    private static final int bufferSize = 8192;
    private byte[] buffer;
    private int bufferDataLength;
    private int bufferPos;
    private long sharedBufferPos;
    private SharedBufferManager manager;
    private boolean blocking;
    private static final Logger log = Logger.getLogger("webcore.platform.api.SharedBufferInputStream");
    private String idStr;

    private String getID() {
        if (this.idStr == null) {
            this.idStr = String.format("ID %X: ", this.hashCode());
        }
        return this.idStr;
    }

    public SharedBufferInputStream(SharedBufferManager sharedBufferManager, boolean bl) {
        this.manager = sharedBufferManager;
        this.blocking = bl;
        this.buffer = new byte[8192];
        this.bufferDataLength = 0;
        this.bufferPos = 0;
        this.sharedBufferPos = 0L;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean checkBuffer() throws IOException {
        while (this.bufferPos == this.bufferDataLength) {
            if (log.isLoggable(Level.FINE)) {
                log.fine(this.getID() + "need to fill buffer, sharedBufferSize=" + this.manager.getSharedBufferSize() + ", sharedBufferPos=" + this.sharedBufferPos);
            }
            SharedBufferManager sharedBufferManager = this.manager;
            synchronized (sharedBufferManager) {
                while (this.manager.getSharedBufferSize() <= this.sharedBufferPos) {
                    if (log.isLoggable(Level.FINE)) {
                        log.fine(this.getID() + "No data available in the shared buffer...");
                    }
                    if (!this.blocking || this.manager.isAllDataReceived() || this.manager.isReleased()) {
                        if (log.isLoggable(Level.FINE)) {
                            log.fine(this.getID() + "Reached end of the shared buffer at " + this.sharedBufferPos + ", returns EOF");
                        }
                        return false;
                    }
                    if (log.isLoggable(Level.FINE)) {
                        log.fine(this.getID() + "Wait for data...");
                    }
                    try {
                        this.manager.wait(200L);
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                    if (!log.isLoggable(Level.FINE)) continue;
                    log.fine(this.getID() + "Got data notification...");
                }
            }
            if (log.isLoggable(Level.FINE)) {
                log.fine(this.getID() + "Fill buffer...");
            }
            this.fillBuffer();
        }
        return true;
    }

    private synchronized void fillBuffer() throws IOException {
        this.bufferPos = 0;
        this.bufferDataLength = this.manager.fillBuffer(this.sharedBufferPos, this.buffer);
        this.sharedBufferPos += (long)this.bufferDataLength;
    }

    public void dumpState(Logger logger) {
        if (logger.isLoggable(Level.FINE)) {
            logger.fine(String.format("State of %s\n\tsharedBufferPtr: %X\n\tsharedBufferSize: %d\n\tsharedBufferPos: %d\n\tallDataRecieved: %s\n\tbufferPos: %d\n\tbufferSize: %d\n\tbufferDataLength: %d\n\tnativeBufferSize: %d\n", this.toString(), this.manager.getSharedBufferPtr(), this.manager.getSharedBufferSize(), this.sharedBufferPos, this.manager.isAllDataReceived(), this.bufferPos, 8192, this.bufferDataLength, this.manager.getNativeBufferSize()));
        }
    }

    public synchronized void rewind() throws IOException {
        this.bufferPos = 0;
        this.bufferDataLength = 0;
        this.sharedBufferPos = 0L;
    }

    @Override
    public int read() throws IOException {
        if (!this.checkBuffer()) {
            return -1;
        }
        return 0xFF & this.buffer[this.bufferPos++];
    }

    @Override
    public int read(byte[] byArray, int n, int n2) throws IOException {
        if (n < 0 || n2 < 0 || byArray.length - n < n2) {
            if (log.isLoggable(Level.FINER)) {
                log.finer(this.getID() + "Invalid method arguments:");
            }
            throw new IndexOutOfBoundsException("Invalid arguments");
        }
        if (n2 == 0) {
            return 0;
        }
        if (!this.checkBuffer()) {
            return -1;
        }
        if (log.isLoggable(Level.FINER)) {
            log.finer(this.getID() + "Requested " + n2 + " bytes");
        }
        if (this.bufferPos + n2 > this.bufferDataLength) {
            n2 = this.bufferDataLength - this.bufferPos;
        }
        if (log.isLoggable(Level.FINER)) {
            log.finer(this.getID() + "Available " + n2 + " bytes");
        }
        System.arraycopy(this.buffer, this.bufferPos, byArray, n, n2);
        this.bufferPos += n2;
        return n2;
    }

    @Override
    public void close() throws IOException {
        this.manager.notifyInputStreamClosed();
    }

    @Override
    public boolean markSupported() {
        if (log.isLoggable(Level.FINEST)) {
            log.finest(this.getID() + "markSupported()");
        }
        return super.markSupported();
    }

    @Override
    public void mark(int n) {
        if (log.isLoggable(Level.FINEST)) {
            log.finest(this.getID() + "mark(" + n + ")");
        }
        super.mark(n);
    }

    @Override
    public void reset() throws IOException {
        if (log.isLoggable(Level.FINEST)) {
            log.finest(this.getID() + "reset()");
        }
        try {
            super.reset();
        }
        catch (IOException iOException) {
            if (log.isLoggable(Level.FINEST)) {
                log.log(Level.FINEST, this.getID() + "reset(): catch exception", iOException);
            }
            throw iOException;
        }
    }
}

