/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javafx.tk.quantum;

import com.sun.javafx.geom.CameraImpl;
import com.sun.javafx.geom.PickRay;
import com.sun.javafx.geom.Rectangle;
import com.sun.javafx.geom.Vec3d;
import com.sun.javafx.geom.transform.Affine3D;
import com.sun.javafx.geom.transform.GeneralTransform3D;
import com.sun.javafx.geom.transform.NoninvertibleTransformException;
import com.sun.javafx.logging.PlatformLogger;
import com.sun.javafx.sg.PGNode;
import com.sun.javafx.sg.prism.NGNode;
import com.sun.javafx.sg.prism.SceneChangeListener;
import com.sun.javafx.tk.TKDragGestureListener;
import com.sun.javafx.tk.TKDragSourceListener;
import com.sun.javafx.tk.TKDropTargetListener;
import com.sun.javafx.tk.TKScene;
import com.sun.javafx.tk.TKSceneListener;
import com.sun.javafx.tk.TKScenePaintListener;
import com.sun.javafx.tk.Toolkit;
import com.sun.javafx.tk.quantum.GlassStage;
import com.sun.javafx.tk.quantum.PaintCollector;
import com.sun.javafx.tk.quantum.PopupStage;
import com.sun.javafx.tk.quantum.ViewScene;
import com.sun.prism.camera.PrismCameraImpl;
import com.sun.prism.camera.PrismParallelCameraImpl;
import com.sun.prism.camera.PrismPerspectiveCameraImpl;
import com.sun.prism.impl.PrismSettings;
import com.sun.prism.paint.Paint;
import javafx.scene.input.Dragboard;
import javafx.scene.input.InputMethodRequests;

public abstract class GlassScene
implements TKScene,
SceneChangeListener {
    protected boolean verbose;
    protected GlassStage glassStage;
    protected TKSceneListener sceneListener;
    protected TKDragGestureListener dragGestureListener;
    protected TKDragSourceListener dragSourceListener;
    protected TKDropTargetListener dropTargetListener;
    protected InputMethodRequests inputMethodRequests;
    private TKScenePaintListener scenePaintListener;
    protected NGNode root;
    protected PrismCameraImpl camera;
    protected Paint fillPaint;
    private boolean dirty;
    private boolean entireSceneDirty = true;
    private boolean depthBuffer = false;
    private static final double[] projMatValues = new double[16];
    private static final Vec3d ptCc = new Vec3d();
    private static final Vec3d ptEc = new Vec3d();
    private static final Vec3d ptWc = new Vec3d();
    private static final Vec3d eyeEc = new Vec3d();
    private static final Vec3d eyeWc = new Vec3d();

    protected GlassScene(boolean bl) {
        this(bl, false);
    }

    protected GlassScene(boolean bl, boolean bl2) {
        this.verbose = bl;
        this.depthBuffer = bl2;
    }

    boolean hasDepthBuffer() {
        return this.depthBuffer;
    }

    protected abstract boolean isSynchronous();

    @Override
    public void setScene(Object object) {
    }

    @Override
    public void setTKSceneListener(TKSceneListener tKSceneListener) {
        this.sceneListener = tKSceneListener;
    }

    @Override
    public synchronized void setTKScenePaintListener(TKScenePaintListener tKScenePaintListener) {
        this.scenePaintListener = tKScenePaintListener;
    }

    public void setTKDropTargetListener(TKDropTargetListener tKDropTargetListener) {
        this.dropTargetListener = tKDropTargetListener;
    }

    public void setTKDragSourceListener(TKDragSourceListener tKDragSourceListener) {
        this.dragSourceListener = tKDragSourceListener;
    }

    public void setTKDragGestureListener(TKDragGestureListener tKDragGestureListener) {
        this.dragGestureListener = tKDragGestureListener;
    }

    public void setInputMethodRequests(InputMethodRequests inputMethodRequests) {
        this.inputMethodRequests = inputMethodRequests;
    }

    @Override
    public void setRoot(PGNode pGNode) {
        this.root = (NGNode)pGNode;
        this.entireSceneNeedsRepaint();
    }

    protected PGNode getRoot() {
        return this.root;
    }

    @Override
    public void setCamera(CameraImpl cameraImpl) {
        this.camera = cameraImpl != null ? (PrismCameraImpl)cameraImpl : PrismParallelCameraImpl.getInstance();
        this.entireSceneNeedsRepaint();
    }

    @Override
    public void setFillPaint(Object object) {
        this.fillPaint = (Paint)object;
        this.entireSceneNeedsRepaint();
    }

    @Override
    public void setCursor(Object object) {
    }

    @Override
    public void markDirty() {
        this.sceneChanged();
    }

    @Override
    public void entireSceneNeedsRepaint() {
        this.entireSceneDirty = true;
        this.sceneChanged();
    }

    public boolean isEntireSceneDirty() {
        return this.entireSceneDirty;
    }

    public void clearEntireSceneDirty() {
        this.entireSceneDirty = false;
    }

    void clearDirty() {
        this.dirty = false;
    }

    @Override
    public void requestFocus() {
        if (this.glassStage != null) {
            this.glassStage.requestFocus();
        }
    }

    @Override
    public Dragboard createDragboard() {
        return Toolkit.getToolkit().createDragboard();
    }

    void setGlassStage(GlassStage glassStage) {
        this.glassStage = glassStage;
        if (this.glassStage != null) {
            this.sceneChanged();
        } else {
            PaintCollector.getInstance().removeDirtyScene(this);
            this.clearDirty();
        }
    }

    void repaint() {
    }

    void stageVisible(boolean bl) {
        if (!bl && PrismSettings.forceRepaint) {
            PaintCollector.getInstance().removeDirtyScene(this);
            this.clearDirty();
        }
        if (bl) {
            PaintCollector.getInstance().addDirtyScene(this);
        }
    }

    @Override
    public PickRay computePickRay(float f, float f2, PickRay pickRay) {
        GeneralTransform3D generalTransform3D = this.camera.getProjectionTransform(null);
        generalTransform3D.get(projMatValues);
        Affine3D affine3D = this.camera.getViewTransform(null);
        Rectangle rectangle = this.camera.getViewport(null);
        double d = (double)(f / (float)rectangle.width) * 2.0 - 1.0;
        double d2 = (double)(f2 / (float)rectangle.height) * -2.0 + 1.0;
        if (!(this.camera instanceof PrismPerspectiveCameraImpl)) {
            System.err.println("Picking not implemented for parallel projection");
        } else {
            double[] dArray = projMatValues;
            double d3 = (1.0 - dArray[15]) / dArray[14];
            double d4 = dArray[10] * d3 + dArray[11];
            ptCc.set(d, d2, d4);
            generalTransform3D.invert();
            generalTransform3D.transform(ptCc, ptEc);
            try {
                affine3D.invert();
            }
            catch (NoninvertibleTransformException noninvertibleTransformException) {
                String string = ViewScene.class.getName();
                PlatformLogger.getLogger(string).severe("computePickRay", noninvertibleTransformException);
            }
            affine3D.transform(ptEc, ptWc);
            eyeEc.set(0.0, 0.0, 0.0);
            affine3D.transform(eyeEc, eyeWc);
            if (pickRay == null) {
                pickRay = new PickRay();
            }
            pickRay.getOriginNoClone().set(eyeWc);
            pickRay.getDirectionNoClone().sub(ptWc, eyeWc);
        }
        return pickRay;
    }

    @Override
    public void sceneChanged() {
        if (this.glassStage instanceof PopupStage) {
            ((PopupStage)this.glassStage).getOwnerScene().sceneChanged();
        }
        if (this.glassStage != null) {
            PaintCollector.getInstance().addDirtyScene(this);
        }
    }

    public final synchronized void frameRendered() {
        if (this.scenePaintListener != null) {
            this.scenePaintListener.frameRendered();
        }
    }
}

