/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javafx.css;

import com.sun.javafx.css.Combinator;
import com.sun.javafx.css.Match;
import com.sun.javafx.css.Selector;
import com.sun.javafx.css.SimpleSelector;
import com.sun.javafx.css.StringStore;
import com.sun.javafx.css.StyleHelper;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javafx.scene.Node;
import javafx.scene.Parent;
import javafx.scene.Scene;

public final class CompoundSelector
extends Selector {
    private final List<SimpleSelector> selectors;
    private final List<Combinator> relationships;
    private int hash = -1;

    public List<SimpleSelector> getSelectors() {
        return this.selectors;
    }

    public List<Combinator> getRelationships() {
        return this.relationships;
    }

    public CompoundSelector(List<SimpleSelector> list, List<Combinator> list2) {
        this.selectors = list != null ? Collections.unmodifiableList(list) : Collections.EMPTY_LIST;
        this.relationships = list2 != null ? Collections.unmodifiableList(list2) : Collections.EMPTY_LIST;
    }

    private CompoundSelector() {
        this(null, null);
    }

    @Override
    Match matches(Node node) {
        return this.matches(node, this.selectors.size() - 1);
    }

    private Match matches(Node node, int n) {
        Match match = this.selectors.get(n).matches(node);
        if (match == null || n == 0) {
            return match;
        }
        for (Parent parent = node.getParent(); parent != null; parent = parent.getParent()) {
            Match match2 = this.matches(parent, n - 1);
            if (match2 != null) {
                List<String> list = match2.pseudoclasses;
                List<String> list2 = match.pseudoclasses;
                ArrayList<String> arrayList = new ArrayList<String>();
                arrayList.addAll(match2.pseudoclasses);
                arrayList.addAll(match.pseudoclasses);
                return new Match(this, arrayList, match2.idCount + match.idCount, match2.styleClassCount + match.styleClassCount);
            }
            if (this.relationships.get(n - 1) == Combinator.CHILD) break;
        }
        return null;
    }

    @Override
    Match matches(Scene scene) {
        return null;
    }

    @Override
    public boolean applies(Node node) {
        return this.applies(node, this.selectors.size() - 1);
    }

    private boolean applies(Node node, int n) {
        if (n < 0) {
            return false;
        }
        if (!this.selectors.get(n).applies(node)) {
            return false;
        }
        if (n == 0) {
            return true;
        }
        Combinator combinator = this.relationships.get(n - 1);
        if (combinator == Combinator.CHILD) {
            Parent parent = node.getParent();
            if (parent == null) {
                return false;
            }
            return this.applies(parent, n - 1);
        }
        for (Parent parent = node.getParent(); parent != null; parent = parent.getParent()) {
            boolean bl = this.applies(parent, n - 1);
            if (!bl) continue;
            return true;
        }
        return false;
    }

    @Override
    boolean mightApply(String string, String string2, List<String> list) {
        return this.selectors.get(this.selectors.size() - 1).mightApply(string, string2, list);
    }

    @Override
    boolean stateMatches(Node node, long l) {
        return this.stateMatches(node, l, this.selectors.size() - 1);
    }

    private boolean stateMatches(Node node, long l, int n) {
        if (n < 0) {
            return false;
        }
        if (!this.selectors.get(n).stateMatches(node, l)) {
            return false;
        }
        if (n == 0) {
            return true;
        }
        Combinator combinator = this.relationships.get(n - 1);
        if (combinator == Combinator.CHILD) {
            Parent parent = node.getParent();
            if (parent == null) {
                return false;
            }
            if (this.selectors.get(n - 1).applies(parent)) {
                StyleHelper styleHelper = parent.impl_getStyleHelper();
                if (styleHelper == null) {
                    return false;
                }
                long l2 = styleHelper.getPseudoClassState();
                return this.stateMatches(parent, l2, n - 1);
            }
        } else {
            for (Parent parent = node.getParent(); parent != null; parent = parent.getParent()) {
                if (!this.selectors.get(n - 1).applies(parent)) continue;
                StyleHelper styleHelper = parent.impl_getStyleHelper();
                if (styleHelper != null) {
                    long l3 = styleHelper.getPseudoClassState();
                    return this.stateMatches(parent, l3, n - 1);
                }
                return false;
            }
        }
        return false;
    }

    public int hashCode() {
        if (this.hash == -1) {
            int n;
            int n2 = this.selectors.size();
            for (n = 0; n < n2; ++n) {
                this.hash = 31 * (this.hash + this.selectors.get(n).hashCode());
            }
            n2 = this.relationships.size();
            for (n = 0; n < n2; ++n) {
                this.hash = 31 * (this.hash + this.relationships.get(n).hashCode());
            }
        }
        return this.hash;
    }

    public boolean equals(Object object) {
        int n;
        if (object == null) {
            return false;
        }
        if (this.getClass() != object.getClass()) {
            return false;
        }
        CompoundSelector compoundSelector = (CompoundSelector)object;
        if (compoundSelector.selectors.size() != this.selectors.size()) {
            return false;
        }
        int n2 = this.selectors.size();
        for (n = 0; n < n2; ++n) {
            if (compoundSelector.selectors.get(n).equals(this.selectors.get(n))) continue;
            return false;
        }
        if (compoundSelector.relationships.size() != this.relationships.size()) {
            return false;
        }
        n2 = this.relationships.size();
        for (n = 0; n < n2; ++n) {
            if (compoundSelector.relationships.get(n).equals((Object)this.relationships.get(n))) continue;
            return false;
        }
        return true;
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(this.selectors.get(0));
        for (int i = 1; i < this.selectors.size(); ++i) {
            stringBuilder.append((Object)this.relationships.get(i - 1));
            stringBuilder.append(this.selectors.get(i));
        }
        return stringBuilder.toString();
    }

    @Override
    public void writeBinary(DataOutputStream dataOutputStream, StringStore stringStore) throws IOException {
        int n;
        super.writeBinary(dataOutputStream, stringStore);
        dataOutputStream.writeShort(this.selectors.size());
        for (n = 0; n < this.selectors.size(); ++n) {
            this.selectors.get(n).writeBinary(dataOutputStream, stringStore);
        }
        dataOutputStream.writeShort(this.relationships.size());
        for (n = 0; n < this.relationships.size(); ++n) {
            dataOutputStream.writeByte(this.relationships.get(n).ordinal());
        }
    }

    public static CompoundSelector readBinary(DataInputStream dataInputStream, String[] stringArray) throws IOException {
        int n;
        int n2 = dataInputStream.readShort();
        ArrayList<SimpleSelector> arrayList = new ArrayList<SimpleSelector>();
        for (n = 0; n < n2; ++n) {
            arrayList.add((SimpleSelector)Selector.readBinary(dataInputStream, stringArray));
        }
        n = dataInputStream.readShort();
        ArrayList<Combinator> arrayList2 = new ArrayList<Combinator>();
        for (int i = 0; i < n; ++i) {
            byte by = dataInputStream.readByte();
            if (by == Combinator.CHILD.ordinal()) {
                arrayList2.add(Combinator.CHILD);
                continue;
            }
            if (by == Combinator.DESCENDANT.ordinal()) {
                arrayList2.add(Combinator.DESCENDANT);
                continue;
            }
            assert (false) : "error deserializing CompoundSelector: Combinator = " + by;
            arrayList2.add(Combinator.DESCENDANT);
        }
        return new CompoundSelector(arrayList, arrayList2);
    }
}

