/*
 * Decompiled with CFR 0.152.
 */
package com.sun.glass.events;

import java.util.Map;

public class NpapiEvent {
    public static final int NPCocoaEventDrawRect = 1;
    public static final int NPCocoaEventMouseDown = 2;
    public static final int NPCocoaEventMouseUp = 3;
    public static final int NPCocoaEventMouseMoved = 4;
    public static final int NPCocoaEventMouseEntered = 5;
    public static final int NPCocoaEventMouseExited = 6;
    public static final int NPCocoaEventMouseDragged = 7;
    public static final int NPCocoaEventKeyDown = 8;
    public static final int NPCocoaEventKeyUp = 9;
    public static final int NPCocoaEventFlagsChanged = 10;
    public static final int NPCocoaEventFocusChanged = 11;
    public static final int NPCocoaEventWindowFocusChanged = 12;
    public static final int NPCocoaEventScrollWheel = 13;
    public static final int NPCocoaEventTextInput = 14;

    public static native void _dispatchCocoaNpapiDrawEvent(long var0, int var2, long var3, double var5, double var7, double var9, double var11);

    public static native void _dispatchCocoaNpapiMouseEvent(long var0, int var2, int var3, double var4, double var6, int var8, int var9, double var10, double var12, double var14);

    public static native void _dispatchCocoaNpapiKeyEvent(long var0, int var2, int var3, String var4, String var5, boolean var6, int var7, boolean var8);

    public static native void _dispatchCocoaNpapiFocusEvent(long var0, int var2, boolean var3);

    public static native void _dispatchCocoaNpapiTextInputEvent(long var0, int var2, String var3);

    private static final boolean getBoolean(Map eventInfo, String key) {
        boolean value = false;
        if (eventInfo.containsKey(key)) {
            try {
                value = (Boolean)eventInfo.get(key);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return value;
    }

    private static final int getInt(Map eventInfo, String key) {
        int value = 0;
        if (eventInfo.containsKey(key)) {
            try {
                value = (Integer)eventInfo.get(key);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return value;
    }

    private static final long getLong(Map eventInfo, String key) {
        long value = 0L;
        if (eventInfo.containsKey(key)) {
            try {
                value = (Long)eventInfo.get(key);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return value;
    }

    private static final double getDouble(Map eventInfo, String key) {
        double value = 0.0;
        if (eventInfo.containsKey(key)) {
            try {
                value = (Double)eventInfo.get(key);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return value;
    }

    private static final String getString(Map eventInfo, String key) {
        String value = null;
        if (eventInfo.containsKey(key)) {
            try {
                value = (String)eventInfo.get(key);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return value;
    }

    public static void dispatchCocoaNpapiEvent(long windowPtr, Map eventInfo) {
        int type = (Integer)eventInfo.get("type");
        switch (type) {
            case 1: {
                long context = NpapiEvent.getLong(eventInfo, "context");
                double x = NpapiEvent.getDouble(eventInfo, "x");
                double y = NpapiEvent.getDouble(eventInfo, "y");
                double width = NpapiEvent.getDouble(eventInfo, "width");
                double height = NpapiEvent.getDouble(eventInfo, "height");
                NpapiEvent._dispatchCocoaNpapiDrawEvent(windowPtr, type, context, x, y, width, height);
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 13: {
                int modifierFlags = NpapiEvent.getInt(eventInfo, "modifierFlags");
                double pluginX = NpapiEvent.getDouble(eventInfo, "pluginX");
                double pluginY = NpapiEvent.getDouble(eventInfo, "pluginY");
                int buttonNumber = NpapiEvent.getInt(eventInfo, "buttonNumber");
                int clickCount = NpapiEvent.getInt(eventInfo, "clickCount");
                double deltaX = NpapiEvent.getDouble(eventInfo, "deltaX");
                double deltaY = NpapiEvent.getDouble(eventInfo, "deltaY");
                double deltaZ = NpapiEvent.getDouble(eventInfo, "deltaZ");
                NpapiEvent._dispatchCocoaNpapiMouseEvent(windowPtr, type, modifierFlags, pluginX, pluginY, buttonNumber, clickCount, deltaX, deltaY, deltaZ);
                break;
            }
            case 8: 
            case 9: 
            case 10: {
                int modifierFlags = NpapiEvent.getInt(eventInfo, "modifierFlags");
                String characters = NpapiEvent.getString(eventInfo, "characters");
                String charactersIgnoringModifiers = NpapiEvent.getString(eventInfo, "charactersIgnoringModifiers");
                boolean isARepeat = NpapiEvent.getBoolean(eventInfo, "isARepeat");
                int keyCode = NpapiEvent.getInt(eventInfo, "keyCode");
                boolean needsKeyTyped = NpapiEvent.getBoolean(eventInfo, "needsKeyTyped");
                NpapiEvent._dispatchCocoaNpapiKeyEvent(windowPtr, type, modifierFlags, characters, charactersIgnoringModifiers, isARepeat, keyCode, needsKeyTyped);
                break;
            }
            case 11: 
            case 12: {
                boolean hasFocus = NpapiEvent.getBoolean(eventInfo, "hasFocus");
                NpapiEvent._dispatchCocoaNpapiFocusEvent(windowPtr, type, hasFocus);
                break;
            }
            case 14: {
                String text = NpapiEvent.getString(eventInfo, "text");
                NpapiEvent._dispatchCocoaNpapiTextInputEvent(windowPtr, type, text);
            }
        }
    }
}

