/*
 * Decompiled with CFR 0.152.
 */
package org.fife.ui.rsyntaxtextarea;

import java.awt.Color;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.geom.Rectangle2D;
import javax.swing.text.TabExpander;
import org.fife.ui.rsyntaxtextarea.RSyntaxTextArea;
import org.fife.ui.rsyntaxtextarea.RSyntaxUtilities;
import org.fife.ui.rsyntaxtextarea.Style;
import org.fife.ui.rsyntaxtextarea.SyntaxScheme;

public abstract class Token {
    public char[] text = null;
    public int textOffset = -1;
    public int textCount = -1;
    public int offset = -1;
    public int type = 0;
    private boolean hyperlink = false;
    private Token nextToken = null;
    private Rectangle2D.Float bgRect = new Rectangle2D.Float();
    private static char[] tabBuf;
    public static final int NULL = 0;
    public static final int COMMENT_EOL = 1;
    public static final int COMMENT_MULTILINE = 2;
    public static final int COMMENT_DOCUMENTATION = 3;
    public static final int RESERVED_WORD = 4;
    public static final int FUNCTION = 5;
    public static final int LITERAL_BOOLEAN = 6;
    public static final int LITERAL_NUMBER_DECIMAL_INT = 7;
    public static final int LITERAL_NUMBER_FLOAT = 8;
    public static final int LITERAL_NUMBER_HEXADECIMAL = 9;
    public static final int LITERAL_STRING_DOUBLE_QUOTE = 10;
    public static final int LITERAL_CHAR = 11;
    public static final int LITERAL_BACKQUOTE = 12;
    public static final int DATA_TYPE = 13;
    public static final int VARIABLE = 14;
    public static final int IDENTIFIER = 15;
    public static final int WHITESPACE = 16;
    public static final int SEPARATOR = 17;
    public static final int OPERATOR = 18;
    public static final int PREPROCESSOR = 19;
    public static final int MARKUP_TAG_DELIMITER = 20;
    public static final int MARKUP_TAG_NAME = 21;
    public static final int MARKUP_TAG_ATTRIBUTE = 22;
    public static final int ERROR_IDENTIFIER = 23;
    public static final int ERROR_NUMBER_FORMAT = 24;
    public static final int ERROR_STRING_DOUBLE = 25;
    public static final int ERROR_CHAR = 26;
    public static final int NUM_TOKEN_TYPES = 27;

    public Token() {
    }

    public Token(char[] cArray, int n, int n2, int n3, int n4) {
        this();
        this.set(cArray, n, n2, n3, n4);
    }

    public Token(Token token) {
        this();
        this.copyFrom(token);
    }

    public StringBuffer appendHTMLRepresentation(StringBuffer stringBuffer, RSyntaxTextArea rSyntaxTextArea, boolean bl) {
        SyntaxScheme syntaxScheme = rSyntaxTextArea.getSyntaxScheme();
        Style style = syntaxScheme.styles[this.type];
        Font font = rSyntaxTextArea.getFontForTokenType(this.type);
        if (font.isBold()) {
            stringBuffer.append("<b>");
        }
        if (font.isItalic()) {
            stringBuffer.append("<em>");
        }
        if (style.underline) {
            stringBuffer.append("<u>");
        }
        stringBuffer.append("<font");
        if (bl) {
            stringBuffer.append(" face=\"").append(font.getFamily()).append("\"");
        }
        stringBuffer.append(" color=\"").append(Token.getHTMLFormatForColor(style.foreground)).append("\">");
        this.appendHtmlLexeme(stringBuffer);
        stringBuffer.append("</font>");
        if (style.underline) {
            stringBuffer.append("</u>");
        }
        if (font.isItalic()) {
            stringBuffer.append("</em>");
        }
        if (font.isBold()) {
            stringBuffer.append("</b>");
        }
        return stringBuffer;
    }

    private final StringBuffer appendHtmlLexeme(StringBuffer stringBuffer) {
        int n;
        int n2 = n = this.textOffset;
        while (n < this.textOffset + this.textCount) {
            char c = this.text[n];
            switch (c) {
                case '\t': {
                    stringBuffer.append(this.text, n2, n - n2);
                    n2 = n + 1;
                    stringBuffer.append("&nbsp;");
                    break;
                }
                case '<': {
                    stringBuffer.append(this.text, n2, n - n2);
                    n2 = n + 1;
                    stringBuffer.append("&lt;");
                    break;
                }
                case '>': {
                    stringBuffer.append(this.text, n2, n - n2);
                    n2 = n + 1;
                    stringBuffer.append("&gt;");
                }
            }
            ++n;
        }
        if (n2 < this.textOffset + this.textCount) {
            stringBuffer.append(this.text, n2, this.textOffset + this.textCount - n2);
        }
        return stringBuffer;
    }

    public boolean containsPosition(int n) {
        return n >= this.offset && n < this.offset + this.textCount;
    }

    public void copyFrom(Token token) {
        this.text = token.text;
        this.textOffset = token.textOffset;
        this.textCount = token.textCount;
        this.offset = token.offset;
        this.type = token.type;
        this.nextToken = token.nextToken;
    }

    public int documentToToken(int n) {
        return n + (this.textOffset - this.offset);
    }

    private static final String getHTMLFormatForColor(Color color) {
        String string;
        String string2;
        if (color == null) {
            return "black";
        }
        String string3 = Integer.toHexString(color.getRed());
        if (string3.length() == 1) {
            string3 = "0" + string3;
        }
        if ((string2 = Integer.toHexString(color.getGreen())).length() == 1) {
            string2 = "0" + string2;
        }
        if ((string = Integer.toHexString(color.getBlue())).length() == 1) {
            string = "0" + string;
        }
        return "#" + string3 + string2 + string;
    }

    public String getHTMLRepresentation(RSyntaxTextArea rSyntaxTextArea) {
        StringBuffer stringBuffer = new StringBuffer();
        this.appendHTMLRepresentation(stringBuffer, rSyntaxTextArea, true);
        return stringBuffer.toString();
    }

    public Token getLastNonCommentNonWhitespaceToken() {
        Token token = null;
        Token token2 = this;
        while (token2 != null && token2.isPaintable()) {
            switch (token2.type) {
                case 1: 
                case 2: 
                case 3: 
                case 16: {
                    break;
                }
                default: {
                    token = token2;
                }
            }
            token2 = token2.nextToken;
        }
        return token;
    }

    public Token getLastPaintableToken() {
        Token token = this;
        while (token.isPaintable()) {
            if (token.nextToken == null || !token.nextToken.isPaintable()) {
                return token;
            }
            token = token.nextToken;
        }
        return null;
    }

    public String getLexeme() {
        return new String(this.text, this.textOffset, this.textCount);
    }

    public abstract int getListOffset(RSyntaxTextArea var1, TabExpander var2, float var3, float var4);

    public Token getNextToken() {
        return this.nextToken;
    }

    public int getOffsetBeforeX(RSyntaxTextArea rSyntaxTextArea, TabExpander tabExpander, float f, float f2) {
        int n;
        FontMetrics fontMetrics = rSyntaxTextArea.getFontMetricsForTokenType(this.type);
        int n2 = n + this.textCount;
        float f3 = f;
        for (n = this.textOffset; n < n2; ++n) {
            f3 = this.text[n] == '\t' ? tabExpander.nextTabStop(f3, 0) : (f3 += (float)fontMetrics.charWidth(this.text[n]));
            if (!(f3 > f2)) continue;
            int n3 = Math.max(n - this.textOffset, 1);
            return this.offset + n3;
        }
        return this.offset + this.textCount - 1;
    }

    public float getWidth(RSyntaxTextArea rSyntaxTextArea, TabExpander tabExpander, float f) {
        return this.getWidthUpTo(this.textCount, rSyntaxTextArea, tabExpander, f);
    }

    public abstract float getWidthUpTo(int var1, RSyntaxTextArea var2, TabExpander var3, float var4);

    public boolean is(int n, String string) {
        return this.type == n && this.textCount == string.length() && string.equals(this.getLexeme());
    }

    public boolean isComment() {
        return this.type >= 1 && this.type <= 3;
    }

    public boolean isHyperlink() {
        return this.hyperlink;
    }

    public boolean isLeftCurly() {
        return this.type == 17 && this.isSingleChar('{');
    }

    public boolean isRightCurly() {
        return this.type == 17 && this.isSingleChar('}');
    }

    public boolean isPaintable() {
        return this.type > 0;
    }

    public boolean isSingleChar(char c) {
        return this.textCount == 1 && this.text[this.textOffset] == c;
    }

    public boolean isWhitespace() {
        return this.type == 16;
    }

    public abstract Rectangle listOffsetToView(RSyntaxTextArea var1, TabExpander var2, int var3, int var4, Rectangle var5);

    public void makeStartAt(int n) {
        if (n < this.offset || n >= this.offset + this.textCount) {
            throw new IllegalArgumentException("pos " + n + " is not in range " + this.offset + "-" + (this.offset + this.textCount - 1));
        }
        int n2 = n - this.offset;
        this.offset = n;
        this.textOffset += n2;
        this.textCount -= n2;
    }

    public void moveOffset(int n) {
        if (n < 0 || n > this.textCount) {
            throw new IllegalArgumentException("amt " + n + " is not in range 0-" + this.textCount);
        }
        this.offset += n;
        this.textOffset += n;
        this.textCount -= n;
    }

    public final float paint(Graphics2D graphics2D, float f, float f2, RSyntaxTextArea rSyntaxTextArea, TabExpander tabExpander) {
        return this.paint(graphics2D, f, f2, rSyntaxTextArea, tabExpander, 0.0f);
    }

    public abstract float paint(Graphics2D var1, float var2, float var3, RSyntaxTextArea var4, TabExpander var5, float var6);

    protected void paintBackground(float f, float f2, float f3, float f4, Graphics2D graphics2D, int n, RSyntaxTextArea rSyntaxTextArea, Color color) {
        Color color2 = rSyntaxTextArea.getBackground();
        graphics2D.setXORMode(color2 != null ? color2 : Color.WHITE);
        graphics2D.setColor(color);
        this.bgRect.setRect(f, f2 - (float)n, f3, f4);
        graphics2D.fill(this.bgRect);
        graphics2D.setPaintMode();
    }

    protected void paintTabLines(int n, int n2, int n3, Graphics2D graphics2D, TabExpander tabExpander, RSyntaxTextArea rSyntaxTextArea) {
        int n4;
        int n5;
        if (this.type != 16) {
            int n6;
            for (n6 = this.textOffset; n6 < this.textOffset + this.textCount && RSyntaxUtilities.isWhitespace(this.text[n6]); ++n6) {
            }
            n5 = n6 - this.textOffset;
            if (n5 < 2) {
                return;
            }
            n3 = (int)this.getWidthUpTo(n5, rSyntaxTextArea, tabExpander, 0.0f);
        }
        FontMetrics fontMetrics = rSyntaxTextArea.getFontMetricsForTokenType(this.type);
        n5 = rSyntaxTextArea.getTabSize();
        if (tabBuf == null || tabBuf.length < n5) {
            tabBuf = new char[n5];
            for (n4 = 0; n4 < n5; ++n4) {
                Token.tabBuf[n4] = 32;
            }
        }
        n4 = fontMetrics.charsWidth(tabBuf, 0, n5);
        graphics2D.setColor(rSyntaxTextArea.getTabLineColor());
        int n7 = n2 - fontMetrics.getAscent();
        for (int i = n + n4; i < n3; i += n4) {
            int n8 = n7 + rSyntaxTextArea.getLineHeight();
            for (int j = n7; j < n8; j += 2) {
                graphics2D.drawLine(i, j, i, j);
            }
        }
    }

    public void set(char[] cArray, int n, int n2, int n3, int n4) {
        this.text = cArray;
        this.textOffset = n;
        this.textCount = n2 - n + 1;
        this.type = n4;
        this.offset = n3;
        this.nextToken = null;
    }

    public void setHyperlink(boolean bl) {
        this.hyperlink = bl;
    }

    public void setNextToken(Token token) {
        this.nextToken = token;
    }

    public int tokenToDocument(int n) {
        return n + (this.offset - this.textOffset);
    }

    public String toString() {
        return "[Token: " + (this.type == 0 ? "<null token>" : "text: '" + (this.text == null ? "<null>" : this.getLexeme() + "'; " + "offset: " + this.offset + "; type: " + this.type + "; " + "isPaintable: " + this.isPaintable() + "; nextToken==null: " + (this.nextToken == null))) + "]";
    }
}

