/*
 * Decompiled with CFR 0.152.
 */
package se.marell.libusb;

import com.sun.jna.Pointer;
import se.marell.libusb.LibUsbBusyException;
import se.marell.libusb.LibUsbInvalidParameterException;
import se.marell.libusb.LibUsbNoDeviceException;
import se.marell.libusb.LibUsbNotFoundException;
import se.marell.libusb.LibUsbOtherException;
import se.marell.libusb.LibUsbOverflowException;
import se.marell.libusb.LibUsbPermissionException;
import se.marell.libusb.LibUsbPipeException;
import se.marell.libusb.LibUsbTimeoutException;
import se.marell.libusb.LibUsbTransmissionException;
import se.marell.libusb.jna.LibUsb;
import se.marell.libusb.jna.libusb_device_descriptor;

public class UsbDevice {
    private Pointer usb_device;
    private Pointer dev_handle;
    private LibUsb usb;
    private libusb_device_descriptor descriptor;

    public UsbDevice(LibUsb usb, Pointer usb_device) throws LibUsbNoDeviceException, LibUsbPermissionException, LibUsbOtherException {
        this.usb = usb;
        this.usb_device = usb_device;
        this.descriptor = this.get_descriptor();
    }

    public Pointer get_usb_device() {
        return this.usb_device;
    }

    public Pointer get_dev_handle() {
        return this.dev_handle;
    }

    public int get_bus_number() {
        return this.usb.libusb_get_bus_number(this.usb_device);
    }

    public int get_address() {
        return this.usb.libusb_get_device_address(this.usb_device);
    }

    public int get_max_iso_packet_size(int endpoint) throws LibUsbNotFoundException, LibUsbOtherException {
        int rc = this.usb.libusb_get_max_iso_packet_size(this.usb_device, endpoint);
        if (rc < 0) {
            switch (rc) {
                case -5: {
                    throw new LibUsbNotFoundException();
                }
            }
            throw new LibUsbOtherException(rc);
        }
        return rc;
    }

    public void ref_device() {
        this.usb.libusb_ref_device(this.usb_device);
    }

    public void unref_device() {
        this.usb.libusb_unref_device(this.usb_device);
    }

    public void open() throws LibUsbNoDeviceException, LibUsbPermissionException, LibUsbOtherException {
        this.close();
        Pointer[] arr = new Pointer[1];
        int rc = this.usb.libusb_open(this.usb_device, arr);
        if (rc < 0) {
            switch (rc) {
                case -3: {
                    throw new LibUsbPermissionException();
                }
                case -4: {
                    throw new LibUsbNoDeviceException();
                }
            }
            throw new LibUsbOtherException(rc);
        }
        this.dev_handle = arr[0];
    }

    public void close() {
        if (this.dev_handle != null) {
            this.usb.libusb_close(this.dev_handle);
            this.dev_handle = null;
        }
    }

    public short getBcdUSB() {
        return this.descriptor.bcdDevice;
    }

    public byte getBDeviceClass() {
        return this.descriptor.bDeviceClass;
    }

    public byte getBDeviceSubClass() {
        return this.descriptor.bDeviceSubClass;
    }

    public byte getBDeviceProtocol() {
        return this.descriptor.bDeviceProtocol;
    }

    public byte getBMaxPacketSize0() {
        return this.descriptor.bMaxPacketSize0;
    }

    public short getIdVendor() {
        return this.descriptor.idVendor;
    }

    public short getIdProduct() {
        return this.descriptor.idProduct;
    }

    public short getBcdDevice() {
        return this.descriptor.bcdDevice;
    }

    public String getManufacturer() {
        return this.get_string_ascii(this.descriptor.iManufacturer);
    }

    public String getProduct() {
        return this.get_string_ascii(this.descriptor.iProduct);
    }

    public String getSerialNumber() {
        return this.get_string_ascii(this.descriptor.iSerialNumber);
    }

    public byte getBNumConfigurations() {
        return this.descriptor.bNumConfigurations;
    }

    private libusb_device_descriptor get_descriptor() throws LibUsbNoDeviceException, LibUsbPermissionException, LibUsbOtherException {
        libusb_device_descriptor[] arr = new libusb_device_descriptor[1];
        int rc = this.usb.libusb_get_device_descriptor(this.usb_device, arr);
        if (rc < 0) {
            switch (rc) {
                case -3: {
                    throw new LibUsbPermissionException();
                }
                case -4: {
                    throw new LibUsbNoDeviceException();
                }
            }
            throw new LibUsbOtherException(rc);
        }
        return arr[0];
    }

    public String get_string_ascii(byte desc_index) {
        byte[] data = new byte[256];
        this.usb.libusb_get_string_descriptor_ascii(this.dev_handle, desc_index, data, data.length);
        int len = 0;
        while (data[len] != 0) {
            ++len;
        }
        return new String(data, 0, len);
    }

    public int get_configuration() throws LibUsbNoDeviceException, LibUsbPermissionException, LibUsbOtherException {
        int[] arr = new int[1];
        int rc = this.usb.libusb_get_configuration(this.dev_handle, arr);
        if (rc < 0) {
            switch (rc) {
                case -3: {
                    throw new LibUsbPermissionException();
                }
                case -4: {
                    throw new LibUsbNoDeviceException();
                }
            }
            throw new LibUsbOtherException(rc);
        }
        return arr[0];
    }

    public void set_configuration(int configuration) throws LibUsbNotFoundException, LibUsbBusyException, LibUsbNoDeviceException, LibUsbOtherException {
        int rc = this.usb.libusb_set_configuration(this.dev_handle, configuration);
        if (rc < 0) {
            switch (rc) {
                case -5: {
                    throw new LibUsbNotFoundException("configuration=" + configuration);
                }
                case -6: {
                    throw new LibUsbBusyException();
                }
                case -4: {
                    throw new LibUsbNoDeviceException();
                }
            }
            throw new LibUsbOtherException(rc);
        }
    }

    public void claim_interface(int interface_number) throws LibUsbNotFoundException, LibUsbBusyException, LibUsbNoDeviceException, LibUsbOtherException {
        int rc = this.usb.libusb_claim_interface(this.dev_handle, interface_number);
        if (rc < 0) {
            switch (rc) {
                case -5: {
                    throw new LibUsbNotFoundException();
                }
                case -6: {
                    throw new LibUsbBusyException();
                }
                case -4: {
                    throw new LibUsbNoDeviceException();
                }
            }
            throw new LibUsbOtherException(rc);
        }
    }

    public void release_interface(int interface_number) throws LibUsbNotFoundException, LibUsbBusyException, LibUsbNoDeviceException, LibUsbOtherException {
        int rc = this.usb.libusb_release_interface(this.dev_handle, interface_number);
        if (rc < 0) {
            switch (rc) {
                case -5: {
                    throw new LibUsbNotFoundException("interface_number=" + interface_number);
                }
                case -6: {
                    throw new LibUsbBusyException();
                }
                case -4: {
                    throw new LibUsbNoDeviceException();
                }
            }
            throw new LibUsbOtherException(rc);
        }
    }

    public void set_interface_alt_setting(int interface_number, int alternate_setting) throws LibUsbNotFoundException, LibUsbNoDeviceException, LibUsbOtherException {
        int rc = this.usb.libusb_set_interface_alt_setting(this.dev_handle, interface_number, alternate_setting);
        if (rc < 0) {
            switch (rc) {
                case -5: {
                    throw new LibUsbNotFoundException("interface_number=" + interface_number + ",alternate_setting=" + alternate_setting);
                }
                case -4: {
                    throw new LibUsbNoDeviceException();
                }
            }
            throw new LibUsbOtherException(rc);
        }
    }

    public void clear_halt(byte endpoint) throws LibUsbNotFoundException, LibUsbNoDeviceException, LibUsbOtherException {
        int rc = this.usb.libusb_clear_halt(this.dev_handle, endpoint);
        if (rc < 0) {
            switch (rc) {
                case -5: {
                    throw new LibUsbNotFoundException("endpoint=" + endpoint);
                }
                case -4: {
                    throw new LibUsbNoDeviceException();
                }
            }
            throw new LibUsbOtherException(rc);
        }
    }

    public void reset_device() throws LibUsbNotFoundException, LibUsbOtherException {
        int rc = this.usb.libusb_reset_device(this.dev_handle);
        if (rc < 0) {
            switch (rc) {
                case -5: {
                    throw new LibUsbNotFoundException();
                }
            }
            throw new LibUsbOtherException(rc);
        }
    }

    public boolean kernel_driver_active(int interface_number) throws LibUsbNoDeviceException, LibUsbOtherException {
        int rc = this.usb.libusb_kernel_driver_active(this.dev_handle, interface_number);
        if (rc < 0) {
            switch (rc) {
                case -4: {
                    throw new LibUsbNoDeviceException();
                }
            }
            throw new LibUsbOtherException(rc);
        }
        return rc == 1;
    }

    public void detach_kernel_driver(int interface_number) throws LibUsbInvalidParameterException, LibUsbNotFoundException, LibUsbNoDeviceException, LibUsbOtherException {
        int rc = this.usb.libusb_detach_kernel_driver(this.dev_handle, interface_number);
        if (rc < 0) {
            switch (rc) {
                case -2: {
                    throw new LibUsbInvalidParameterException("interface_number=" + interface_number);
                }
                case -5: {
                    throw new LibUsbNotFoundException();
                }
                case -4: {
                    throw new LibUsbNoDeviceException();
                }
            }
            throw new LibUsbOtherException(rc);
        }
    }

    public void attach_kernel_driver(int interface_number) throws LibUsbInvalidParameterException, LibUsbNotFoundException, LibUsbBusyException, LibUsbNoDeviceException, LibUsbOtherException {
        int rc = this.usb.libusb_attach_kernel_driver(this.dev_handle, interface_number);
        if (rc < 0) {
            switch (rc) {
                case -2: {
                    throw new LibUsbInvalidParameterException("interface_number=" + interface_number);
                }
                case -5: {
                    throw new LibUsbNotFoundException();
                }
                case -6: {
                    throw new LibUsbBusyException();
                }
                case -4: {
                    throw new LibUsbNoDeviceException();
                }
            }
            throw new LibUsbOtherException(rc);
        }
    }

    public void control_write(byte bmRequestType, byte bRequest, short wValue, short wIndex, byte[] data, short wLength, int timeout) throws LibUsbTimeoutException, LibUsbPipeException, LibUsbNoDeviceException, LibUsbTransmissionException, LibUsbOtherException {
        int rc = this.usb.libusb_control_transfer(this.dev_handle, bmRequestType, bRequest, wValue, wIndex, data, (short)data.length, timeout);
        if (rc < 0) {
            switch (rc) {
                case -7: {
                    throw new LibUsbTimeoutException();
                }
                case -9: {
                    throw new LibUsbPipeException();
                }
                case -4: {
                    throw new LibUsbNoDeviceException();
                }
            }
            throw new LibUsbOtherException(rc);
        }
        if (rc != data.length) {
            throw new LibUsbTransmissionException("Transferred " + rc + " bytes of " + data.length);
        }
    }

    public int control_read(byte bmRequestType, byte bRequest, short wValue, short wIndex, byte[] data, short wLength, int timeout) throws LibUsbTimeoutException, LibUsbPipeException, LibUsbNoDeviceException, LibUsbOtherException {
        int rc = this.usb.libusb_control_transfer(this.dev_handle, bmRequestType, bRequest, wValue, wIndex, data, (short)data.length, timeout);
        if (rc < 0) {
            switch (rc) {
                case -7: {
                    throw new LibUsbTimeoutException();
                }
                case -9: {
                    throw new LibUsbPipeException();
                }
                case -4: {
                    throw new LibUsbNoDeviceException();
                }
            }
            throw new LibUsbOtherException(rc);
        }
        return rc;
    }

    public void bulk_write(int endpoint, byte[] data, int timeout) throws LibUsbTimeoutException, LibUsbPipeException, LibUsbNoDeviceException, LibUsbTransmissionException, LibUsbOtherException {
        int[] transferred = new int[1];
        int rc = this.usb.libusb_bulk_transfer(this.dev_handle, (byte)endpoint, data, data.length, transferred, timeout);
        if (transferred[0] != data.length) {
            throw new LibUsbTransmissionException("Transferred " + transferred[0] + " bytes of " + data.length);
        }
        if (rc < 0) {
            switch (rc) {
                case -7: {
                    throw new LibUsbTimeoutException(transferred[0]);
                }
                case -9: {
                    throw new LibUsbPipeException();
                }
                case -4: {
                    throw new LibUsbNoDeviceException();
                }
            }
            throw new LibUsbOtherException(rc);
        }
    }

    public int bulk_read(int endpoint, byte[] data, int timeout) throws LibUsbTimeoutException, LibUsbPipeException, LibUsbOverflowException, LibUsbNoDeviceException, LibUsbOtherException {
        int[] transferred = new int[1];
        int rc = this.usb.libusb_bulk_transfer(this.dev_handle, (byte)endpoint, data, data.length, transferred, timeout);
        if (rc < 0) {
            switch (rc) {
                case -7: {
                    throw new LibUsbTimeoutException(transferred[0]);
                }
                case -9: {
                    throw new LibUsbPipeException();
                }
                case -8: {
                    throw new LibUsbOverflowException();
                }
                case -4: {
                    throw new LibUsbNoDeviceException();
                }
            }
            throw new LibUsbOtherException(rc);
        }
        return transferred[0];
    }

    public void interrupt_write(int endpoint, byte[] data, int timeout) throws LibUsbTimeoutException, LibUsbPipeException, LibUsbNoDeviceException, LibUsbTransmissionException, LibUsbOtherException {
        int[] transferred = new int[1];
        int rc = this.usb.libusb_interrupt_transfer(this.dev_handle, (byte)endpoint, data, data.length, transferred, timeout);
        if (transferred[0] != data.length) {
            throw new LibUsbTransmissionException("Transferred " + transferred[0] + " bytes of " + data.length);
        }
        if (rc < 0) {
            switch (rc) {
                case -7: {
                    throw new LibUsbTimeoutException();
                }
                case -9: {
                    throw new LibUsbPipeException();
                }
                case -4: {
                    throw new LibUsbNoDeviceException();
                }
            }
            throw new LibUsbOtherException(rc);
        }
    }

    public int interrupt_read(int endpoint, byte[] data, int timeout) throws LibUsbTimeoutException, LibUsbPipeException, LibUsbOverflowException, LibUsbNoDeviceException, LibUsbOtherException {
        int[] transferred = new int[1];
        int rc = this.usb.libusb_interrupt_transfer(this.dev_handle, (byte)endpoint, data, data.length, transferred, timeout);
        if (rc < 0) {
            switch (rc) {
                case -7: {
                    throw new LibUsbTimeoutException(transferred[0]);
                }
                case -9: {
                    throw new LibUsbPipeException();
                }
                case -8: {
                    throw new LibUsbOverflowException();
                }
                case -4: {
                    throw new LibUsbNoDeviceException();
                }
            }
            throw new LibUsbOtherException(rc);
        }
        return transferred[0];
    }

    public String toString() {
        return "UsbDevice { bus_number=" + this.get_bus_number() + " address=" + this.get_address() + "}";
    }
}

