/*
 * Decompiled with CFR 0.152.
 */
package se.marell.libusb;

import com.sun.jna.Pointer;
import java.util.ArrayList;
import java.util.List;
import se.marell.libusb.LibUsbNoDeviceException;
import se.marell.libusb.LibUsbOtherException;
import se.marell.libusb.LibUsbPermissionException;
import se.marell.libusb.UsbDevice;
import se.marell.libusb.UsbSystem;
import se.marell.libusb.jna.LibUsb;

public class LibUsbSystem
implements UsbSystem {
    private Pointer context;
    private LibUsb usb = LibUsb.libUsb;

    public LibUsbSystem(boolean setContext) {
        if (setContext) {
            Pointer[] p = new Pointer[1];
            this.usb.libusb_init(p);
            this.context = p[0];
        } else {
            this.usb.libusb_init(null);
        }
    }

    public LibUsbSystem(boolean setContext, int debugLevel) {
        this(setContext);
        this.usb.libusb_set_debug(this.context, debugLevel);
    }

    @Override
    public List<UsbDevice> visitUsbDevices(UsbSystem.UsbDeviceVisitor visitor) throws LibUsbNoDeviceException, LibUsbPermissionException, LibUsbOtherException {
        Pointer[] parr;
        Pointer[] pa = new Pointer[1];
        int rc = this.usb.libusb_get_device_list(this.context, pa);
        if (rc <= 0) {
            switch (rc) {
                case -11: {
                    throw new OutOfMemoryError("ERROR_NO_MEM when calling libusb_get_device_list");
                }
            }
            throw new LibUsbOtherException(rc);
        }
        Pointer device_list = pa[0];
        ArrayList<UsbDevice> devices = new ArrayList<UsbDevice>();
        Pointer[] pointerArray = parr = device_list.getPointerArray(0L);
        int n = parr.length;
        int n2 = 0;
        while (n2 < n) {
            Pointer usb_device = pointerArray[n2];
            devices.add(new UsbDevice(this.usb, usb_device));
            ++n2;
        }
        List<UsbDevice> targetDevices = visitor.visitDevices(devices);
        for (UsbDevice d : devices) {
            if (targetDevices.contains(d)) continue;
            this.usb.libusb_unref_device(d.get_usb_device());
        }
        this.usb.libusb_free_device_list(this.context, device_list, 0);
        return targetDevices;
    }

    @Override
    public void cleanup() {
        this.usb.libusb_exit(this.context);
    }

    @Override
    public LibUsb getLibUsb() {
        return this.usb;
    }
}

