/*
 * Decompiled with CFR 0.152.
 */
package org.plugins.generic.newunlock;

import com.jgoodies.forms.factories.FormFactory;
import com.jgoodies.forms.layout.ColumnSpec;
import com.jgoodies.forms.layout.FormLayout;
import com.jgoodies.forms.layout.RowSpec;
import foxtrot.Job;
import foxtrot.Worker;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Desktop;
import java.awt.Dialog;
import java.awt.FlowLayout;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.net.URI;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.border.EmptyBorder;
import org.adb.FastbootUtility;
import org.logger.MyLogger;
import org.system.RunOutputs;

public class UnlockWizard
extends JDialog {
    private final JPanel contentPanel = new JPanel();
    private JTextField textIMEI;
    private JTextField textULCODE;
    private JButton btnUnlock;
    private JButton btnGetULCode;
    private boolean unlocked = false;

    public UnlockWizard(String imei, String ulcode) {
        this.setModalityType(Dialog.ModalityType.APPLICATION_MODAL);
        this.setResizable(false);
        this.setTitle("Bootloader Unlock Wizard");
        this.setBounds(100, 100, 372, 253);
        this.getContentPane().setLayout(new BorderLayout());
        this.contentPanel.setBorder(new EmptyBorder(5, 5, 5, 5));
        this.getContentPane().add((Component)this.contentPanel, "Center");
        this.contentPanel.setLayout((LayoutManager)new FormLayout(new ColumnSpec[]{FormFactory.RELATED_GAP_COLSPEC, FormFactory.DEFAULT_COLSPEC, FormFactory.RELATED_GAP_COLSPEC, ColumnSpec.decode((String)"max(34dlu;default)"), FormFactory.RELATED_GAP_COLSPEC, ColumnSpec.decode((String)"max(50dlu;default)"), FormFactory.RELATED_GAP_COLSPEC, ColumnSpec.decode((String)"max(44dlu;default)"), FormFactory.RELATED_GAP_COLSPEC, ColumnSpec.decode((String)"default:grow")}, new RowSpec[]{FormFactory.RELATED_GAP_ROWSPEC, FormFactory.DEFAULT_ROWSPEC, FormFactory.RELATED_GAP_ROWSPEC, FormFactory.DEFAULT_ROWSPEC, FormFactory.RELATED_GAP_ROWSPEC, FormFactory.DEFAULT_ROWSPEC, FormFactory.RELATED_GAP_ROWSPEC, FormFactory.DEFAULT_ROWSPEC, FormFactory.RELATED_GAP_ROWSPEC, FormFactory.DEFAULT_ROWSPEC, FormFactory.RELATED_GAP_ROWSPEC, FormFactory.DEFAULT_ROWSPEC, FormFactory.RELATED_GAP_ROWSPEC, FormFactory.DEFAULT_ROWSPEC, FormFactory.RELATED_GAP_ROWSPEC, FormFactory.DEFAULT_ROWSPEC}));
        JLabel lblNewLabel = new JLabel("IMEI :");
        this.contentPanel.add((Component)lblNewLabel, "2, 4, right, bottom");
        this.textIMEI = new JTextField();
        this.textIMEI.setEditable(false);
        this.contentPanel.add((Component)this.textIMEI, "4, 4, 5, 1, fill, default");
        this.textIMEI.setColumns(10);
        JLabel lblNewLabel_1 = new JLabel("Unlock Code :");
        this.contentPanel.add((Component)lblNewLabel_1, "2, 6, right, default");
        this.textULCODE = new JTextField();
        this.textULCODE.addKeyListener(new KeyAdapter(){

            @Override
            public void keyReleased(KeyEvent arg0) {
                if (UnlockWizard.this.textULCODE.getText().length() == 0) {
                    UnlockWizard.this.btnUnlock.setEnabled(false);
                } else if (UnlockWizard.this.unlocked) {
                    UnlockWizard.this.btnUnlock.setEnabled(false);
                } else {
                    UnlockWizard.this.btnUnlock.setEnabled(true);
                }
            }
        });
        this.contentPanel.add((Component)this.textULCODE, "4, 6, 5, 1, fill, default");
        this.textULCODE.setColumns(10);
        this.btnGetULCode = new JButton("Get Unlock Code");
        this.btnGetULCode.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                UnlockWizard.this.showInBrowser("http://unlockbootloader.sonymobile.com/unlock/step1");
            }
        });
        this.contentPanel.add((Component)this.btnGetULCode, "6, 10");
        JPanel buttonPane = new JPanel();
        buttonPane.setLayout(new FlowLayout(2));
        this.getContentPane().add((Component)buttonPane, "South");
        JButton cancelButton = new JButton("Close");
        cancelButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                UnlockWizard.this.dispose();
            }
        });
        cancelButton.setActionCommand("Cancel");
        buttonPane.add(cancelButton);
        this.textIMEI.setText(imei);
        this.textULCODE.setText(ulcode);
        this.btnUnlock = new JButton("Unlock");
        this.btnUnlock.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                Worker.post((Job)new Job(){

                    public Object run() {
                        try {
                            if (FastbootUtility.getDevices().hasMoreElements()) {
                                RunOutputs out = FastbootUtility.unlock((String)UnlockWizard.this.textULCODE.getText());
                                MyLogger.getLogger().info((Object)"Device will reboot into system now");
                                FastbootUtility.rebootDevice();
                            } else {
                                MyLogger.getLogger().error((Object)"Your device must be in fastboot mode");
                                MyLogger.getLogger().error((Object)"Please restart it in fastboot mode");
                            }
                        }
                        catch (Exception e) {
                            MyLogger.getLogger().error((Object)e.getMessage());
                        }
                        return null;
                    }
                });
            }
        });
        this.contentPanel.add((Component)this.btnUnlock, "6, 12");
    }

    @Override
    public void setVisible(boolean visible) {
        if (this.textULCODE.getText().length() == 0) {
            this.unlocked = false;
            this.btnUnlock.setEnabled(false);
        } else {
            this.unlocked = true;
            this.textULCODE.setEditable(false);
            this.btnGetULCode.setEnabled(false);
            this.btnUnlock.setEnabled(false);
        }
        super.setVisible(visible);
    }

    private boolean showInBrowser(String url) {
        try {
            this.textULCODE.setText("");
            Desktop.getDesktop().browse(new URI(url));
        }
        catch (Exception exception) {
            // empty catch block
        }
        return true;
    }
}

