/*
 * Decompiled with CFR 0.152.
 */
package org.fife.ui.rsyntaxtextarea.folding;

import java.util.HashMap;
import java.util.Map;
import org.fife.ui.rsyntaxtextarea.SyntaxConstants;
import org.fife.ui.rsyntaxtextarea.folding.CurlyFoldParser;
import org.fife.ui.rsyntaxtextarea.folding.FoldParser;
import org.fife.ui.rsyntaxtextarea.folding.LatexFoldParser;
import org.fife.ui.rsyntaxtextarea.folding.LispFoldParser;
import org.fife.ui.rsyntaxtextarea.folding.XmlFoldParser;

public class FoldParserManager
implements SyntaxConstants {
    private Map foldParserMap = this.createFoldParserMap();
    private static final FoldParserManager INSTANCE = new FoldParserManager();

    private FoldParserManager() {
    }

    public void addFoldParserMapping(String string, FoldParser foldParser) {
        this.foldParserMap.put(string, foldParser);
    }

    private Map createFoldParserMap() {
        HashMap<String, FoldParser> hashMap = new HashMap<String, FoldParser>();
        hashMap.put("text/c", new CurlyFoldParser());
        hashMap.put("text/cpp", new CurlyFoldParser());
        hashMap.put("text/cs", new CurlyFoldParser());
        hashMap.put("text/clojure", new LispFoldParser());
        hashMap.put("text/css", new CurlyFoldParser());
        hashMap.put("text/groovy", new CurlyFoldParser());
        hashMap.put("text/java", new CurlyFoldParser(true, true));
        hashMap.put("text/javascript", new CurlyFoldParser());
        hashMap.put("text/latex", new LatexFoldParser());
        hashMap.put("text/lisp", new LispFoldParser());
        hashMap.put("text/mxml", new XmlFoldParser());
        hashMap.put("text/perl", new CurlyFoldParser());
        hashMap.put("text/xml", new XmlFoldParser());
        return hashMap;
    }

    public static FoldParserManager get() {
        return INSTANCE;
    }

    public FoldParser getFoldParser(String string) {
        return (FoldParser)this.foldParserMap.get(string);
    }
}

