/*
 * Decompiled with CFR 0.152.
 */
package at.HexLib.library;

import at.HexLib.library.HexLib;
import at.HexLib.library.HexTransfer;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.io.IOException;

public class HexTransferable
implements Transferable {
    protected static DataFlavor hexFlavor = new DataFlavor(HexTransferable.class, "Java HexLib Object");
    protected static DataFlavor[] supportedFlavors = new DataFlavor[]{hexFlavor, DataFlavor.plainTextFlavor, DataFlavor.getTextPlainUnicodeFlavor()};
    byte[] buffer;
    private HexTransfer.copyStringAction copyAction;

    public HexTransferable(byte[] buffer, HexTransfer.copyStringAction copyAction) {
        this.buffer = buffer;
        this.copyAction = copyAction;
    }

    @Override
    public DataFlavor[] getTransferDataFlavors() {
        return supportedFlavors;
    }

    @Override
    public boolean isDataFlavorSupported(DataFlavor flavor) {
        DataFlavor[] dataFlavorArray = supportedFlavors;
        int n = supportedFlavors.length;
        int n2 = 0;
        while (n2 < n) {
            DataFlavor curFlavor = dataFlavorArray[n2];
            if (flavor.equals(curFlavor)) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    @Override
    public Object getTransferData(DataFlavor flavor) throws UnsupportedFlavorException, IOException {
        if (flavor.equals(hexFlavor)) {
            return this.buffer;
        }
        if (flavor.equals(DataFlavor.stringFlavor)) {
            return this.getStringRepresentationOfContent();
        }
        if (flavor.equals(DataFlavor.plainTextFlavor) || flavor.equals(DataFlavor.getTextPlainUnicodeFlavor())) {
            return this.getStringRepresentationOfContent();
        }
        throw new UnsupportedFlavorException(flavor);
    }

    public Object getStringRepresentationOfContent() {
        StringBuilder selectionContent = new StringBuilder();
        byte[] byArray = this.buffer;
        int n = this.buffer.length;
        int n2 = 0;
        while (n2 < n) {
            byte curByte = byArray[n2];
            if (this.copyAction == HexTransfer.copyStringAction.BINARY) {
                if (curByte < 0) {
                    selectionContent.append((char)(256 + curByte));
                } else {
                    selectionContent.append((char)curByte);
                }
            } else if (this.copyAction == HexTransfer.copyStringAction.BINARY_AS_STRING) {
                selectionContent.append(HexLib.convertToHex(curByte, 2));
            }
            ++n2;
        }
        return selectionContent.toString();
    }
}

