/*
 * Decompiled with CFR 0.152.
 */
package at.HexLib.library;

import at.HexLib.library.HexLib;
import at.HexLib.library.HexTransferable;
import java.awt.Point;
import java.awt.Toolkit;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.TreeSet;
import java.util.concurrent.Executors;
import javax.swing.SwingUtilities;

public class HexTransfer {
    Clipboard clipboard = Toolkit.getDefaultToolkit().getSystemClipboard();
    private HexLib he;
    private copyStringAction copyAction = copyStringAction.BINARY_AS_STRING;
    private insertActions insertAction = insertActions.INSERTandDELETE_SELECTION;
    private boolean inActionDelete;

    public HexTransfer(HexLib he) {
        this.he = he;
    }

    void copyContent2Clipboard() {
        ArrayList<Point> listMarks = this.he.getSelectionModel().getSelectionList();
        if (listMarks == null || listMarks.size() == 0) {
            return;
        }
        TreeSet<Integer> selPoints = new TreeSet<Integer>();
        for (Point curSelection : listMarks) {
            int startSel = curSelection.x;
            while (startSel <= curSelection.y) {
                selPoints.add(startSel);
                ++startSel;
            }
        }
        byte[] copyBytes = new byte[selPoints.size()];
        int count = 0;
        for (Integer curPos : selPoints) {
            copyBytes[count++] = this.he.buff[curPos];
        }
        HexTransferable copy2ClipBoard = new HexTransferable(copyBytes, this.getCopyAction());
        this.clipboard.setContents(copy2ClipBoard, this.he);
    }

    synchronized void pasteContentFromClipboard() {
        Transferable clipData = this.clipboard.getContents(this.clipboard);
        if (clipData != null) {
            try {
                if (this.he.getSelectionModel().getSelectionList().size() > 1) {
                    Toolkit.getDefaultToolkit().beep();
                } else if (clipData.isDataFlavorSupported(HexTransferable.hexFlavor)) {
                    byte[] mu = (byte[])clipData.getTransferData(HexTransferable.hexFlavor);
                    this.insertContent(mu);
                } else if (clipData.isDataFlavorSupported(DataFlavor.stringFlavor)) {
                    String s = (String)clipData.getTransferData(DataFlavor.stringFlavor);
                    this.insertContent(s.getBytes());
                } else {
                    Toolkit.getDefaultToolkit().beep();
                }
            }
            catch (Exception e) {
                System.err.println("Problems getting data:" + e);
            }
        }
    }

    private void insertContent(byte[] content) {
        if (content != null && content.length >= 0) {
            if (this.getInsertAction() == insertActions.OVERWRITE) {
                int cursorPos = this.he.getCursorPosition();
                int end = Math.min(cursorPos + content.length, this.he.buff.length);
                System.arraycopy(content, 0, this.he.buff, cursorPos, end - cursorPos);
                this.he.reCalcHashCode();
                this.he.repaint();
            } else if (this.getInsertAction() == insertActions.INSERTandDELETE_SELECTION) {
                int cursorPos = this.he.getCursorPosition();
                ArrayList<Point> sel = this.he.getSelectionModel().getSelectionList();
                int delBytes = 0;
                if (sel.size() == 1) {
                    delBytes = Math.abs(sel.get((int)0).x - sel.get((int)0).y) + 1;
                }
                byte[] destArray = new byte[this.he.buff.length + content.length - delBytes];
                System.arraycopy(this.he.buff, 0, destArray, 0, cursorPos);
                System.arraycopy(content, 0, destArray, cursorPos, content.length);
                System.arraycopy(this.he.buff, cursorPos + delBytes, destArray, cursorPos + content.length, this.he.buff.length - cursorPos - delBytes);
                int muStart = this.he.getStart();
                this.he.setByteContent(destArray);
                this.he.setCursorPostion(cursorPos);
                this.he.setStart(muStart);
                this.he.scrlRight.setValue(muStart);
            }
        }
    }

    void deleteChars() {
        if (this.inActionDelete) {
            return;
        }
        this.inActionDelete = true;
        Executors.newCachedThreadPool().execute(new Runnable(){

            @Override
            public void run() {
                final int cursorPos = HexTransfer.this.he.getCursorPosition();
                ArrayList<Point> listMarks = HexTransfer.this.he.getSelectionModel().getSelectionList();
                ArrayList<Integer> selPoints = new ArrayList<Integer>();
                for (Point curSelection : listMarks) {
                    int startSel = curSelection.x;
                    while (startSel <= curSelection.y) {
                        if (!selPoints.contains(startSel)) {
                            selPoints.add(startSel);
                        }
                        ++startSel;
                    }
                }
                if (!selPoints.contains(cursorPos)) {
                    selPoints.add(cursorPos);
                }
                Collections.sort(selPoints);
                final byte[] destArray = new byte[((HexTransfer)HexTransfer.this).he.buff.length - selPoints.size()];
                int destByte = 0;
                int destBytePos = 0;
                for (Integer curRemPos : selPoints) {
                    System.arraycopy(((HexTransfer)HexTransfer.this).he.buff, destByte, destArray, destBytePos, curRemPos - destByte);
                    destBytePos += curRemPos - destByte;
                    destByte = curRemPos + 1;
                }
                System.arraycopy(((HexTransfer)HexTransfer.this).he.buff, destByte, destArray, destBytePos, ((HexTransfer)HexTransfer.this).he.buff.length - destByte);
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        int muStart = HexTransfer.this.he.getStart();
                        HexTransfer.this.he.setByteContent(destArray);
                        HexTransfer.this.he.setCursorPostion(cursorPos);
                        HexTransfer.this.he.setStart(muStart);
                        ((HexTransfer)(this).HexTransfer.this).he.scrlRight.setValue(muStart);
                        HexTransfer.this.inActionDelete = false;
                    }
                });
            }
        });
    }

    public insertActions getInsertAction() {
        return this.insertAction;
    }

    public void setInsertAction(insertActions insertAction) {
        this.insertAction = insertAction;
    }

    public copyStringAction getCopyAction() {
        return this.copyAction;
    }

    public void setCopyAction(copyStringAction copyAction) {
        this.copyAction = copyAction;
    }

    public void cutContent2Clipboard() {
        this.copyContent2Clipboard();
        this.deleteChars();
    }

    public static enum copyStringAction {
        BINARY,
        BINARY_AS_STRING;

    }

    public static enum insertActions {
        OVERWRITE,
        INSERTandDELETE_SELECTION;

    }
}

