/*
 * Decompiled with CFR 0.152.
 */
package at.HexLib.library;

import at.HexLib.library.HexLib;
import java.awt.Point;
import java.util.ArrayList;
import java.util.concurrent.CopyOnWriteArrayList;

public class HexLibSelectionModel {
    protected CopyOnWriteArrayList<Point> selectionPoints = new CopyOnWriteArrayList();
    Point markPositions = new Point(-1, -1);
    public final int SINGLE_INTERVAL_SELECTION = 1;
    public final int MULTIPLE_INTERVAL_SELECTION = 2;
    private int selectionMode = 2;
    private HexLib hexEditor;

    public void setSelectionMode(int selectionMode) {
        this.selectionMode = selectionMode;
    }

    public int getSelectionMode() {
        return this.selectionMode;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void addNewEndPoint(int calcCursorPos) {
        Point point = this.markPositions;
        synchronized (point) {
            if (calcCursorPos < 0) {
                calcCursorPos = 0;
            } else if (calcCursorPos >= this.hexEditor.buff.length) {
                calcCursorPos = this.hexEditor.buff.length - 1;
            }
            this.markPositions.y = calcCursorPos;
            if (this.selectionMode == 1) {
                this.selectionPoints.clear();
            }
            if (this.markPositions.x >= 0 && this.selectionPoints.size() > 0) {
                this.selectionPoints.remove(this.selectionPoints.size() - 1);
            }
            this.selectionPoints.addIfAbsent(this.markPositions);
        }
    }

    public void clear() {
        this.selectionPoints.clear();
        this.markPositions = new Point(-1, -1);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void addNewStartPoint(int pointYPressed) {
        Point point = this.markPositions;
        synchronized (point) {
            this.markPositions = new Point(-1, -1);
            this.markPositions.x = pointYPressed;
            this.markPositions.y = pointYPressed;
        }
    }

    int getStartPoint() {
        return this.markPositions.x;
    }

    int getEndPoint() {
        return this.markPositions.y;
    }

    void addStartAndEndPoint(int cursorPosition, int pointYPressed) {
        this.addNewStartPoint(cursorPosition);
        this.selectionPoints.addIfAbsent(this.markPositions);
        this.addNewEndPoint(pointYPressed);
    }

    boolean isPositionWithinMarkPos(int pos2Check) {
        boolean result = false;
        for (Point point2Check : this.selectionPoints) {
            if (point2Check.x < point2Check.y) {
                result = point2Check.x <= pos2Check && pos2Check <= point2Check.y;
            } else if (point2Check.y < point2Check.x) {
                result = point2Check.y <= pos2Check && pos2Check <= point2Check.x;
            } else {
                boolean bl = result = pos2Check == point2Check.x;
            }
            if (result) break;
        }
        return result;
    }

    public void dispose() {
        this.selectionPoints.clear();
    }

    public void setSelectionIntervals(ArrayList<Point> listMark) {
        this.selectionPoints.clear();
        for (Point curPoint : listMark) {
            this.selectionPoints.add(curPoint);
        }
        this.hexEditor.repaint();
    }

    void setUpdatePainter(HexLib hexEditor) {
        this.hexEditor = hexEditor;
    }

    public ArrayList<Point> getSelectionList() {
        ArrayList<Point> retList = new ArrayList<Point>();
        for (Point curPoint : this.selectionPoints) {
            retList.add(curPoint);
        }
        return retList;
    }

    public boolean isEmpty() {
        return this.selectionPoints.isEmpty();
    }
}

