/*
 * Decompiled with CFR 0.152.
 */
package at.HexLib.library;

import at.HexLib.library.BasicContentPanel;
import at.HexLib.library.HexLib;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.event.KeyEvent;

public class HexLibHEX
extends BasicContentPanel {
    private int hexCursor = 0;
    boolean isSameThread = false;
    private boolean doesHexAlwaysStartFirstPosition;

    public HexLibHEX(HexLib he) {
        super(he);
        this.setFontObjects();
    }

    @Override
    public void setFontObjects() {
        this.minWidth = HexLib.fontWidth * 47 + 5;
        this.setPreferredSize(new Dimension(this.minWidth, 0));
        this.setMinimumSize(new Dimension(this.minWidth, 0));
    }

    @Override
    public void paint(Graphics g) {
        if (g == null) {
            return;
        }
        if (this.he.buff == null) {
            return;
        }
        int ini = this.he.getStart() * 16;
        int end = ini + (this.he.getLines() + 2) * 16;
        if (end > this.he.buff.length) {
            end = this.he.buff.length;
        }
        int x = 0;
        int y = 0;
        if (this.paintCursorOnly) {
            int muCursor = this.getCursorPosition() - ini;
            y = muCursor / 16;
            x = muCursor - y * 16;
            ini = this.getCursorPosition();
            if (ini < 0) {
                return;
            }
            end = Math.min(ini + 1, this.he.buff.length);
        } else {
            super.paint(g);
            g.setColor(this.getFontForeground());
        }
        g.setFont(HexLib.font);
        int n = ini;
        while (n < end) {
            String byteAsString = HexLib.convertToHex(this.he.buff[n], 2);
            if (this.checkCurPosPaintable(n)) {
                int hexCursorPos = x * 3 + this.hexCursor;
                if (this.hasFocus() && this.getSelectionModel().isEmpty()) {
                    g.setColor(this.colorSecondCursor);
                    this.fillRect4Cursor(g, x * 3, y, 2);
                    if (this.he.cursorBlink != null && this.he.cursorBlink.isActive()) {
                        g.setColor(this.colorActiveCursor);
                    } else if (this.hasStripes && (this.he.getStart() + y) % 2 == 0) {
                        g.setColor(this.stripeColors[1]);
                    } else {
                        g.setColor(this.getBackground());
                    }
                    this.fillRect4Cursor(g, hexCursorPos, y, 1);
                } else {
                    g.setColor(this.colorSecondCursor);
                    this.rect(g, x * 3, y, 2);
                }
                if (this.hasFocus() && this.getSelectionModel().isEmpty()) {
                    g.setColor(this.fontCursorForeground);
                    this.printString(g, byteAsString, x++ * 3, y);
                    if (this.he.cursorBlink != null && !this.he.cursorBlink.isActive()) {
                        g.setColor(this.getFontForeground());
                        this.printStringSingle(g, byteAsString.substring(this.hexCursor, this.hexCursor + 1), hexCursorPos, y, this.hexCursor);
                    }
                } else {
                    g.setColor(this.getFontForeground());
                    this.printString(g, byteAsString, x++ * 3, y);
                }
            } else {
                if (this.getSelectionModel().isPositionWithinMarkPos(n)) {
                    g.setColor(this.colorMarkPos);
                    this.fillRect4Mark(g, x * 3, y, 2);
                    if (n == this.getCursorPosition()) {
                        g.setColor(this.colorSecondCursor);
                        this.rect(g, x * 3, y, 2);
                    }
                }
                g.setColor(this.getFontForeground());
                this.printString(g, byteAsString, x++ * 3, y);
            }
            if (x == 16) {
                x = 0;
                ++y;
            }
            ++n;
        }
        g.setColor(this.separatorLine);
        if (this.maxInactive > 0) {
            g.drawLine(this.minWidth - 1, 0, this.minWidth - 1, this.maxHeightPainted - 5 - 1);
        } else {
            g.drawLine(this.minWidth - 1, 0, this.minWidth - 1, this.maxHeightPainted);
        }
        g.setColor(this.getFontForeground());
    }

    private void fillRect4Cursor(Graphics g, int x, int y, int s) {
        g.fillRect(HexLib.fontWidth * x + 2 - this.hexCursor, HexLib.fontHeight * y, (HexLib.fontWidth - 1) * s + this.hexCursor, HexLib.fontHeight);
    }

    private void fillRect4Mark(Graphics g, int x, int y, int s) {
        g.fillRect(HexLib.fontWidth * x - (HexLib.fontWidth - 2) / 2, HexLib.fontHeight * y, HexLib.fontWidth * (s + 1), HexLib.fontHeight);
    }

    @Override
    public int calcCursorPos(int x, int y) {
        int muX = x / (HexLib.fontWidth * 3);
        int total = muX + ((y /= HexLib.fontHeight) + this.he.getStart()) * 16;
        int cursPos = x - muX * HexLib.fontWidth * 3 - HexLib.fontWidth;
        if (total > this.he.buff.length - 1) {
            total = this.he.buff.length - 1;
            cursPos = 1;
        }
        this.hexCursor = cursPos <= 0 || this.isHexAlwaysStartFirstPosition() ? 0 : 1;
        return total;
    }

    @Override
    public void setCursorPosition(int cursor) {
        this.setCursorPosition(cursor, this.getCursorPosition() < cursor);
    }

    void setCursorPosition(int cursor, boolean forward) {
        if (this.isHexAlwaysStartFirstPosition() || Math.abs(cursor - this.getCursorPosition()) > 1) {
            this.hexCursor = 0;
            if (cursor >= 0 && cursor <= this.he.buff.length - 1) {
                super.setCursorPosition(cursor);
            }
            return;
        }
        if (forward) {
            if (this.hexCursor == 0) {
                this.hexCursor = 1;
            } else if (cursor <= this.he.buff.length - 1) {
                this.hexCursor = 0;
                super.setCursorPosition(cursor);
            }
        } else if (this.hexCursor == 0) {
            if (cursor >= 0) {
                this.hexCursor = 1;
                super.setCursorPosition(cursor);
            }
        } else {
            this.hexCursor = 0;
        }
    }

    @Override
    public void keyTyped(KeyEvent e) {
        char c;
        if (this.getCursorPosition() > this.he.buff.length) {
            return;
        }
        if (this.he.txtFieldContainer.isEditable() && this.he.txtFieldContainer.isEnabled() && ((c = e.getKeyChar()) >= '0' && c <= '9' || c >= 'A' && c <= 'F' || c >= 'a' && c <= 'f')) {
            char[] str = new char[2];
            String n = HexLib.convertToHex(this.he.buff[this.getCursorPosition()], 2);
            str[1 - this.hexCursor] = n.charAt(1 - this.hexCursor);
            str[this.hexCursor] = e.getKeyChar();
            this.he.buff[this.getCursorPosition()] = (byte)Integer.parseInt(new String(str), 16);
            if (this.hexCursor != 1) {
                this.hexCursor = 1;
            } else if (this.getCursorPosition() != this.he.buff.length - 1) {
                this.setCursorPosition(this.getCursorPosition() + 1);
                this.hexCursor = 0;
            }
            this.he.reCalcHashCode();
            this.updateCursor();
        }
    }

    public void setHexAlwaysStartFirstPosition(boolean isHexAlwaysStartFirstPosition) {
        this.doesHexAlwaysStartFirstPosition = isHexAlwaysStartFirstPosition;
    }

    public boolean isHexAlwaysStartFirstPosition() {
        return this.doesHexAlwaysStartFirstPosition;
    }
}

