/*
 * Decompiled with CFR 0.152.
 */
package at.HexLib.library;

import at.HexLib.library.BasicContentPanel;
import at.HexLib.library.HexLib;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.event.KeyEvent;

public class HexLibASCII
extends BasicContentPanel {
    public HexLibASCII(HexLib he) {
        super(he);
        this.setFontObjects();
    }

    @Override
    public void setFontObjects() {
        this.minWidth = HexLib.fontWidth * 16 + 5;
        this.setPreferredSize(new Dimension(this.minWidth, 0));
        this.setMinimumSize(new Dimension(this.minWidth, 0));
    }

    @Override
    public void paint(Graphics g) {
        if (g == null) {
            return;
        }
        if (this.he.buff == null) {
            return;
        }
        int ini = this.he.getStart() * 16;
        int fin = ini + (this.he.getLines() + 2) * 16;
        if (fin > this.he.buff.length) {
            fin = this.he.buff.length;
        }
        int x = 0;
        int y = 0;
        if (this.paintCursorOnly) {
            int muCursor = this.getCursorPosition() - ini;
            y = muCursor / 16;
            x = muCursor - y * 16;
            ini = this.getCursorPosition();
            if (ini < 0) {
                return;
            }
            fin = Math.min(ini + 1, this.he.buff.length);
        } else {
            super.paint(g);
        }
        g.setFont(HexLib.font);
        int n = Math.max(ini, 0);
        while (n < fin) {
            if (this.checkCurPosPaintable(n)) {
                if (this.hasFocus() && this.getSelectionModel().isEmpty()) {
                    if (this.hasStripes && (this.he.getStart() + y) % 2 == 0) {
                        g.setColor(this.stripeColors[1]);
                    } else {
                        g.setColor(this.getBackground());
                    }
                    this.fillRect4Cursor(g, x, y, 1);
                    g.setColor(this.colorActiveCursor);
                    if (this.he.cursorBlink != null && this.he.cursorBlink.isActive()) {
                        this.rect(g, x, y, 1);
                    } else {
                        this.fillRect4Cursor(g, x, y, 1);
                    }
                } else {
                    g.setColor(this.colorActiveCursor);
                    this.rect(g, x, y, 1);
                }
                if (this.hasFocus() && this.getSelectionModel().isEmpty()) {
                    if (this.he.cursorBlink != null && this.he.cursorBlink.isActive()) {
                        g.setColor(this.getFontForeground());
                    } else {
                        g.setColor(this.fontCursorForeground);
                    }
                } else {
                    g.setColor(this.getFontForeground());
                }
            } else {
                if (this.getSelectionModel().isPositionWithinMarkPos(n)) {
                    g.setColor(this.colorMarkPos);
                    this.fillRect4Mark(g, x, y, 1);
                    if (n == this.getCursorPosition()) {
                        g.setColor(this.colorSecondCursor);
                        this.rect(g, x, y, 1);
                    }
                }
                g.setColor(this.getFontForeground());
            }
            if (this.he.buff[n] == 0) {
                this.printString(g, "", x++, y);
            } else if (this.he.buff[n] < 0) {
                this.printString(g, "" + (char)(256 + this.he.buff[n]), x++, y);
            } else {
                this.printString(g, "" + (char)this.he.buff[n], x++, y);
            }
            if (x == 16) {
                x = 0;
                ++y;
            }
            ++n;
        }
    }

    private void fillRect4Cursor(Graphics g, int x, int y, int s) {
        g.fillRect(HexLib.fontWidth * x + 2, HexLib.fontHeight * y, HexLib.fontWidth * s, HexLib.fontHeight - 1);
    }

    private void fillRect4Mark(Graphics g, int x, int y, int s) {
        g.fillRect(HexLib.fontWidth * x + 2, HexLib.fontHeight * y, HexLib.fontWidth * s, HexLib.fontHeight);
    }

    @Override
    public int calcCursorPos(int x, int y) {
        int total = (x /= HexLib.fontWidth) + ((y /= HexLib.fontHeight) + this.he.getStart()) * 16;
        if (total > this.he.buff.length - 1) {
            total = this.he.buff.length - 1;
        } else if (total < 0) {
            total = 0;
        }
        return total;
    }

    @Override
    public void keyTyped(KeyEvent e) {
        if (this.getCursorPosition() > this.he.buff.length) {
            return;
        }
        if (this.he.txtFieldContainer.isEditable() && this.he.txtFieldContainer.isEnabled() && this.isPrintableChar(e.getKeyChar())) {
            this.he.buff[this.getCursorPosition()] = (byte)e.getKeyChar();
            this.he.reCalcHashCode();
            if (this.getCursorPosition() != this.he.buff.length - 1) {
                this.setCursorPosition(this.getCursorPosition() + 1);
            }
            this.updateCursor();
        }
    }

    boolean isPrintableChar(char c) {
        Character.UnicodeBlock block = Character.UnicodeBlock.of(c);
        return !Character.isISOControl(c) && c != '\uffff' && block != null && block != Character.UnicodeBlock.SPECIALS;
    }
}

