/*
 * Decompiled with CFR 0.152.
 */
package at.HexLib.library;

import at.HexLib.library.BasicPanel;
import at.HexLib.library.ColumnsLeft;
import at.HexLib.library.CursorBlink;
import at.HexLib.library.HeaderChangedPanel;
import at.HexLib.library.HeaderColumnPanel;
import at.HexLib.library.HeaderLenPanel;
import at.HexLib.library.HexLibASCII;
import at.HexLib.library.HexLibHEX;
import at.HexLib.library.HexLibSelectionModel;
import at.HexLib.library.HexTransfer;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Rectangle;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.ClipboardOwner;
import java.awt.datatransfer.Transferable;
import java.awt.event.AdjustmentEvent;
import java.awt.event.AdjustmentListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.util.Arrays;
import java.util.concurrent.Executors;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JScrollBar;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;

public class HexLib
extends JPanel
implements AdjustmentListener,
ClipboardOwner {
    private static final long serialVersionUID = -2981812315423877420L;
    byte[] buff;
    protected static Font font = Font.decode("Monospaced");
    protected static Font fontBold = font.deriveFont(1);
    protected static int fontHeight = 16;
    protected static int fontWidth = 16;
    protected static int fontMaxDescent;
    public boolean DEBUG = false;
    JScrollBar scrlRight;
    private int start = 0;
    private final int minLines = 10;
    private int lines = 10;
    protected int maxLineas = this.getLines();
    protected int maxHeight = 0;
    private HeaderChangedPanel pnlInactiveHeader;
    private HexLibASCII jHexEditorASCII;
    private HexLibHEX jHexEditorHEX;
    private HeaderColumnPanel headerColumnPanel;
    private ColumnsLeft columnLeft;
    private HeaderLenPanel headerLenPanel;
    protected CursorBlink cursorBlink;
    private Color colorHexBackGround = UIManager.getColor("TextArea.background");
    Color colorASCIIBackGround = UIManager.getColor("TextArea.background");
    private Color colorInactiveBackGround = UIManager.getColor("TextArea.inactiveForeground");
    private Color disabledBG = UIManager.getColor("TextField.disabledBackground");
    private Color inactiveBG = UIManager.getColor("TextField.inactiveBackground");
    private Color inactiveFG = UIManager.getColor("TextField.inactiveForeground");
    private Color colorHexCounterBackGround = new Color(255, 255, 74);
    private long hashCode;
    private boolean continousScroll = true;
    private ComponentAdapter myCompListener;
    private HexLibSelectionModel selectionModel;
    public static String contentChangedProperty;
    public static String cursorProperty;
    protected JTextField txtFieldContainer = new JTextField();
    protected int cursor;
    private HexTransfer hexTransfer;
    int oldStart = -1;
    private long reCalcHashCode;
    private static final byte[] correspondingNibble;

    static {
        contentChangedProperty = "contentChanged";
        cursorProperty = "cursorPosChanged";
        correspondingNibble = new byte[103];
        int i = 0;
        while (i <= 102) {
            HexLib.correspondingNibble[i] = -1;
            ++i;
        }
        i = 48;
        while (i <= 57) {
            HexLib.correspondingNibble[i] = (byte)(i - 48);
            ++i;
        }
        i = 65;
        while (i <= 70) {
            HexLib.correspondingNibble[i] = (byte)(i - 65 + 10);
            ++i;
        }
        i = 97;
        while (i <= 102) {
            HexLib.correspondingNibble[i] = (byte)(i - 97 + 10);
            ++i;
        }
    }

    public HexLib() {
        this(new byte[0]);
    }

    public HexLib(byte[] buff) {
        this.initialize();
        this.buildLayout();
        this.addListeners();
        this.setByteContent(buff);
        this.setColorInactiveBackGround(this.colorInactiveBackGround);
    }

    private void initialize() {
        this.columnLeft = new ColumnsLeft(this);
        this.headerColumnPanel = new HeaderColumnPanel(this);
        this.headerLenPanel = new HeaderLenPanel(this);
        this.jHexEditorHEX = new HexLibHEX(this);
        this.jHexEditorHEX.setBackground(this.getColorHexBackGround());
        this.jHexEditorASCII = new HexLibASCII(this);
        this.jHexEditorASCII.setBackground(this.colorASCIIBackGround);
        this.calcFontObjects();
        this.scrlRight = new JScrollBar(1);
        this.scrlRight.setMinimum(0);
        this.pnlInactiveHeader = new HeaderChangedPanel(this);
        this.cursorBlink = new CursorBlink(this);
        this.setSelectionModel(new HexLibSelectionModel());
        this.setHexTransferHandler(new HexTransfer(this.getMe()));
    }

    public void calcFontObjects() {
        fontHeight = this.getFontMetrics(font).getHeight();
        fontWidth = this.getFontMetrics(font).stringWidth(" ") + 1;
        fontMaxDescent = this.getFontMetrics(font).getMaxDescent();
        this.columnLeft.setFontObjects();
        this.headerColumnPanel.setFontObjects();
        this.headerLenPanel.setFontObjects();
        this.jHexEditorASCII.setFontObjects();
        this.jHexEditorHEX.setFontObjects();
    }

    private void addListeners() {
        this.scrlRight.addAdjustmentListener(this);
        this.myCompListener = new ComponentAdapter(){

            @Override
            public void componentResized(ComponentEvent e) {
                HexLib.this.jHexEditorASCII.checkOverMaxLines();
                HexLib.this.checkVisibleProportions();
            }

            @Override
            public void componentMoved(ComponentEvent e) {
                HexLib.this.jHexEditorASCII.checkOverMaxLines();
                HexLib.this.checkVisibleProportions();
            }

            private Rectangle getBounds() {
                return null;
            }
        };
        this.addComponentListener(this.myCompListener);
    }

    public HexLib getMe() {
        return this;
    }

    public void buildLayout() {
        GridBagLayout gbl = new GridBagLayout();
        this.setLayout(gbl);
        this.addComponent(gbl, this.pnlInactiveHeader, 0, 0, 1, 1, 0.0, 0.0);
        this.addComponent(gbl, this.headerColumnPanel, 1, 0, 1, 1, 0.0, 0.0);
        this.addComponent(gbl, this.headerLenPanel, 2, 0, 2, 1, 0.0, 0.0);
        this.addComponent(gbl, this.columnLeft, 0, 1, 1, 1, 0.0, 1.0);
        this.addComponent(gbl, this.jHexEditorHEX, 1, 1, 1, 1, 0.0, 1.0);
        this.addComponent(gbl, this.jHexEditorASCII, 2, 1, 1, 1, 0.0, 1.0);
        this.addComponent(gbl, this.scrlRight, 3, 1, 1, 1, 0.0, 1.0);
    }

    private void addComponent(GridBagLayout gbl, JComponent c, int x, int y, int width, int height, double weightx, double weighty) {
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.fill = 1;
        gbc.gridx = x;
        gbc.gridy = y;
        gbc.gridwidth = width;
        gbc.gridheight = height;
        gbc.weightx = weightx;
        gbc.weighty = weighty;
        gbl.setConstraints(c, gbc);
        this.add(c);
    }

    public void dispose() {
        this.scrlRight.removeAdjustmentListener(this);
        this.removeComponentListener(this.myCompListener);
        this.jHexEditorASCII.dispose();
        this.jHexEditorHEX.dispose();
        this.headerColumnPanel.dispose();
        this.headerLenPanel.dispose();
        this.selectionModel.dispose();
    }

    public byte[] getByteContent() {
        return this.buff;
    }

    public void setByteContent(byte[] buff) {
        this.buff = buff;
        System.gc();
        if (this.cursorBlink != null) {
            this.cursorBlink.stop();
        }
        this.cursorBlink = null;
        this.headerLenPanel.setStrLength(buff != null ? buff.length : 0);
        if (buff == null) {
            buff = new byte[]{};
            this.scrlRight.setMaximum(0);
            this.maxLineas = 0;
        }
        this.resetHashCode();
        if (this.getLines() == 0) {
            this.setLines(10);
        }
        this.maxLineas = buff.length / 16;
        if (this.maxLineas * 16 < buff.length) {
            ++this.maxLineas;
        }
        this.scrlRight.setMaximum(this.maxLineas);
        this.clearSelection();
        this.setStart(0);
        this.columnLeft.setMaxDigits((int)(Math.log(buff.length) / Math.log(16.0)));
        this.maxHeight = this.maxLineas * fontHeight + 5;
        this.jHexEditorASCII.setCursorPosition(0);
        this.jHexEditorASCII.requestFocus();
        this.revalidate();
        this.repaint();
        this.cursorBlink = new CursorBlink(this);
        this.checkVisibleProportions();
    }

    public void resetHashCode() {
        this.reCalcHashCode = this.hashCode = this.calcHashCode();
    }

    private void clearSelection() {
        this.selectionModel.clear();
    }

    @Override
    public void paint(Graphics g) {
        super.paint(g);
    }

    protected int getStart() {
        return this.start;
    }

    protected int getLines() {
        return this.lines;
    }

    public void setLines(int lines) {
        this.lines = lines < 10 ? 10 : lines;
    }

    protected int getOverMaxLines() {
        return this.getLines() + this.scrlRight.getValue() - this.maxLineas;
    }

    @Override
    public void adjustmentValueChanged(AdjustmentEvent e) {
        if ((this.isContinousScroll() || !e.getValueIsAdjusting()) && e.getValue() != this.getStart()) {
            this.setStart(e.getValue());
            this.jHexEditorHEX.checkOverMaxLines();
            this.repaint();
        }
    }

    protected static String convertToHex(int num, int countLen) {
        String convInt = "0";
        if (num > 0) {
            convInt = Integer.toHexString(num);
        } else if (num < 0) {
            return Integer.toHexString(num & 0xFF);
        }
        if (convInt.length() == countLen) {
            return convInt;
        }
        StringBuilder conv = new StringBuilder(countLen + 1);
        int i = 0;
        while (i < countLen - convInt.length()) {
            conv.append('0');
            ++i;
        }
        conv.append(convInt);
        return conv.toString();
    }

    public void setStart(int start) {
        this.start = start < 0 ? 0 : (start > this.maxLineas ? this.maxLineas : start);
    }

    public void repaintCursorOnly() {
        if (this.jHexEditorASCII.hasFocus()) {
            this.jHexEditorASCII.repaintCursorOnly();
        } else if (this.jHexEditorHEX.hasFocus()) {
            this.jHexEditorHEX.repaintCursorOnly();
        }
    }

    public void setColorHexBackGround(Color colorHexBackGround) {
        this.colorHexBackGround = colorHexBackGround;
        this.jHexEditorHEX.setBackground(colorHexBackGround);
        this.jHexEditorHEX.repaint();
        this.jHexEditorASCII.setBackground(colorHexBackGround);
        this.jHexEditorASCII.repaint();
    }

    public Color getColorHexBackGround() {
        return this.colorHexBackGround;
    }

    public void setColorInactiveBackGround(Color colorInactiveBackGround) {
        this.colorInactiveBackGround = colorInactiveBackGround;
        this.pnlInactiveHeader.setBackground(colorInactiveBackGround);
        BasicPanel.setColorInactiveBackGround(colorInactiveBackGround);
        this.repaint();
    }

    public Color getColorInactiveBackGround() {
        return this.colorInactiveBackGround;
    }

    public void setColorBorderBackGround(Color colorBorderBackGround) {
        this.colorHexCounterBackGround = colorBorderBackGround;
        this.headerColumnPanel.setBackground(colorBorderBackGround);
        this.columnLeft.setBackground(colorBorderBackGround);
        this.repaint();
    }

    public Color getColorBorderBackGround() {
        return this.colorHexCounterBackGround;
    }

    public void setConvertBytesLen(boolean convertBytesLen) {
        this.headerLenPanel.setConvertBytes(convertBytesLen);
    }

    public boolean isConvertBytesLen() {
        return this.headerLenPanel.isConvertBytes();
    }

    public long getBlinkIntervall() {
        return this.cursorBlink.getBlinkIntervall();
    }

    public void setBlinkIntervall(String text) {
        if (this.cursorBlink != null) {
            this.cursorBlink.setBlinkIntervall(Long.parseLong(text));
        }
    }

    public void setCursorPostion(int cursPos) {
        this.setCursorPostion(String.valueOf(cursPos));
    }

    public void setCursorPostion(String cursPos) {
        int mu = Integer.parseInt(cursPos);
        if (mu > this.buff.length) {
            this.jHexEditorASCII.setCursorPosition(this.buff.length - 1);
        } else {
            this.jHexEditorASCII.setCursorPosition(mu);
        }
        this.selectionModel.clear();
        int curMinPosDisplayed = this.getStart() * 16;
        int curMaxPosDisplayed = curMinPosDisplayed + this.getLines() * 16;
        if (this.jHexEditorASCII.getCursorPosition() > curMaxPosDisplayed || this.jHexEditorASCII.getCursorPosition() < curMinPosDisplayed) {
            int muStart = this.jHexEditorASCII.getCursorPosition() / 16 - 2;
            if (muStart < 0) {
                muStart = 0;
            }
            if (muStart + this.getLines() > this.maxLineas) {
                muStart = this.maxLineas - this.getLines() - 1;
            }
            this.setStart(muStart);
            this.scrlRight.setValue(muStart);
        }
        this.repaint();
    }

    public int getCursorPosition() {
        return this.jHexEditorHEX.getCursorPosition();
    }

    public void setHexAlwaysStartFirstPosition(boolean isHexAlwaysStartFirstPosition) {
        this.jHexEditorHEX.setHexAlwaysStartFirstPosition(isHexAlwaysStartFirstPosition);
    }

    public boolean isHexAlwaysStartFirstPosition() {
        return this.jHexEditorHEX.isHexAlwaysStartFirstPosition();
    }

    public void requestFocus4Hex() {
        this.jHexEditorHEX.requestFocus();
    }

    public void requestFocus4ASCII() {
        this.jHexEditorASCII.requestFocus();
    }

    public boolean isContentChanged() {
        return this.hashCode != this.reCalcHashCode;
    }

    protected void reCalcHashCode() {
        Executors.newCachedThreadPool().execute(new Runnable(){

            @Override
            public void run() {
                final long oldHash = HexLib.this.reCalcHashCode;
                HexLib.this.reCalcHashCode = HexLib.this.calcHashCode();
                if (oldHash != HexLib.this.reCalcHashCode) {
                    SwingUtilities.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            HexLib.this.pnlInactiveHeader.repaint();
                            HexLib.this.firePropertyChange(contentChangedProperty, HexLib.this.hashCode == oldHash, HexLib.this.hashCode == HexLib.this.reCalcHashCode);
                        }
                    });
                }
            }
        });
    }

    public long getHashCode() {
        return this.calcHashCode();
    }

    private synchronized long calcHashCode() {
        return Arrays.hashCode(this.buff);
    }

    public void setFontSize(int newFontSize) {
        font = font.deriveFont((float)newFontSize);
        fontBold = fontBold.deriveFont((float)newFontSize);
        this.calcFontObjects();
        this.revalidate();
        this.repaint();
    }

    public boolean isHexBeanEditable() {
        return this.txtFieldContainer.isEditable();
    }

    public void setHexBeanEditable(boolean isEditable) {
        this.txtFieldContainer.setEditable(isEditable);
        this.repaint();
    }

    public boolean isHexBeanEnabled() {
        return this.txtFieldContainer.isEnabled();
    }

    public void setHexBeanEnabled(boolean isEditable) {
        this.txtFieldContainer.setEnabled(isEditable);
        this.repaint();
    }

    public Color getDisabledBG() {
        return this.disabledBG;
    }

    public void setDisabledBG(Color disabledBG) {
        this.disabledBG = disabledBG;
    }

    public Color getInactiveBG() {
        return this.inactiveBG;
    }

    public void setInactiveBG(Color inactiveBG) {
        this.inactiveBG = inactiveBG;
    }

    public Color getInactiveFG() {
        return this.inactiveFG;
    }

    public void setInactiveFG(Color inactiveFG) {
        this.inactiveFG = inactiveFG;
    }

    public boolean isHexEditorVisible() {
        return this.jHexEditorHEX.isVisible();
    }

    public void setHexEditorVisible(boolean b) {
        this.jHexEditorHEX.setVisible(b);
        this.headerColumnPanel.setVisible(b);
    }

    public boolean isASCIIEditorVisible() {
        return this.jHexEditorASCII.isVisible();
    }

    public void setASCIIEditorVisible(boolean b) {
        this.jHexEditorASCII.setVisible(b);
        this.headerLenPanel.setVisible(b);
    }

    public int indexOf(String dataToFind, boolean isDataString) {
        return this.indexOf(dataToFind, isDataString, 0);
    }

    public int indexOf(String dataToFind, boolean isDataString, int startPos) {
        return this.indexOf(dataToFind, isDataString, false, startPos);
    }

    public int indexOf(String dataToFind, boolean isDataString, boolean isCaseSensitive, int startPos) {
        if (isDataString) {
            byte curByte;
            byte[] srchBytesLower = null;
            byte[] srchBytesUpper = null;
            if (isCaseSensitive) {
                srchBytesLower = dataToFind.getBytes();
                srchBytesUpper = dataToFind.getBytes();
            } else {
                srchBytesUpper = dataToFind.toUpperCase().getBytes();
                srchBytesLower = dataToFind.toLowerCase().getBytes();
            }
            byte[] byArray = srchBytesLower;
            int n = srchBytesLower.length;
            int n2 = 0;
            while (n2 < n) {
                curByte = byArray[n2];
                if (curByte >= 128) {
                    curByte = (byte)(curByte - 255);
                }
                ++n2;
            }
            byArray = srchBytesUpper;
            n = srchBytesUpper.length;
            n2 = 0;
            while (n2 < n) {
                curByte = byArray[n2];
                if (curByte >= 128) {
                    curByte = (byte)(curByte - 255);
                }
                ++n2;
            }
            return this.indexOf(srchBytesLower, srchBytesUpper, startPos);
        }
        byte[] srchBytes = this.fromHexString(dataToFind);
        return this.indexOf(srchBytes, startPos);
    }

    public int indexOf(byte[] dataToFind) {
        return this.indexOf(dataToFind, 0);
    }

    public int indexOf(byte[] dataToFind, int startPos) {
        return this.indexOf(dataToFind, dataToFind, startPos);
    }

    private int indexOf(byte[] dataToFindLowerCase, byte[] dataToFindUpperCase, int startPos) {
        int iDataLen = this.buff.length;
        int iDataToFindLen = dataToFindLowerCase.length;
        int iMatchDataCntr = 0;
        if (startPos < 0) {
            startPos = 0;
        } else if (startPos > iDataLen) {
            startPos = iDataLen - 1;
        }
        int i = startPos;
        while (i < iDataLen) {
            iMatchDataCntr = this.buff[i] == dataToFindLowerCase[iMatchDataCntr] || this.buff[i] == dataToFindUpperCase[iMatchDataCntr] ? ++iMatchDataCntr : (this.buff[i] == dataToFindLowerCase[0] || this.buff[i] == dataToFindUpperCase[0] ? 1 : 0);
            if (iMatchDataCntr == iDataToFindLen) {
                return i - iDataToFindLen + 1;
            }
            ++i;
        }
        return -1;
    }

    public int lastIndexOf(String dataToFind, boolean isDataString) {
        return this.lastIndexOf(dataToFind, isDataString, 0);
    }

    public int lastIndexOf(String dataToFind, boolean isDataString, int startPos) {
        return this.lastIndexOf(dataToFind, isDataString, false, startPos);
    }

    public int lastIndexOf(String dataToFind, boolean isDataString, boolean isCaseSensitive, int startPos) {
        if (isDataString) {
            byte curByte;
            byte[] srchBytesLower = null;
            byte[] srchBytesUpper = null;
            if (isCaseSensitive) {
                srchBytesLower = dataToFind.getBytes();
                srchBytesUpper = dataToFind.getBytes();
            } else {
                srchBytesUpper = dataToFind.toUpperCase().getBytes();
                srchBytesLower = dataToFind.toLowerCase().getBytes();
            }
            byte[] byArray = srchBytesLower;
            int n = srchBytesLower.length;
            int n2 = 0;
            while (n2 < n) {
                curByte = byArray[n2];
                if (curByte >= 128) {
                    curByte = (byte)(curByte - 255);
                }
                ++n2;
            }
            byArray = srchBytesUpper;
            n = srchBytesUpper.length;
            n2 = 0;
            while (n2 < n) {
                curByte = byArray[n2];
                if (curByte >= 128) {
                    curByte = (byte)(curByte - 255);
                }
                ++n2;
            }
            return this.lastIndexOf(srchBytesLower, srchBytesUpper, startPos);
        }
        byte[] srchBytes = this.fromHexString(dataToFind);
        return this.lastIndexOf(srchBytes, startPos);
    }

    public int lastIndexOf(byte[] dataToFind) {
        return this.lastIndexOf(dataToFind, -1);
    }

    public int lastIndexOf(byte[] dataToFind, int startPos) {
        return this.lastIndexOf(dataToFind, dataToFind, startPos);
    }

    private int lastIndexOf(byte[] dataToFindLowerCase, byte[] dataToFindUpperCase, int startPos) {
        int iDataToFindLen;
        int iDataLen = this.buff.length - 1;
        int iMatchDataCntr = iDataToFindLen = dataToFindLowerCase.length - 1;
        if (startPos < 0) {
            startPos = iDataLen;
        } else if (startPos > iDataLen) {
            startPos = iDataLen;
        }
        int i = startPos;
        while (i >= 0) {
            iMatchDataCntr = this.buff[i] == dataToFindLowerCase[iMatchDataCntr] || this.buff[i] == dataToFindUpperCase[iMatchDataCntr] ? --iMatchDataCntr : (this.buff[i] == dataToFindLowerCase[iDataToFindLen] || this.buff[i] == dataToFindUpperCase[iDataToFindLen] ? iDataToFindLen - 1 : iDataToFindLen);
            if (iMatchDataCntr < 0) {
                return i;
            }
            --i;
        }
        return -1;
    }

    private int charToNibble(char c) {
        if (c > 'f') {
            throw new IllegalArgumentException("Invalid hex character: " + c);
        }
        byte nibble = correspondingNibble[c];
        if (nibble < 0) {
            throw new IllegalArgumentException("Invalid hex character: " + c);
        }
        return nibble;
    }

    private byte[] fromHexString(String s) {
        int stringLength = s.length();
        if ((stringLength & 1) != 0) {
            throw new IllegalArgumentException("fromHexString requires an even number of hex characters");
        }
        byte[] bytes = new byte[stringLength / 2];
        int i = 0;
        int j = 0;
        while (i < stringLength) {
            int high = this.charToNibble(s.charAt(i));
            int low = this.charToNibble(s.charAt(i + 1));
            bytes[j] = (byte)(high << 4 | low);
            i += 2;
            ++j;
        }
        return bytes;
    }

    public boolean isContinousScroll() {
        return this.continousScroll;
    }

    public void setContinousScroll(boolean continousScroll) {
        this.continousScroll = continousScroll;
    }

    public void checkVisibleProportions() {
        if (this.getLines() > 0) {
            int extent = (int)((float)(this.maxLineas - this.getLines()) * (float)this.getLines() / (float)this.maxLineas);
            Rectangle rec = this.getMe().getBounds();
            int starterLines = -2;
            int muLineas = rec.height / fontHeight + starterLines;
            if (muLineas == starterLines) {
                return;
            }
            this.setLines(muLineas);
            if (this.getLines() > this.maxLineas) {
                this.setLines(this.maxLineas);
                this.setStart(0);
            }
            this.scrlRight.setVisibleAmount(this.getLines());
            this.scrlRight.setValue(this.getStart());
        }
    }

    @Override
    public void scrollRectToVisible(Rectangle aRect) {
        super.scrollRectToVisible(aRect);
    }

    public HexLibSelectionModel getSelectionModel() {
        return this.selectionModel;
    }

    public void setSelectionModel(HexLibSelectionModel selectionModel) {
        this.selectionModel = selectionModel;
        this.selectionModel.setUpdatePainter(this);
    }

    @Override
    public void lostOwnership(Clipboard clipboard, Transferable contents) {
        System.out.println("lost ownership with copy-paste");
    }

    public HexTransfer getHexTransferHandler() {
        return this.hexTransfer;
    }

    public void setHexTransferHandler(HexTransfer hexTransferHandler) {
        this.hexTransfer = hexTransferHandler;
    }

    protected boolean isOwnFocusComponent(Component oppositeComponent) {
        return oppositeComponent == this.columnLeft || oppositeComponent == this.headerColumnPanel || oppositeComponent == this.headerLenPanel || oppositeComponent == this.scrlRight || oppositeComponent == this.jHexEditorASCII || oppositeComponent == this.jHexEditorHEX;
    }

    @Override
    public boolean hasFocus() {
        return this.columnLeft.hasFocus() || this.headerColumnPanel.hasFocus() || this.headerLenPanel.hasFocus() || this.scrlRight.hasFocus() || this.jHexEditorASCII.hasFocus() || this.jHexEditorHEX.hasFocus();
    }

    public static boolean instanceOfHexLib(Object obj) {
        return obj instanceof HexLib || obj instanceof HexLibHEX || obj instanceof HexLibASCII || obj instanceof HeaderLenPanel || obj instanceof HeaderChangedPanel || obj instanceof HeaderColumnPanel;
    }
}

