/*
 * Decompiled with CFR 0.152.
 */
package at.HexLib.library;

import at.HexLib.library.BasicPanel;
import at.HexLib.library.HexLib;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.text.NumberFormat;

public class HeaderLenPanel
extends BasicPanel {
    private String strLength = "";
    private static double iKiloByte = 1024.0;
    private static double iMegaByte = iKiloByte * iKiloByte;
    private static String strBytes = "Bytes";
    private static String strKiloByte = "KByte";
    private static String strMegaByte = "MByte";
    private boolean convertBytes = false;
    private int calcLen;
    Color fontForeground = Color.black;

    public HeaderLenPanel(HexLib he) {
        super(he);
        this.setBackground(this.colorLenHeaderBackGround);
        this.setFontObjects();
    }

    public void setFontObjects() {
        Dimension minDimension = new Dimension();
        minDimension.setSize(0, HexLib.fontHeight + 5);
        this.setPreferredSize(minDimension);
    }

    @Override
    public void setBackground(Color backGroundColor) {
        super.setBackground(backGroundColor);
    }

    @Override
    public void paint(Graphics g) {
        Color oldColor = g.getColor();
        g.setColor(this.getBackground());
        g.fillRect(0, 0, this.getBounds().width, this.getBounds().height);
        g.setColor(this.fontForeground);
        this.printString(g, this.getStrLength(), 0.25, 0);
        g.setColor(oldColor);
    }

    public void setStrLength(int buffLength) {
        this.calcLen = buffLength;
        StringBuilder result = new StringBuilder(30);
        result.append("Length: ");
        if ((double)buffLength > iMegaByte && this.convertBytes) {
            result.append(this.round((double)buffLength / iMegaByte, 2));
            result.append(" ");
            result.append(strMegaByte);
        } else if ((double)buffLength > iKiloByte && this.convertBytes) {
            result.append(this.round((double)buffLength / iKiloByte, 2));
            result.append(" ");
            result.append(strKiloByte);
        } else {
            result.append(NumberFormat.getIntegerInstance().format(buffLength));
            result.append(" ");
            result.append(strBytes);
        }
        this.strLength = result.toString();
    }

    public String getStrLength() {
        return this.strLength;
    }

    private double round(double value, int places) {
        if (places < 0) {
            throw new IllegalArgumentException();
        }
        long factor = (long)Math.pow(10.0, places);
        long tmp = Math.round(value *= (double)factor);
        return (double)tmp / (double)factor;
    }

    public void setConvertBytes(boolean convertBytes) {
        this.convertBytes = convertBytes;
        this.setStrLength(this.calcLen);
        this.repaint();
    }

    public boolean isConvertBytes() {
        return this.convertBytes;
    }
}

