/*
 * Decompiled with CFR 0.152.
 */
package at.HexLib.library;

import at.HexLib.library.BasicPanel;
import at.HexLib.library.HexLib;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;

public class HeaderColumnPanel
extends BasicPanel {
    Color fontForeground = Color.black;
    String[] strHeader = new String[16];

    public HeaderColumnPanel(HexLib he) {
        super(he);
        this.setBackground(he.getColorBorderBackGround());
        this.setLayout(new BorderLayout(1, 1));
        this.setFontObjects();
    }

    public void setFontObjects() {
        this.minWidth = HexLib.fontWidth * 47 + 5;
        Dimension minDimension = new Dimension();
        minDimension.setSize(this.minWidth, HexLib.fontHeight);
        this.setPreferredSize(minDimension);
        this.setMinimumSize(minDimension);
        this.strHeader = new String[16];
        int i = 0;
        while (i < 16) {
            this.strHeader[i] = "." + HexLib.convertToHex(i, 1);
            ++i;
        }
    }

    @Override
    public void paint(Graphics g) {
        super.paint(g);
        g.setColor(this.separatorLine);
        g.drawLine(this.minWidth - 1, 0, this.minWidth - 1, this.maxHeightPainted);
        g.setColor(this.fontForeground);
        int n = 0;
        while (n < 16) {
            if (this.checkCurPosPaintable(n)) {
                this.rect(g, n * 3, 0, 2);
                g.setFont(HexLib.fontBold);
            } else {
                g.setFont(HexLib.font);
            }
            this.printString(g, this.strHeader[n], n * 3, 0);
            ++n;
        }
    }

    @Override
    protected void rect(Graphics g, int x, int y, int s) {
        g.drawRect(HexLib.fontWidth * x + 2 - 1, HexLib.fontHeight * y, HexLib.fontWidth * s, HexLib.fontHeight + 5 - 1);
    }

    @Override
    protected void printString(Graphics g, String s, int x, int y) {
        g.drawString(s, HexLib.fontWidth * x + 2, HexLib.fontHeight * (y + 1) - HexLib.fontMaxDescent + 2);
    }

    protected boolean checkCurPosPaintable(int pos2Check) {
        return pos2Check == this.getCursorPosition() % 16 && this.getSelectionModel().isPositionWithinMarkPos(pos2Check);
    }
}

