/*
 * Decompiled with CFR 0.152.
 */
package at.HexLib.library;

import at.HexLib.library.BasicPanel;
import at.HexLib.library.HexLib;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;

public class ColumnsLeft
extends BasicPanel {
    private int maxDigits = 8;
    HexLib he;
    Color fontForeground = Color.black;

    public ColumnsLeft(HexLib he) {
        super(he);
        this.he = he;
        this.setLayout(new BorderLayout(1, 1));
        this.setDigitCounter(this.maxDigits);
        this.hasStripes = true;
        this.setBackground(he.getColorBorderBackGround());
        this.createZebraColors(he.getColorBorderBackGround(), he.getColorBorderBackGround());
    }

    public void setDigitCounter(int count) {
        this.maxDigits = count;
        this.setFontObjects();
    }

    public void setFontObjects() {
        this.minWidth = HexLib.fontWidth * (this.maxDigits + 1) + 5;
        this.setPreferredSize(new Dimension(this.minWidth, 0));
        this.setMinimumSize(new Dimension(this.minWidth, 0));
    }

    public void setMaxDigits(int maxDigit) {
        if (maxDigit < 1) {
            maxDigit = 1;
        }
        this.setDigitCounter(maxDigit);
    }

    public int getMaxDigits() {
        return this.maxDigits;
    }

    @Override
    public void paint(Graphics g) {
        this.minWidth = this.getSize().width;
        super.paint(g);
        g.setColor(this.fontForeground);
        this.end = Math.min(this.ini + this.he.getLines() + 2, this.he.maxLineas);
        int y = 0;
        int n = this.ini;
        while (n < this.end) {
            if (this.checkCurPosPaintable(n)) {
                this.createRect(g, 0, y, this.maxDigits + 1);
                g.setFont(HexLib.fontBold);
            } else {
                g.setFont(HexLib.font);
            }
            this.printString(g, String.valueOf(HexLib.convertToHex(n, this.maxDigits)) + ".:", 0, y++);
            ++n;
        }
    }

    protected boolean checkCurPosPaintable(int pos2Check) {
        return pos2Check == this.getCursorPosition() / 16 && this.getSelectionModel().isPositionWithinMarkPos(pos2Check);
    }
}

