/*
 * Decompiled with CFR 0.152.
 */
package at.HexLib.library;

import at.HexLib.library.HexLib;
import at.HexLib.library.HexLibFocusListener;
import at.HexLib.library.HexLibSelectionModel;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import javax.swing.JComponent;
import javax.swing.UIManager;
import javax.swing.plaf.ColorUIResource;

public class BasicPanel
extends JComponent
implements KeyListener {
    protected HexLib he;
    protected static final int border = 2;
    protected static final int borderTwice = 5;
    private Color backGroundColor = Color.pink;
    private static Color colorInactiveBackGround = Color.GREEN;
    Color colorActiveCursor = Color.blue.darker();
    Color colorSecondCursor = Color.cyan.darker().darker();
    Color fontCursorForeground = Color.yellow;
    private Color fontForeground = UIManager.getColor("TextArea.foreground");
    Color fontChangedForeground = UIManager.getColor("TextField.highlight");
    boolean hasTextFieldColors = false;
    Color separatorLine = Color.GRAY.brighter();
    Color colorLenHeaderBackGround = new Color(255, 255, 170);
    protected final Color[] stripeColors = new Color[2];
    protected boolean hasStripes = false;
    protected int minWidth;
    protected int ini;
    protected int end;
    protected int maxHeightPainted;
    protected int maxInactive;
    private HexLibFocusListener focusListener;
    protected boolean paintCursorOnly = false;

    public BasicPanel(HexLib he) {
        this.he = he;
        this.setLayout(new BorderLayout());
        this.addKeyListener(this);
        this.focusListener = new HexLibFocusListener(this);
        this.addFocusListener(this.focusListener);
    }

    public void dispose() {
        this.removeKeyListener(this);
        this.removeFocusListener(this.focusListener);
    }

    @Override
    public void keyTyped(KeyEvent e) {
    }

    @Override
    public void keyPressed(KeyEvent e) {
        switch (e.getKeyCode()) {
            case 33: {
                if ((e.getModifiersEx() ^ 0x40) == 0) {
                    if (this.getSelectionModel().getStartPoint() < 0) {
                        this.getSelectionModel().addStartAndEndPoint(this.getCursorPosition(), this.getCursorPosition());
                    }
                    int changeCurPos = this.getSelectionModel().getEndPoint();
                    this.getSelectionModel().addNewEndPoint(changeCurPos -= 16 * (this.he.getLines() + 1));
                    this.scrollPane(-(this.he.getLines() + 1));
                    break;
                }
                int changeCurPos = 0;
                if (this.getCursorPosition() > 16 * (this.he.getLines() + 1)) {
                    changeCurPos = this.getCursorPosition() - 16 * (this.he.getLines() + 1);
                }
                this.setCursorPosition(changeCurPos);
                this.updateCursor();
                break;
            }
            case 34: {
                if ((e.getModifiersEx() ^ 0x40) == 0) {
                    if (this.getSelectionModel().getStartPoint() < 0) {
                        this.getSelectionModel().addStartAndEndPoint(this.getCursorPosition(), this.getCursorPosition());
                    }
                    int changeCurPos = this.getSelectionModel().getEndPoint();
                    this.getSelectionModel().addNewEndPoint(changeCurPos += 16 * (this.he.getLines() + 1));
                    this.scrollPane(this.he.getLines() + 1);
                    break;
                }
                if (this.getCursorPosition() < this.he.buff.length - 16 * (this.he.getLines() + 1)) {
                    this.setCursorPosition(this.getCursorPosition() + 16 * (this.he.getLines() + 1));
                } else {
                    this.setCursorPosition(this.he.buff.length - 1);
                }
                this.updateCursor();
                break;
            }
            case 35: {
                if ((e.getModifiersEx() ^ 0x40) == 0) {
                    int mu;
                    int end;
                    if (this.getSelectionModel().getStartPoint() < 0) {
                        this.getSelectionModel().addStartAndEndPoint(this.getCursorPosition(), this.getCursorPosition());
                    }
                    if ((end = this.getSelectionModel().getEndPoint()) + 1 != (mu = (end + 1) / 16) * 16) {
                        if (this.getSelectionModel().getEndPoint() > this.getSelectionModel().getStartPoint()) {
                            this.getSelectionModel().addNewEndPoint((mu + 1) * 16 - 1);
                        } else {
                            this.getSelectionModel().addNewEndPoint((mu + 1) * 16);
                        }
                    }
                    this.checkScrollOneLineRequired(true);
                } else if (e.getModifiers() == 3) {
                    if (this.getSelectionModel().getStartPoint() < 0) {
                        this.getSelectionModel().addStartAndEndPoint(this.getCursorPosition(), this.he.buff.length - 1);
                    } else {
                        this.getSelectionModel().addNewEndPoint(this.he.buff.length - 1);
                    }
                } else if (e.getModifiers() == 2) {
                    this.setCursorPosition(this.he.buff.length - 1);
                } else if (e.getModifiers() == 0) {
                    int mu = (this.getCursorPosition() + 1) / 16;
                    if (this.getCursorPosition() + 1 != mu * 16) {
                        this.setCursorPosition((mu + 1) * 16 - 1);
                    }
                }
                this.updateCursor();
                break;
            }
            case 36: {
                if ((e.getModifiersEx() ^ 0x40) == 0) {
                    int mu;
                    int start;
                    if (this.getSelectionModel().getStartPoint() < 0) {
                        this.getSelectionModel().addStartAndEndPoint(this.getCursorPosition(), this.getCursorPosition());
                    }
                    if ((start = this.getSelectionModel().getEndPoint()) != (mu = start / 16) * 16) {
                        if (this.getSelectionModel().getEndPoint() > this.getSelectionModel().getStartPoint()) {
                            this.getSelectionModel().addNewEndPoint(mu * 16 - 1);
                        } else {
                            this.getSelectionModel().addNewEndPoint(mu * 16);
                        }
                    }
                    this.checkScrollOneLineRequired(true);
                } else if (e.getModifiers() == 3) {
                    if (this.getSelectionModel().getStartPoint() < 0) {
                        this.getSelectionModel().addStartAndEndPoint(0, this.getCursorPosition());
                    } else {
                        this.getSelectionModel().addNewEndPoint(0);
                    }
                } else if (e.getModifiers() == 2) {
                    this.setCursorPosition(0);
                } else if (e.getModifiers() == 0) {
                    int mu = this.getCursorPosition() / 16;
                    if (this.getCursorPosition() != mu * 16) {
                        this.setCursorPosition(mu * 16);
                    }
                }
                this.updateCursor();
                break;
            }
            case 37: {
                if ((e.getModifiersEx() ^ 0x40) == 0) {
                    if (this.getSelectionModel().getStartPoint() < 0) {
                        this.getSelectionModel().addStartAndEndPoint(this.getCursorPosition(), this.getCursorPosition());
                    }
                    this.getSelectionModel().addNewEndPoint(this.getSelectionModel().getEndPoint() - 1);
                    this.checkScrollOneLineRequired(false);
                    break;
                }
                this.setCursorPosition(this.getCursorPosition() - 1);
                this.updateCursor();
                break;
            }
            case 38: {
                if ((e.getModifiersEx() ^ 0x40) == 0) {
                    if (this.getSelectionModel().getStartPoint() < 0) {
                        this.getSelectionModel().addStartAndEndPoint(this.getCursorPosition(), this.getCursorPosition());
                    }
                    this.getSelectionModel().addNewEndPoint(this.getSelectionModel().getEndPoint() - 16);
                    this.checkScrollOneLineRequired(false);
                    break;
                }
                if (this.getCursorPosition() > 15) {
                    this.setCursorPosition(this.getCursorPosition() - 16);
                }
                this.getSelectionModel().clear();
                this.updateCursor();
                break;
            }
            case 39: {
                if ((e.getModifiersEx() ^ 0x40) == 0) {
                    if (this.getSelectionModel().getStartPoint() < 0) {
                        this.getSelectionModel().addStartAndEndPoint(this.getCursorPosition(), this.getCursorPosition());
                    }
                    this.getSelectionModel().addNewEndPoint(this.getSelectionModel().getEndPoint() + 1);
                    this.checkScrollOneLineRequired(true);
                    break;
                }
                this.setCursorPosition(this.getCursorPosition() + 1);
                this.updateCursor();
                break;
            }
            case 40: {
                if ((e.getModifiersEx() ^ 0x40) == 0) {
                    if (this.getSelectionModel().getStartPoint() < 0) {
                        this.getSelectionModel().addStartAndEndPoint(this.getCursorPosition(), this.getCursorPosition());
                    }
                    this.getSelectionModel().addNewEndPoint(this.getSelectionModel().getEndPoint() + 16);
                    this.checkScrollOneLineRequired(true);
                    break;
                }
                if (this.getCursorPosition() < this.he.buff.length - 16) {
                    this.setCursorPosition(this.getCursorPosition() + 16);
                }
                this.getSelectionModel().clear();
                this.updateCursor();
                break;
            }
            case 65: {
                if (e.getModifiers() != 2) break;
                this.getSelectionModel().clear();
                this.getSelectionModel().addStartAndEndPoint(0, this.he.buff.length - 1);
                e.consume();
                this.he.repaint();
                break;
            }
            case 67: {
                if (e.getModifiers() != 2) break;
                this.he.getHexTransferHandler().copyContent2Clipboard();
                break;
            }
            case 86: {
                if (e.getModifiers() != 2) break;
                this.he.getHexTransferHandler().pasteContentFromClipboard();
                break;
            }
            case 88: {
                if (e.getModifiers() != 2) break;
                this.he.getHexTransferHandler().cutContent2Clipboard();
                break;
            }
            case 127: {
                this.he.getHexTransferHandler().deleteChars();
            }
        }
    }

    void checkScrollOneLineRequired(boolean directionDown) {
        int ini = this.he.getStart() * 16;
        int end = ini + (this.he.getLines() + 1) * 16;
        if (end > this.he.buff.length) {
            end = this.he.buff.length;
        }
        if (directionDown) {
            if (Math.max(this.getSelectionModel().getStartPoint(), this.getSelectionModel().getEndPoint()) >= end) {
                this.scrollPane(1);
                return;
            }
        } else if (Math.min(this.getSelectionModel().getStartPoint(), this.getSelectionModel().getEndPoint()) <= ini) {
            this.scrollPane(-1);
            return;
        }
        this.he.repaint();
    }

    protected void updateCursor() {
        int n = this.getCursorPosition() / 16;
        if (n < this.he.getStart()) {
            this.he.setStart(n);
        } else if (n >= this.he.getStart() + this.he.getLines()) {
            this.he.setStart(n - this.he.getLines());
        }
        this.he.scrlRight.setValues(this.he.getStart(), this.he.getLines(), 0, this.he.maxLineas);
        this.he.repaint();
    }

    @Override
    public void keyReleased(KeyEvent e) {
    }

    @Override
    public boolean isFocusTraversable() {
        return true;
    }

    @Override
    public void paint(Graphics g) {
        Color oldColor = g.getColor();
        this.ini = this.he.getStart();
        this.end = Math.min(this.ini + this.he.getLines() + 1, this.he.maxLineas);
        if (this.hasTextFieldColors && !this.he.txtFieldContainer.isEnabled()) {
            g.setColor(this.he.getDisabledBG());
        } else if (this.hasTextFieldColors && !this.he.txtFieldContainer.isEditable()) {
            g.setColor(this.he.getInactiveBG());
        } else {
            g.setColor(this.getBackground());
        }
        this.maxInactive = -1;
        if (this.end == this.he.maxLineas) {
            this.maxHeightPainted = 5;
            int muCompare = 0;
            muCompare = this.end - this.ini;
            this.maxHeightPainted = muCompare == 0 ? (this.maxHeightPainted += HexLib.fontHeight) : (this.maxHeightPainted += HexLib.fontHeight * muCompare);
            this.maxInactive = this.getBounds().height - this.maxHeightPainted;
        } else {
            this.maxHeightPainted = Math.min(this.getBounds().height, this.he.maxHeight);
        }
        g.fillRect(0, 0, this.minWidth, this.maxHeightPainted);
        if (this.hasStripes) {
            g.setColor(this.stripeColors[1]);
            int starter = this.he.getStart() % 2 == 0 ? 0 : 1;
            int lastStripe = this.end - this.he.getStart();
            int row = starter;
            while (row <= lastStripe) {
                g.fillRect(0, row * HexLib.fontHeight, this.minWidth, HexLib.fontHeight);
                row += 2;
            }
        }
        if (this.maxInactive > 0) {
            g.setColor(this.getColorInactiveBackGround());
            g.fillRect(0, this.maxHeightPainted - 5, this.minWidth, this.maxInactive + 5);
        }
        g.setColor(oldColor);
    }

    protected boolean checkOverMaxLines() {
        boolean b;
        boolean bl = b = this.he.maxLineas <= this.he.getLines() + this.he.getStart();
        if (b) {
            this.he.setStart(this.he.maxLineas - this.he.getLines() - 1);
        }
        return b;
    }

    protected void rect(Graphics g, int x, int y, int s) {
        g.drawRect(HexLib.fontWidth * x + 2 - 1, HexLib.fontHeight * y, HexLib.fontWidth * s, HexLib.fontHeight - 1);
    }

    protected void createRect(Graphics g, int x, int y, int s) {
        g.drawRect(HexLib.fontWidth * x, HexLib.fontHeight * y, HexLib.fontWidth * s + 4, HexLib.fontHeight - 1);
    }

    protected void printString(Graphics g, String s, int x, int y) {
        g.drawString(s, HexLib.fontWidth * x + 2, HexLib.fontHeight * (y + 1) - HexLib.fontMaxDescent - 1);
    }

    protected void printStringSingle(Graphics g, String s, int x, int y, int hexCursor) {
        g.drawString(s, HexLib.fontWidth * x + 2 - hexCursor, HexLib.fontHeight * (y + 1) - HexLib.fontMaxDescent - 1);
    }

    protected void printString(Graphics g, String s, double x, int y) {
        g.drawString(s, (int)((double)HexLib.fontWidth * x) + 2, HexLib.fontHeight * (y + 1) - HexLib.fontMaxDescent + 2);
    }

    @Override
    public void setBackground(Color bg) {
        this.backGroundColor = bg;
        this.createZebraColors(bg, bg);
    }

    @Override
    public Color getBackground() {
        return this.backGroundColor;
    }

    public void repaintCursorOnly() {
        this.paintCursorOnly = true;
        this.paint(this.getGraphics());
        this.paintCursorOnly = false;
    }

    public static void setColorInactiveBackGround(Color muColorInactiveBackGround) {
        colorInactiveBackGround = muColorInactiveBackGround;
    }

    public Color getColorInactiveBackGround() {
        return colorInactiveBackGround;
    }

    public void setCursorPosition(int cursor) {
        this.setCursorPositionInternal(cursor, true);
    }

    void setCursorPositionInternal(int cursor, boolean clearSelection) {
        if (cursor < 0) {
            cursor = 0;
        } else if (cursor > this.he.buff.length - 1) {
            cursor = this.he.buff.length - 1;
        }
        int muOldCursor = this.he.cursor;
        this.he.cursor = cursor;
        this.he.firePropertyChange(HexLib.cursorProperty, muOldCursor, cursor);
        if (clearSelection) {
            this.getSelectionModel().clear();
        }
    }

    public int getCursorPosition() {
        return this.he.cursor;
    }

    protected void createZebraColors() {
        this.createZebraColors(UIManager.getColor("TextArea.background"), UIManager.getColor("TextArea.selectionBackground"));
    }

    protected void createZebraColors(Color basisColor, Color stripeBasisColor) {
        this.stripeColors[0] = this.stripeColors[1] = basisColor;
        Color sel = stripeBasisColor;
        float[] bgHSB = Color.RGBtoHSB(this.stripeColors[0].getRed(), this.stripeColors[0].getGreen(), this.stripeColors[0].getBlue(), null);
        float[] selHSB = Color.RGBtoHSB(sel.getRed(), sel.getGreen(), sel.getBlue(), null);
        Color muColor = Color.getHSBColor((double)selHSB[1] == 0.0 || (double)selHSB[2] == 0.0 ? bgHSB[0] : selHSB[0], 0.08f * selHSB[1] + 0.8f * bgHSB[1], bgHSB[2] + (bgHSB[2] < 0.5f ? 0.05f : -0.05f));
        this.stripeColors[1] = new ColorUIResource(muColor);
    }

    public Color getFontForeground() {
        if (!this.he.txtFieldContainer.isEnabled()) {
            return this.he.getInactiveFG();
        }
        return this.fontForeground;
    }

    void scrollPane(int unitsToScroll) {
        if (unitsToScroll != 0) {
            this.he.setStart(this.he.getStart() + unitsToScroll);
            if (this.checkOverMaxLines()) {
                this.he.scrlRight.setValue(this.he.scrlRight.getMaximum() - this.he.scrlRight.getVisibleAmount());
            } else {
                this.he.scrlRight.setValue(this.he.getStart());
            }
        }
        this.he.repaint();
    }

    HexLibSelectionModel getSelectionModel() {
        return this.he.getSelectionModel();
    }
}

