/*
 * Decompiled with CFR 0.152.
 */
package at.HexLib.library;

import at.HexLib.library.BasicPanel;
import at.HexLib.library.HexLib;
import java.awt.Color;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.awt.event.MouseWheelEvent;
import java.awt.event.MouseWheelListener;
import javax.swing.UIManager;

public abstract class BasicContentPanel
extends BasicPanel
implements MouseListener,
MouseMotionListener,
MouseWheelListener {
    Color colorMarkPos = UIManager.getColor("TextField.selectionBackground");
    int leftAndShift = 1088;
    int leftAndCtrl = 1152;

    protected abstract int calcCursorPos(int var1, int var2);

    protected abstract void setFontObjects();

    public BasicContentPanel(HexLib he) {
        super(he);
        this.hasStripes = true;
        this.createZebraColors();
        this.addMouseListener(this);
        this.addMouseMotionListener(this);
        this.addMouseWheelListener(this);
        this.hasTextFieldColors = true;
        this.setAutoscrolls(true);
        this.setFocusable(true);
    }

    @Override
    public void dispose() {
        super.dispose();
        this.removeMouseListener(this);
        this.removeMouseMotionListener(this);
        this.removeMouseWheelListener(this);
    }

    @Override
    public void mouseDragged(MouseEvent e) {
        int muX = e.getX();
        if (muX > this.getSize().width) {
            muX = this.getSize().width - 4;
        } else if (muX < 0) {
            muX = 0;
        }
        int mousePressedPos = this.calcCursorPos(muX, e.getY());
        if (e.getModifiersEx() == (e.getModifiersEx() & 0x400)) {
            if (this.getSelectionModel().getStartPoint() < 0) {
                this.getSelectionModel().addStartAndEndPoint(this.getCursorPosition(), mousePressedPos);
            } else {
                this.getSelectionModel().addNewEndPoint(mousePressedPos);
            }
        } else if ((e.getModifiersEx() ^ this.leftAndShift) == 0) {
            this.getSelectionModel().addNewEndPoint(mousePressedPos);
        } else if ((e.getModifiersEx() ^ this.leftAndCtrl) == 0) {
            this.getSelectionModel().addStartAndEndPoint(this.he.getCursorPosition(), mousePressedPos);
        }
        int muReleasePointY = e.getPoint().y;
        int unitsToScroll = 0;
        if (muReleasePointY < 0) {
            unitsToScroll = -1 + this.he.getLines() * muReleasePointY / this.getSize().height;
        } else if (muReleasePointY > this.getSize().height) {
            unitsToScroll = 1 + this.he.getLines() * (muReleasePointY - this.getSize().height) / this.getSize().height;
        }
        this.scrollPane(unitsToScroll);
    }

    @Override
    public void mouseMoved(MouseEvent e) {
    }

    @Override
    public void mouseClicked(MouseEvent e) {
        if (!this.hasFocus()) {
            this.he.requestFocusInWindow();
        }
    }

    @Override
    public void mouseReleased(MouseEvent e) {
    }

    @Override
    public void mouseEntered(MouseEvent e) {
    }

    @Override
    public void mouseExited(MouseEvent e) {
    }

    @Override
    public void mousePressed(MouseEvent e) {
        int pointYPressed = this.calcCursorPos(e.getX(), e.getY());
        boolean canCursorBeChanged = false;
        boolean clearSelection = true;
        if (e.getModifiersEx() == (e.getModifiersEx() & 0x400)) {
            this.getSelectionModel().clear();
            this.getSelectionModel().addNewStartPoint(pointYPressed);
            canCursorBeChanged = true;
        } else if ((e.getModifiersEx() ^ this.leftAndShift) == 0) {
            this.getSelectionModel().addStartAndEndPoint(this.he.getCursorPosition(), pointYPressed);
            this.he.repaint();
        } else if ((e.getModifiersEx() ^ this.leftAndCtrl) == 0) {
            canCursorBeChanged = true;
            clearSelection = false;
        }
        if (canCursorBeChanged && pointYPressed >= 0) {
            this.setCursorPositionInternal(pointYPressed, clearSelection);
            this.requestFocus();
            this.he.repaint();
        }
    }

    @Override
    public void mouseWheelMoved(MouseWheelEvent e) {
        int unitsToScroll = e.getUnitsToScroll();
        this.scrollPane(unitsToScroll);
    }

    protected boolean checkCurPosPaintable(int pos2Check) {
        return pos2Check == this.getCursorPosition() && !this.getSelectionModel().isPositionWithinMarkPos(pos2Check);
    }
}

