#include "WindowsHeader.h"
#include "QtWindowBase.h"
#include "my_file.h"
#include "my_encode.h"
#include "my_util.h"
#include "my_reg.h"



CQtWindowBase::CQtWindowBase(QWidget *parent)
	: QWidget(parent)
{
	m_pMainWidget = NULL;
	m_bClosing = FALSE;
	m_hEvent_Job_ThreadExited = NULL;
}

CQtWindowBase::~CQtWindowBase()
{
	this->Free();
}

BOOL CQtWindowBase::Init_N_Show(CStringA straUiFilePath, BOOL bShow)
{
	BOOL bResult = FALSE;
	BOOL bRet = FALSE;
	QUiLoader t_UiLoader;
	CStringA straMsg;
	QFile *pQFile = NULL;

	m_straUiFilePath = straUiFilePath;

	if (! ::IsFileExist(::CStringA2T(straUiFilePath)))
	{
		straMsg = "ʼʧܣԭUIļ";
		this->SetMsg((LPSTR)(LPCSTR)straMsg, "FMSE!CQtWindowBase::Init_N_Show: %s \r\n", (LPSTR)(LPCSTR)straMsg);
		goto __Cleanup;
	}

	pQFile = new QFile(QString::fromLocal8Bit((LPCSTR)straUiFilePath));
    bRet = pQFile->open(QFile::ReadOnly);
	if (! bRet)
	{
		straMsg = "ʼʧܣԭ򣺼UIļʧ";
		this->SetMsg((LPSTR)(LPCSTR)straMsg, "FMSE!CQtWindowBase::Init_N_Show: %s \r\n", (LPSTR)(LPCSTR)straMsg);
		goto __Cleanup;
	}
	m_pMainWidget = t_UiLoader.load(pQFile, this);
    pQFile->close();

	if (! m_pMainWidget)
	{
		straMsg = "ʼʧܣԭ򣺽UIļʧ";
		this->SetMsg((LPSTR)(LPCSTR)straMsg, "FMSE!CQtWindowBase::Init_N_Show: %s \r\n", (LPSTR)(LPCSTR)straMsg);
		goto __Cleanup;
	}
	m_pEventFilter = new CQtWindowBaseEventFilter(this, FALSE);
	this->m_pMainWidget->installEventFilter(m_pEventFilter);

	QMetaObject::connectSlotsByName(this);
	// Զź
	connect(this, SIGNAL(my_sg_MessageBox(QString)), this, SLOT(my_on_MessageBox(QString)));
	connect(this, SIGNAL(my_sg_SetMsg(QString)), this, SLOT(my_on_SetMsg(QString)));
	connect(this, SIGNAL(my_sg_SetEnabledAll(bool)), this, SLOT(my_on_SetEnabledAll(bool)));

	// UIļWindowIconЧԭδ飬ֻڴôͼ
	// ˴ͼЧ
	m_pMainWidget->setWindowIcon(QIcon(QString::fromLocal8Bit((LPCSTR)(straUiFilePath + ".png"))));
	if (bShow)
		m_pMainWidget->show();

	m_hEvent_Job_ThreadExited = ::CreateEvent(NULL, TRUE, TRUE, NULL);

	bResult = TRUE;
__Cleanup:
	if (pQFile)
		delete pQFile;
	return bResult;
}

BOOL CQtWindowBase::Free()
{
	BOOL bResult = FALSE;

	if (m_hEvent_Job_ThreadExited)
	{
		::WaitForSingleObject(m_hEvent_Job_ThreadExited, 20*1000);
		CloseHandle(m_hEvent_Job_ThreadExited);
		m_hEvent_Job_ThreadExited = NULL;
	}

	//this->m_pMainWidget->removeEventFilter(m_pEventFilter);
	if (m_pEventFilter)
	{
		delete m_pEventFilter;
		m_pEventFilter = NULL;
	}
	if (m_pMainWidget)
	{
		m_pMainWidget->close();
		m_pMainWidget = NULL;
	}

	bResult = TRUE;
	return bResult;
}

// ˺ǰ
void CQtWindowBase::closeEvent(QCloseEvent *event)
{
	;
}

void *CQtWindowBase::GetMainWidget()
{
	return m_pMainWidget;
}

BOOL CQtWindowBase::Job(JOB_TYPE ulJob)
{
	if (m_hEvent_Job_ThreadExited)
	{
		if (WAIT_OBJECT_0 != ::WaitForSingleObject(m_hEvent_Job_ThreadExited, 0))
		{
			this->ShowMsg("ȴǰһɺٲ");
			return FALSE;
		}
	}
	this->m_ulCurrentJob = ulJob;

	if (m_hEvent_Job_ThreadExited)
		::WaitForSingleObject(m_hEvent_Job_ThreadExited, INFINITE);
	else
		m_hEvent_Job_ThreadExited = ::CreateEvent(NULL, TRUE, FALSE, NULL);
	AfxBeginThread(CQtWindowBase::Job_TR, this);
	return TRUE;
}

UINT CQtWindowBase::Job_TR(LPVOID pParam)
{
	CQtWindowBase *pThis = (CQtWindowBase*) pParam;
	
	ResetEvent(pThis->m_hEvent_Job_ThreadExited);

	pThis->JobDispatcher();

__Cleanup:
	SetEvent(pThis->m_hEvent_Job_ThreadExited);
	return 0;
}

void CQtWindowBase::my_on_MessageBox(QString qstrText)
{
	QMessageBox::information(this->m_pMainWidget, QString::fromLocal8Bit("ʾ"), qstrText);
}

void CQtWindowBase::SetMsg(char *pszMsg, char *pszLogFormat, ...)
{
	emit this->my_sg_SetMsg(QString::fromLocal8Bit(pszMsg));
	
	if (pszLogFormat)
	{
		va_list ap;
		va_start(ap, pszLogFormat);
		this->s_pLog->LogVl(pszLogFormat, ap);
		va_end(ap);
	}
}

ULONG CQtWindowBase::ShowMsg(CStringA straMsg, MSG_WINDOW_STYLE ulStyle, CStringA straCaption, BOOL bAnimate)
{
	emit this->my_sg_MessageBox(QString::fromLocal8Bit("ȴǰһɺٲ"));
	return 1;
}

void CQtWindowBase::SetClosing()
{
	this->m_bClosing = TRUE;
}

void CQtWindowBase::RedirectEventFromMainWidget(QEvent *e)
{
	if (! m_bClosing)
		this->event(e);
}