#ifndef __MAIN_WINDOW__
#define __MAIN_WINDOW__

#include "QtWindowBase.h"


class CMainWindow : public CQtWindowBase
{
    Q_OBJECT

public:
	CMainWindow(QWidget *parent = 0);
	~CMainWindow();
	static CMainWindow *s_pThis;
	static HHOOK s_hMouseHook;

private:
protected:
	// ؼ
	QLabel *lblMinimize;
	QLabel *lblMaximize;
	QLabel *lblClose;
	QLabel *lblMsg;

public:
	BOOL Init_N_Show(CStringA straUiDirPath, BOOL bShow = TRUE);
	BOOL Free();

	int DoModal();
	void SetVersion(CString strVersion);
};


class CQtEventFilter : public QObject
{
	Q_OBJECT

public:
	CQtEventFilter()
	{
		s_bExiting = FALSE;
		s_pMainWindow = NULL;
	};

protected:
	static BOOL   s_bExiting;
	static void   *s_pMainWindow;

	bool eventFilter(QObject *obj, QEvent *event)
	{
		if (event->type() == QEvent::Close)
		{
			if ((void*)obj == s_pMainWindow || (void*)obj == ((QWidget*)s_pMainWindow)->parent())
			{
				::SetExitingProcess(TRUE);
				s_bExiting = TRUE;
				QApplication::closeAllWindows();
			}
		}
		else if (event->type() == QEvent::Quit)
		{
			if (! s_bExiting)
				return true;
			else
				::SetExitingProcess(TRUE);
		}

		// standard event processing
		return QObject::eventFilter(obj, event);
	};

public:
	static void SetAppExiting(BOOL bExiting = TRUE)
	{
		s_bExiting = bExiting;
	};
	
	void SetMainWindow(void *pMainWindow)
	{
		s_pMainWindow = pMainWindow;
	};
};


#endif  // #ifndef __MAIN_WINDOW__