#include "CommonLogBase.h"
#include "MainWindow.h"



int main(int argc, char *argv[])
{
	if (! AfxWinInit(::GetModuleHandle(NULL), NULL, ::GetCommandLine(), 0))
		return 1;
	
	QApplication *pQApp = NULL;
	CQtEventFilter *pQtEventFilter = NULL;
	CMainWindow *pMainWindow = NULL;
	CString strVersion;

	::SetupExceptionHandlers();
	fReadFile_Str(::GetCurrentExeDir() + _T("\\Version.txt"), strVersion);
	::SetDumpVersion(strVersion);

	CLogBase::Init();
	CLogBase::s_pLog->SetLogLevel(COMMON_LOG_LEVEL_OUTPUT_DEBUG_STRING | COMMON_LOG_LEVEL_FILE);

	SetCurrentDirectory((LPCTSTR)::GetCurrentExeDir());

	//qputenv("QTWEBKIT_PLUGIN_PATH", (LPCSTR)::CStringT2A(::GetCurrentExeDir() + _T("\\plugins")));
	QCoreApplication::addLibraryPath(QString::fromUtf16((const ushort*)(LPCWSTR)(::GetCurrentExeDir() + _T("\\plugins"))));
	pQApp = new QApplication(argc, argv);
	pQtEventFilter = new CQtEventFilter();

	QTextCodec::setCodecForTr(QTextCodec::codecForLocale()/*("GBK")*/);

	QSettings settings;
	settings.setIniCodec("GBK");

	QApplication::setStyle("cleanlooks");
	pQtEventFilter->SetAppExiting(FALSE);
	pQApp->installEventFilter(pQtEventFilter);
	
	QApplication::setWindowIcon(QIcon(QString::fromLocal8Bit(::CStringT2A(::GetCurrentExeDir()) + "\\UI\\MainWindow.ui.png")));

	pMainWindow = new CMainWindow(NULL);
	//pMainWindow->SetVersion(strVersion);
	pMainWindow->setFixedSize(1, 1);
	pMainWindow->move(-1000, -1000);
	pMainWindow->show();
	if (! pMainWindow->Init_N_Show(::CStringT2A(::GetCurrentExeDir()) + "\\UI\\MainWindow.ui"))
		goto __Cleanup;

	pQtEventFilter->SetMainWindow(pMainWindow->GetMainWidget());
	pQApp->exec();
	pQApp->removeEventFilter(pQtEventFilter);

__Cleanup:
	if (pMainWindow)
		delete pMainWindow;
	if (pQtEventFilter)
		delete pQtEventFilter;
	if (pQApp)
		delete pQApp;

	CLogBase::Free();
	return 0;
}