﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Windows;
using System.Windows.Controls;
using System.Windows.Data;
using System.Windows.Documents;
using System.Windows.Input;
using System.Windows.Media;
using System.Windows.Media.Imaging;
using System.Windows.Navigation;
using System.Windows.Shapes;
using System.Runtime.InteropServices;
using System.Windows.Interop;
using System.Windows.Forms;
using System.Drawing;
using System.Threading;

namespace c_sharp_sample_双目
{
    /// <summary>
    /// MainWindow.xaml 的交互逻辑
    /// </summary>
    /// 

    //下面是人脸识别1CN的输出数据结构
    unsafe public struct DLL_1CN_RECOG_OUT_STRUCT
    {
        public byte address;                 //'无意义，传址用的
        public float VALUE;                  //'相似度值
        public fixed byte Template_ID[33];          //'相似的ID
        public fixed byte TemplateFileName[256];    //'这个ID对应的模板的图像文件名称
    };


    //下面是人脸检测的输出数据结构
    unsafe public struct DLL_OUT_FACE_STRUCT
    {
        public byte address;     //无意义，传址的
        public Int32 eye1_x;
        public Int32 eye1_y;

        public Int32 eye2_x;
        public Int32 eye2_y;       //两眼坐标

        public Int32 left;
        public Int32 top;
        public Int32 right;
        public Int32 bottom;       //人脸矩形

        public Int32 angle;        //人脸平面角度 (正面垂直时为90度)
        public float tally;       //得分 ,100分制,即人脸的置信度。

        public Int32 is_small_face;//    '是小脸还是大脸，1为小脸，是启用了小脸检测的结果，但小脸不能进行后续的人脸识别
        //'当是小脸时，只输出人脸矩形，即只有人脸矩形有效,其它值无效

        //'下面的值要进行了人眼定位与人脸检测的后期处理才有效
        public Int32 skin_color_R;     //'采样肤色COLORREF。(RGB)
        public Int32 skin_color_G;     //'采样肤色COLORREF。(RGB)
        public Int32 skin_color_B;     //'采样肤色COLORREF。(RGB)
        public Int32 skin_hd_bright;   //'采样肤色的灰度亮度。

        public Int32 left_face_len;        //'从左眼开始计算的左脸估计长度。
        public Int32 right_face_len;       //'从右眼开始计算的右脸估计长度。
        public float face_width_rely;   // '脸宽的信任度[0，1）。

        public Int32 nose_x;                // '在原图像中的鼻尖位置。
        public Int32 nose_y;                //'在原图像中的鼻尖位置。
        public float nose_rely;         //'鼻尖位置:可信任度[0，1）。

        public Int32 month_x;               // '在原图像中的嘴中心位置。
        public Int32 month_y;                // '在原图像中的嘴中心位置。
        public float month_rely;           // '嘴心位置:可信任度[0，1）。

        public float glass_rely;             //'可能眼镜的置信度[0,1)

        public Int32 eye1_w;
        public Int32 eye1_h;
        public Int32 eye2_w;
        public Int32 eye2_h;        //人眼球大小，要示姿势端正，眼距为100以上的人脸，且眼球无反光的情况下才正确

        public Int32 CloseEyeBelievable;           //闭眼的可能性系数输出,值域[0,1000]
    };//END STRUCT DEF

   

    public partial class MainWindow : Window
    {

        //下面是导入的SDK函数
        [DllImport("SunLightFace.dll")]
        public static unsafe extern Int32 zInitialize(string UserName);
        [DllImport("SunLightFace.dll")]
        public static unsafe extern Int32 zUnInitialize();
        [DllImport("SunLightFace.dll")]
        public static unsafe extern Int32 zCreateOneThreadObject(Int32 is_load_tzlib, string datafilepath);
        [DllImport("SunLightFace.dll")]
        public static unsafe extern Int32 zDeleteOneThreadObject(Int32 OID);
        [DllImport("SunLightFace.dll")]
        public static unsafe extern Int32 zGetLastError(Int32 OID, byte* outstr);
        [DllImport("SunLightFace.dll")]
        public static unsafe extern Int32 zFaceLocate(Int32 OID, string FileName, Int32 MAX_OUT_NUMS, float Threshold, DLL_OUT_FACE_STRUCT* pofs);
        [DllImport("SunLightFace.dll")]
        public static unsafe extern Int32 zFlagFace(Int32 OID, Int32 draw_window_hwnd, Int32 order, Int32 offset_x, Int32 offset_y);
        [DllImport("SunLightFace.dll")]
        public static unsafe extern Int32 zFaceLocate_FreeMemory(Int32 OID);

        [DllImport("SunLightFace.dll")]
        public static unsafe extern Int32 zRecog1C1(Int32 OID, string vid, Int32 order, float* VALUE, string TemplateFileName);
        [DllImport("SunLightFace.dll")]
        public static unsafe extern Int32 zRecog1C1_Fast(Int32 OID, string vid, Int32 order, float* VALUE, string TemplateFileName);
        [DllImport("SunLightFace.dll")]
        public static unsafe extern Int32 zRecog1CN(Int32 OID, Int32 order, Int32 max_out_num, DLL_1CN_RECOG_OUT_STRUCT* pout);

        [DllImport("SunLightFace.dll")]
        public static unsafe extern Int32 UsbVideo_Init(Int32 DEVICE_ID, Int32 play_window_hwnd, Int32 Base_Height);
        [DllImport("SunLightFace.dll")]
        public static unsafe extern Int32 UsbVideo_Get_Width(Int32 DEVICE_ID);
        [DllImport("SunLightFace.dll")]
        public static unsafe extern Int32 UsbVideo_Get_Height(Int32 DEVICE_ID);
        [DllImport("SunLightFace.dll")]
        public static unsafe extern Int32 UsbVideo_CapOneBmp(Int32 DEVICE_ID,string bmpFileName);
        [DllImport("SunLightFace.dll")]
        public static unsafe extern Int32 UsbVideo_EndAll();



        [DllImport("SunLightFace.dll")]
        public static unsafe extern Int32 zAddFaceTemplate(Int32 OID, string TID, Int32 order);
        [DllImport("SunLightFace.dll")]
        public static unsafe extern Int32 zDelTemplateA(Int32 OID, string TID, string template_filename);
        [DllImport("SunLightFace.dll")]
        public static unsafe extern Int32 zDelTemplateB(Int32 OID, string TID, Int32 BH);
        [DllImport("SunLightFace.dll")]
        public static unsafe extern Int32 zDelAllTemplate(Int32 OID);
        [DllImport("SunLightFace.dll")]
        public static unsafe extern Int32 zUpdateMemory(Int32 OID);
        [DllImport("SunLightFace.dll")]
        public static unsafe extern Int32 zCountMemoryTidTotaleNums(Int32 OID);
        [DllImport("SunLightFace.dll")]
        public static unsafe extern Int32 zDrawOneTemplatePhoto(Int32 OID, string TID, Int32 BH, Int32 object_window_hwnd, Int32 start_x, Int32 start_y, Int32 IS_FLAG_EYE);
        [DllImport("SunLightFace.dll")]
        public static unsafe extern Int32 zCountTemplateTotaleNums(Int32 OID, string TID);
        [DllImport("SunLightFace.dll")]
        public static unsafe extern Int32 zEnumMemoryTid(Int32 OID, byte* alltid);
        [DllImport("SunLightFace.dll")]
        public static unsafe extern Int32 zEnumTid(Int32 OID, byte* alltid);


        [DllImport("SunLightFace.dll")]
        public static unsafe extern Int32 zGetA(Int32 OID, Int32 PARA_NAME_ORDER);
        [DllImport("SunLightFace.dll")]
        public static unsafe extern Int32 zSetA(Int32 OID, Int32 PARA_NAME_ORDER, Int32 VALUE);
        [DllImport("SunLightFace.dll")]
        public static unsafe extern Int32 zSetB(Int32 OID, Int32 PARA_NAME_ORDER, float VALUE);


        [DllImport("SunLightFace.dll")]
        public static unsafe extern Int32 zInitCheck(Int32 OID, Int32 order);
        [DllImport("SunLightFace.dll")]
        public static unsafe extern Int32 zFrameCheck(Int32 OID, string bmpFileName);

        [DllImport("kernel32.dll")]
        public static unsafe extern Int32 Beep(Int32 dwFreq, Int32 dwDuration);
       
        
        public bool is_usb_ok1=false;
        public bool is_usb_ok2=false;//主副摄像头的正确打开标志

        public static  Int32 OID,OID2;//人脸识别对象ID
        private PictureBox pictureBox1,pictureBox2;
        private int vw1, vh1,vw2,vh2;//画面高宽			
        float screen_dpiX;
        float screen_dpiY;
        private string mfn;
        private string sfn;
        public static IntPtr thisHwnd; //主窗口句柄值
        public static Int32 mret = 0;//返回的人脸数量
        public static Int32 sret = 0;//返回的人脸数量
        public static Rect[] rectarray1 = new Rect[32];//存人脸的矩形
        public static Rect[] rectarray2 = new Rect[32];//存人脸的矩形

        //下面重写了WPF控件IMAGE的绘制函数,为了在照片上标出人脸矩形
        private static zImage image1 = new zImage();
        private static zImage image2 = new zImage();
        class zImage : System.Windows.Controls.Image
        {      
            protected override void OnRender(DrawingContext drawingContext)
            {
                    base.OnRender(drawingContext);//调用基础类的先               
                    //.标出人脸            
                    for (int i = 0; i < mret; i++)
                    {
                        if (this.Name == "image1") drawingContext.DrawRectangle(null, new System.Windows.Media.Pen(System.Windows.Media.Brushes.White, 1.0), rectarray1[i]);
                    }

                    for (int i = 0; i < sret; i++)
                    {
                        if (this.Name == "image2") drawingContext.DrawRectangle(null, new System.Windows.Media.Pen(System.Windows.Media.Brushes.White, 1.0), rectarray2[i]);
                    }
            }//end func
        }//end class defi zImage



        public MainWindow()
        {
            InitializeComponent();

            if (!System.IO.File.Exists("SunLightFace.dll"))
            {
                System.Windows.MessageBox.Show("SunLightFace.dll未找到! 请先复制SDK目录下的所有DLL文件到可执行文件目录下.");               
            }

            if (!System.IO.Directory.Exists("..\\zdata2"))
            {
                System.Windows.MessageBox.Show("请先把zData目录复制一份同级副本，并将副本更名为zData2，再点确定。");
            }

            listBox1.Visibility = System.Windows.Visibility.Hidden;
            listBox2.Visibility = System.Windows.Visibility.Hidden;

            //显示说明文本
            richTextBox1.AppendText("    (双目识别的功能也可用VS2005以上的winform方式来实现。)\n");
            richTextBox1.AppendText("０.硬件需求：笔记本自带摄像头，再加插一个普通USB摄像头。\n");
            richTextBox1.AppendText("１.两个摄像头一为主一为副,形成水平夹角，主摄要正对人脸。\n");
            richTextBox1.AppendText("２.眼光主动看着主摄的画面为宜。\n");
            richTextBox1.AppendText("３.两摄夹角太小，则双目识别所起的双重认证作用不大，且照片也易通过。\n");
            richTextBox1.AppendText("４.两摄夹角太大，则副摄可能捉不到人脸或捉到了但人脸的特征品质低。\n");
            richTextBox1.AppendText("５.请自行根据实际设备和环境测量出最佳夹角度。\n");           
            richTextBox1.AppendText("６.请自行灵活组合双目识别的两组结果，来判断他是不是他。\n");
            richTextBox1.AppendText("７.同理可扩展成为多目识别，可扩展上下仰角等，如5路有3路通过就算OK。\n");
            richTextBox1.AppendText("８.范例只有1CN，1C1同理由开发者灵活组合。\n");
            richTextBox1.AppendText("９.多路识别的意义在于:\n        a.防照片通过，b.大幅提高识别精度，c.用户面部角度更自由。\n");
       
        }//end 构造函数


        private void Window_Loaded(object sender, RoutedEventArgs e)
        {
            thisHwnd = new WindowInteropHelper(this).Handle;
            //下面取得屏幕DPI
            using (Graphics graphics = Graphics.FromHwnd(IntPtr.Zero))
            {
                screen_dpiX = graphics.DpiX;
                screen_dpiY = graphics.DpiY;
            }

            //下面设置图像控件
            image1.Height = 240;
            image1.Width = 324;
            image1.HorizontalAlignment = System.Windows.HorizontalAlignment.Left;
            image1.VerticalAlignment = System.Windows.VerticalAlignment.Top;
            image1.Margin = new Thickness(484, 230, 0, 0);
            image1.Name = "image1";

            image2.Height = 240;
            image2.Width = 324;
            image2.HorizontalAlignment = System.Windows.HorizontalAlignment.Left;
            image2.VerticalAlignment = System.Windows.VerticalAlignment.Top;
            image2.Margin = new Thickness(404, 230, 0, 0);
            image2.Name = "image2";

            grid1.Children.Add(image1);
            grid1.Children.Add(image2);
//下面是等效的XAML控件描述:
        //<zImage Height="240" HorizontalAlignment="Left" Margin="12,262,0,0" Name="image1" Stretch="Fill" VerticalAlignment="Top" Width="324" />
        //<zImage Height="240" HorizontalAlignment="Left" Margin="404,262,0,0" Name="image2" Stretch="Fill" VerticalAlignment="Top" Width="324" />


            //启动主摄像头
            pictureBox1 = new System.Windows.Forms.PictureBox();
            pictureBox1.BorderStyle = System.Windows.Forms.BorderStyle.FixedSingle;
                  
            is_usb_ok1 = true;
            //注意:下面的参数1, 一般笔记本自带摄像头的DEVICE_ID=0
            if (UsbVideo_Init(0, pictureBox1.Handle.ToInt32(), 240) != 1)
            {
                System.Windows.MessageBox.Show("本范例程序需要有USB摄像头的支持！");
                is_usb_ok1 = false;
                this.Close();//调用关闭函数FREE资源,并结束进程
            }

            //注意:SDK中的DPI是以96为计量的
            vw1 = UsbVideo_Get_Width(0);
            vh1 = UsbVideo_Get_Height(0);
            windowsFormsHost1.Width = vw1 / (screen_dpiX / 96);  //dpi转换
            windowsFormsHost1.Height = vh1 / (screen_dpiX / 96);  //dpi转换
            windowsFormsHost1.Child = pictureBox1;


            //初始化人脸识别
            OID = -1;
            zInitialize("阳光人脸识别二次开发包<青铜版>：此版为免费正式版本,最大用户数1000,许可商用.");
            OID = zCreateOneThreadObject(1, "..\\zdata");
            if (OID < 1) System.Windows.MessageBox.Show("载入人脸数据失败！");


            //下面开启副线程(它做捉图,人脸检测,1CN识别)
            Thread aThread = new Thread(new ThreadStart(ThreadFunction));
            aThread.Start(); 
        }//end func

        //退出
        private void Window_Closed(object sender, EventArgs e)
        {
            //当关窗口时，放出内存
            if (OID > 0) zDeleteOneThreadObject(OID); //回收对象内存
            zUnInitialize(); //反初始化
            if (is_usb_ok1 == true) UsbVideo_EndAll();
        }//end func


        //启动副摄像头
        private void button1_Click(object sender, RoutedEventArgs e)
        {
            if (is_usb_ok2) return;//已启动,不再重复

            
            pictureBox2 = new System.Windows.Forms.PictureBox();
            pictureBox2.BorderStyle = System.Windows.Forms.BorderStyle.FixedSingle;
            
            is_usb_ok2 = true;
            //注意下面函数的参数1: 一般笔记本自带摄像头的DEVICE_ID=0,
            //若再外接一个USB摄像头,一般DEVICE_ID=1
            if (UsbVideo_Init(1, pictureBox2.Handle.ToInt32(), 240) != 1)
            {
                System.Windows.MessageBox.Show("本范例程序需要有USB摄像头的支持！");
                is_usb_ok2 = false;
                return;
            }
            vw2 = UsbVideo_Get_Width(1);
            vh2 = UsbVideo_Get_Height(1);
            windowsFormsHost2.Width  =   vw2/ (screen_dpiX/96);    //dpi转换 因为sdk的DPI标准是96dpi,也是视频显示的标准
            windowsFormsHost2.Height = vh2 / (screen_dpiY/96);    //dpi转换
            windowsFormsHost2.Child = pictureBox2;
            // image2.Margin = new Thickness(1, 2, 3, 4);
            //用这种方法才能改变控件的LEFT和TOP
            windowsFormsHost2.Margin =new Thickness( this.Width - windowsFormsHost2.Width  -24-2,windowsFormsHost2.Margin.Top,windowsFormsHost2.Margin.Right,windowsFormsHost2.Margin.Bottom);
            image2.Margin = new Thickness(windowsFormsHost2.Margin.Left, image2.Margin.Top, image2.Margin.Right, image2.Margin.Bottom);            
        }//END FUNC

        //线程之间通信用的触发事件
        private ManualResetEvent mre = new ManualResetEvent(false);
        private ManualResetEvent mnt = new ManualResetEvent(false);

        //启动副摄工作
        private void second_start()
        {
            if (!is_usb_ok2) return;
            mre.Set();//启动信号  --- 开工
        }//end func

        //另开的_副摄的工作线程
        private void ThreadFunction()
        {           
            //建立人脸识别对象,这个一定要在识别线程中进行!!!
            OID2 = -1;
            OID2 = zCreateOneThreadObject(1, "..\\zdata2");
            if (OID2 < 1)
            {
                System.Windows.MessageBox.Show("载入人脸数据失败！");
                return;//结束本线程
            }

            //线程循环
            while (true)
            {
                mre.WaitOne();//等信号
                mre.Reset();


                true_second_cap();//捉图
                true_second_findface();//找脸
                if (sret>0 && is_do_1cn_flag) sec_1cn();//1cn识别


                mnt.Set();//发出收工信号
                Console.WriteLine("DO FINDFACE 2");
            }
        }//END 线程函数




        //人脸检测
        BitmapImage bitmap1,bitmap2;
        Uri uri1,uri2;
        static ulong jojsq = 0;
        //下面是副摄的捉图
        private void true_second_cap()
        {
            sfn = "temp20.bmp";
            if ((jojsq % 2) != 0) sfn = "temp21.bmp";

            UsbVideo_CapOneBmp(1, sfn);//注意:副摄的DEVICE_ID=1

            System.IO.File.Copy(sfn, "temp23.bmp", true);
        }


        //下面是副摄像头的画图像
        private void second_drawimg()
        {
            if (!is_usb_ok2) return;

            //注意:!!! XAML与CS中的格式不一样  
            //又是这个URI问题!!!
            //下面在控件中显示图片
            string g_wpath = System.Windows.Forms.Application.StartupPath;
            sfn=g_wpath + "\\" + sfn;
            uri2 = new Uri(sfn, UriKind.Relative);
            bitmap2 = new BitmapImage(uri2);
           
            //取得图像的DPI,进行换算
            double bh = bitmap2.Height;
            double bw = bitmap2.Width;
            image2.Width = bw / (screen_dpiX / bitmap2.DpiX);
            image2.Height = bh / (screen_dpiY / bitmap2.DpiY);
            image2.Source = bitmap2;
        }//end func


        //下面是主摄的捉图
        private void first_cap()
        {
            if (!is_usb_ok1) return;
            mfn= "temp10.bmp";
            if ((jojsq % 2) != 0) mfn = "temp11.bmp";

            if (0 == UsbVideo_CapOneBmp(0, mfn))
            {
                System.Windows.MessageBox.Show("捉图失败!");

                return;
            }
            System.IO.File.Copy(mfn, "temp13.bmp", true);
           

            //注意:!!! XAML与CS中的格式不一样  
            //又是这个URI问题!!!
            //下面在控件中显示图片

            string g_wpath = System.Windows.Forms.Application.StartupPath;                      
            uri1 = new Uri( g_wpath + "\\" + mfn, UriKind.Relative);
            bitmap1 = new BitmapImage(uri1);

            //取得图像的DPI,进行换算
            double bh = bitmap1.Height;
            double bw = bitmap1.Width;
            image1.Width = bw / (screen_dpiX / bitmap1.DpiX);
            image1.Height = bh / (screen_dpiY / bitmap1.DpiY);
            image1.Source = bitmap1;
            
        }//end func

        


        //副摄的找脸
        unsafe private void true_second_findface()
        {
            //2.人脸定位
            DLL_OUT_FACE_STRUCT* pofs = stackalloc DLL_OUT_FACE_STRUCT[32 + 1];
            sret = zFaceLocate(OID2, "temp23.bmp", 32, 0.55f, pofs);
            if (sret < 0)
            {
                byte* ermsg = stackalloc byte[256];
                zGetLastError(OID2, ermsg);
                System.Windows.MessageBox.Show(byte2string(ermsg, 256));
                return;
            }

            //3.下面保存人脸位置矩形
            for (int i = 0; i < sret; i++)
            {
                //注意:SDK中的所有坐标和SIZE都用的是96DPI
                rectarray2[i] = new Rect(
                    new System.Windows.Point((double)pofs[i].left / (screen_dpiX / 96), (double)pofs[i].top / (screen_dpiX / 96)),
                    new System.Windows.Point((double)pofs[i].right / (screen_dpiX / 96), (double)pofs[i].bottom / (screen_dpiX / 96)));
            }


        }//end func


        //下面是主摄的找脸
        unsafe private void main_findface()
        {
            if (!is_usb_ok1) return;

            //2.人脸定位
            DLL_OUT_FACE_STRUCT* pofs = stackalloc DLL_OUT_FACE_STRUCT[32 + 1];
            mret = zFaceLocate(OID, "temp13.bmp", 32, 0.55f, pofs);
            if (mret < 0)
            {
                byte* ermsg = stackalloc byte[256];
                zGetLastError(OID, ermsg);
                System.Windows.MessageBox.Show(byte2string(ermsg, 256));
                return;
            }

            //3.下面保存人脸位置矩形
            for (int i = 0; i < mret; i++)
            {
                //注意:SDK中的所有坐标和SIZE都用的是96DPI
                rectarray1[i] = new Rect(
                    new System.Windows.Point((double)pofs[i].left / (screen_dpiX / 96), (double)pofs[i].top / (screen_dpiX / 96)), 
                    new System.Windows.Point((double)pofs[i].right / (screen_dpiX / 96), (double)pofs[i].bottom /(screen_dpiX / 96)));
            }

        }//end func


        //功能函数，把VC的byte *转为C#的string
        unsafe private string byte2string(byte* p, Int32 len)
        {
            byte[] ba = new byte[len];
            for (int i = 0; i < len; i++) ba[i] = p[i];
            string outr = System.Text.Encoding.Default.GetString(ba);
            int at = outr.IndexOf("\0");//去掉尾部的C语言结束符
            if (at == -1) return string.Empty;
            return outr.Substring(0, at);
        }//end func ：len长度是空间长度，但空间的尾部可能并未填满，再之前则是C语言结束符


        //实际人脸检测主体函数
        private void true_findface_main_func()
        {
            //下面是文件名进行奇偶交换,也是为了能正确FREE文件服务的.
            jojsq++;
            //下面这样做的目的,就是为了FREE 文件,不然下面就不能再捉图存到文件.
            /////////////////////////////
            bitmap1 = bitmap2 = null;
            GC.Collect();
            GC.WaitForPendingFinalizers();
            GC.Collect();
            //////////////////////////////
            //上面这样做的目的,就是为了FREE 文件,不然下面就不能再捉图存到文件.                 
            second_start();//注意,此函数是非阻塞的,副摄像头开工
            //上一句前置的目的: 是假定它和后面的操作一起"并发"完成
            first_cap();//主摄像头捉图
            main_findface();//主摄找脸
            if (mret > 0 && is_do_1cn_flag) main_1cn();

            if (is_usb_ok2)
            {
                mnt.WaitOne();//这里是等副线程收工
                mnt.Reset();
            }

            //5.触发IMAGE控件重绘
            image1.InvalidateVisual();
            second_drawimg();//副通道画图像
            image2.InvalidateVisual();//重绘人脸矩形
        }//end func


        unsafe private void main_1cn()
        {
            if (!is_usb_ok1) return;
            DLL_1CN_RECOG_OUT_STRUCT* rout = stackalloc DLL_1CN_RECOG_OUT_STRUCT[3];

            int ret = zRecog1CN(OID, 0, 3, rout);
            Console.WriteLine("main:");

            string str = "";
            listBox1.Items.Clear();
            listBox1.Items.Add("主_摄像头识别:");
            for (int i = 0; i < ret; i++)
            {
                str = "ID: " + byte2string(rout[i].Template_ID, 33);
                str += "     相似度: " + rout[i].VALUE.ToString();
                //str += "  fn:" + byte2string(rout[i].TemplateFileName, 256);
                //Console.WriteLine(str);
                listBox1.Items.Add(str);
            }//end for          
        }//end func

        string[] secstr = new string[3];
        unsafe private void sec_1cn()
        {
            if (!is_usb_ok2) return;
            DLL_1CN_RECOG_OUT_STRUCT* rout = stackalloc DLL_1CN_RECOG_OUT_STRUCT[3];

            int ret = zRecog1CN(OID2, 0, 3, rout);
            Console.WriteLine("second:");
            secstr[0] = secstr[1] = secstr[2] = null;
            string str = "";
            for (int i = 0; i < ret; i++)
            {
                str = "ID: " + byte2string(rout[i].Template_ID, 33);
                str += "     相似度: " + rout[i].VALUE.ToString();
                //str += "  fn:" + byte2string(rout[i].TemplateFileName, 256);
                //Console.WriteLine(str);
                //Console.WriteLine(str);
                secstr[i] = str;
            }//end for          
        }//end func

//////////////////////////
//下面是表层的按钮响应调用
//////////////////////////

        //清空模板库_BTN
        private void button4_Click(object sender, RoutedEventArgs e)
        {
            if (OID > 0) zDelAllTemplate(OID);
            if (OID2 > 0) zDelAllTemplate(OID2);
        }

        //人脸检测_BTN
        private void button2_Click(object sender, RoutedEventArgs e)
        {
            is_do_1cn_flag = false;
            true_findface_main_func(); //实际人脸检测主体函数

            //free memeory
            if (is_usb_ok1) zFaceLocate_FreeMemory(OID);
            if (is_usb_ok2) zFaceLocate_FreeMemory(OID2);
        }

        //添加模板_BTN
        private void button3_Click(object sender, RoutedEventArgs e)
        {
            string tid = textBox1.Text.Trim();
            if (tid.Length == 0)
            {
                System.Windows.MessageBox.Show("请输入模板ID先!");
                return;
            }

            is_do_1cn_flag = false;
            true_findface_main_func(); //实际人脸检测主体函数

            if ((is_usb_ok1 && is_usb_ok2) && (mret<=0 || sret <= 0) )
            {
                System.Windows.MessageBox.Show("其中一个摄像头找脸失败,请重试,需要双目同时采集成功!");
                return;
            }

            if (is_usb_ok1)
            {
                //开始加模板，并让添加立即生效。
                if (zAddFaceTemplate(OID, tid, 0) == 1) zUpdateMemory(OID); 
                zFaceLocate_FreeMemory(OID);
            }

            if (is_usb_ok2)
            {
                //开始加模板，并让添加立即生效。
                if (zAddFaceTemplate(OID2, tid, 0) == 1) zUpdateMemory(OID2); 
                zFaceLocate_FreeMemory(OID2);
            }
        }

        //1CN双目识别_BTN
        private  bool is_do_1cn_flag=false;
        private void button5_Click(object sender, RoutedEventArgs e)
        {
            // //副摄识别   1CN 是在线程中完成的
            is_do_1cn_flag = true;//这个送标志给线程
            true_findface_main_func(); //实际人脸检测主体函数

            listBox2.Items.Clear();
            listBox2.Items.Add("副_摄像头识别:");
            for (int i = 0; i < 3; i++)
            {
                if (secstr[i] == null) break;
                listBox2.Items.Add(secstr[i]);
            }

   

            if (is_usb_ok1)
            {
                listBox1.Visibility = System.Windows.Visibility.Visible;
                zFaceLocate_FreeMemory(OID);
            }

            if (is_usb_ok2)
            {
                listBox2.Visibility = System.Windows.Visibility.Visible;
                zFaceLocate_FreeMemory(OID2);
            }
        }//end func



    }//end class
}//end namespace





