# Eneroth Railroad System

# Copyright Julia Christina Eneroth, eneroth3@gmail.com

module EneRailroad

# Internal: Container for methods requiring Win32API.
module WinApi

  if WIN

    # Require Win32API.
    # Either bundled with plugin or from standard library.
    path = File.join PLUGIN_DIR, "Win32API.so"
    require (RUBY_VERSION < "2.0.0") ? path : "Win32API"

    WS_CAPTION       = 0x00C00000
    WS_EX_TOOLWINDOW = 0x00000080

    GWL_STYLE   = -16
    GWL_EXSTYLE = -20

    # SetWindowPos() flags.
    SWP_NOSIZE       = 0x0001
    SWP_NOMOVE       = 0x0002
    SWP_DRAWFRAME    = 0x0020
    SWP_FRAMECHANGED = 0x0020
    SWP_NOREPOSITION = 0x0200

    # Window functions.
    SetWindowPos        = Win32API.new("user32.dll" , "SetWindowPos" , "LLIIIII", "I")
    SetWindowLong       = Win32API.new("user32.dll" , "SetWindowLong", "LIL", "L")
    GetWindowLong       = Win32API.new("user32.dll" , "GetWindowLong", "LI" , "L")
    GetActiveWindow     = Win32API.new("user32.dll", "GetActiveWindow", "", "L")
    GetWindowText       = Win32API.new("user32.dll", "GetWindowText", "LPI", "I")
    GetWindowTextLength = Win32API.new("user32.dll", "GetWindowTextLength", "L", "I")
  
  end
  
  # Change window style to make active web dialog match inspectors.
  # Windows only.
  def self.dialog2toolbox
    
    return unless defined? Win32API
    
    # Get window reference, assume active window.
    hwnd = GetActiveWindow.call# TODO: get the correct window somehow?
    
    # Set style.
    style = GetWindowLong.call(hwnd, GWL_EXSTYLE)
    SetWindowLong.call(hwnd, GWL_EXSTYLE,  style | WS_EX_TOOLWINDOW)
    SetWindowPos.call(hwnd, 0, 0, 0, 0, 0, SWP_FRAMECHANGED|SWP_NOSIZE|SWP_NOMOVE)
    
    true
    
  end
  
end# Module

end# Module
