/*
 * Decompiled with CFR 0.152.
 */
package org.homebrew;

import java.awt.AlphaComposite;
import java.awt.Color;
import java.awt.Component;
import java.awt.Composite;
import java.awt.Dimension;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.event.KeyListener;
import java.util.Stack;
import org.davic.resources.ResourceClient;
import org.havi.ui.HConfigurationException;
import org.havi.ui.HGraphicsConfigTemplate;
import org.havi.ui.HGraphicsDevice;
import org.havi.ui.HPermissionDeniedException;
import org.havi.ui.HScene;
import org.havi.ui.HSceneFactory;
import org.havi.ui.HScreen;
import org.homebrew.ImageLoader;
import org.homebrew.ImageRegion;
import org.homebrew.ResourceClientAdapter;

public class Screen {
    private static HScene scene;
    private static Graphics2D graphics;
    private static Color bgColor;
    private static Stack savedCompsites;
    private static int screenWidth;
    private static int screenHeight;
    private static Image clearImage;

    public static void initialise(int n, int n2) throws Exception {
        screenWidth = n;
        screenHeight = n2;
        Screen.setScreenResolution(n, n2);
        scene = Screen.createScene();
        ImageLoader.init((Component)scene);
        String string = System.getProperty("bluray.vfs.root");
        if (!string.endsWith("/") && !string.endsWith("\\")) {
            string = string + "/";
        }
        ImageLoader.setBaseDir(string + "BDMV/JAR/00000");
        clearImage = ImageLoader.loadImage("clear.png");
    }

    public static void terminate() {
        scene.setVisible(false);
        scene.dispose();
        scene = null;
    }

    public static void show() {
        scene.setVisible(true);
        scene.requestFocus();
        graphics = (Graphics2D)scene.getGraphics();
        graphics.setComposite(AlphaComposite.Src);
    }

    public static void hide() {
        graphics.dispose();
        graphics = null;
        scene.setVisible(false);
    }

    public static void addKeyListener(KeyListener keyListener) {
        scene.addKeyListener(keyListener);
    }

    public static void removeKeyListener(KeyListener keyListener) {
        scene.removeKeyListener(keyListener);
    }

    public static Image createBuffer(int n, int n2) {
        Image image = scene.createImage(n, n2);
        ImageLoader.addImageSize(image);
        return image;
    }

    public static Graphics2D createGraphics(Image image) {
        Graphics2D graphics2D = (Graphics2D)image.getGraphics();
        graphics2D.setComposite(AlphaComposite.Src);
        return graphics2D;
    }

    public static void saveComposite() {
        Composite composite = graphics.getComposite();
        if (null != composite) {
            savedCompsites.push(composite);
        }
    }

    public static void restoreComposite() {
        if (!savedCompsites.empty()) {
            graphics.setComposite((Composite)savedCompsites.pop());
        } else {
            graphics.setComposite(null);
        }
    }

    public static void srcOver(float f) {
        graphics.setComposite(AlphaComposite.getInstance(3, f));
    }

    public static void srcOver() {
        graphics.setComposite(AlphaComposite.SrcOver);
    }

    public static void src() {
        graphics.setComposite(AlphaComposite.Src);
    }

    public static void translate(int n, int n2) {
        graphics.translate(n, n2);
    }

    public static void drawImage(Image image, int n, int n2) {
        graphics.drawImage(image, n, n2, null);
    }

    public static void drawImage(ImageRegion imageRegion, int n, int n2) {
        imageRegion.draw(graphics, n, n2);
    }

    public static void drawImage(Image image, int n, int n2, int n3, int n4) {
        graphics.drawImage(image, n, n2, n3, n4, null);
    }

    public static void drawImage(Image image, int n, int n2, int n3, int n4, int n5, int n6, int n7, int n8) {
        graphics.drawImage(image, n, n2, n3, n4, n5, n6, n7, n8, null);
    }

    public static void setBackgroundColor(Color color) {
        scene.setBackground(color);
    }

    public static void setColor(Color color) {
        graphics.setColor(color);
    }

    public static void fillRect(int n, int n2, int n3, int n4) {
        graphics.fillRect(n, n2, n3, n4);
    }

    public static void clearRect(int n, int n2, int n3, int n4) {
        graphics.clearRect(n, n2, n3, n4);
    }

    public static void clear() {
        Screen.drawImage(clearImage, 0, 0, 1920, 1080);
    }

    public static void setClip(Rectangle rectangle) {
        graphics.setClip(rectangle);
    }

    public static void setClip(int n, int n2, int n3, int n4) {
        graphics.setClip(n, n2, n3, n4);
    }

    public static void resetClip() {
        graphics.setClip(null);
    }

    public static void sync() {
        Toolkit.getDefaultToolkit().sync();
    }

    private static void setScreenResolution(int n, int n2) throws HConfigurationException, HPermissionDeniedException {
        HGraphicsDevice hGraphicsDevice = HScreen.getDefaultHScreen().getDefaultHGraphicsDevice();
        HGraphicsConfigTemplate hGraphicsConfigTemplate = new HGraphicsConfigTemplate();
        hGraphicsDevice.reserveDevice((ResourceClient)new ResourceClientAdapter());
        hGraphicsConfigTemplate.setPreference(8, (Object)new Dimension(n, n2), 1);
        hGraphicsDevice.setGraphicsConfiguration(hGraphicsDevice.getBestConfiguration(hGraphicsConfigTemplate));
    }

    private static HScene createScene() {
        HScene hScene = HSceneFactory.getInstance().getDefaultHScene();
        hScene.setBackground(bgColor);
        return hScene;
    }

    public static void pause(long l) {
        try {
            Thread.sleep(l);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    public static void drawString(String string, int n, int n2) {
        graphics.drawString(string, n, n2);
    }

    public static Graphics2D getGraphics() {
        return graphics;
    }

    static {
        bgColor = new Color(0, 0, 0, 0);
        savedCompsites = new Stack();
    }
}

