/*
 * Decompiled with CFR 0.152.
 */
package org.homebrew;

import javax.media.Control;
import javax.media.ControllerEvent;
import javax.media.ControllerListener;
import javax.media.EndOfMediaEvent;
import javax.media.Manager;
import javax.media.MediaLocator;
import javax.media.Player;
import javax.media.RateChangeEvent;
import javax.media.StartEvent;
import javax.media.StopEvent;
import javax.media.Time;
import javax.tv.service.selection.ServiceContentHandler;
import javax.tv.service.selection.ServiceContext;
import javax.tv.service.selection.ServiceContextException;
import javax.tv.service.selection.ServiceContextFactory;
import javax.tv.xlet.XletContext;
import org.bluray.media.AudioControl;
import org.bluray.media.PlayListChangeControl;
import org.bluray.media.PlaybackControl;
import org.bluray.media.PlaybackListener;
import org.bluray.media.PlaybackMarkEvent;
import org.bluray.media.PlaybackPlayItemEvent;
import org.bluray.media.PrimaryAudioControl;
import org.bluray.media.SubtitlingControl;
import org.bluray.net.BDLocator;
import org.davic.media.MediaTimeEventControl;
import org.davic.media.MediaTimeEventListener;
import org.homebrew.Debug;
import org.homebrew.MediaListener;

public class JMFPlaybackControl {
    private static Player player;
    private static SubtitlingControl subtitleControl;
    private static PlaybackControl playbackControl;
    private static PlayListChangeControl playlistChangeControl;
    private static AudioControl audioControl;
    private static int currentPlaylist;
    private static MediaListener currentListener;
    private static BDLocator newLocation;
    private static long newStartTimeInNs;
    private static ControllerListener controllerListener;
    private static MediaTimeEventControl mediaTimeEventControl;
    private static PlaybackControlListener playbackControlListener;
    static /* synthetic */ Class class$org$homebrew$JMFPlaybackControl;

    public static void initialise(int n, MediaListener mediaListener) throws Exception {
        Debug.info(class$org$homebrew$JMFPlaybackControl == null ? (class$org$homebrew$JMFPlaybackControl = JMFPlaybackControl.class$("org.homebrew.JMFPlaybackControl")) : class$org$homebrew$JMFPlaybackControl, "initialise(id =" + n + ")");
        MediaLocator mediaLocator = new MediaLocator(JMFPlaybackControl.createPlaylistLocator(n));
        Player player = Manager.createPlayer((MediaLocator)mediaLocator);
        JMFPlaybackControl.init(player, n, mediaListener);
    }

    public static void terminate() {
        Debug.info(class$org$homebrew$JMFPlaybackControl == null ? (class$org$homebrew$JMFPlaybackControl = JMFPlaybackControl.class$("org.homebrew.JMFPlaybackControl")) : class$org$homebrew$JMFPlaybackControl, "terminate()");
        player.removeControllerListener(controllerListener);
        player.stop();
        player.deallocate();
        player.close();
    }

    public static void start() {
        player.start();
    }

    public static void realize() {
        player.realize();
    }

    public static int getState() {
        return player.getState();
    }

    public static long getMediaTime() {
        try {
            return player.getMediaNanoseconds();
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return 0L;
        }
    }

    public static void setMediaTime(long l) {
        Debug.info(class$org$homebrew$JMFPlaybackControl == null ? (class$org$homebrew$JMFPlaybackControl = JMFPlaybackControl.class$("org.homebrew.JMFPlaybackControl")) : class$org$homebrew$JMFPlaybackControl, "setMediaTime(time =" + l + ")");
        try {
            player.setMediaTime(new Time(l));
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public static void showSubtitle(boolean bl) {
        Debug.info(class$org$homebrew$JMFPlaybackControl == null ? (class$org$homebrew$JMFPlaybackControl = JMFPlaybackControl.class$("org.homebrew.JMFPlaybackControl")) : class$org$homebrew$JMFPlaybackControl, "showSubtitles(show=" + bl + ")");
        try {
            subtitleControl.setSubtitling(bl);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public static void setSubtitle(int n) {
        Debug.info(class$org$homebrew$JMFPlaybackControl == null ? (class$org$homebrew$JMFPlaybackControl = JMFPlaybackControl.class$("org.homebrew.JMFPlaybackControl")) : class$org$homebrew$JMFPlaybackControl, "setSubtitle(streamId=" + n + ")");
        try {
            subtitleControl.selectStreamNumber(n);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public static int getCurrentSubtitle() {
        return subtitleControl.getCurrentStreamNumber();
    }

    public static boolean isShowingSubtitles() {
        return subtitleControl.isSubtitlingOn();
    }

    public static int getCurrentAudio() {
        return audioControl.getCurrentStreamNumber();
    }

    public static void setAudio(int n) {
        Debug.info(class$org$homebrew$JMFPlaybackControl == null ? (class$org$homebrew$JMFPlaybackControl = JMFPlaybackControl.class$("org.homebrew.JMFPlaybackControl")) : class$org$homebrew$JMFPlaybackControl, "setAudio() streamId = " + n);
        try {
            audioControl.selectStreamNumber(n);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public static void pauseOn() {
        Debug.info(class$org$homebrew$JMFPlaybackControl == null ? (class$org$homebrew$JMFPlaybackControl = JMFPlaybackControl.class$("org.homebrew.JMFPlaybackControl")) : class$org$homebrew$JMFPlaybackControl, "pauseOn()");
        try {
            player.setRate(0.0f);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public static void pauseOff() {
        Debug.info(class$org$homebrew$JMFPlaybackControl == null ? (class$org$homebrew$JMFPlaybackControl = JMFPlaybackControl.class$("org.homebrew.JMFPlaybackControl")) : class$org$homebrew$JMFPlaybackControl, "pauseOff()");
        try {
            player.setRate(1.0f);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public static void skipToMark(int n) {
        Debug.info(class$org$homebrew$JMFPlaybackControl == null ? (class$org$homebrew$JMFPlaybackControl = JMFPlaybackControl.class$("org.homebrew.JMFPlaybackControl")) : class$org$homebrew$JMFPlaybackControl, "skipToMark(mark=" + n + ")");
        try {
            playbackControl.skipToMark(n);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public static void playPlaylistAtMark(int n, int n2, MediaListener mediaListener) {
        Debug.info(class$org$homebrew$JMFPlaybackControl == null ? (class$org$homebrew$JMFPlaybackControl = JMFPlaybackControl.class$("org.homebrew.JMFPlaybackControl")) : class$org$homebrew$JMFPlaybackControl, "playPlaylist(id=" + n + ", mark=" + n2 + ")");
        JMFPlaybackControl.changePlaylist(n, n2, -1L, mediaListener);
    }

    public static void playPlaylistAtTime(int n, long l, MediaListener mediaListener) {
        Debug.info(class$org$homebrew$JMFPlaybackControl == null ? (class$org$homebrew$JMFPlaybackControl = JMFPlaybackControl.class$("org.homebrew.JMFPlaybackControl")) : class$org$homebrew$JMFPlaybackControl, "playPlaylist(id=" + n + ", time=" + l + ")");
        JMFPlaybackControl.changePlaylist(n, 0, l, mediaListener);
    }

    public static int getCurrentPlaylist() {
        Debug.info(class$org$homebrew$JMFPlaybackControl == null ? (class$org$homebrew$JMFPlaybackControl = JMFPlaybackControl.class$("org.homebrew.JMFPlaybackControl")) : class$org$homebrew$JMFPlaybackControl, "getCurrentPlaylist()");
        return currentPlaylist;
    }

    public static void playPlaylistAtPlayItem(int n, int n2, MediaListener mediaListener) {
        Debug.info(class$org$homebrew$JMFPlaybackControl == null ? (class$org$homebrew$JMFPlaybackControl = JMFPlaybackControl.class$("org.homebrew.JMFPlaybackControl")) : class$org$homebrew$JMFPlaybackControl, "playPlaylist(id=" + n + ", item=" + n2 + ")");
        try {
            newLocation = new BDLocator(null, -1, n, n2, -1, null);
            currentPlaylist = n;
            currentListener = mediaListener;
            newStartTimeInNs = -1L;
            player.stop();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    private static void changePlaylist(int n, int n2, long l, MediaListener mediaListener) {
        Debug.info(class$org$homebrew$JMFPlaybackControl == null ? (class$org$homebrew$JMFPlaybackControl = JMFPlaybackControl.class$("org.homebrew.JMFPlaybackControl")) : class$org$homebrew$JMFPlaybackControl, "changePlaylist(id=" + n + ", mark=" + n2 + ", time=" + l + ")");
        try {
            newLocation = new BDLocator(null, -1, n, -1, n2, null);
            currentPlaylist = n;
            currentListener = mediaListener;
            newStartTimeInNs = l;
            player.stop();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    private static void init(Player player, int n, MediaListener mediaListener) {
        JMFPlaybackControl.player = player;
        currentPlaylist = n;
        currentListener = mediaListener;
        controllerListener = new ControllerAdapter(null);
        playbackControlListener = new PlaybackControlListener(null);
        JMFPlaybackControl.initialiseControls();
        JMFPlaybackControl.player.addControllerListener(controllerListener);
        playbackControl.addPlaybackControlListener((PlaybackListener)playbackControlListener);
    }

    private static void initialiseControls() {
        Control[] controlArray = player.getControls();
        for (int i = 0; i < controlArray.length; ++i) {
            if (controlArray[i] instanceof SubtitlingControl) {
                subtitleControl = (SubtitlingControl)controlArray[i];
                continue;
            }
            if (controlArray[i] instanceof PlaybackControl) {
                playbackControl = (PlaybackControl)controlArray[i];
                continue;
            }
            if (controlArray[i] instanceof PlayListChangeControl) {
                playlistChangeControl = (PlayListChangeControl)controlArray[i];
                continue;
            }
            if (controlArray[i] instanceof PrimaryAudioControl) {
                audioControl = (AudioControl)controlArray[i];
                continue;
            }
            if (controlArray[i] instanceof AudioControl) {
                if (audioControl != null) continue;
                audioControl = (AudioControl)controlArray[i];
                continue;
            }
            if (!(controlArray[i] instanceof MediaTimeEventControl) || mediaTimeEventControl != null) continue;
            mediaTimeEventControl = (MediaTimeEventControl)controlArray[i];
        }
    }

    private static void onControllerUpdate(ControllerEvent controllerEvent) {
        if (controllerEvent instanceof StartEvent) {
            JMFPlaybackControl.onStart();
        } else if (controllerEvent instanceof EndOfMediaEvent) {
            JMFPlaybackControl.onEnd();
        } else if (controllerEvent instanceof StopEvent) {
            JMFPlaybackControl.onStop();
        } else if (controllerEvent instanceof RateChangeEvent) {
            JMFPlaybackControl.onRateChange((RateChangeEvent)controllerEvent);
        }
    }

    private static void onStart() {
        Debug.info(class$org$homebrew$JMFPlaybackControl == null ? (class$org$homebrew$JMFPlaybackControl = JMFPlaybackControl.class$("org.homebrew.JMFPlaybackControl")) : class$org$homebrew$JMFPlaybackControl, "onStart()");
        if (currentPlaylist == JMFPlaybackControl.getPlayingPlaylist() && currentListener != null) {
            currentListener.onMediaStart();
        }
    }

    public static int getCurrentMarkId() {
        if (playlistChangeControl != null && playlistChangeControl.getCurrentPlayList() != null) {
            Debug.info(class$org$homebrew$JMFPlaybackControl == null ? (class$org$homebrew$JMFPlaybackControl = JMFPlaybackControl.class$("org.homebrew.JMFPlaybackControl")) : class$org$homebrew$JMFPlaybackControl, "getCurrentMarkId(mark=" + playlistChangeControl.getCurrentPlayList().getMarkId() + ")");
            return playlistChangeControl.getCurrentPlayList().getMarkId();
        }
        return -1;
    }

    public static int getPlayingPlaylist() {
        if (playlistChangeControl != null && playlistChangeControl.getCurrentPlayList() != null) {
            return playlistChangeControl.getCurrentPlayList().getPlayListId();
        }
        return currentPlaylist;
    }

    private static void onEnd() {
        Debug.info(class$org$homebrew$JMFPlaybackControl == null ? (class$org$homebrew$JMFPlaybackControl = JMFPlaybackControl.class$("org.homebrew.JMFPlaybackControl")) : class$org$homebrew$JMFPlaybackControl, "onEnd()");
        if (currentPlaylist == JMFPlaybackControl.getPlayingPlaylist() && currentListener != null) {
            currentListener.onMediaEnd();
        }
    }

    private static void onStop() {
        Debug.info(class$org$homebrew$JMFPlaybackControl == null ? (class$org$homebrew$JMFPlaybackControl = JMFPlaybackControl.class$("org.homebrew.JMFPlaybackControl")) : class$org$homebrew$JMFPlaybackControl, "onStop()");
        try {
            if (newLocation != null) {
                playlistChangeControl.selectPlayList(newLocation);
                if (newStartTimeInNs >= 0L) {
                    JMFPlaybackControl.setMediaTime(newStartTimeInNs);
                }
                newLocation = null;
                newStartTimeInNs = -1L;
                player.start();
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    private static void onRateChange(RateChangeEvent rateChangeEvent) {
        Debug.info(class$org$homebrew$JMFPlaybackControl == null ? (class$org$homebrew$JMFPlaybackControl = JMFPlaybackControl.class$("org.homebrew.JMFPlaybackControl")) : class$org$homebrew$JMFPlaybackControl, "onRateChange(rate=" + rateChangeEvent.getRate() + ")");
        if (currentPlaylist == JMFPlaybackControl.getPlayingPlaylist() && currentListener != null) {
            currentListener.onRateChanged(rateChangeEvent.getRate());
        }
    }

    private static Player findPlayer(XletContext xletContext) throws ServiceContextException {
        ServiceContext serviceContext = ServiceContextFactory.getInstance().getServiceContext(xletContext);
        ServiceContentHandler[] serviceContentHandlerArray = serviceContext.getServiceContentHandlers();
        for (int i = 0; i < serviceContentHandlerArray.length; ++i) {
            if (!(serviceContentHandlerArray[i] instanceof Player)) continue;
            return (Player)serviceContentHandlerArray[i];
        }
        return null;
    }

    private static String createPlaylistLocator(int n) {
        String string = "";
        try {
            string = new BDLocator(null, -1, n, -1, -1, null).toExternalForm();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        System.out.println("createPlaylistLocator str = " + string);
        return string;
    }

    public static float getRate() {
        Debug.info(class$org$homebrew$JMFPlaybackControl == null ? (class$org$homebrew$JMFPlaybackControl = JMFPlaybackControl.class$("org.homebrew.JMFPlaybackControl")) : class$org$homebrew$JMFPlaybackControl, "getRate(rate:" + player.getRate() + ")");
        return player.getRate();
    }

    public static void setMediaEventWait(MediaTimeEventListener mediaTimeEventListener, long l, int n) {
        Debug.info(class$org$homebrew$JMFPlaybackControl == null ? (class$org$homebrew$JMFPlaybackControl = JMFPlaybackControl.class$("org.homebrew.JMFPlaybackControl")) : class$org$homebrew$JMFPlaybackControl, "setMediaEventWait(time=" + l + "id=" + n + ")");
        mediaTimeEventControl.notifyWhen(mediaTimeEventListener, l, n);
    }

    public static void setMediaEventWait(MediaTimeEventListener mediaTimeEventListener, long[] lArray, int[] nArray) {
        if (lArray.length == nArray.length) {
            for (int i = 0; i < lArray.length; ++i) {
                JMFPlaybackControl.setMediaEventWait(mediaTimeEventListener, lArray[i], nArray[i]);
            }
        } else {
            throw new IllegalArgumentException("'mediaTime.length' is not equal 'id.length'");
        }
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    private static class ControllerAdapter
    implements ControllerListener {
        private ControllerAdapter() {
        }

        public void controllerUpdate(ControllerEvent controllerEvent) {
            JMFPlaybackControl.onControllerUpdate(controllerEvent);
        }

        ControllerAdapter(JMFPlaybackControl jMFPlaybackControl) {
            this();
        }
    }

    private static class PlaybackControlListener
    implements PlaybackListener {
        private PlaybackControlListener() {
        }

        public void markReached(PlaybackMarkEvent playbackMarkEvent) {
            Debug.info(class$org$homebrew$JMFPlaybackControl == null ? (class$org$homebrew$JMFPlaybackControl = JMFPlaybackControl.class$("org.homebrew.JMFPlaybackControl")) : class$org$homebrew$JMFPlaybackControl, "markReached(mark=" + playbackMarkEvent.getMark() + ")");
            if (currentPlaylist == JMFPlaybackControl.getPlayingPlaylist() && currentListener != null) {
                currentListener.onMark(playbackMarkEvent.getMark());
            }
        }

        public void playItemReached(PlaybackPlayItemEvent playbackPlayItemEvent) {
            Debug.info(class$org$homebrew$JMFPlaybackControl == null ? (class$org$homebrew$JMFPlaybackControl = JMFPlaybackControl.class$("org.homebrew.JMFPlaybackControl")) : class$org$homebrew$JMFPlaybackControl, "playItemReached(playItem=" + playbackPlayItemEvent.getPlayItem() + ")");
            if (currentPlaylist == JMFPlaybackControl.getPlayingPlaylist() && currentListener != null) {
                currentListener.onPlayItemChanged(playbackPlayItemEvent.getPlayItem());
            }
        }

        PlaybackControlListener(JMFPlaybackControl jMFPlaybackControl) {
            this();
        }
    }
}

