/*
 * Decompiled with CFR 0.152.
 */
package org.homebrew;

import java.awt.Component;
import java.awt.Image;
import java.awt.MediaTracker;
import java.awt.Toolkit;
import java.io.File;
import org.homebrew.Debug;

public class ImageLoader {
    private static MediaTracker tracker;
    private static File baseDir;
    private static long numImages;
    private static long totalSize;
    static /* synthetic */ Class class$org$homebrew$ImageLoader;

    public static void addImageSize(Image image) {
        long l = image.getWidth(null) * image.getHeight(null) * 4;
        Debug.info(class$org$homebrew$ImageLoader == null ? (class$org$homebrew$ImageLoader = ImageLoader.class$("org.homebrew.ImageLoader")) : class$org$homebrew$ImageLoader, "w=" + image.getWidth(null) + " h=" + image.getHeight(null));
        Debug.info(class$org$homebrew$ImageLoader == null ? (class$org$homebrew$ImageLoader = ImageLoader.class$("org.homebrew.ImageLoader")) : class$org$homebrew$ImageLoader, ++numImages + " images. " + (totalSize += l) + "bytes");
    }

    public static void init(Component component) {
        tracker = new MediaTracker(component);
        baseDir = null;
    }

    public static void setBaseDir(String string) {
        ImageLoader.setBaseDir(new File(string));
    }

    public static void setBaseDir(File file) {
        baseDir = file;
    }

    public static Image loadImage(String string) {
        try {
            File file = new File(baseDir, string);
            if (!file.exists()) {
                Debug.info(class$org$homebrew$ImageLoader == null ? (class$org$homebrew$ImageLoader = ImageLoader.class$("org.homebrew.ImageLoader")) : class$org$homebrew$ImageLoader, "Could not find image " + file.getAbsolutePath().toString());
            } else {
                Debug.info(class$org$homebrew$ImageLoader == null ? (class$org$homebrew$ImageLoader = ImageLoader.class$("org.homebrew.ImageLoader")) : class$org$homebrew$ImageLoader, "Loading " + string);
            }
            Image image = Toolkit.getDefaultToolkit().createImage(file.toString());
            tracker.addImage(image, 0);
            tracker.waitForAll();
            ImageLoader.addImageSize(image);
            return image;
        }
        catch (Exception exception) {
            Debug.info(class$org$homebrew$ImageLoader == null ? (class$org$homebrew$ImageLoader = ImageLoader.class$("org.homebrew.ImageLoader")) : class$org$homebrew$ImageLoader, "Error Loading Image " + string);
            return null;
        }
    }

    public static void removeImage(Image image) {
        tracker.removeImage(image);
    }

    public static void removeTracker() {
        tracker = new MediaTracker(null);
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

